/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_idt.cpp

Abstract: Implements !IDT extension command. 

Revision History:

 Sten        15/10/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>
#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "intel.h"
#include "softice.h"
#include "multicpu.h"

extern WINDBG_EXTENSION_APIS ExtensionApis;

extern void help_IDT(void);

////////////////////////////////////////////////////////////////////////////
//
// IDT
//
//   Display Interrupt Descriptor Table
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(idt)
{
    DWORD      i;
    DWORD      IdtLimit;
    DWORD      IdtBase;

    IdtEntry_t Entry;
    DWORD      Addr;
    UCHAR      chBuffer[200];
    ULONG      Displacement;
    char       EntryType[9];

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0] == '!') args += 6; // "! idt "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
        help_IDT();
        return;
    }

    DWORD IdtNum = 0;

    DWORD tmp; tmp  = sscanf(args, "%u", &IdtNum);

    if (IdtNum >= mp_NumOfCPUs)
    {
        DbgPrint("ERROR: Invalid CPU number.\n");
        return;
    }

    IdtBase  = mp_GetIDTBase(IdtNum);
    IdtLimit = GetIDTLimit();

    dprintf("Interrupt Descriptor Table for CPU%u\n", IdtNum);
    dprintf("IDTBase=%08X  Limit=%04X\n", IdtBase, IdtLimit);
    for ( i=0;i<(IdtLimit+1)/8;i++ )
    {
        GetIDTEntry(i, &Entry, IdtNum);  
        Addr = ((Entry.OffsetHigh<<16)+Entry.OffsetLow);            
    
        // Try to resolve IDT Handler name
        GetSymbol((PVOID)Addr, chBuffer, &Displacement);

        // Find IDT entry type
        if (Entry.Type == 0x5) strcpy(EntryType, "TaskG   "); else
        if (Entry.Type == 0xE) strcpy(EntryType, "IntG32  "); else
        if (Entry.Type == 0xF) strcpy(EntryType, "TrapG   "); else
          strcpy(EntryType, "Reserved");           

        dprintf("%04X  %s %04X:%08X  DPL=%x  %-2s  %s\n", i,
                                    EntryType,
                                     Entry.Selector, 
                                     Addr,
                                     Entry.Dpl,
                                     Entry.Present ? "P" : "NP",
                                     chBuffer
                                     );
    }

    return;
}
