/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
Module Name:
    cmd_if.cpp

Abstract: Implements !IF extension command. 

Revision History:

 Sten            16/05/2004
      Small modifications. The code added to official IceExt release.

 crUsAdEr        01/04/2004
      Initial release.

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>
#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "intel.h"
#include "softice.h"
#include "search.h"
#include "keyboard.h"

extern WINDBG_EXTENSION_APIS ExtensionApis;

extern void help_IF (void);

////////////////////////////////////////////////////////////////////////////
//
// IF
//     IF "CONDITIONS" THEN "EXECUTION" 
//   ONLY EXECUTE COMMANDS IF CONDITIONS ARE SATISFIED!
//   Limitation : Nested !IFX not supported use Macro for that
//                Only one nested layer of \" \" allowed in the command body
//                this is due to limitation of the " sign, there is 
//                no way to tell if it is an open or close sign.
////////////////////////////////////////////////////////////////////////////
static UCHAR      IfxCommands[128];
static ULONG      original_QueueMacroExec;
static ULONG      original_fMacroQueued;

void ExecuteIfx() 
{
    BYTE  fOpenClose=0;    // to check if " are matched, if not
    		           // then do not change ';' to ENTER

    ULONG  i=0;
    
    while ((IfxCommands[i]!='"') && (IfxCommands[i]!=0)) {i++;}
    i++;

	//
    // Macro Queued...
    //

	si_PutToKbdBufferChar(1);
    
	while (IfxCommands[i] != '\0') 
	{  
      UCHAR CurrChar = IfxCommands[i];
      
	  if ((fOpenClose==0) && (CurrChar==';')) 
	  {
          si_PutToKbdBufferChar(KBD_ENTER); // Replace ";" by ENTER
          si_PutToKbdBufferChar(1);        	// small trick to stop SoftICE 
          				                    // showing cmds on the screen
      } 
	  else 
	  {   
          if (CurrChar=='"') break;
          if (CurrChar=='\\') 
		  {
              i++;                  // Escape character
              CurrChar = IfxCommands[i];
              if (CurrChar=='"') fOpenClose ^= 1;
          }
          si_PutToKbdBufferChar(CurrChar);
      }
      i++;
    }
    si_PutToKbdBufferChar(KBD_ENTER);

    *(DWORD *)(si_fMacroQueued) = original_fMacroQueued;     // restore
    *(DWORD *)(si_QueueMacroExec) = original_QueueMacroExec;    
    return;
}

//
// N.B. I declare this command as IFX because 'if' is a C/C++ reserved word.
//      The magic happens in the IceExt.DEF file (if = ifx)
//
DECLARE_API(ifx)
{
    DWORD      CompiledIF=0;
    PCHAR      tmp;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0] == '!') args += 6; // "! if "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
        help_IF();
        return;
    }

	_strlwr((PCHAR)args);

    __asm
	{
			push     args
			call     si_ProcessIF
			mov      CompiledIF, eax
			mov      args, edx
	}

	if (!args || !CompiledIF)
	{
		DbgPrint("ERROR: Illegal IF statement.\n");
		return;
	}

	//
    // IF statements OK! Now checking IF condition...
    //
	if (si_CheckCondition(CompiledIF)) 
	{
		//
    	// Conditions Passed! Executing THEN...
    	// 
		tmp = strstr(args, "then");    	 
    } 
	else 
	{ 
		//
        // Conditions Failed! Executing ELSE...
        //
	    tmp = strstr(args, "else");
    }
    
	si_ClearCompiledIF(CompiledIF);
               
    if (tmp == NULL)
	{
		DbgPrint("ERROR: Unable to find THEN/ELSE statement.\n");
		return;
	}

    tmp += 5; // "else " or "then "
    strcpy((PCHAR)IfxCommands, tmp);
    
    // clear the else part of the command, so we only execute THEN part
    tmp = strstr((PCHAR)IfxCommands, "else"); 
    if (tmp != NULL)  tmp[0] = '\0';
   
    original_fMacroQueued   = *(DWORD *)(si_fMacroQueued);   // Back up
    original_QueueMacroExec = *(DWORD *)(si_QueueMacroExec);
    
    *(DWORD *)(si_QueueMacroExec) = (DWORD)((PULONG) *ExecuteIfx);
    *(DWORD *)(si_fMacroQueued) = 1;

    return;
}
