/*++
    Copyright  (c) 2002 Kab

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_int.cpp

Abstract: Implements !INTSAVE, !INTREST, !INTXCHG extension commands. 

Revision History:

 kab        15/10/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>
#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "intel.h"
#include "softice.h"

////////////////////////////////////////////////////////////////////////////
//	added by kab


extern void help_INTSAVE (void);
extern void help_INTREST (void);
extern void help_INTXCHG (void);

static void *ptrInt[0xff];
static void *ptrIntTemp;
static DWORD dwInt;

DECLARE_API(intsave)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0]=='!') args += 10; // "! intsave "

    if (args[0] != 0)
    {
        _asm
        {
             mov       esi, args
             call      si_Expression2Integer
             jb        syntax_error
	     cmp       eax, 0ffh
	     ja	       syntax_error
             mov       dwInt, eax
        }
	ptrInt[dwInt]=GetInterruptHandler(dwInt);
	DbgPrint("Save %d handler, value: %08X\n", dwInt, (DWORD)ptrInt[dwInt]);
    }
    else
    {
	help_INTSAVE();
    }

    return;

syntax_error:
    DbgPrint("Syntax error.\n");
    return;
}

DECLARE_API(intrest)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0]=='!') args += 10; // "! intrest "

    if (args[0] != 0)
    {
        _asm
        {
             mov       esi, args
             call      si_Expression2Integer
             jb        syntax_error
	     cmp       eax, 0ffh
	     ja	       syntax_error
             mov       dwInt, eax
        }
	ptrIntTemp=SetInterruptHandler(dwInt, ptrInt[dwInt]);
	DbgPrint("Restore %d handler, was: %08X, now: %08X\n", dwInt, (DWORD)ptrIntTemp, (DWORD)ptrInt[dwInt]);
    }
    else
    {
	help_INTREST();
    }

    return;

syntax_error:
    DbgPrint("Syntax error.\n");
    return;
}

DECLARE_API(intxchg)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0]=='!') args += 10; // "! intxchg "

    if (args[0] != 0)
    {
        _asm
        {
             mov       esi, args
             call      si_Expression2Integer
             jb        syntax_error
	     cmp       eax, 0ffh
	     ja	       syntax_error
             mov       dwInt, eax
        }
	ptrIntTemp=SetInterruptHandler(dwInt, ptrInt[dwInt]);
	DbgPrint("Exchange %d handler, was: %08X, now: %08X\n", dwInt, (DWORD)ptrIntTemp, (DWORD)ptrInt[dwInt]);
	ptrInt[dwInt]=ptrIntTemp;
    }
    else
    {
	help_INTXCHG();
    }

    return;

syntax_error:
    DbgPrint("Syntax error.\n");
    return;
}

DECLARE_API(intshow)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);
	UNREFERENCED_PARAMETER(args);

	DbgPrint("Internal interrupt handler table:\n");
	for (DWORD i = 0; i < 0xff; i++)
	{
		if (ptrInt[i]!=0) DbgPrint("%d handler: %08X\n", i, ptrInt[i]);
	}
}
