/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_iqrl.cpp

Abstract: Implements !IRQL extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"

////////////////////////////////////////////////////////////////////////////
//
// IRQL
//
//   Display current IRQL level
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(irql)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);
	UNREFERENCED_PARAMETER(args);

    DWORD IrqlLev = si_GetCurrentIRQLLevel();

    DbgPrint("Current IRQL: %d ", IrqlLev);

    switch (IrqlLev)
    {
        case PASSIVE_LEVEL:  DbgPrint("(PASSIVE_LEVEL)\n");     break;
        case APC_LEVEL:      DbgPrint("(APC_LEVEL)\n");         break;
        case DISPATCH_LEVEL: DbgPrint("(DISPATCH_LEVEL)\n");    break;
        case PROFILE_LEVEL:  DbgPrint("(PROFILE_LEVEL)\n");     break;
        case CLOCK1_LEVEL:   DbgPrint("(CLOCK1_LEVEL)\n");      break;
        case IPI_LEVEL:      DbgPrint("(IPI_LEVEL)\n");         break;
        case POWER_LEVEL:    DbgPrint("(POWER_LEVEL)\n");       break;
        case HIGH_LEVEL:     DbgPrint("(HIGH_LEVEL) - Wow!\n"); break;

        default:             DbgPrint("\n");                    break;
    }       
}
