/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_lastbranch.cpp

Abstract: Implements !LASTBRANCH extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>
#include <string.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"

extern void help_LASTBRANCH(void);

////////////////////////////////////////////////////////////////////////////
//
// LASTBRANCH
//
//  Shows last branch info recorded by SoftICE
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(lastbranch)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);
  
    if (args[0] == '!') args += 13; // "! lastbranch "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_LASTBRANCH();
         return;
    }

    dprintf("  MSR LastBranchFromIP=%08X\n", *si_MSR_LAST_BRANCH_0); 
    dprintf("    MSR LastBranchToIP=%08X\n", *si_MSR_LAST_BRANCH_1); 
}