/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    loadfile.cpp

Abstract: Implements !LOADFILE extension command. 

Revision History:

 Sten        26/06/2003
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "softice.h"
#include "defs.h"

extern void help_LOADFILE(void);

extern PVOID loadBuffer;  // pointer to kernel mode memory where loaded file is located
extern PVOID loadAddr;    // memory address to where we must load file
extern int   loadSize;    // file size
extern DWORD loadCR3;     // CR3 of the process we must load file to

#define OBJ_PREFIX      "\\??\\"
#define OBJ_PREFIX_LEN  (sizeof(OBJ_PREFIX)-1)

DECLARE_API(suspend);  

////////////////////////////////////////////////////////////////////////////
//
// LOADFILE
//
//  Load disk file to memory
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(loadfile)
{
    char FileName[256];
  
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (si_IceVersion <= 200) args += 11; // "! loadfile "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_LOADFILE();
         return;
    }
 
    if (args[0]==0)
    {
         help_LOADFILE();
         return;
    }

    if (si_GetCurrentIRQLLevel() >= DISPATCH_LEVEL)
    {
         DbgPrint("ERROR: IRQL is too high.\n");
         return;
    }

    // parse command line
    __asm
    {
          mov      esi, args
          lea      edi, FileName

my_loop:                                    ; get filename
          lodsb          
          cmp      al,  ' '
          jz       loop_end
          cmp      al, 0
          jz       loop_end
          stosb
          jmp      my_loop
loop_end:
          
          cmp      byte ptr [esi], 0
          jz       syntax_error

          call     si_Expression2Integer
          jb       syntax_error

          mov      loadAddr, eax
    }    

    if (strncmp(FileName, OBJ_PREFIX, OBJ_PREFIX_LEN) != 0)
    {
        if ((strlen(FileName)+OBJ_PREFIX_LEN+sizeof(char)) < sizeof(FileName))
        {
            RtlMoveMemory(FileName+OBJ_PREFIX_LEN, FileName, strlen(FileName));
            RtlCopyMemory(FileName, OBJ_PREFIX, OBJ_PREFIX_LEN);
        }
    }

    loadCR3 = ClientRegs->CR3;

    DbgPrint("LOADFILE: %s %x\n", FileName, loadAddr);

    SheduleReadFile(FileName, &loadBuffer, &loadSize);

    suspend( 
             hCurrentProcess,    
             hCurrentThread,     
             dwCurrentPc,        
             dwProcessor,
             args
           );        

    return;

syntax_error:
    DbgPrint("Syntax error.\n");
    return;
}