/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_protect.cpp

Abstract: Implements !PROTECT command.
          Turns protection ON/OFF. 

Revision History:

 Sten        08/03/2003
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>
#include <string.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"

extern void help_PROTECT(void);

extern DWORD protect_MeltICE;
extern DWORD protect_NtQuerySystemInformation;
extern DWORD protect_INT3;
extern DWORD protect_UEF_Flag;
extern DWORD protect_CR4_DE;

extern DWORD protSetUEFPatch(DWORD);
extern ULONG protSetCR4_DE_Patch(ULONG fDisableProtection);


////////////////////////////////////////////////////////////////////////////
//
// PROTECT
//
//   Change SoftICE protection ON/OFF
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(protect)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if(args[0]=='!') args += 10;          // "! protect "

    if (_stricmp(args, "ON") == 0)
    {   // turn protection ON
        protect_MeltICE                  = 1;
        protect_NtQuerySystemInformation = 1;
        protect_INT3                     = 1;
        protSetUEFPatch(FALSE);     // disable Unhandled Exception Filter patching
        protSetCR4_DE_Patch(FALSE); // disable CR4 DE patching
        dprintf("Protection is ON\n");
    }
    else
    if (_stricmp(args, "OFF") == 0)
    {   // turn protection OFF
        protect_MeltICE                  = 0;
        protect_NtQuerySystemInformation = 0;
        protect_INT3                     = 0;
        protSetUEFPatch(TRUE);     // enable Unhandled Exception Filter patching
        protSetCR4_DE_Patch(TRUE); // enable CR4 DE patching
        dprintf("Protection is OFF\n");
    }                         
    else
    if (_strnicmp(args, "UEF", 3) == 0)
    {   // UEF protection 
        args += 3;
        while ((*args == ' ') && (*args != 0)) args++; // skip white spaces

        if (_stricmp(args, "ON") == 0)
        {
             protSetUEFPatch(FALSE); // disable Unhandled Exception Filter patching
        }
        else
        if (_stricmp(args, "OFF") == 0)
        {
             protSetUEFPatch(TRUE);  // enable Unhandled Exception Filter patching
        }
    }
    else
    if (_strnicmp(args, "MELTICE", 7) == 0)
    {   // MeltICE protection 
        args += 7;
        while ((*args == ' ') && (*args != 0)) args++; // skip white spaces

        if (_stricmp(args, "ON") == 0)
        {
             protect_MeltICE                  = 1;
        }
        else
        if (_stricmp(args, "OFF") == 0)
        {
             protect_MeltICE                  = 0;
        }
    }
    else
    if (_strnicmp(args, "INT3", 4) == 0)
    {   // INT3 protection 
        args += 4;
        while ((*args == ' ') && (*args != 0)) args++; // skip white spaces

         if (_stricmp(args, "ON") == 0)
         {
              protect_INT3                     = 1;
         }
         else
         if (_stricmp(args, "OFF") == 0)
         {
              protect_INT3                     = 0;
         }
    }
    else
	if (_strnicmp(args, "SYSINF", 6) == 0)
    {   // NtQuerySystemInformation protection 
        args += 6;
        while ((*args == ' ') && (*args != 0)) args++; // skip white spaces

        if (_stricmp(args, "ON") == 0)
        {
             protect_NtQuerySystemInformation = 1;
        }
        else
        if (_stricmp(args, "OFF") == 0)
        {
             protect_NtQuerySystemInformation = 0;
        }
    }
    else
	if (_strnicmp(args, "DE", 2) == 0)
    {   // CR4 DE protection 
        args += 2;
        while ((*args == ' ') && (*args != 0)) args++; // skip white spaces

		if (_stricmp(args, "ON") == 0)
        {
             protSetCR4_DE_Patch(FALSE); // disable CR4 DE patching
        }
        else
        if (_stricmp(args, "OFF") == 0)
        {
             protSetCR4_DE_Patch(TRUE); // enable CR4 DE patching
        }
    }
    else
    if (_strnicmp(args, "/H",2) == 0)
    {
        help_PROTECT();
        return;
    }

    // display information about protection
    dprintf("MeltICE protection                  is %s\n", 
                             protect_MeltICE ? "ON" : "OFF");
    dprintf("NtQuerySystemInformation protection is %s\n", 
                             protect_NtQuerySystemInformation ? "ON" : "OFF");
    dprintf("INT3 protection                     is %s\n", 
                             protect_INT3 ? "ON" : "OFF");

    dprintf("UnhandledExceptionFilter protection is %s\n", 
                             protect_UEF_Flag ? "ON" : "OFF");

    dprintf("CR4 Debug Extensions bit protection is %s\n", 
                             protect_CR4_DE ? "ON" : "OFF");
}

