/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_pte.cpp

Abstract: Implements !PTE extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"
#include "undoc.h"

extern void help_PTE(void);

////////////////////////////////////////////////////////////////////////////
//
// PTE
//
//   Display PDE and PTE of given address.
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(pte)
{
    DWORD Addr;
    DWORD *Pde;
    DWORD *Pte;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0] == '!') args += 6; // "! pte "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_PTE();
         return;
    }
 
    if (args[0]==0)
    {
         help_PTE();
         return;
    }

    __asm
    {
          mov     esi, args
          call    si_Expression2Integer
          jb      syntax_error
          mov     Addr, eax
    }


    InitSEH();
    __try
    {
          Pde = (DWORD*)GetPde((void*)Addr);
          Pte = (DWORD*)GetPte((void*)Addr);

          PHARDWARE_PTE hpde = (PHARDWARE_PTE)Pde;
          PHARDWARE_PTE hpte = (PHARDWARE_PTE)Pte;

          DbgPrint(    "%08X   PDE at %08X   PTE at   %08X\n",   Addr,Pde,Pte);
          DbgPrint("         contains %08X   contains %08X(%08X)\n\n", *Pde,*Pte, *(DWORD**)hpte);

          DbgPrint("         Present       : %d   Present       : %d\n", hpde->Valid,           hpte->Valid);
          DbgPrint("         Writeable     : %d   Writeable     : %d\n", hpde->Write,           hpte->Write);
          DbgPrint("         User-mode     : %d   User-mode     : %d\n", hpde->Owner,           hpte->Owner);
          DbgPrint("         Write-Trough  : %d   Write-Trough  : %d\n", hpde->WriteThrough,    hpte->WriteThrough);
          DbgPrint("         Cache-Disabled: %d   Cache-Disabled: %d\n", hpde->CacheDisable,    hpte->CacheDisable);
          DbgPrint("         Accessed      : %d   Accessed      : %d\n", hpde->Accessed,        hpte->Accessed);
          DbgPrint("                             Dirty         : %d\n",                         hpte->Dirty);
          DbgPrint("         PageSize      : %d   PAT           : %d\n", hpde->LargePage,       hpte->LargePage);
          DbgPrint("                             Global        : %d\n",                         hpte->Global);
          DbgPrint("                             CopyOnWrite   : %d\n",                         hpte->CopyOnWrite);
          DbgPrint("         PageFrame:   %04X   PageFrame:   %04X\n",   hpde->PageFrameNumber, hpte->PageFrameNumber);
    }
    __except(EXCEPTION_EXECUTE_HANDLER)
    {
          DbgPrint("PTE ERROR: Exception occured.\n");
    }
    CleanupSEH();
    return;

syntax_error:
    DbgPrint("Syntax error.\n");
    return;
}
