/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_sdt.cpp

Abstract: Implements !SDT extension command. 

Revision History:

 Sten        03/10/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"
#include "ntoskrnl.h"

extern WINDBG_EXTENSION_APIS ExtensionApis;

extern void help_SDT(void);

static TableNum = 0;
static ServiceDescriptorTableEntry_t *Table;

////////////////////////////////////////////////////////////////////////////
//
// SDT
//
//   Display Service Descriptor Table
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(sdt)
{
    DWORD  Addr;
    UCHAR  chBuffer[200];
    ULONG  Displacement;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if(args[0]=='!') args += 6;          // "! sdt "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_SDT();
         return;
    }

    if (args[0] == '0') TableNum = 0;
    else
    if (args[0] == '1') TableNum = 1;
    else
    if (args[0] == '2') TableNum = 2;
    else
    if (args[0] == '3') TableNum = 3;
    else
    {
         help_SDT();
         return;
    }

    if ((si_GetCurrentIRQLLevel() >= DISPATCH_LEVEL) && (TableNum != 0))
    {
       dprintf("Warning: IRQL too high. Some descriptor tables may not be available.\n");
    }

    Table = KeServiceDescriptorTableShadow;
    dprintf("Service Descriptor Table %d at %08X\n", TableNum, (DWORD)Table);
    dprintf("Serv     Addr          Name\n");

    // Display each element of SDT
    for (DWORD i=0; i<Table->Table[TableNum].NumberOfServices; i++)
    {
        Addr = Table->Table[TableNum].ServiceTableBase[i];

        GetSymbol((PVOID)Addr, chBuffer, &Displacement);

        dprintf("%04X:  %08X  %s\n", i, Addr, chBuffer); // Note that dprintf function
                                                         // outputs text "screen by screen"
    }
}
