/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
Module Name:
    cmd_test.cpp

Abstract: Implements !TEST extension command. 
    Only for debugging purposes.

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"
#include "screen.h"
#include "multicpu.h"

#include "pci.h"
#include "ac97.h"
#include "mp3.h"

////////////////////////////////////////////////////////////////////////////
//
// Only for debugging purposes
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(test)
{
    DWORD Addr;
    DWORD Len;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    si_Exec("u KERNEL32!UnhandledExceptionFilter");
    return;

    DbgPrint("Current KTHREAD: %08X\n", *si_CurrentContext);
    return;

    // parse command line
    __asm
    {
			mov      esi, args

			cmp      byte ptr [esi], 0
			jz       syntax_error

			call     si_Expression2Integer
			jb       syntax_error

			mov      Addr, eax
			cmp      byte ptr [esi], 0
			jz       syntax_error

			call     si_Expression2Integer
			jb       syntax_error

			mov      Len, eax
    }    

    DbgPrint("Playing Addr=%08X Len=%08X\n", Addr, Len);

    if (AC97_PCI_ADDRESS)
    {
        ac97_PrepareToPlay();
	    ac97_SetMasterVolume(0x0505);
	    ac97_SetPcmOutVolume(0x0505);

        mp3_Init((void *)Addr, Len); 

        mp3_GetData(WAV_BUFFER1, WAV_BUFFER_SIZE);
        mp3_GetData(WAV_BUFFER2, WAV_BUFFER_SIZE);

        // we've already decoded several mp3 frames, so we can get current sample rate
	    ac97_SetPcmFrontDacRate((WORD)mp3_GetCurrentSampleRate());
	    ac97_SetPcmSurroundDacRate((WORD)mp3_GetCurrentSampleRate());

        si_EmptyKbdBuffer();
	    ac97_Play();
        ac97_Loop();

        mp3_Done();
    }
    else
    {
        DbgPrint("AC97 codec is not found.\n");
        return;
    }


    DbgPrint("Current index:    %02X\n", ac97_GetCurrentIndex());

    ac97_Stop();
    ac97_ResetDMA(); // to be sure we've stopped everything even something 
                     // Window's drivers were playing.. he-he. :)
    return;

syntax_error:
    DbgPrint("Syntax error.\n");
    return;

}
