/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_idt.cpp

Abstract: Implements !UNHOOK extension command. 

Revision History:

 Sten      15/10/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>
#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "intel.h"
#include "softice.h"

extern WINDBG_EXTENSION_APIS ExtensionApis;

static BYTE fUnhooked              = 0; // Unhook flag
static BYTE SavedActivateHooksByte = 0; // Old byte

////////////////////////////////////////////////////////////////////////////
//
// UNHOOK
//
//   For internal use ONLY
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(unhook)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);
	UNREFERENCED_PARAMETER(args);

    if (!fUnhooked)
    {
        si_DeActivateHooks(); // Just to be sure
                              // Normally hooks are deactivated while SoftICE
                              // is active

        // Save first byte of si_ActivateHooks
        SavedActivateHooksByte = *(BYTE*)(si_ActivateHooks);

        // Patch si_ActivateHooks so that hooks couldn't be activated
        *(BYTE *)(si_ActivateHooks) = 0xC3; // retn

        // Set unhook flag
        fUnhooked = 1;
    }
}

////////////////////////////////////////////////////////////////////////////
//
// REHOOK
//
//   For internal use ONLY
//
////////////////////////////////////////////////////////////////////////////

int RehookSystemApi (void)
{
    if (fUnhooked)
    {
      // restore old si_ActivateHooks byte
      *(BYTE *)(si_ActivateHooks) = SavedActivateHooksByte;

      // Clear unhook flag
      fUnhooked = 0;
      return 1;
    }
    else
      return 0;
}

DECLARE_API(rehook)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);
	UNREFERENCED_PARAMETER(args);

    if (!RehookSystemApi())
        DbgPrint("Nothing to rehook.\n");
}