#ifndef __DEFS_H__
#define __DEFS_H__

#undef EXPORT
#ifdef __cplusplus
#define EXPORT extern "C"
#else
#define EXPORT
#endif

#include "intel.h"

#define NT_HIGHEST_USER_ADDRESS                       0x7EEEEEEE

typedef unsigned long   DWORD;
typedef unsigned short   WORD;
typedef unsigned char    BYTE;

void RemoveBugCheckHandler();

// main.cpp
extern void Init(void);
extern void SheduleDumpFile(char *FileName, void *Addr, int Size);
extern void SheduleReadFile(char *FileName, void **ReadHere, int *Size);

// seh.cpp
extern void InitSEH();
extern void CleanupSEH();

// utils.cpp
EXPORT BOOLEAN IsAddressValid(void *Addr);
EXPORT void*   SetInterruptHandler(int IntNo, void *HandlerPtr, BYTE flags = 0x8e);
EXPORT DWORD*  GetPde(void*Address); 
EXPORT DWORD*  GetPte(void*Address);
EXPORT void    SetInterruptFlags(int IntNo, WORD flags);
EXPORT void*   GetInterruptHandler(DWORD IntNo, DWORD IdtNum = 0);
EXPORT DWORD   GetIDTLimit();
EXPORT void    GetIDTEntry(DWORD IntNo, PIdtEntry_t entry, DWORD IdtNum = 0);

// siwvid.cpp
EXPORT NTSTATUS siw_LoadFont(char *Font, int Size);


////////////////////////////////////////////////////////////////////////////
//
// Enable write 
//     Clears write-protect bit in CR0 register.
//     Enables write access to system pages
//     RETURNS: old CR0 register value
//
////////////////////////////////////////////////////////////////////////////
EXPORT DWORD EnableWrite();

////////////////////////////////////////////////////////////////////////////
//
// Disable write 
//     Sets write-protect bit in CR0 register.
//     Disables write access to system pages
//
////////////////////////////////////////////////////////////////////////////
EXPORT void DisableWrite();


// modules.cpp

/////////////////////////////////////////////////////////////////////////////
//
// UtGetModuleBase
//
//   Returns the kernel module base address given any address inside the
//   module.
//
/////////////////////////////////////////////////////////////////////////////

ULONG UtGetModuleBaseByAddr(ULONG dwAddr);

////////////////////////////////////////////////////////////////////////////
//
// UtGetModuleBase
//
//   Returns the kernel module base address.
//
////////////////////////////////////////////////////////////////////////////
EXPORT DWORD UtGetModuleBase(const char *Mod);

////////////////////////////////////////////////////////////////////////////
//
// UtGetProcAddress
//
//   Returns procedure address
//
////////////////////////////////////////////////////////////////////////////
EXPORT PVOID UtGetProcAddress(HANDLE hModule, char *lpProcName);

////////////////////////////////////////////////////////////////////////////
//
// Set CR0 register value 
//     Sets write-protect bit in CR0 register.
//     Disables write access to system pages
//
////////////////////////////////////////////////////////////////////////////
void SetCR0(DWORD dwValue);

#undef EXPORT
#endif 