/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    main.cpp

Abstract: Implements DriverEntry and other driver-related functions. 

Revision History:

        29.11.2002 - File renamed to main.cpp
 Sten   05/06/2002 - dbg.cpp Initial release
        

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed
#pragma warning ( disable: 4127 ) // conditional expression is constant

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>
#include "wdbgexts.h"
#include "ver.h"
#include "defs.h"
#include "pgfault.h"
#include "ntoskrnl.h"
#include "softice.h"
#include "multicpu.h"
#include "ac97.h"
#include "keyboard.h"

extern "C" {
extern char Font08x08;
extern char Font08x16;
}


extern void InitThread();
extern DWORD si_Init();

extern void InstallActivateBPsHook();           // activatehook.cpp
extern void RemoveActivateBPsHook();

extern void InstallDeactivateBPsHook();         // activatehook.cpp
extern void RemoveDeactivateBPsHook();

extern NTSTATUS InitSwapContextHook();          // taskswch.cpp
extern void     RemoveSwapContextHook();

extern NTSTATUS InitProcessHook();              // process.cpp
extern void     RemoveProcessHook();

extern NTSTATUS ProtectInit();                  // protect.cpp
extern void     ProtectDone();

extern NTSTATUS InitNTosKernel();               // ntoskrnl.cpp

extern int      RehookSystemApi();              // cmd_unhook.cpp

extern NTSTATUS InitSiwvid(PDRIVER_OBJECT Drv); // siwvid.cpp
extern void     DoneSiwvid();

extern void     MyDumpFilter(void);             // cmd_cp.cpp

extern NTSTATUS InitTracer(void);               // tracer.cpp
extern void     DoneTracer(void);

VOID UnloadDriver(IN PDRIVER_OBJECT Driver);

PDRIVER_OBJECT MyDriver=0;

static char szBanner[] =
    "------------------------------------------------------\n"
    "-              IceExt version %u.%02u                   -\n"
    "-              (c) Sten, 2002-2004                   -\n"
    "------------------------------------------------------\n";

BOOLEAN IsRegistryKeyExists(IN PWSTR pszRegPath, IN PWSTR pszParameter)
{
    HANDLE hkey;
    NTSTATUS ntStatus;
    OBJECT_ATTRIBUTES oa;
    UNICODE_STRING    RegistryPath;

    ASSERT(pszRegPath);
    if (!pszRegPath)
        return FALSE;

    RtlInitUnicodeString(&RegistryPath, pszRegPath);
    InitializeObjectAttributes(&oa, &RegistryPath, OBJ_KERNEL_HANDLE | OBJ_CASE_INSENSITIVE, NULL, NULL);
    
    ntStatus = ZwOpenKey(&hkey, KEY_READ, &oa);

    if (NT_SUCCESS(ntStatus))
    {
        ULONG size = 0;

        RtlInitUnicodeString(&RegistryPath, pszParameter);
        ntStatus = ZwQueryValueKey(hkey, &RegistryPath, KeyValuePartialInformation, NULL, 0, &size);
        if (ntStatus == STATUS_BUFFER_TOO_SMALL) ntStatus = STATUS_SUCCESS;

        ZwClose(hkey);
    }

    return NT_SUCCESS(ntStatus);
}

ULONG ReadRegistryUlong(IN PWSTR pszRegPath, IN PWSTR pszParameter, ULONG ulDefaultValue)
{
    HANDLE hkey;
    NTSTATUS ntStatus;
    OBJECT_ATTRIBUTES oa;
    UNICODE_STRING    RegistryPath;

    struct{
        KEY_VALUE_PARTIAL_INFORMATION kvpi;
        UCHAR                         Padding[3];
    }reg_data;

    ASSERT(pszRegPath);
    if (!pszRegPath)
        return ulDefaultValue;

    RtlZeroMemory(&reg_data, sizeof(reg_data));

    RtlInitUnicodeString(&RegistryPath, pszRegPath);
    InitializeObjectAttributes(&oa, &RegistryPath, OBJ_KERNEL_HANDLE | OBJ_CASE_INSENSITIVE, NULL, NULL);
    
    ntStatus = ZwOpenKey(&hkey, KEY_READ, &oa);

    if (NT_SUCCESS(ntStatus))
    {
        ULONG size = 0;

        RtlInitUnicodeString(&RegistryPath, pszParameter);
        ntStatus = ZwQueryValueKey(hkey, &RegistryPath, KeyValuePartialInformation, &reg_data, sizeof(reg_data), &size);
        ZwClose(hkey);
    }

    return NT_SUCCESS(ntStatus) ? *(PULONG)&reg_data.kvpi.Data : ulDefaultValue;
}

/////////////////////////////////////////////////////////////////////////////
//
// DriverEntry
//   
//   NOTE: SoftICE calls this routine from it's hook with params like to 
//         DLLEntryPoint
/////////////////////////////////////////////////////////////////////////////

extern "C"
NTSTATUS DriverEntry(IN PDRIVER_OBJECT  DriverObject,
                     IN PUNICODE_STRING RegistryPath)
{
    UNREFERENCED_PARAMETER(RegistryPath);

    MyDriver = DriverObject;
    DriverObject->DriverUnload = UnloadDriver;

    // print banner
    DbgPrint(szBanner, ICEEXT_VERSION_MAJOR, ICEEXT_VERSION_MINOR);

    mp_Init(); // init MP module
    si_Init(); // find some useful SoftICE functions

    ULONG dwIceExtBase = UtGetModuleBaseByAddr((ULONG)&UnloadDriver);

    if (dwIceExtBase && si_InitCompleted)
    {
        si_LoadKDE(dwIceExtBase);
    }
    else
    {
        si_InitCompleted = FALSE;
    }

    return STATUS_SUCCESS;
}

/////////////////////////////////////////////////////////////////////////////
//
//  WinDbgExtensionDllInit
//
//    
//
/////////////////////////////////////////////////////////////////////////////
EXT_API_VERSION        ApiVersion = { 3, 5, EXT_API_VERSION_NUMBER, 0 };
WINDBG_EXTENSION_APIS  ExtensionApis;
static USHORT          SavedMajorVersion;
static USHORT          SavedMinorVersion;

static VOID ProcessIniFile(VOID);

VOID
WinDbgExtensionDllInit(PWINDBG_EXTENSION_APIS   lpExtensionApis,
                       USHORT                   MajorVersion,
                       USHORT                   MinorVersion)
{
    ExtensionApis = *lpExtensionApis;

    DbgPrint("mp_PCR_VA:                                    %08X\n", mp_PCR_VA);
    DbgPrint("mp_PCR_VA_array:                              %08X\n", mp_PCR_VA_array);
    DbgPrint("mp_NumOfCPUs:                                 %08X\n", mp_NumOfCPUs);

    SavedMajorVersion = MajorVersion;
    SavedMinorVersion = MinorVersion;

    if (!si_InitCompleted) return; // nothing to do
                                     
    if (!NT_SUCCESS(InitNTosKernel())) // find addresses of NTOSKRNL.EXE and
                                       // NTDLL.DLL and link dynamically some
                                       // symbols.
								       // N.B. This is critical function, so I do not
								       // continue initialization if it fails.
    {
	si_InitCompleted = FALSE;
	return;
    }

    InitSiwvid(MyDriver);       // Initialize interface to the Siwvid driver

    si_InstallDumpFilter(MyDumpFilter); // Install my own dump window character 
                                        // filter. So that SoftICE will
                                        // display russian symbols in dump.

    InstallInt0eHandler();      // install my own page faults handler
                                // I can't do it in DriverEntry, because I get
                                // wrong OldHandler this way.

    InstallActivateBPsHook();   // Install my own activate BPs hook 
                                // inside SoftICE body

    InstallDeactivateBPsHook(); // Install my own deactivate BPs hook 
                                // inside SoftICE body



    InitSwapContextHook();      // Install my own swap context hook into
                                // ntoskrnl.exe image

    InitProcessHook();          // Install process creation/deletion hook

    ProtectInit();              // Install protection hooks

    InitTracer();               // Install tracer hooks 

    ac97_Init();                // Initialize AC'97 subsystem

    InitThread();

//
// Sten: ProcessIniFile() is temporarily commented out as this call 
//       causes BSOD when IceExt driver is loaded with help of loader 
//       application.
//
//       TODO: Fix this.
//
//    ProcessIniFile();           // Process WinIce.DAT and execute IceExt initialization line

    DbgPrint("------------------------------------------------------\n");

    return;
}// WinDbgExtensionDllInit()

/////////////////////////////////////////////////////////////////////////////
//
// UnloadDriver
//
//   Called at driver unload. Calls all ShutdownXXX & RemoveXXX routines.
//
/////////////////////////////////////////////////////////////////////////////

VOID UnloadDriver(IN PDRIVER_OBJECT Driver)
{
    PAGED_CODE(); 

    UNREFERENCED_PARAMETER(Driver);

    DbgPrint("UNLOAD CALLED\n");

    mp_Done();

    DbgPrint("Clearing Bang Funcs Array.\n");
    si_ClearBangFuncsArray();

    if (!si_InitCompleted) return; // nothing to do

    DbgPrint("Removing dump filter.\n");
    si_RemoveDumpFilter();     // Removes my own dump window character filter. 

    DbgPrint("Removing int 0e handler.\n");
    RemoveInt0eHandler();      // remove my page faults handler
                               // not a good idea to do it, because something
                               // can hook int 0E after I've installed my handler

    DbgPrint("Removing ActivateBPs hook.\n");
    RemoveActivateBPsHook();   // remove my own activate BPs hook from
                               // SoftICE body

    DbgPrint("Removing DeactivateBPs hook.\n");
    RemoveDeactivateBPsHook(); // remove my own deactivate BPs hook from
                               // SoftICE body

    DbgPrint("Removing SwapContext hook.\n");
    RemoveSwapContextHook();   // remove my own SwapContext hook from
                               // ntoskrnl.exe image

    DbgPrint("Removing Process hook.\n");
    RemoveProcessHook();       // remove the process creation/deletion hook

    DbgPrint("Calling DoneTracer.\n");
    DoneTracer();              // remove all tracer hooks

    DbgPrint("Calling ac97_Done.\n");
    ac97_Done();

    DbgPrint("Calling ProtectDone.\n");
    ProtectDone();             // remove protection hooks

    DbgPrint("Rehooking system api.\n");

    RehookSystemApi();         // restore old byte at si_ActivateHooks if
                               // !UNHOOK cmd has been used

    DbgPrint("Activating hooks.\n");
    si_ActivateHooks();        // Activate SoftICE hooks

    // Load standard siwvid 8x8 font
    // Don't know where to get standard 8x16 font
    DbgPrint("Loading standard font.\n");
    siw_LoadFont((char*)si_Fonts[0]->Body, 2048);

    DbgPrint("Deinitializing Siwvid.\n");
    DoneSiwvid();              // Deinitialize Siwvid

    // Now we must set SoftICE to use it's old font
    si_PutToKbdBufferChar('s');    // "set font 1"
    si_PutToKbdBufferChar('e');
    si_PutToKbdBufferChar('t');
    si_PutToKbdBufferChar(' ');
    si_PutToKbdBufferChar('f');
    si_PutToKbdBufferChar('o');
    si_PutToKbdBufferChar('n');
    si_PutToKbdBufferChar('t');
    si_PutToKbdBufferChar(' ');
    si_PutToKbdBufferChar((const char)('1' + *si_CurFontIdx));

    si_PutToKbdBufferChar('\x0D'); // ENTER

    si_PutToKbdBufferChar('x');    // "x"

    si_PutToKbdBufferChar('\x0D'); // ENTER

    si_NTIce();                    // execute

    DbgPrint("UNLOAD OK.\n");

    return;
} // Unload driver

/*
VOID ProcessIniFile(VOID)
{
    IO_STATUS_BLOCK           ioStatus;
    ULONG                     ntStatus;
    UNICODE_STRING            unicodeFullName;
    OBJECT_ATTRIBUTES         objectAttributes;
    FILE_STANDARD_INFORMATION eof;
    HANDLE                    hFile         = 0;
    PUCHAR                    pWinIceBuffer = NULL;

    RtlInitUnicodeString(&unicodeFullName, L"\\SystemRoot\\System32\\drivers\\WINICE.DAT");

    InitializeObjectAttributes( &objectAttributes,
                                &unicodeFullName,
                                OBJ_CASE_INSENSITIVE,
                                NULL,
                                NULL);

    ntStatus = ZwCreateFile( &hFile,
               GENERIC_READ | SYNCHRONIZE,
               &objectAttributes,
               &ioStatus,
               0,
               FILE_ATTRIBUTE_NORMAL,
               0,
               FILE_OPEN_IF,               
               FILE_SYNCHRONOUS_IO_NONALERT,
               NULL,
               0);

    if(!NT_SUCCESS(ntStatus))
	{
        DbgPrint("IceExt was unable to open WINICE.DAT (%08X)\n", ntStatus);
	    goto cleanup;
	} 

    ntStatus = ZwQueryInformationFile(hFile, &ioStatus, &eof, sizeof(eof), FileStandardInformation);

    if(!NT_SUCCESS(ntStatus))
    {
        DbgPrint("IceExt was unable get WINICE.DAT file size (%08X)\n", ntStatus);
	    goto cleanup;
    }

	pWinIceBuffer = (PUCHAR)ExAllocatePool(PagedPool, eof.EndOfFile.LowPart+sizeof(UCHAR));

	if (!pWinIceBuffer)
	{
        DbgPrint("IceExt was unable to allocate %d bytes of memory\n", eof.EndOfFile.QuadPart);
	    goto cleanup;
	}

    ntStatus = ZwReadFile(hFile,
                          NULL,
                          NULL,
                          NULL,
                          &ioStatus,
                          pWinIceBuffer,
                          eof.EndOfFile.LowPart,
                          NULL,
                          NULL);

	if (!NT_SUCCESS(ntStatus))
	{
        DbgPrint("IceExt was unable to read WINICE.DAT into memory\n", eof.EndOfFile.QuadPart);
	    goto cleanup;
	}

	DbgPrint("WINICE.DAT: %08X\n", pWinIceBuffer);

	//
	// Process WinICE.DAT
	//
	pWinIceBuffer[eof.EndOfFile.LowPart] = '\0';

    BOOL   fTagFound; fTagFound = FALSE;
    PUCHAR pBuf; pBuf = pWinIceBuffer;

#define INIT_LINE_TAG      "EXTINIT"
#define INIT_LINE_TAG_SIZE (sizeof(INIT_LINE_TAG) - sizeof(UCHAR))	
    do
	{
		// exit if size of the rest of the buffer is not enough to hold EXTINIT tag
        if ((ULONG_PTR)(pBuf - pWinIceBuffer + INIT_LINE_TAG_SIZE) >= eof.EndOfFile.LowPart) break;

		// search for EXTINIT tag
        if (_strnicmp((const char *)pBuf, INIT_LINE_TAG, INIT_LINE_TAG_SIZE) != 0) goto next_line;
        pBuf += INIT_LINE_TAG_SIZE;

		// check for '=' sign
		while (*pBuf == ' ' || *pBuf == '\t') pBuf++; // skip white spaces
		if ((*pBuf) != '=') goto next_line;
		pBuf++;

		// check for opening apostrophe
		while (*pBuf == ' ' || *pBuf == '\t') pBuf++; // skip white spaces
        UCHAR chBrace; chBrace = *pBuf;

		// " or ' allowed here
		switch(chBrace)
		{
		    case '\'':
			case '"': 
				 break;

			default: 
				goto next_line;
        }

		pBuf++; // skip apostrophe 
       	while (*pBuf == ' ' || *pBuf == '\t') pBuf++; // skip white spaces

		fTagFound = TRUE;

		do
		{
    		if (*pBuf == '\0')    break; // end of file?
    		if (*pBuf == chBrace) break; // end of line?
     
    		if (*pBuf == ';')
			{
                si_PutToKbdBufferChar(KBD_ENTER);             // treat ';' character as ENTER
                pBuf++;  
             	while (*pBuf == ' ' || *pBuf == '\t') pBuf++; // skip white spaces
			}
			else
			{
	    		si_PutToKbdBufferChar(*pBuf);
                pBuf++;
			} 

		}while(*pBuf != '\n');

		break;

      	// search for CR
next_line:
		do 
		{
    		if (*pBuf == '\0') break;
			pBuf++;
		}while(*pBuf != '\n');

		pBuf++;
	}while(*pBuf != '\0');

	if (fTagFound) si_NTIce(); // execute commands

cleanup:
	if (pWinIceBuffer) ExFreePool(pWinIceBuffer);
	ZwClose(hFile);
}
*/
/////////////////////////////////////////////////////////////////////////////
//
//  ExtensionApiVersion
//
//    Get Extension Api Version    
//
/////////////////////////////////////////////////////////////////////////////

extern "C" LPEXT_API_VERSION 
ExtensionApiVersion(VOID)
{
    return &ApiVersion;
}// ExtensionApiVersion()

/////////////////////////////////////////////////////////////////////////////
//
//  CheckVersion
//
//    Check Extension Api Version    
//
/////////////////////////////////////////////////////////////////////////////

extern "C" VOID 
CheckVersion(VOID)
{
#if DBG
    if ( (SavedMajorVersion != 0x0c)
       ||(SavedMinorVersion != VER_PRODUCTBUILD) )
    {
        dprintf("\r\n*** Extension DLL(%d Checked) does not match target system(%d %s)\r\n\r\n",
                VER_PRODUCTBUILD, SavedMinorVersion,
                (SavedMajorVersion==0x0f) ? "Free" : "Checked" );
    }
#else
    if ( (SavedMajorVersion != 0x0f)
       ||(SavedMinorVersion != VER_PRODUCTBUILD) )
    {
        dprintf("\r\n*** Extension DLL(%d Free) does not match target system(%d %s)\r\n\r\n",
                VER_PRODUCTBUILD, SavedMinorVersion, (SavedMajorVersion==0x0f) ? "Free" : "Checked" );
    }
#endif
}// CheckVersion()
