/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This code has been posted on NT & NDIS forum. (www.ntkernel.com/forum.shtml)

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    modules.cpp

Abstract: Implements NtGetModuleHandle & NtGetProcAddress -like functions. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#include "ntimage.h"
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed
#pragma warning ( disable: 4127 ) // conditional expression is constant

#include <stdlib.h>

#include "defs.h" 
#include "undoc.h"

/////////////////////////////////////////////////////////////////////////////
//
// UtGetModuleBase
//
//   Returns the kernel module base address given any address inside the
//   module.
//
/////////////////////////////////////////////////////////////////////////////

ULONG UtGetModuleBaseByAddr(ULONG dwAddr)
{
    dwAddr&=~0x00000FFF;

    while (1)
    {
        if (*(PSHORT)dwAddr == 'ZM') break; 
        if (*(PSHORT)dwAddr == 'MZ') break; 
 
        dwAddr -= 4096;
    }

    return dwAddr;
}

/////////////////////////////////////////////////////////////////////////////
//
// UtGetModuleBase
//
//   Returns the kernel module base address.
//
/////////////////////////////////////////////////////////////////////////////

DWORD UtGetModuleBase(const char *Mod)
{
     ULONG  i;
     PSYSTEM_MODULE_INFORMATION pModInfo;
     PULONG p;

     unsigned long Base = 0;

     ZwQuerySystemInformation( SystemModuleInformation, &i, 0, &i ); // system module info
     p = (PULONG)ExAllocatePool(NonPagedPool, sizeof(ULONG)*i);
     if (!p) return 0;

     ZwQuerySystemInformation( SystemModuleInformation, p, i * sizeof(*p), 0);
     pModInfo = (PSYSTEM_MODULE_INFORMATION)p;

     for (i=0; i<*p; i++)
     {
          if (!_stricmp((char*)pModInfo->aSM[i].abName + pModInfo->aSM[i].wNameOffset, Mod))
          {
               Base = (DWORD)pModInfo->aSM[i].pAddress;
               break;
          }
     }

     ExFreePool(p);
     return Base;
}

/////////////////////////////////////////////////////////////////////////////
//
// UtGetProcAddress
//
//   Returns procedure address
//
/////////////////////////////////////////////////////////////////////////////

PVOID UtGetProcAddress(HANDLE hModule, char *lpProcName)
{
     PIMAGE_DOS_HEADER       DosHeader  = NULL;
     PIMAGE_NT_HEADERS       NtHeader   = NULL;
     PIMAGE_DATA_DIRECTORY   ExportsDir = NULL;
     PIMAGE_EXPORT_DIRECTORY Exports    = NULL;

     PULONG Functions = NULL;
     PSHORT Ordinals  = NULL;
     PULONG Names     = NULL;
     ULONG ProcAddr   = 0;

     ULONG i=0, NumOfNames=0, iOrd=0, nSize=0;

     if (!hModule || !lpProcName) return NULL;

     DosHeader=(PIMAGE_DOS_HEADER)hModule;
     
     NtHeader=(PIMAGE_NT_HEADERS)((char*)hModule+DosHeader->e_lfanew);

     if (!NtHeader) return NULL;

     ExportsDir=NtHeader->OptionalHeader.DataDirectory+
                                       IMAGE_DIRECTORY_ENTRY_EXPORT;

     if (!ExportsDir) return NULL;

     Exports=(PIMAGE_EXPORT_DIRECTORY)((char*)hModule+ExportsDir->VirtualAddress);

     if (!Exports) return NULL;

     Functions=(PULONG)((char*)hModule+Exports->AddressOfFunctions);
     Ordinals=(PSHORT)((char*)hModule+Exports->AddressOfNameOrdinals);
     Names=(PULONG)((char*)hModule+Exports->AddressOfNames);

     NumOfNames=Exports->NumberOfNames;
     ProcAddr=ExportsDir->VirtualAddress;

     nSize=ExportsDir->Size;

     for(i=0;i<NumOfNames;i++)
     {
         iOrd=Ordinals[i];
         if(Functions[iOrd]<ProcAddr||Functions[iOrd]>(ProcAddr+nSize))
         {
             if(_stricmp((char*)hModule+Names[i],lpProcName)==0)
                 return (PVOID)((char*)hModule+Functions[iOrd]);
         }
     }
       
     return NULL;
}