#ifndef __NTOSKRNL_H__
#define __NTOSKRNL_H__

#include "defs.h"

#ifdef  __NTOSKRNL_C__
#define EXPORT
#define INIT    =0
#else
#define EXPORT       extern
#define INIT
#endif


EXPORT DWORD hNTOSKRNL INIT;
EXPORT DWORD hNTDLL    INIT;

EXPORT DWORD NTOS_TEXT_SIZE INIT;
EXPORT BYTE* NTOS_TEXT_ADDR INIT;

////////////////////////////////////////////////////////////////////////////
// NtOsKernel function typedefs
////////////////////////////////////////////////////////////////////////////
typedef struct _DIRECTORY_BASIC_INFORMATION {
UNICODE_STRING ObjectName;
UNICODE_STRING ObjectTypeName;
} DIRECTORY_BASIC_INFORMATION, *PDIRECTORY_BASIC_INFORMATION;

typedef NTSTATUS (*NTQUERYDIRECTORYOBJECT)(
	IN HANDLE hDirectory,
	OUT PDIRECTORY_BASIC_INFORMATION DirectoryEntryBuffer,
	IN ULONG DirectoryEntryBufferSize,
	IN BOOLEAN  bOnlyFirstEntry,
	IN BOOLEAN bFirstEntry,
	IN PULONG  BytesReturned,
	IN PULONG  EntryIndex
);

typedef NTSTATUS (*ZWDELAYEXECUTION)      (
                                      IN BOOLEAN Alertable,
                                      IN PLARGE_INTEGER Interval
                                          );

typedef NTSTATUS (*ZWYIELDEXECUTION) (VOID);

typedef NTSTATUS (*ZWWAITFORSINGLEOBJECT) (
                                      IN HANDLE Handle,
                                      IN BOOLEAN Alertable,
                                      IN PLARGE_INTEGER Timeout OPTIONAL
                                          );

typedef NTSTATUS (*OBOPENOBJECTBYPOINTER) (
                                      IN PVOID Object,
                                      IN ULONG HandleAttributes,
                                      IN PACCESS_STATE PassedAccessState OPTIONAL,
                                      IN ACCESS_MASK DesiredAccess OPTIONAL,
                                      IN POBJECT_TYPE ObjectType OPTIONAL,
                                      IN KPROCESSOR_MODE AccessMode,
                                      OUT PHANDLE Handle
                                          );

EXPORT ZWDELAYEXECUTION          NtDelayExecution;
EXPORT ZWYIELDEXECUTION          NtYieldExecution;
EXPORT ZWWAITFORSINGLEOBJECT     NtWaitForSingleObject;
EXPORT NTQUERYDIRECTORYOBJECT    ZwQueryDirectoryObject;

EXPORT OBOPENOBJECTBYPOINTER     ObOpenObjectByPointer;

EXPORT DWORD                     NTDLL_NtClose;

////////////////////////////////////////////////////////////////////////////
// Some declarations needed to gain access to SDT
////////////////////////////////////////////////////////////////////////////

typedef struct ServiceTableEntry 
{
	unsigned int *ServiceTableBase;
	unsigned int *ServiceCounterTableBase; //Used only in checked build
	unsigned int NumberOfServices;
	unsigned char *ParamTableBase;
}ServiceTableEntry_t;

typedef struct ServiceDescriptorEntry 
{
        ServiceTableEntry_t Table[4];  
} ServiceDescriptorTableEntry_t, *PServiceDescriptorTableEntry_t;

EXPORT ServiceDescriptorTableEntry_t *KeServiceDescriptorTable;

EXPORT ServiceDescriptorTableEntry_t *KeServiceDescriptorTableShadow;

extern "C"
{
__declspec(dllimport) _stdcall KeAddSystemServiceTable(PVOID, PVOID, PVOID, PVOID, PVOID);
}

#define SYSTEMSERVICE(_function)    KeServiceDescriptorTable->Table[0].ServiceTableBase[_function]

////////////////////////////////////////////////////////////////////////////
//
// InitNTosKernel
//
//   Find addresses of NTOSKRNL.EXE and NTDLL.DLL in memory
//   Find address and size of NTOSKRNL!CODE section
//
////////////////////////////////////////////////////////////////////////////

EXPORT NTSTATUS InitNTosKernel(void);


#undef EXPORT
#undef INIT

#endif
