/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    pageinprogress.cpp

Abstract: Contains hook function that called when pagein is in progress. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include "defs.h"
#include "softice.h"


/////////////////////////////////////////////////////////////////////////////
//
// Public variables
//
/////////////////////////////////////////////////////////////////////////////

PVOID loadBuffer;  // pointer to kernel mode memory where loaded file is located
PVOID loadAddr;    // memory address to where we must load file
int   loadSize;    // file size

DWORD loadCR3;     // CR3 of the process we must load file to

/////////////////////////////////////////////////////////////////////////////
//
//  OnPageInProgress
//
//    Hook function that called when pagein is in progress.
//
/////////////////////////////////////////////////////////////////////////////

void si_OnPageInProgressHook(void)
{
    __asm
    {
          mov        eax, cr3
          cmp        eax, loadCR3
          jne        exit_hook
    }

    // ensure we are not called twice
    loadCR3 = (ULONG)-1;

    if (!loadAddr)
    {
//       DbgPrint("Invalid loadAddr.\n");
       return;
    }

//    DbgPrint("IRQL: %u\n", KeGetCurrentIrql());

    // allocate and initialize MDL for user memory 
    PMDL mdl = IoAllocateMdl(loadAddr, loadSize, FALSE, TRUE, NULL);

    if (!mdl)
    {
        DbgPrint("ERROR: Unable to allocate MDL.\n");
        return;
    } 

    InitSEH();
    __try
    {
        MmProbeAndLockPages(mdl, KernelMode, IoWriteAccess);
    }                                 
    __except (EXCEPTION_EXECUTE_HANDLER)
    {
        DbgPrint("ERROR: Unable to lock user buffer in memory.\n");
        if (loadBuffer) ExFreePool(loadBuffer);
        IoFreeMdl(mdl);
        CleanupSEH();
        return;
    }
    CleanupSEH();

    PVOID sysaddr = MmGetSystemAddressForMdl(mdl);

    if (!sysaddr)
    {
        DbgPrint("ERROR: Unable to map MDL to system space.\n");
        if (loadBuffer) ExFreePool(loadBuffer);
        MmUnlockPages(mdl);
        IoFreeMdl(mdl);
        return;
    }

    // copy loaded file to user mode memory
    RtlCopyMemory(sysaddr, loadBuffer, loadSize);
    
    // free temporary buffer
    if (loadBuffer) ExFreePool(loadBuffer);

    // unlock user mode pages
    MmUnlockPages(mdl);

    // free allocated MDL
    IoFreeMdl(mdl);

exit_hook:
    return;
}

void __declspec (naked) si_OnPageInProgress(void)
{
    __asm
    { 
                 pushad
                 push       fs
                 push       ds
                 push       es

                 mov        ebx, 30h
                 mov        fs,  bx
                  
                 mov        ebx, 23h
                 mov        ds,  bx
                 mov        es,  bx

                 ; TO DO: ring0 prolog/epilog

                 call       si_OnPageInProgressHook

                 pop        es
                 pop        ds
                 pop        fs
                 popad
                 ret
    }
}
