/*++
    Copyright  (c) 2004 Sten
    Contact information:
        mail: stenri@mail.ru

    This code was mainly ported from jeff leyda's .wav file player for DOS. 

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    pci.h

Abstract: PCI bus functions 

Revision History:

 Sten        01/01/2004
      Initial release. Started expiriments on using AC'97.. Wow!!

--*/

#ifndef __PCI_H__
#define __PCI_H__

#define BIT0    0x00000001
#define BIT1    0x00000002
#define BIT2    0x00000004
#define BIT3    0x00000008
#define BIT4    0x00000010
#define BIT5    0x00000020
#define BIT6    0x00000040
#define BIT7    0x00000080
#define BIT8    0x00000100
#define BIT9    0x00000200
#define BIT10   0x00000400
#define BIT11   0x00000800
#define BIT12   0x00001000
#define BIT13   0x00002000
#define BIT14   0x00004000
#define BIT15   0x00008000
#define BIT16   0x00010000
#define BIT17   0x00020000
#define BIT18   0x00040000
#define BIT19   0x00080000
#define BIT20   0x00100000
#define BIT21   0x00200000
#define BIT22   0x00400000
#define BIT23   0x00800000
#define BIT24   0x01000000
#define BIT25   0x02000000
#define BIT26   0x04000000
#define BIT27   0x08000000
#define BIT28   0x10000000
#define BIT29   0x20000000
#define BIT30   0x40000000
#define BIT31   0x80000000

// PCI equates
// PCI function address (PFA)
// bit 31 = 1
// bit 23:16 = bus number     (0-255)
// bit 15:11 = device number  (0-31)
// bit 10:8 = function number (0-7)
// bit 7:0 = register number  (0-255)

#define IO_ADDR_MASK     0xFFFE         // mask off bit 0 for reading BARs
#define PCI_INDEX_PORT   0x0CF8
#define PCI_DATA_PORT    0x0CFC
#define PCI32            BIT31          // bitflag to signal 32bit access
#define PCI16            BIT30          // bitflag for 16bit access

#define PCI_FN0          (0 << 8)
#define PCI_FN1          (1 << 8)
#define PCI_FN2          (2 << 8)
#define PCI_FN3          (3 << 8)
#define PCI_FN4          (4 << 8)
#define PCI_FN5          (5 << 8)
#define PCI_FN6          (6 << 8)
#define PCI_FN7          (7 << 8)

#define PCI_CMD_REG 	 04	        // reg 04, command reg
#define IO_ENA		 BIT0          	// i/o decode enable
#define MEM_ENA		 BIT1 	        // memory decode enable
#define BM_ENA           BIT2           // bus master enable

void pciRegRead8    ( void );
void pciRegRead16   ( void );
void pciRegRead32   ( void );
void pciRegWrite8   ( void );
void pciRegWrite16  ( void );
void pciRegWrite32  ( void );
DWORD pciFindDevice ( DWORD dwID);

#endif  __PCI_H__