/*++
    This file is mostly derived from mamaich's debugger codename BlindStudio.

    Copyleft  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    Copyright (c) 2001 mamaich
    Contact information:
    	web: www.reversing.net/mamaich
        mail: mamaich@reversing.net
        ICQ# 70241285

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    pgfault.cpp

Abstract:  Exception handler. Used in !BPR command implementation.

Revision History:

 Sten        05/06/2002
      The file is fully rewritten for better understanding.
 mamaich     14/06/2001
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include "defs.h"
#include "softice.h"
#include "bpr.h"

#define  __PGFAULT_C__
#include "pgfault.h"
#undef   __PGFAULT_C__

static void *OldIntr=0;

static DWORD SavedFS=0; // not used yet
static DWORD SavedDS=0;
static DWORD SavedES=0;

/////////////////////////////////////////////////////////////////////////////
//
//  BPR_TracerCallBack
//
//    This routine called by INT 01 handler every time interrupt is
//    generated
/////////////////////////////////////////////////////////////////////////////

void __declspec(naked) BPR_TracerCallBack(void)
{
    __asm
    {
          ret
    }       
}

/////////////////////////////////////////////////////////////////////////////
//
//  Int 0E handler (page fault)
//
/////////////////////////////////////////////////////////////////////////////

void __declspec(naked) Int0eHandler(void)
{
    __asm
    {
//        call       si_RecordLastBranchInfo - MUST BE RecordLastFaultInfo !!!

          pushad
          push       fs
          push       ds
          push       es

          mov        eax, 00000030h
          mov        fs,ax

          mov        eax, 23h
          mov        ds,ax
          mov        es,ax

          mov        ebp,esp
          sub        esp,32

          cmp        bpr_Count, 0               // are any BPRs installed?
          je         _Out                       // exit if aren't
    }
    
    static DWORD _CR2;
    static DWORD _CR3;
    static DWORD ErrCode;
    static DWORD bpNo;
    __asm
    {  
          mov        eax,[ebp+12+32]            // Get error code from stack
          test       eax,1
          jnz        _Out                       // Bit 0==0 - fault caused by
                                                // nonpresent page
          mov        ErrCode, eax
          mov        eax, cr2
          mov        _CR2, eax
          mov        eax, cr3
          mov        _CR3, eax
    }

    bpNo = bpr_Check(_CR3, _CR2, ErrCode);

    if (bpNo != 0xFFFFFFFF)
    { 
       if ((bpNo & 0x80000000) != 0) 
       {
           DbgPrint("Emulating inst: %08X\n", _CR2);
           goto _Emulate;  // We must emulate instruction that
                           // accesses breakpoint's memory
       }

       // Break point conditions matched. Force SoftICE to popup
       DbgPrint("Break due to BPR: N=%02X CR2=%08X CR3=%08X\n", bpNo, _CR2, _CR3);
       goto _IceCall;
    }

_Out:
    __asm
    {
          mov        esp,ebp

          pop        es
          pop        ds
          pop        fs
          popad
          jmp        cs:[OldIntr]
    }

_IceCall:
    __asm
    {
          mov        eax, si_BreakReason
          mov        dword ptr [eax], BREAK_HOTKEY 
                          
          mov        eax, si_TraceFlag
          mov        dword ptr [eax], 1

          mov        eax, bpNo
          push       eax
          call       bpr_Deactivate

          mov        esp,ebp

          pop        es
          pop        ds
          pop        fs
          popad

          add        esp,4                 // remove ErrCode from stack

//          call       si_SaveClientRegisters
//          call       si_NTIceMain

          or        dword ptr [esp+8],100h // set TF flag
          iretd
    }

_Emulate:
    __asm
    {
          mov        eax, bpNo
          and        eax, 0x7FFFFFFF
          push       eax
          call       bpr_Deactivate

          mov        esp,ebp

          pop        es
          pop        ds
          pop        fs
          popad

          add        esp,4                  // remove ErrCode from stack

          or         dword ptr [esp+8],100h // set TF flag
          iretd
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  InstallInt0eHandler
//
//     Hooks int 0E
//
/////////////////////////////////////////////////////////////////////////////

void InstallInt0eHandler(void)
{
     OldIntr=SetInterruptHandler(0x0E,Int0eHandler);
     SetInterruptFlags(0x0E, 0x8e00);        // Set DPL = 0
     DbgPrint("OLD int 0E handler:                           %08X\n",OldIntr);
}

/////////////////////////////////////////////////////////////////////////////
//
//  RemoveInt0eHandler
//
//     Restores the original int 0E handler
//
/////////////////////////////////////////////////////////////////////////////

void RemoveInt0eHandler(void)
{
     if (OldIntr)
     {
          SetInterruptHandler(0x0E,OldIntr);
          SetInterruptFlags(0x0E, 0x8e00);   // Set DPL = 0
          OldIntr=0;
     }
}