/*++
    This file is mostly derived from mamaich's debugger codename BlindStudio.

    Copyleft  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    Copyright (c) 2001 mamaich
    Contact information:
    	web: www.reversing.net/mamaich
        mail: mamaich@reversing.net
        ICQ# 70241285

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    process.cpp

Abstract:  Process creation/deletion hook. Clears my breakpoint on process
    deletion.

Revision History:

 Sten        05/06/2002
      The file is fully rewritten for better understanding.
 mamaich     14/06/2001
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include "defs.h"
#include "bpr.h"

//////////////////////////////////////////////////////////////////////////////
//
// MyCreateProcessHook
//
//   Called on process creation/deletion
//
//////////////////////////////////////////////////////////////////////////////

VOID MyCreateProcessNotify (
         IN HANDLE ParentId,
         IN HANDLE ProcessId,
         IN BOOLEAN Create
         )
{
	UNREFERENCED_PARAMETER(ProcessId);
	UNREFERENCED_PARAMETER(ParentId);

    if(Create)
    {
      // do nothing
    }
    else // deletion
    {
        bpr_ClearAll(); // Clear all BPRs for the current process
    }
}

//////////////////////////////////////////////////////////////////////////////
//
// InitProcessHook
//
//   Hooks the process creation 
//
//////////////////////////////////////////////////////////////////////////////

NTSTATUS InitProcessHook()
{
   return PsSetCreateProcessNotifyRoutine(MyCreateProcessNotify, FALSE);
}

//////////////////////////////////////////////////////////////////////////////
//
// RemoveProcessHook
//
//   Unhooks the process creation 
//
//////////////////////////////////////////////////////////////////////////////

void RemoveProcessHook()
{
   PsSetCreateProcessNotifyRoutine(MyCreateProcessNotify, TRUE);
}