/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    protect.cpp

Abstract: Protect SoftICE from detection:
           - int 1 single step
           - int 1 EIP+2
           - int 3 backdoor interface
           - MeltICE, MeltSiwVID, MeltSiwSYM

Revision History:

 Sten        21/09/2002
      Initial release

--*/

extern "C"{
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include "defs.h"
#include "search.h"
#include "ntoskrnl.h"
#include "softice.h"
#include "undoc.h"


///////////////////////////////////////////////////////////////////////
//                          Globals
///////////////////////////////////////////////////////////////////////
ULONG protect_MeltICE                  = 0;
ULONG protect_NtQuerySystemInformation = 0;
ULONG protect_INT3                     = 0;
ULONG protect_CR4_DE                   = 0;

ULONG protect_UEF_Flag                 = 0; // Warning: DO NOT change!

///////////////////////////////////////////////////////////////////////
//                          Typedefs
///////////////////////////////////////////////////////////////////////
typedef NTSTATUS (*NTCREATEFILE)(
            PHANDLE FileHandle,
            ACCESS_MASK DesiredAccess,
            POBJECT_ATTRIBUTES ObjectAttributes,
            PIO_STATUS_BLOCK IoStatusBlock,
            PLARGE_INTEGER AllocationSize OPTIONAL,
            ULONG FileAttributes,
            ULONG ShareAccess,
            ULONG CreateDisposition,
            ULONG CreateOptions,
            PVOID EaBuffer OPTIONAL,
            ULONG EaLength
);

typedef NTSTATUS (*NTSETCONTEXTTHREAD)(
                                IN HANDLE ThreadHandle,
                                IN PCONTEXT Context
);

typedef NTSTATUS (*NTGETCONTEXTTHREAD)(
                                IN  HANDLE ThreadHandle,
                                OUT PCONTEXT Context
);

typedef NTSTATUS (*NTQUERYSYSTEMINFORMATION)(
                                IN SYSTEMINFOCLASS SystemInformationClass,
                                IN OUT PVOID SystemInformation,
                                IN ULONG SystemInformationLength,
                                OUT PULONG ReturnLength OPTIONAL
);

typedef NTSTATUS (*NTCONTINUE)(
                           IN PCONTEXT Context,
                           IN ULONG InAlert
);

#define INVALID_SERVICE_NUM ((ULONG)(-1))

// NTCREATEFILE
static ULONG                     NtCreateFileServiceNum      = INVALID_SERVICE_NUM;
static NTCREATEFILE              OldNtCreateFile             = 0;

// NTQUERYSYSTEMINFORMATION
static ULONG                     NtQuerySystemInfoServiceNum = INVALID_SERVICE_NUM;
static NTQUERYSYSTEMINFORMATION  OldNtQuerySystemInformation = 0;

// NWQUERYDIRECTORYOBJECT
static ULONG                     NtQueryDirObjectServiceNum  = INVALID_SERVICE_NUM;
static NTQUERYDIRECTORYOBJECT    OldNtQueryDirectoryObject   = 0;

// NTCONTINUE
static ULONG                     NtContinueServiceNum        = INVALID_SERVICE_NUM;
static NTCONTINUE                OldNtContinue               = 0;

// Old int3 handler
static void *OsInt3  = 0;
static void *OldInt3 = 0;

static char szMethodMeltICE[] = "PROTECT: MeltICE\n";

// no carier return needed below (si_SayESI used to print these strings)
static char szMethodINT3[]    = "PROTECT: Backdoor interface";
static char szMethodBCHK[]    = "PROTECT: BoundChecker interface";

// some symbols we are resolving
static CCHAR aKernel32UnhandledExceptionFilter[] = "kernel32!UnhandledExceptionFilter";
static CCHAR aTrap03[]                           = "ntoskrnl!_KiTrap03";


///////////////////////////////////////////////////////////////////////
//
// NewNtCreateFile
//
//   New NtCreateFile service.
//
///////////////////////////////////////////////////////////////////////

static WCHAR FILT_STR1[] = L"\\??\\NTICE";
static WCHAR FILT_STR2[] = L"\\??\\SIWVIDSTART";
static WCHAR FILT_STR3[] = L"\\??\\SIWSYM";

#define FILT_STR1_SIZE ((sizeof(FILT_STR1)-1)/sizeof(WCHAR))
#define FILT_STR2_SIZE ((sizeof(FILT_STR2)-1)/sizeof(WCHAR))
#define FILT_STR3_SIZE ((sizeof(FILT_STR3)-1)/sizeof(WCHAR))

NTSTATUS NewNtCreateFile(
            PHANDLE FileHandle,
            ACCESS_MASK DesiredAccess,
            POBJECT_ATTRIBUTES ObjectAttributes,
            PIO_STATUS_BLOCK IoStatusBlock,
            PLARGE_INTEGER AllocationSize OPTIONAL,
            ULONG FileAttributes,
            ULONG ShareAccess,
            ULONG CreateDisposition,
            ULONG CreateOptions,
            PVOID EaBuffer OPTIONAL,
            ULONG EaLength)
{
     NTSTATUS rc;

     if (protect_MeltICE)
     {

         if (ObjectAttributes->ObjectName->Buffer)
         {
             if (
                  (_wcsnicmp(ObjectAttributes->ObjectName->Buffer, 
                                     FILT_STR1, FILT_STR1_SIZE) == 0) ||
                  (_wcsnicmp(ObjectAttributes->ObjectName->Buffer, 
                                     FILT_STR2, FILT_STR2_SIZE) == 0) ||
                  (_wcsnicmp(ObjectAttributes->ObjectName->Buffer, 
                                     FILT_STR3, FILT_STR3_SIZE) == 0) 
                )
             {
                  DbgPrint(szMethodMeltICE);
                  return STATUS_OBJECT_NAME_NOT_FOUND;
             }
         }
     }

     rc=((NTCREATEFILE)(OldNtCreateFile)) (
                        FileHandle,
                        DesiredAccess,
                        ObjectAttributes,
                        IoStatusBlock,
                        AllocationSize,
                        FileAttributes,
                        ShareAccess,
                        CreateDisposition,
                        CreateOptions,
                        EaBuffer,
                        EaLength);
     return rc;
}

NTSTATUS NewNtQuerySystemInformation(
                                IN SYSTEMINFOCLASS SystemInformationClass,
                                IN OUT PVOID SystemInformation,
                                IN ULONG SystemInformationLength,
                                OUT PULONG ReturnLength OPTIONAL)
{
     NTSTATUS rc;

     rc=((NTQUERYSYSTEMINFORMATION)(OldNtQuerySystemInformation)) (
                                SystemInformationClass,
                                SystemInformation,
                                SystemInformationLength,
                                ReturnLength);

     if (protect_NtQuerySystemInformation)
     {

         if (SystemInformationClass == SystemModuleInformation)
         {
             if ((SystemInformationLength != 0) && (SystemInformation))
             {
                  PSYSTEM_MODULE_INFORMATION pModInfo 
                                    = (PSYSTEM_MODULE_INFORMATION)SystemInformation;
  
                  ULONG count = (SystemInformationLength - 4) / sizeof(SYSTEM_MODULE);

                  for (ULONG i=0; i<count; i++)
                  {
                      if (!_stricmp((char*)pModInfo->aSM[i].abName + pModInfo->aSM[i].wNameOffset, 
                                        "NTICE.SYS"))
                      {
                          strcpy((char*)pModInfo->aSM[i].abName + pModInfo->aSM[i].wNameOffset,
                                        "TROF2.SYS");
                          break;
                      }
                  }
             }
         }
     }

     return rc;
}

///////////////////////////////////////////////////////////////////////
//
// NewNtQueryDirectoryObject
//
//   Hooks NtQueryDirectoryObject.
//
///////////////////////////////////////////////////////////////////////
static WCHAR STR_NTICE[]  = L"NTICE";
static WCHAR STR_DRIVER[] = L"DRIVER";

#define STR_NTICE_SIZE  ((sizeof(STR_NTICE)-1)/sizeof(WCHAR))
#define STR_DRIVER_SIZE ((sizeof(STR_DRIVER)-1)/sizeof(WCHAR))

NTSTATUS NewNtQueryDirectoryObject(
	HANDLE hDirectory,
	PDIRECTORY_BASIC_INFORMATION DirectoryEntryBuffer,
	ULONG DirectoryEntryBufferSize,
	BOOLEAN  bOnlyFirstEntry,
	BOOLEAN bFirstEntry,
	PULONG  BytesReturned,
	PULONG  EntryIndex)
{
        int rc;
		
        rc=((NTQUERYDIRECTORYOBJECT)(OldNtQueryDirectoryObject)) (
			hDirectory,
			DirectoryEntryBuffer,
			DirectoryEntryBufferSize,
			bOnlyFirstEntry,
			bFirstEntry,
			BytesReturned,
			EntryIndex );

        if (DirectoryEntryBuffer)
        {
            PDIRECTORY_BASIC_INFORMATION DirInf = DirectoryEntryBuffer;

            while(
                   DirInf->ObjectName.Length            ||
                   DirInf->ObjectName.MaximumLength     ||
                   DirInf->ObjectName.Buffer            ||
                   DirInf->ObjectTypeName.Length        ||
                   DirInf->ObjectTypeName.MaximumLength ||
                   DirInf->ObjectTypeName.Buffer 
                 )
            {
/*
                 ANSI_STRING aName;
                 ANSI_STRING aTypeName;

                 if (RtlUnicodeStringToAnsiString(&aTypeName,
                                                  &DirInf->ObjectTypeName, 
                                                  TRUE) == STATUS_SUCCESS)
                 {
                     DbgPrint("    Entry: \\%s\\", aTypeName.Buffer);
                     RtlFreeAnsiString(&aTypeName);
                 }

                 if (RtlUnicodeStringToAnsiString(&aName,
                                                  &DirInf->ObjectName, 
                                                  TRUE) == STATUS_SUCCESS)
                 {
                     DbgPrint("%s\n", aName.Buffer);
                     RtlFreeAnsiString(&aName);
                 }
*/
                 if ( 
                     (_wcsnicmp(DirInf->ObjectTypeName.Buffer, 
                                STR_DRIVER, 
                                STR_DRIVER_SIZE) == 0)         &&
                     (_wcsnicmp(DirInf->ObjectName.Buffer, 
                                STR_NTICE, 
                                STR_NTICE_SIZE) == 0)
                    )
                 {
                     wcscpy(DirInf->ObjectName.Buffer, L"SSINF");                    
                 }

                 DirInf++;
            }    
        } 

        return rc;
}

///////////////////////////////////////////////////////////////////////
//
// NewNtContinue
//
//   Hooks NtContinue
//
///////////////////////////////////////////////////////////////////////

extern ULONG CR3ForOurProcess;
extern ULONG TracerCallBack;

NTSTATUS __declspec(naked) NewNtContinue(
                                IN PCONTEXT Context,
                                IN ULONG InAlert
                                )
{
    UNREFERENCED_PARAMETER(Context);
    UNREFERENCED_PARAMETER(InAlert);

    __asm
    {
        push    eax
        cmp     TracerCallBack, 0
        je      nt_continue_exit
        mov     eax, CR3
        cmp     eax, CR3ForOurProcess
        jne     nt_continue_exit

        mov     eax, [esp + 8]
        or      dword ptr [eax + 0C0h], 100h // restore TF-flag in eflags

    nt_continue_exit:
        pop     eax
        jmp     dword ptr [OldNtContinue]
    }
}

///////////////////////////////////////////////////////////////////////
//
//  Int 03 handler 
//
///////////////////////////////////////////////////////////////////////

extern void si_OnPageInProgress(void);
extern char szInt3Inst[];
extern char DRSavedByte;
extern int DRDebugException;
extern int DRSavedHandler;

void __declspec(naked) Int03Handler(void)
{
     __asm
     {
           cmp        cs:[TracerCallBack], 0
           je         next_handler
           pushad
           push       fs
           push       ds
           push       es

           mov        eax, 30h
           mov        fs, ax
           mov        eax, 23h
           mov        ds, ax
           mov        es, ax

           cmp        DRDebugException, 1
           jne        not_drdebug_exception

           mov        eax, CR3
           cmp        eax, CR3ForOurProcess
           jne        not_drdebug_exception

           mov        DRDebugException, 0
           call       EnableWrite
           mov        ebx, eax

           mov        eax, DRSavedHandler
           mov        dword ptr [esp + 0x2C], eax  // restore eip value
           or         dword ptr [esp + 0x34], 100h // restore TF flag in EFLAGS
           mov        dl, DRSavedByte
           mov        byte ptr [eax], dl

           push       ebx
           call       SetCR0

           pop        es                           // continue tracing
           pop        ds
           pop        fs
           popad
           iretd

not_drdebug_exception:

           push       dword ptr [esp + 0x2C]
           dec        dword ptr [esp]
           push       offset szInt3Inst
           call       DbgPrint
           add        esp, 8

           pop        es
           pop        ds
           pop        fs
           popad

next_handler:
           push       eax
           mov        eax, si_Pagein_InProgress
           cmp        byte ptr [eax], 0
           pop        eax   
           jz         no_pagein_in_progress
           call       si_OnPageInProgress

           push       eax
           mov        eax, si_TraceFlag           ; in trace mode
           cmp        byte ptr [eax], 0
           pop        eax
           jne        All_ok

no_pagein_in_progress:
           cmp        protect_INT3, 0
           jz         All_ok

           cmp        dword ptr [esp], NT_HIGHEST_USER_ADDRESS
           ja         All_ok

           cmp        si, 'FG'
           jne        not_BackDoor
      
           cmp        di, 'JM'
           jne        not_BackDoor

           cmp        cs:[OsInt3], 0FFh
           jbe        All_ok
           jmp        cs:[OsInt3]


not_BackDoor:
           cmp        ebp, 'BCHK'
           jne        All_ok

           cmp        cs:[OsInt3], 0FFh
           jbe        All_ok
           jmp        cs:[OsInt3]

All_ok:
           jmp        cs:[OldInt3]   ; call ntice handler
     }
}

///////////////////////////////////////////////////////////////////////
//
// Enable/Disable Unhandled Exception Filter Patching 
//
///////////////////////////////////////////////////////////////////////
const PROT_UEF_PATCH_ENABLED  = 1;

//////////////////////////////////////////////////////////////////////////////
//                               pUNH_Write
//////////////////////////////////////////////////////////////////////////////
unsigned char PAT_UNH_Write[] =
{
   0x8B, 0x3D, _XX_, _XX_, _XX_, _XX_,       // mov   edi, UEF_addr
   0x0B, 0xFF,                               // or    edi, edi
   0x74, _XX_,                               // jz    short locret_57BA2
   0x0A, 0xD2,                               // or    dl,  dl
   0x74, _XX_,                               // jz    short locret_57BA2
   0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00  // cmp   byte_D3DA7, 0
};

ULONG protSetUEFPatchDS31(ULONG fUEFPatch)
{
    BYTE *pUnhAddr = 0;

    __asm
    {
          mov     esi, offset aKernel32UnhandledExceptionFilter
          call    si_Expression2Integer
          jb      unh_error
          mov     pUnhAddr, eax
unh_error:
    }

    if   (!pUnhAddr)
    {
        DbgPrint("Error: unable to resolve UnhandledExceptionFilter address.\n");
        return FALSE;
    }

    InitSEH();

    __try
    {
        if (fUEFPatch)
        { 
          *pUnhAddr = 0xCC;
           protect_UEF_Flag   = 0;
        }
        else
        {
           *pUnhAddr = 0x68;
           protect_UEF_Flag   = 1;
        }
    }      
    __except(EXCEPTION_EXECUTE_HANDLER)
    {
        DbgPrint("Error: unable to patch UnhandledExceptionFilter.\n");
    }

    CleanupSEH();

    return TRUE;
}

ULONG protSetCR4_DE_Patch(ULONG fDisableProtection)
{
    if (!si_Patch_DE_JZ) return FALSE;

    if (fDisableProtection)
    { 
       *si_Patch_DE_JZ = 0x74;
       protect_CR4_DE = 0;
    }
    else
    {
       *si_Patch_DE_JZ = 0xEB;
       protect_CR4_DE = 1;
    }

	return TRUE;
}

ULONG protSetUEFPatch(ULONG fUEFPatch)
{
   if (si_IceBuild >= 1722) return protSetUEFPatchDS31(fUEFPatch);

   if (protect_UEF_Flag)
   {
       PAT_UNH_Write[0] = 0xC3;
   }
   else
   {
       PAT_UNH_Write[0] = 0x8B;
   } 
    

   //-------------------------------------------------------------------------
   //    si_UNH_Write
   //-------------------------------------------------------------------------
   BYTE *si_UNH_Write = (BYTE *)(RabSearch(PAT_UNH_Write, sizeof(PAT_UNH_Write),
                             si_CodeBase, si_CodeSize) + si_CodeBase);

   if ((ULONG)si_UNH_Write < (ULONG)si_CodeBase)
   {
       DbgPrint("ERROR: Can't find si_UNH_Write address in memory.\n");
       return FALSE;
   }

//   DbgPrint("si_UNH_Write:      %08X\n", si_UNH_Write);

   si_DeactivateBPs();

   if (fUEFPatch)
   { 
      *si_UNH_Write = 0x8B;
      protect_UEF_Flag   = 0;
   }
   else
   {
      *si_UNH_Write = 0xC3;
      protect_UEF_Flag   = 1;
   }

   si_ActivateBPs();

   return TRUE;
}


///////////////////////////////////////////////////////////////////////
//
// ProtectInit
//
//   Hooks some system services.
//
///////////////////////////////////////////////////////////////////////

NTSTATUS ProtectInit()
{
     //-----------------------------------------------------------------------
     // Hook NtCreateFile
     //-----------------------------------------------------------------------
     DbgPrint("ZwCreatFile:                                  %08X\n", ZwCreateFile);

     NtCreateFileServiceNum = *(PULONG)((PUCHAR)ZwCreateFile+1);

     DbgPrint("NtCreateFileServiceNum:                       %08X\n", NtCreateFileServiceNum);

     OldNtCreateFile=(NTCREATEFILE)(SYSTEMSERVICE(NtCreateFileServiceNum));
     _asm cli
     SYSTEMSERVICE(NtCreateFileServiceNum)=(ULONG)NewNtCreateFile;
     _asm sti

     //-----------------------------------------------------------------------
     // Hook NtQuerySystemInformation
     //-----------------------------------------------------------------------
     DbgPrint("ZwQuerySystemInformation:                     %08X\n", ZwQuerySystemInformation);

     NtQuerySystemInfoServiceNum = *(PULONG)((PUCHAR)ZwQuerySystemInformation+1);

     DbgPrint("NtQuerySystemInfoServiceNum:                  %08X\n", NtQuerySystemInfoServiceNum);

     OldNtQuerySystemInformation=(NTQUERYSYSTEMINFORMATION)(SYSTEMSERVICE(NtQuerySystemInfoServiceNum));
     _asm cli
     SYSTEMSERVICE(NtQuerySystemInfoServiceNum)=(ULONG)NewNtQuerySystemInformation;
     _asm sti

     //-----------------------------------------------------------------------
     // Hook NtQueryDirectoryObject
     //-----------------------------------------------------------------------
     DbgPrint("ZwQueryDirectoryObject:                       %08X\n", ZwQueryDirectoryObject);

     if (ZwQueryDirectoryObject)
     {
         NtQueryDirObjectServiceNum = *(PULONG)((PUCHAR)ZwQueryDirectoryObject+1);

         DbgPrint("NtQueryDirObjectServiceNum:                   %08X\n", NtQueryDirObjectServiceNum);

         OldNtQueryDirectoryObject=(NTQUERYDIRECTORYOBJECT)(SYSTEMSERVICE(NtQueryDirObjectServiceNum));
         _asm cli
         SYSTEMSERVICE(NtQueryDirObjectServiceNum)=(ULONG)NewNtQueryDirectoryObject;
         _asm sti
     }

     //-----------------------------------------------------------------------
     // Hook NtContinue
     //-----------------------------------------------------------------------
     ULONG build = 0;
     NtContinueServiceNum = 0;

     PsGetVersion(NULL, NULL, &build, NULL);

     switch (build)
     {
     case 2195 :  //win 2k
         NtContinueServiceNum = 0x1C;
         break;

     case 2600 : //win xp
         NtContinueServiceNum = 0x20;
         break;

     default :
         DbgPrint("Can't find NtContinue - unknown windows build !!!\n");
         break;
     }
     
     if (NtContinueServiceNum) 
     {
         OldNtContinue=(NTCONTINUE)(SYSTEMSERVICE(NtContinueServiceNum));

         DbgPrint("OldNtContinue:                                %08X\n", OldNtContinue);
         DbgPrint("NtContinueServiceNum:                         %08X\n", NtContinueServiceNum);

         _asm cli
             SYSTEMSERVICE(NtContinueServiceNum)=(ULONG)NewNtContinue;
         _asm sti
     }

     //-----------------------------------------------------------------------
     // Install int03 handler
     //-----------------------------------------------------------------------
     OsInt3 = (void*)si_OldIntTable[3];
     OldInt3= SetInterruptHandler(0x03,Int03Handler, 0xee);

     if ((ULONG_PTR)OsInt3 <= 0x000000FF)
     {
        InitSEH();
        __try
        {
            OsInt3 = *(void**)((ULONG_PTR)OldInt3+1);
        }
        __except(EXCEPTION_EXECUTE_HANDLER)
        {
            OsInt3 = 0;
            DbgPrint("Error: IceExt was unable to find original OS INT3 handler.\n");
            DbgPrint("Error: INT3 BackDoor interface protection will not work.\n");
        };
        CleanupSEH();
     }

     DbgPrint("OsInt3:                                       %08X\n", OsInt3);
     DbgPrint("OldINT3:                                      %08X\n", OldInt3);

     //-----------------------------------------------------------------------
     // Protect int01 handler
     //-----------------------------------------------------------------------
     SetInterruptFlags(0x01, 0x8e00); // Set DPL=0 as is at system startup

     //-----------------------------------------------------------------------
     // Protect int41 handler
     //-----------------------------------------------------------------------
     SetInterruptFlags(0x41, 0x8e00); // Set DPL=0 as is at system startup

     //-----------------------------------------------------------------------
     // Patch int0E handler
     //-----------------------------------------------------------------------
     if (si_INT_0E_Handler)
     {
         __asm
         {                             
               ;                            pINT_0E:
               ; 6A 0E                         push    0Eh
               ; E8 2D 6E 00 00                call    pGeneralProtectionFault
               ; 8D 64 24 04                   lea     esp, [esp+4]
               ; 81 64 24 0C FF FF FE FF       and     dword ptr [esp+12], 0FFFEFFFFh
               ; ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^  
               ;   Patch this instruction

               push          eax
               push          ebx
               push          ecx
               mov           ebx, dword ptr [si_INT_0E_Handler]
               add           ebx, 11
               mov           ax, 6481h
               mov           cx, 06EBh
               lock cmpxchg  word ptr [ebx], cx
               pop           ecx 
               pop           ebx
               pop           eax                            
         }
     }

     //-----------------------------------------------------------------------
     // Disable Unhandled Exception Filter Patching
     //-----------------------------------------------------------------------
/*
     protSetUEFPatch(FALSE);
*/
     return STATUS_SUCCESS;
}

///////////////////////////////////////////////////////////////////////
//
// ProtectDone
//
//   Unhooks hooked services. 
//
///////////////////////////////////////////////////////////////////////

void ProtectDone()
{
     // Delete NtCreateFile hook
     if (OldNtCreateFile)
     {
        _asm cli
        SYSTEMSERVICE(NtCreateFileServiceNum)=(ULONG)OldNtCreateFile;
        _asm sti
     }

     // Delete NtQuerySystemInformation hook
     if (OldNtQuerySystemInformation)
     {
        _asm cli
        SYSTEMSERVICE(NtQuerySystemInfoServiceNum)=(ULONG)OldNtQuerySystemInformation;
        _asm sti
     }

     // Delete NtQueryDirectoryObject hook
     if (OldNtQueryDirectoryObject)
     {
        _asm cli
        SYSTEMSERVICE(NtQueryDirObjectServiceNum)=(ULONG)OldNtQueryDirectoryObject;
        _asm sti
     }

     // Delete NtContinue hook
     if (OldNtContinue)
     {
        _asm cli
        SYSTEMSERVICE(NtContinueServiceNum)=(ULONG)OldNtContinue;
        _asm sti
     }

     // Uninstall INT3 handler
     if (OldInt3)
     {
          SetInterruptHandler(0x03,OldInt3, 0xee);
          OldInt3=0;
     }

     // Remove INT1 protection
     SetInterruptFlags(0x01, 0xee00); // Set DPL=3

     // Remove INT41 protection
     SetInterruptFlags(0x41, 0xee00); // Set DPL=3

     //-----------------------------------------------------------------------
     // Patch int0E handler (restore original)
     //-----------------------------------------------------------------------
     if (si_INT_0E_Handler)
     {
         __asm
         {                             
               ;                            pINT_0E:
               ; 6A 0E                         push    0Eh
               ; E8 2D 6E 00 00                call    pGeneralProtectionFault
               ; 8D 64 24 04                   lea     esp, [esp+4]
               ; 81 64 24 0C FF FF FE FF       and     dword ptr [esp+12], 0FFFEFFFFh
               ; ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^  
               ;   Patch this instruction

               push          eax
               push          ebx
               push          ecx
               mov           ebx, dword ptr [si_INT_0E_Handler]
               add           ebx, 11
               mov           ax, 06EBh
               mov           cx, 6481h
               lock cmpxchg  word ptr [ebx], cx
               pop           ecx 
               pop           ebx
               pop           eax                            
         }
     }

     //-----------------------------------------------------------------------
     // Enable Unhandled Exception Filter Patching
     //-----------------------------------------------------------------------
     protSetUEFPatch(TRUE);

     //-----------------------------------------------------------------------
     // Enable CR4 DE Patching
     //-----------------------------------------------------------------------
     protSetCR4_DE_Patch(TRUE);

     return;
}
