/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    screen.cpp

Abstract: Helper functions to work with SoftICE screen. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include "defs.h"
#include "softice.h"

static char *ScrBuff     = 0;
static int   ScrBuffSize = 0;

/////////////////////////////////////////////////////////////////////////////
//
// GetScreenPtr
//
//   Returns pointer to SI screen buffer
//
/////////////////////////////////////////////////////////////////////////////

char* GetScreenPtr()
{
    return (char*)(*si_Screen);
}

/////////////////////////////////////////////////////////////////////////////
//
// GetWidth
//
//   Get screen width
//
/////////////////////////////////////////////////////////////////////////////

int GetWidth()
{
    return *si_Width;
}

/////////////////////////////////////////////////////////////////////////////
//
// GetHeight
//
//   Get screen height
//
/////////////////////////////////////////////////////////////////////////////

int GetHeight()
{
    return *si_Height;
}

/////////////////////////////////////////////////////////////////////////////
//
// SaveScreen()
//
//   Get screen height
//
/////////////////////////////////////////////////////////////////////////////

void SaveScreen()
{
   char *S=GetScreenPtr();
   if (S==0) return;

   int W=GetWidth(), H=GetHeight();

   if (ScrBuffSize!=W*H*2)
   {
       if(ScrBuff) ExFreePool(ScrBuff);
        
       ScrBuff=(char*)ExAllocatePool(NonPagedPool,W*H*2);
   }

   if (ScrBuff==0)
        DbgPrint("Not enough NonPaged memory to alloc screen buffer\n");
   else
        memcpy(ScrBuff,S,W*H*2);
}

/////////////////////////////////////////////////////////////////////////////
//
// RestoreScreen()
//
//   Get screen height
//
/////////////////////////////////////////////////////////////////////////////

void RestoreScreen()
{
    char *S=GetScreenPtr();
    if(S==0 || ScrBuff ==0) return;

    int W=GetWidth(), H=GetHeight();
   
    memcpy(S, ScrBuff, W*H*2);
}

/////////////////////////////////////////////////////////////////////////////
//
// ClearScreen()
//
//   Clears screen
//
/////////////////////////////////////////////////////////////////////////////

void ClearScreen()
{
    char *S=GetScreenPtr();
    if (S==0) return;

    int Len=GetWidth()*GetHeight();

    for (int i=0; i<Len; i++)
    {           
      S[i*2]   = ' ';
      S[i*2+1] =  0;
    }
    si_UpdateScreen();
}

/////////////////////////////////////////////////////////////////////////////
//
// HideCursor()
//
//   Hides cursor
//
/////////////////////////////////////////////////////////////////////////////

void HideCursor()
{
    si_MoveCursor(250,250); // move cursor outside visible screen
}