/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    Siwvid.cpp

Abstract: Interface to the NuMega's Siwvid video driver. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C"{
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed
#pragma warning ( disable: 4127 ) // conditional expression is constant

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>
#include <malloc.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"

#define  IOCTL_SETFONT        0x9C406804    // Siwvid control interface

static PDEVICE_OBJECT SiwvidDevice;

/////////////////////////////////////////////////////////////////////////////
//
// InitSiwvid
//
//   Initizize Siwvid. Get Siwvid device object
//
/////////////////////////////////////////////////////////////////////////////

NTSTATUS InitSiwvid(PDRIVER_OBJECT Drv)
{
    NTSTATUS            status = STATUS_SUCCESS;
    UNICODE_STRING      VidName;
    PFILE_OBJECT        pFileObj;

	UNREFERENCED_PARAMETER(Drv);

    RtlInitUnicodeString(&VidName, L"\\Device\\Siwvid");

    status = IoGetDeviceObjectPointer(&VidName, FILE_ANY_ACCESS, &pFileObj, &SiwvidDevice);

    if (!NT_SUCCESS(status)) 
    {
        DbgPrint ("SIWVID INIT: Unable to get device object pointer.\n");
        return STATUS_UNSUCCESSFUL;
    }

    return STATUS_SUCCESS;
}

/////////////////////////////////////////////////////////////////////////////
//
// DoneSiwvid
//
//   Deinitizize Siwvid (Dereference Siwvid device object)
//
/////////////////////////////////////////////////////////////////////////////
void DoneSiwvid()
{
    ObDereferenceObject(&SiwvidDevice);
}

/////////////////////////////////////////////////////////////////////////////
//
// Completion routine.
//
/////////////////////////////////////////////////////////////////////////////

static NTSTATUS OnComplete(PDEVICE_OBJECT DeviceObject, PIRP Irp, PVOID Context)
{
	UNREFERENCED_PARAMETER(Context);
	UNREFERENCED_PARAMETER(DeviceObject);

    IoFreeIrp(Irp);
    return STATUS_MORE_PROCESSING_REQUIRED;
}

/////////////////////////////////////////////////////////////////////////////
//
// Load font into siwvid driver.
//
/////////////////////////////////////////////////////////////////////////////

NTSTATUS siw_LoadFont(char *Font, int Size)
{
    PIO_STACK_LOCATION irpSp;
    PIRP               Irp;

    if (!SiwvidDevice) return STATUS_UNSUCCESSFUL;

    if (si_GetCurrentIRQLLevel() > DISPATCH_LEVEL) 
    {
       DbgPrint("siw_LoadFont: Error. IRQL too high. Must be <= DISPATCH_LEVEL.\n");
       return STATUS_UNSUCCESSFUL;
    }

    // Siwvid undestands 8x8 and 8x16 fonts only
    if (Size != 2048)
    { 
        if (Size != 4096)
        {
            DbgPrint("siw_LoadFont: Invalid font size.\n");
            return STATUS_INVALID_PARAMETER; 
        }
    }

    // NTIce calls us with client segment registers values setted up
    // This is not a good case, in particular when FS=38 many system
    // routines crashes
    __asm
    {  
          mov ax, 30h
          mov fs, ax   // so restore normal value
    } 

    Irp = IoAllocateIrp(SiwvidDevice->StackSize, FALSE);
    if (Irp == NULL)
    {
          DbgPrint("siw_LoadFont: Error. Can't allocate IRP.\n");
          return STATUS_INSUFFICIENT_RESOURCES;
    } 

    IoSetCompletionRoutine(Irp, OnComplete, NULL, TRUE, TRUE, TRUE);

    Irp->Flags                      = IRP_BUFFERED_IO;
    Irp->IoStatus.Status            = STATUS_UNSUCCESSFUL;
    Irp->AssociatedIrp.SystemBuffer = Font;
    Irp->UserBuffer                 = Font;

    irpSp = IoGetNextIrpStackLocation(Irp);

    irpSp->MajorFunction = IRP_MJ_DEVICE_CONTROL;
    irpSp->Parameters.DeviceIoControl.InputBufferLength  = Size;
    irpSp->Parameters.DeviceIoControl.OutputBufferLength = Size;
    irpSp->Parameters.DeviceIoControl.IoControlCode      = IOCTL_SETFONT;

    // I'm not waiting here in order to support IRQL == DISPATCH_LEVEL

    return IoCallDriver(SiwvidDevice, Irp);
}