#ifndef __SOFTICE_H__
#define __SOFTICE_H__

#ifdef  __SOFTICE_C__
#define EXPORT
#define INIT  =0
#else
#define EXPORT       extern
#define INIT
#define FINIT
#endif

#include "wdbgexts.h"

extern WINDBG_EXTENSION_APIS  ExtensionApis;

EXPORT struct SiRegs
{
   DWORD EAX, EBX, ECX, EDX, ESI, EDI, EBP, ESP, EIP,
         EFLAGS;
   DWORD CS, DS, SS, ES, FS, GS;
   DWORD CR2, CR3;
} *ClientRegs;

extern ULONG          si_InitCompleted; // flag indicating initialization was
                                        // successful

//////////////////////////////////////////////////////////////////////////////
//                                Constants
//////////////////////////////////////////////////////////////////////////////

//    ********    Break Reason ********
#define BREAK_HOTKEY                   0x10000
#define BREAK_EMBEDDED_INT1            0x10001
#define BREAK_EMBEDDED_INT3            0x10002
#define BREAK_G                        0x10003
#define BREAK_SYMBOL_LOADER            0x10004
#define BREAK_DEBUG_KEYBOARD_REQUEST   0x10005
#define BREAK_NMI                      0x10006 // Non-maskable interrupt
#define BREAK_HOTKEY_2                 0x10007 // not used?
#define BREAK_WINDOWS_REQUESTED_BP     0x10008
#define BREAK_UNHANDLED_EXCEPTION      0x10009
#define BREAK_INVALID_OPCODE_FAULT     0x1000A
#define BREAK_STACK_FAULT              0x1000B
#define BREAK_GPF                      0x1000C // General Protection Fault
#define BREAK_PAGE_FAULT               0x1000D
#define BREAK_VOID                     0x1000E // No break reason message

//////////////////////////////////////////////////////////////////////////////
//                                Types
//////////////////////////////////////////////////////////////////////////////
typedef struct SI_FONT 
{
    ULONG      Height;
    ULONG      Width;
    PVOID      Body;
} SI_FONT; 

//////////////////////////////////////////////////////////////////////////////
//                                Variables
//////////////////////////////////////////////////////////////////////////////

EXPORT ULONG          si_IceVersion;    // SoftICE version
EXPORT ULONG          si_IceBuild;      // SoftICE build number

// Address of SI MZ-header in memory
EXPORT ULONG          si_IceBase INIT;

// Start of SI CODE section in memory (I assume that it is a 1st section it its
EXPORT PUCHAR         si_CodeBase INIT;
EXPORT ULONG          si_CodeSize INIT; // Its size

// Start of DATA section (2nd)
EXPORT PUCHAR         si_DataBase INIT;
EXPORT ULONG          si_DataSize INIT;

// Pointer to screen buffer, Width, Height inside SI DATA section
EXPORT PULONG         si_Screen INIT;
EXPORT PUCHAR         si_Width  INIT;
EXPORT PUCHAR         si_Height INIT;

// CodeFlags. Defines some segment properties
EXPORT PUCHAR         si_CodeFlags INIT;

// Current and popup context
EXPORT PULONG        si_CurrentContext INIT;
EXPORT PULONG        si_PopupContext   INIT;

// Memory to save registers while executing PAGEIN command
EXPORT SiRegs        *si_PageinTempRegz INIT;

// Address of INT3 command in pagein stub code
EXPORT PULONG        si_oPageinINT3    INIT;

// Flag for SI INT3 handler. If 1 - pagein command is executing
EXPORT PULONG        si_Pagein_InProgress INIT;

// Break Reason
EXPORT PULONG        si_BreakReason INIT;          // Contains softice popup reason

// ExecuteMoreCommands
EXPORT PUCHAR        si_ExecuteMoreCommands INIT;  // If true, SoftICE will exit NTIceMain
                                                   // immediatly after current command ends

EXPORT PUCHAR        si_TraceFlag        INIT;     // Trace flag

EXPORT PUCHAR        si_NormCharColor    INIT;     // Normal char color
EXPORT PUCHAR        si_ReverseCharColor INIT;     // Reversed char color
                                                  
EXPORT PULONG        si_OldIntTable      INIT;     // points to  array of dwords
                                                   // each entry = old interrupt

EXPORT SI_FONT       **si_Fonts           INIT;    // array of pointers to 
                                                   // si_FONT structures

EXPORT PULONG        si_CurFontIdx        INIT;    // index of the current font
                                                   // in fonts array

EXPORT PUCHAR        si_DumpFilter        INIT;    // pointer to dump window
                                                   // character filter code
                                                   // inside softice

EXPORT PULONG        si_MSR_LAST_BRANCH_0 INIT;    // points to last branch info
EXPORT PULONG        si_MSR_LAST_BRANCH_1 INIT;    // recorded by SoftICE

EXPORT PUCHAR        si_IceIsActive       INIT;    // nonzero is SoftICE is activated

EXPORT PUCHAR        si_BangFuncsArray    INIT;    // array of exported KDE function 
                                                   // names and addresses

EXPORT PULONG        si_KDEFuncNum        INIT;    // number of exported KDE functions 
                                                   // in SoftICE internal array
EXPORT PULONG        si_QueueMacroExec    INIT;
EXPORT PULONG        si_fMacroQueued      INIT;

EXPORT PUCHAR        si_Patch_DE_JZ       INIT;    // pointer to JZ opcode that
                                                   // controls CR4 DE bit patching by SoftICE

//////////////////////////////////////////////////////////////////////////////
//          Pointers to the functions in SoftIce body.
//////////////////////////////////////////////////////////////////////////////
EXPORT UCHAR (*si_GetChar)();              // Read one key
EXPORT UCHAR (*si_KbHit)();                // Peek one key from keybuffer without
                                           // removing it. Returns 0 if no keys were pressed

EXPORT VOID (*si_UpdateScreen)(VOID);      // Redraw screen after modifying VMem

EXPORT VOID (*si_CallVideoDriver_1)(VOID); // call video driver 1 ? 

EXPORT VOID (*si_MoveCursor)(LONG, LONG);    // Mov cursor pos

EXPORT LONG (*si_Expression2Integer)(PCHAR expr); // Calculate expression
                                                  // ("?" command in SoftICE)

EXPORT LONG (*si_ExecuteMacro)(PCHAR expr);       // Exec SoftIce macro

EXPORT VOID (*si_NTIce)(VOID);         // Enters the SoftIce and traces null_sub.
                                       // Usually called at SoftIce start

EXPORT VOID (*si_NTIceMain)(ULONG);    // Enters the SoftIce and traces given
                                       // virutal address                                       

EXPORT VOID (*si_PrintChar)(VOID);     // Prints character
                                       // Asm-like parameters
                                       // ONLY for use in cmd_tetris.cpp

EXPORT VOID (*si_DelayMilliSec)(VOID); // Delay EAX milliseconds
                                       // Asm-like parameters
                                       // EAX = number of milliseconds to delay

EXPORT LONG (*si_ReadFromKbdBuffer_char)(VOID); // Reads one char from keyboard buffer
                                                // character is removed from keyb-buffer
                                                // returns zero if buffer is empty

EXPORT VOID (*si_WriteToKbdBuffer_char)(VOID);  // Whites one character to
                                                // keyboard buffer

EXPORT VOID (*si_EmptyKbdBuffer)(VOID);// Empies keyboard buffer

EXPORT VOID (*si_ActivateBPs)(VOID);   // Activates breakpoints on SoftICE exit
EXPORT VOID (*si_DeactivateBPs)(VOID); // Deactivates breakpoints on SoftICE entry

EXPORT VOID (*si_ShowBreakReason)(VOID); // Shows break reason on SoftICE popup

EXPORT VOID (*si_SetCursorShape)(VOID);  // Sets cursor shape
                                         // Asm-like params
                                         // al = 0 - shape 1
                                         // al = 1 - shape 2

EXPORT VOID (*si_CallVideoDriver)(VOID);     // call siwvid func
EXPORT VOID (*si_CallVideoDriver_1x)(VOID);  // call video driver func 1

EXPORT VOID (*si_SaveClientRegisters)(VOID);// Saves client registers. Use it 
                                            // before call to si_NTIceMain

EXPORT VOID (*si_SayESI)(VOID);        // prints string
                                       // Asm-like params
                                       // ESI = string to print

EXPORT VOID (*si_SayESIpause)(VOID);   // prints string with pause between screens
                                       // Asm-like params
                                       // ESI = string to print
                                       // BH  = color

EXPORT ULONG (*si_GetCurrentIRQLLevel)(VOID); // Returns current IRQL level

EXPORT VOID (*si_SetFont)(const SI_FONT *);  // set screen font

EXPORT VOID (*si_ActivateHooks)(VOID);   // Activate system functions hooks via int3

EXPORT VOID (*si_DeActivateHooks)(VOID); // Deactivate system functions hooks via int3

EXPORT VOID (*si_RecordLastBranchInfo)(VOID);    // Records Last branch info
                                                 // and enables LBR bit in IA32_DEBUGCTL 
                                           
EXPORT VOID (*si_LoadKDE)(ULONG ModuleBase);     // Loads Kernel debugger extension into
                                                 // SoftICE

EXPORT VOID (*si_EnableIRQ)(VOID);               // Enables specified IRQ
EXPORT VOID (*si_IRQ2INT)(VOID);                 // IRQ -> INT converter
EXPORT VOID (*si_SendSpecificEOI)(VOID);         // Send End of Interrupt message
EXPORT VOID (*si_INT_0E_Handler)(VOID);          // Invalid Opcode interrupt handler

EXPORT ULONG   (*si_ProcessIF)(PCHAR args);             
EXPORT VOID    (*si_ClearCompiledIF)(ULONG CompiledIF);
EXPORT BOOLEAN (*si_CheckCondition) (ULONG CompiledIF);

//////////////////////////////////////////////////////////////////////////////
//                       Some helper functions
//////////////////////////////////////////////////////////////////////////////
BOOLEAN si_Exec(PCHAR Cmd, OPTIONAL BOOLEAN bHideInput = TRUE); // Execute SoftICE command

EXPORT VOID si_PutToKbdBufferChar(CONST CHAR ch); // C-like interface to 
                                                  // si_WriteToKbdBufferChar
                                                  // Puts one byte into keyboard 
                                                  // buffer

EXPORT VOID si_InstallDumpFilter(PVOID MyDumpFilter); // Installs my own dump window character 
                                                      // filter. So that SoftICE will
                                                      // display russian symbols in dump.

EXPORT VOID si_RemoveDumpFilter(VOID);                // Removes my own dump window character 
                                                      // filter.

VOID si_FixChkStkBug(VOID); // SoftICE has a bug in __chkstk implementation that leads to BSOD if KDE 
                            // calls this function. Fix bug, so that my MP3 decoder can work correctly 

VOID si_ClearBangFuncsArray( VOID ); // Deletes all entries in the BangFuncArray pointing into IceExt driver
                                     // Should be called prior to unloading IceExt. 

//////////////////////////////////////////////////////////////////////////////
//                         Some internal pointers
//////////////////////////////////////////////////////////////////////////////
typedef VOID (*SoftIceFunc)();

EXPORT PCHAR si_CommandLine    INIT;  // Pointer to SoftICE command line buffer
EXPORT SoftIceFunc *si_IceCall INIT;  // Pointer to internal SoftICE func table
EXPORT PCHAR si_IceFuncNames   INIT;  // Pointer to table of SoftICE func names

                                           
#ifdef __SOFTICE_C__    // Preinitialized patterns. For internal use only :)

//////////////////////////////////////////////////////////////////////////////
//                                GetChar
//////////////////////////////////////////////////////////////////////////////

// function prototype
#define       TYPE_GetChar  (UCHAR (__stdcall*)(VOID))

#define       OFS_GetChar      0             // offset of code pattern in function 
UCHAR PAT_GetChar[] =                        
{
    0x57,                                    // push      edi
    0x56,                                    // push      esi
    0xE8, _XX_, _XX_, _XX_, _XX_,            // call      ReadOneKey
    0x0F, 0xB6, 0xC0,                        // movzx     eax, al
    0x5E,                                    // pop       esi
    0x5F,                                    // pop       edi
    0xC3                                     // ret
};

//////////////////////////////////////////////////////////////////////////////
//                                KbHit
//////////////////////////////////////////////////////////////////////////////
#define       TYPE_KbHit     (UCHAR (__stdcall*)(VOID))

#define       OFS_KbHit        0              // offset of code pattern in function
UCHAR PAT_KbHit[] =                           
{
    0x53,                                     // push       ebx
    0x33, 0xC0,                               // xor        eax, eax
    0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00, // cmp        fExecuteMoreCommands, 0
    0x74, _XX_,                               // jz         short jReadOneKey_ret
    0x8B, 0x1D, _XX_, _XX_, _XX_, _XX_,       // mov        ebx, dword_B3E69
    0x3B, 0x1D, _XX_, _XX_, _XX_, _XX_,       // cmp        ebx, dword_B3E6D
    0x74, _XX_                                // jz         short jReadOneKey_ret
};

//////////////////////////////////////////////////////////////////////////////
//                              UpdateScreen
//                            CallVideoDriver_1
//////////////////////////////////////////////////////////////////////////////
#define       TYPE_CallVideoDriver_1  (VOID (__stdcall *)(VOID))
#define       TYPE_UpdateScreen       (VOID (__stdcall *)(VOID))

#define       OFS_UpdateScreen   30           // offset of code pattern in function
UCHAR PAT_CallVideoDriver_1[] =               
{
    0x60,                                     // pushad
    0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp   VidDrv_1_flag, 1
    0x75, 0x13,                               // jnz   short loc_376AC
    0xE8, _XX_, _XX_, _XX_, _XX_,             // call  sub_36536
    0xB0, 0x01,                               // mov   al, 1
    0xE8, _XX_, _XX_, _XX_, _XX_,             // call  pCallVideoDriver
    0xC6, 0x05, _XX_, _XX_, _XX_, _XX_, 0x01, // mov   fVidDrv_0B, 1
//                                             loc_376AC:     
    0xE8, _XX_, _XX_, _XX_, _XX_,             // call  pUpdateScreen
    0x61,                                     // popad
    0xC3                                      // retn
};

//////////////////////////////////////////////////////////////////////////////
//                                MoveCursor
//////////////////////////////////////////////////////////////////////////////
#define       TYPE_MoveCursor    (VOID (__stdcall *)(LONG,LONG))

#define       OFS_MoveCursor     0            // offset of code pattern in function 
UCHAR PAT_MoveCursor[] =                      
{
      0x55,                                   // push       ebp
      0x8B, 0xEC,                             // mov        ebp, esp
      0x53,                                   // push       ebx
      0x56,                                   // push       esi
      0x57,                                   // push       edi
      0x8A, 0x75, 0x08,                       // mov        dh, [ebp+arg_0]
      0x8A, 0x55, 0x0C,                       // mov        dl, [ebp+arg_4]
      0xE8, _XX_, _XX_, _XX_, _XX_,           // call       asm_MoveCursor
      0x5F,                                   // pop        edi
      0x5E,                                   // pop        esi
      0x5B,                                   // pop        ebx
      0x5D,                                   // pop        ebp
      0xC2, 0x08, 0x00,                       // retn       8     
// asm_MoveCursor:
      0x50,                                   // push       eax
      0x51,                                   // push       ecx
      0x52,                                   // push       edx
      0x80, 0x3D                              // cmp        byte_C28BD, 0
};      

//////////////////////////////////////////////////////////////////////////////
//                          Expression2Integer
//////////////////////////////////////////////////////////////////////////////
#define    TYPE_Expression2Integer (LONG(__stdcall*)(PCHAR))

#define    OFS_Expression2Integer  13           // offset of code pattern in function
                                        
UCHAR PAT_Expression2Integer[] =                
{
      0xBE, _XX_, _XX_, _XX_, _XX_,             // mov     esi, offset si_CommandLine
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call    pSkipWord
      0x72, 0x12,                               // jb      short loc_44037
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call    pExpression2Integer
      0x72, 0x10,                               // jb      short loc_4403C
      0xBE, _XX_, _XX_, _XX_, _XX_,             // mov     esi, offset loc_44044
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call    c_PHYS_
      0xC3,                                     // retn

                                                //loc_44037:
      0xB8, _XX_, _XX_, _XX_, _XX_,             // mov     eax, offset aParametersRequ ; "Parameters required"
                                                //
                                                //loc_4403C:
      0x8B, 0xF0,                               // mov     esi, eax
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call    pSayESI
      0xC3                                      // retn
};

//////////////////////////////////////////////////////////////////////////////
//                          ExecuteMacro
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_ExecuteMacro  (LONG(__stdcall*)(PCHAR))

#define     OFS_ExecuteMacro   0                // offset of code pattern in function

UCHAR PAT_ExecuteMacro[] =                      
{
      0x55,                                     // push        ebp
      0x8B, 0xEC,                               // mov         ebp, esp
      0x83, 0xEC, _XX_,                         // sub         esp, 0Ch
      0xB8, _XX_, _XX_, _XX_, _XX_,             // mov         eax, offset unk_106D78
      0x56,                                     // push        esi
      0x89, 0x45, 0xF4,                         // mov         [ebp+var_C], eax
      0xC7, 0x45                                // mov         [ebp+var_4], offset unk_106AE0
};

UCHAR PAT_ExecuteMacro_DS30[] =                 
{
      0x55,                                     // push        ebp
      0x8B, 0xEC,                               // mov         ebp, esp
      0x83, 0xEC, _XX_,                         // sub         esp, 0Ch
      0x56,                                     // push        esi
      0xBE, _XX_, _XX_, _XX_, _XX_,             // mov         esi, offset unk_106D78
      0x89, 0x75, 0xF4,                         // mov         [ebp+var_C], esi
      0xC7, 0x45                                // mov         [ebp+var_4], offset unk_106AE0
};

//////////////////////////////////////////////////////////////////////////////
//                             pNTIce
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_NTIce          (VOID(__stdcall*)(VOID))
#define     TYPE_NTIceMain      (VOID(__stdcall*)(ULONG))

#define     OFS_NTIce          0                // offset of code pattern in function
#define     OFS_NTIceMain      9                // offset of pNTIceMain call

UCHAR PAT_NTIce[] =                             
{
      0x9C,                                     // pushf
      0x0E,                                     // push        cs
      0x68, _XX_, _XX_, _XX_, _XX_,             // push        offset nullsub_2
      0xFA,                                     // cli
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call        pNTICEMain
      0xCF                                      // iret 
};

//////////////////////////////////////////////////////////////////////////////
//                           pPrintChar
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_PrintChar      (VOID(__stdcall*)(VOID))

#define     OFS_PrintChar            0
#define     OFS_ExecuteMoreCommands 18

UCHAR PAT_PrintChar[] =                         
{
      0x57,                                     // push        edi
      0x51,                                     // push        ecx
      0x50,                                     // push        eax
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call        pCallVideoDriver_2x
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp         byte_B0A5C, 1
      0x74, _XX_,                               // jz          short loc_33CA9
      0xA0                                      // mov         al, fExecuteMoreCommands
//         ^^ ^^ ^^ ^^ - fExecuteMoreCommands
};

//////////////////////////////////////////////////////////////////////////////
//                          pDelayMilliSec
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_DelayMilliSec  (VOID(__stdcall*)(VOID))

#define     OFS_DelayMilliSec   0

UCHAR PAT_DelayMilliSec[] =                           
{
      0x2E, 0xF6, 0x05, _XX_, _XX_, _XX_, _XX_, 0x01, // test        cs:dw_RDTSC_present,1
      0x75, _XX_,                                     // jnz         short loc_505DD
      0x51,                                           // push        ecx
      0xB9, 0x00, 0x00, 0x0F, 0x00,                   // mov         ecx, 0F0000h
                                                      //loc_505D9:
      0xE2, 0xFE                                      // loop        loc_505D9
};

//////////////////////////////////////////////////////////////////////////////
//                      pReadFromKbdBuffer_char
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_ReadFromKbdBuffer_char  (LONG(__stdcall*)(VOID))

#define     OFS_ReadFromKbdBuffer_char   0

UCHAR PAT_ReadFromKbdBuffer_char[] =            
{
      0x53,                                     // push         ebx
      0x33, 0xC0,                               // xor          eax, eax
      0x8B, 0x1D, _XX_, _XX_, _XX_, _XX_,       // mov          ebx, dw_KbdBufPos
      0x3B, 0x1D, _XX_, _XX_, _XX_, _XX_,       // cmp          ebx, dw_KbdBufMax
      0x74, _XX_,                               // jz           short loc_39592
      0x8A, 0x83, _XX_, _XX_, _XX_, _XX_,       // mov          al, bKeybBuffer[ebx]
      0x43,                                     // inc          ebx
      0x81, 0xE3, _XX_, _XX_, _XX_, _XX_,       // and          ebx, 1FFh
      0x89                                      // mov          dw_KbdBufPos, ebx 
};

//////////////////////////////////////////////////////////////////////////////
//                      pWriteToKbdBuffer_char
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_WriteToKbdBuffer_char  (VOID(__stdcall *)(VOID))

#define     OFS_WriteToKbdBuffer_char    0      

UCHAR PAT_WriteToKbdBuffer_char[] =             
{
      0x53,                                     // push         ebx
      0x51,                                     // push         ecx
      0x3C, 0x1B,                               // cmp          al, 1Bh
      0x75, _XX_,                               // jnz          short loc_39950
      0x83, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp          trace_dwd+1, 1
      0x76, _XX_,                               // jbe          short loc_39950
      0xC7, 0x05                                // mov          trace_dwd+1, 1 
};

//////////////////////////////////////////////////////////////////////////////
//                          pEmptyKbdBuffer
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_EmptyKbdBuffer  (VOID(__stdcall*)(VOID))

#define     OFS_EmptyKbdBuffer   0

UCHAR PAT_EmptyKbdBuffer[] =                                      
{
      0x9C,                                                       // pushf
      0xFA,                                                       // cli
      0xC7, 0x05, _XX_, _XX_, _XX_, _XX_, 0x00, 0x00, 0x00, 0x00, // mov dw_KbdBufPos, 0
      0xC7, 0x05, _XX_, _XX_, _XX_, _XX_, 0x00, 0x00, 0x00, 0x00, // mov dw_KbdBufMax, 0
      0x9D,                                                       // popf
      0xC3                                                        // retn
};

//////////////////////////////////////////////////////////////////////////////
//                           pActivateBPs
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_ActivateBPs  (VOID(__stdcall*)(VOID))

#define     OFS_ActivateBPs   0

UCHAR PAT_ActivateBPs[] =                       
{
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp         dw_IsBPActivated,1
      0x74, _XX_,                               // jz          short locret_41BD4
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp         dwNumberOfBPs?,1
      0x74, _XX_,                               // jz          short locret_41BD4
      0x83, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00, // cmp         dword_C28AC+1,0
      0x74                                      // jz          short loc_41BD5
};

//////////////////////////////////////////////////////////////////////////////
//                           pDeactivateBPs
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_DeactivateBPs  (VOID(__stdcall*)(VOID))

#define     OFS_DeactivateBPs   0

UCHAR PAT_DeactivateBPs[] =                     
{
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00, // cmp         dwNumberOfBPs?, 0
      0x75, 0x01,                               // jnz         short loc_418EA
      0xC3,                                     // retn
                                                //loc_418EA:
      0x60,                                     // pusha
      0x06,                                     // push        es
      0x66, 0x8E, 0x05                          // mov         es, wNTICE_SS
};

//////////////////////////////////////////////////////////////////////////////
//                          pShowBreakReason
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_ShowBreakReason (VOID(__stdcall*)(VOID))

#define     OFS_ShowBreakReason  0
#define     OFS_BreakReason      2

UCHAR PAT_ShowBreakReason[] =                                     // code     pattern
{
      0x81, 0x3D, _XX_, _XX_, _XX_, _XX_, _XX_, 0x00, 0x01, 0x00, // cmp      dBreakReason, 100xxh
//                ^^^^^^^^^^^^^^^^^^^^^^ - BreakReason
      0x76, _XX_,                                                 // jbe      short loc_30512
      0xF8,                                                       // clc
      0xC3,                                                       // retn
      0xBF                                                        // mov      edi, ...
};

//////////////////////////////////////////////////////////////////////////////
//                          pSetCursorShape
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_SetCursorShape (VOID(__stdcall*)(VOID))

#define     OFS_SetCursorShape  0

UCHAR PAT_SetCursorShape[] =                    
{
      0xA2, _XX_, _XX_, _XX_, _XX_,             // mov         byte_B07E9, al
      0x50,                                     // push        eax
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call        sub_778BA
      0x58,                                     // pop         eax
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00, // cmp         byte_C28B8, 0
      0x74, 0x01,                               // jz          short loc_38C38
      0xC3                                      // retn
                                                //loc_38C38:
};

//////////////////////////////////////////////////////////////////////////////
//                           pCallVideoDriver
//                          pCallVideoDriver_1x
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_CallVideoDriver_1x (VOID(__stdcall*)(VOID))
#define     TYPE_CallVideoDriver    (VOID(__stdcall*)(VOID))

#define     OFS_CallVideoDriver_1x  0
#define     OFS_CallVideoDriver    18

UCHAR PAT_CallVideoDriver_1x[] =                
{
      0x60,                                     // pusha
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp         VidDrv_1_flag, 1
      0x75, _XX_,                               // jnz         short loc_376AC
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call        sub_36536
      0xB0, 0x01,                               // mov         al, 1
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call        pCallVideoDriver
      0xC6, 0x05, _XX_, _XX_, _XX_, _XX_, 0x01, // mov         byte_AFD2F, 1
                                                //loc_376AC:
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call        pUpdateScreen
      0x61,                                     // popa
      0xC3                                      // retn
};

//////////////////////////////////////////////////////////////////////////////
//                          pSaveClientRegisters
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_SaveClientRegisters (VOID(__stdcall*)(VOID))

#define     OFS_SaveClientRegisters  0

UCHAR PAT_SaveClientRegisters[] =                     
{
      0x50,                                           // push        eax
      0x55,                                           // push        ebp
      0x8B, 0xEC,                                     // mov         ebp, esp
      0x1E,                                           // push        ds
      0x66, 0x2E, 0x8E, 0x1D, _XX_, _XX_, _XX_, _XX_, // db 66h
                                                      // mov         ds, cs:wNTICE_SS
      0xA3                                            // mov         dClient_EAX, eax
};

//////////////////////////////////////////////////////////////////////////////
//                                pSayESI
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_SayESI (VOID(__stdcall*)(VOID))

#define     OFS_SayESI        0
#define     OFS_NormCharColor 3

UCHAR PAT_SayESI[] =                                  
{
      0x53,                                           // push        ebx
      0x8A, 0x3D, _XX_, _XX_, _XX_, _XX_,             // mov         bh, bNormCharColor
      0xE8, _XX_, _XX_, _XX_, _XX_,                   // call        pSayESIcolor
      0x5B,                                           // pop         ebx
      0xC3                                            // retn 
};

//////////////////////////////////////////////////////////////////////////////
//                              pSayESIpause
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_SayESIpause (VOID(__stdcall*)(VOID))

#define     OFS_SayESIpause 0

UCHAR PAT_SayESIpause[] =                             
{
      0x83, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00,       // cmp         dword_125184, 0
      0x74, _XX_,                                     // jz          short loc_38085
      0x50,                                           // push        eax
      0x56,                                           // push        esi
      0x57,                                           // push        edi
      0xFC,                                           // cld
      0x8B, 0x3D, _XX_, _XX_, _XX_, _XX_,             // mov         edi, dword_125188
      0xB0, 0x20,                                     // mov         al, ' '
      0xAA,                                           // stosb 
      0xAA                                            // stosb
};

//////////////////////////////////////////////////////////////////////////////
//                          pGetCurrentIRQLLevel
//////////////////////////////////////////////////////////////////////////////
#define     TYPE_GetCurrentIRQLLevel (ULONG(__stdcall*)(VOID))

#define     OFS_GetCurrentIRQLLevel 0

UCHAR PAT_GetCurrentIRQLLevel[] =                     
{
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00,       // cmp         byte_AE990, 0
      0x74, 0x10,                                     // jz          short loc1
      0xA1, _XX_, _XX_, _XX_, _XX_,                   // mov         eax, dword_AEB07
      0xC1, 0xE8, 0x04,                               // shr         eax, 4
      0x0F, 0xB6, 0x80, _XX_, _XX_, _XX_, _XX_,       // movzx       eax, byte ptr ds:unk_106FC[eax]
      0xC3,                                           // retn
// loc1:
      0x6A, 0xFF                                      // push        0FFFFFFFFh
};

//////////////////////////////////////////////////////////////////////////////
//                              dwTraceFlag
//////////////////////////////////////////////////////////////////////////////
#define       OFS_TraceFlag   2

UCHAR PAT_TraceFlag[] =                         
{
                                                // somewhere inside pINT_01:

      0xC6, 0x05, _XX_, _XX_, _XX_, _XX_, 0x00, // mov         dwTraceFlag, 0
      0x58,                                     // pop         eax
      0x1F,                                     // pop         ds
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call        pNTIceMain
      0xCF                                      // iret
};

//////////////////////////////////////////////////////////////////////////////
//                               ClientRegs
//////////////////////////////////////////////////////////////////////////////
#define       OFS_ClientRegs   6

UCHAR PAT_ClientRegs[] =                        
{
      0x50,                                     // push        eax
      0x53,                                     // push        ebx
      0x51,                                     // push        ecx
      0x52,                                     // push        edx
      0x56,                                     // push        esi
      0xA1                                      // mov         eax, dClient_EAX
};

//////////////////////////////////////////////////////////////////////////////
//                                VmemPtr
//////////////////////////////////////////////////////////////////////////////
#define       OFS_VmemPtr   6

UCHAR PAT_VmemPtr[] =                           
{
      0xD1, 0xE3,                               // shl         ebx, 1
      0x03, 0xF3,                               // add         esi, ebx
      0x03, 0x35                                // add         esi, VmemPtr
};

//////////////////////////////////////////////////////////////////////////////
//                                 Width
//////////////////////////////////////////////////////////////////////////////
#define       OFS_Width     3

UCHAR PAT_Width[] =                             
{
      0x0F, 0xAF, 0x05, _XX_, _XX_, _XX_, _XX_, // imul        eax, [Width]
      0x03, 0xC0,                               // add         eax, eax
      0x03, 0xF8                                // add         edi, eax
};

//////////////////////////////////////////////////////////////////////////////
//                                 Height
//////////////////////////////////////////////////////////////////////////////
#define       OFS_Height    3

UCHAR PAT_Height[] =                            
{
      0x0F, 0xB6, 0x0D, _XX_, _XX_, _XX_, _XX_, // movzx       eax,b,[Height]
      0x0F, 0xB6, 0xC6,                         // movzx       eax,dh
      0x2B, 0xC8                                // sub         ecx,eax
};

//////////////////////////////////////////////////////////////////////////////
//                             dw_CodeFlags
//////////////////////////////////////////////////////////////////////////////
#define       OFS_CodeFlags   2

UCHAR PAT_CodeFlags[] =                         
{
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x03, // cmp         dw_CodeFlags, 3
      0x74, _XX_,                               // jz          short loc_8EB03
      0x68, _XX_, _XX_, _XX_, _XX_,             // push        offset aPagingIsOnlySu
      0xEB                                      // jmp         short  ...
};

//////////////////////////////////////////////////////////////////////////////
//                             dCurrentContext
//                              dPopupContext
//////////////////////////////////////////////////////////////////////////////
#define       OFS_CurrentContext   2
#define       OFS_PopupContext     8

UCHAR PAT_CurrentContext[] =                    
{
      0x8B, 0x0D, _XX_, _XX_, _XX_, _XX_,       // mov         ecx, dCurrentContext
      0x3B, 0x0D, _XX_, _XX_, _XX_, _XX_,       // cmp         ecx, dPopupContext
      0x74, _XX_,                               // jz          short loc_8EB24
      0x50                                      // push        eax
};

//////////////////////////////////////////////////////////////////////////////
//                             dPageinTempRegz
//////////////////////////////////////////////////////////////////////////////
#define       OFS_PageinTempRegz   9

UCHAR PAT_PageinTempRegz[] =                    
{
      0x6A, 0x48,                               // push        sizeof(SiRegs)
      0xB8, _XX_, _XX_, _XX_, _XX_,             // mov         eax, offset dClient_EAX
      0x50,                                     // push        eax
      0xB8, _XX_, _XX_, _XX_, _XX_,             // mov         eax, offset dPageinTempRegz
      0x50                                      // push        eax
};

//////////////////////////////////////////////////////////////////////////////
//                             oPAGEIN_INT3
//////////////////////////////////////////////////////////////////////////////
#define       OFS_PageinINT3   10

UCHAR PAT_PageinINT3[] =                        
{
      0x89, 0x3D, _XX_, _XX_, _XX_, _XX_,       // mov         dClient_EIP, edi
      0x8D, 0x47, 0x02,                         // lea         eax, [edi+2]
      0xA3, _XX_, _XX_, _XX_, _XX_,             // mov         oPAGEIN_INT3, eax
      0xEB                                      // jmp         short pagein_progress
};

//////////////////////////////////////////////////////////////////////////////
//                          fPAGEIN_InProgress
//////////////////////////////////////////////////////////////////////////////
#define       OFS_Pagein_InProgress  10

UCHAR PAT_Pagein_InProgress[] =                 
{
      0x8B, 0x45, _XX_,                         // mov         eax, [ebp+arg_0]
      0xA3, _XX_, _XX_, _XX_, _XX_,             // mov         dClient_EBX, eax
      0xC7, 0x05, _XX_, _XX_, _XX_, _XX_, 0x01, 0x00, 0x00, 0x00, // mov fPAGEIN_InProgress, 1
      0x33, 0xC0                                // xor         eax, eax
};

//////////////////////////////////////////////////////////////////////////////
//                          bReverseCharColor
//////////////////////////////////////////////////////////////////////////////
#define       OFS_ReverseCharColor  19

UCHAR PAT_ReverseCharColor[] =                  
{
      0xA2, _XX_, _XX_, _XX_, _XX_,             // mov         ds:bLineCharColor, al
      0x88, 0x1D, _XX_, _XX_, _XX_, _XX_,       // mov         ds:bNormCharColor, bl
      0x88, 0x3D, _XX_, _XX_, _XX_, _XX_,       // mov         ds:bBoldCharColor, bh
      0x88, 0x0D, _XX_, _XX_, _XX_, _XX_,       // mov         ds:bReverseCharColor, cl
      0x88, 0x2D, _XX_, _XX_, _XX_, _XX_,       // mov         ds:bHelpCharColor, ch
};

#define       OFS_ReverseCharColor_DS32  12

UCHAR PAT_ReverseCharColor_DS32[] =
{
      0xB2, _XX_,				// mov     dl, 0
      0x02, 0x15, _XX_, _XX_, _XX_, _XX_,	// add     dl, byte ptr ds:dword_EE746
      0x2A, _XX_,				// sub     dl, al
      0x8A, 0x3D, _XX_, _XX_, _XX_, _XX_,	// mov     bh, byte ptr ds:word_164F7E+1
      0xE8, _XX_, _XX_, _XX_, _XX_,		// call    sub_75BA4
};

//////////////////////////////////////////////////////////////////////////////
//                          bReverseCharColor
//////////////////////////////////////////////////////////////////////////////
#define       OFS_OldIntTable   8

UCHAR PAT_OldIntTable[] =                       
{
      0xB9, 0xFF, 0x00, 0x00, 0x00,             // mov         ecx, 0FFh
                                                // loc_loop:
      0x89, 0x0C, 0x8D, _XX_, _XX_, _XX_, _XX_, // mov         old_int_00[ecx*4], ecx
                                                //             ^^^^^^^ - OldIntTable
      0xE2, 0xF7                                // loop        loc_loop
};

//////////////////////////////////////////////////////////////////////////////
//                             si_SetFont
//////////////////////////////////////////////////////////////////////////////
#define       OFS_SetFont          9
#define       OFS_FONTS            3
#define       OFS_CurFontIdx      17
#define       OFS_CurFontIdx_DS30 18

#define       TYPE_SetFont (VOID(__stdcall*)(const SI_FONT *))

UCHAR PAT_SetFont[] =                           
{
      0x8B, 0x14, 0x85, _XX_, _XX_, _XX_, _XX_, // mov          edx, SI_FONTS[eax*4]
      0x52,                                     // push         edx,
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call         si_set_font
      0x8B, 0x45, 0x08,                         // mov          eax, [ebp+arg_0]
      0xA3                                      // mov          dFONT_NUM, eax 
};

UCHAR PAT_SetFont_DS30[] =
{
      0x8B, 0x14, 0x85, _XX_, _XX_, _XX_, _XX_, // mov          edx, SI_FONTS[eax*4]
      0x52,                                     // push         edx,
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call         si_set_font
      0x8B, 0x44, 0x24, 0x18,                   // mov          eax, [esp+14h+arg_0]
      0xA3, _XX_, _XX_, _XX_, _XX_,             // mov          ds:dFONT_NUM, eax
      0x5E                                      // pop     esi
};

//////////////////////////////////////////////////////////////////////////////
//                             si_ActivateHooks
//////////////////////////////////////////////////////////////////////////////
#define       OFS_ActivateHooks 39

#define       TYPE_ActivateHooks (VOID(__stdcall*)(VOID))

UCHAR PAT_ActivateHooks[] =
{
      0xFF, 0x35, _XX_, _XX_, _XX_, _XX_,                         // push    dCurrentContext
      0xC6, 0x05, _XX_, _XX_, _XX_, _XX_, 0x01,                   // mov     dwNumberOfBPs?, 1
      0xC7, 0x05, _XX_, _XX_, _XX_, _XX_, 0x00, 0x00, 0x00, 0x00, // mov     dTSS_Base, 0
      0xC7, 0x05, _XX_, _XX_, _XX_, _XX_, 0xFF, 0xFF, 0xFF, 0xFF, // mov     dword_AF4CE, 0FFFFFFFFh
      0xE8, _XX_, _XX_, _XX_, _XX_,                               // call    sub_4074F
      0xE8, _XX_, _XX_, _XX_, _XX_,                               // call    pActivateHooks
//           ^^    ^^    ^^    ^^
      0x0F, 0xB6, 0x0D, _XX_, _XX_, _XX_, _XX_,                   // movzx   ecx, byte ptr int3_dword
      0xE3                                                        // jecxz   short loc_41C34
};

//////////////////////////////////////////////////////////////////////////////
//                             si_DeActivateHooks
//////////////////////////////////////////////////////////////////////////////
#define       OFS_DeActivateHooks 24

#define       TYPE_DeActivateHooks (VOID(__stdcall*)(VOID))

UCHAR PAT_DeActivateHooks[] =
{
      0x0F, 0xB6, 0x0D, _XX_, _XX_, _XX_, _XX_, // movzx   ecx, byte ptr int3_dword
      0xE3, 0x0E,                               // jecxz   short loc_419BD
                                                //loc_419AF:
      0x8B, 0x1C, 0x8D, _XX_, _XX_, _XX_, _XX_, // mov     ebx, dword_C90DF[ecx*4]
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call    sub_41B03
      0xE2, 0xF2,                               // loop    loc_419AF
                                                //loc_419BD:
      0xE8, _XX_, _XX_, _XX_, _XX_              // call    pDeactivateHooks
                                                // loc_419BD:                          
};

#define       OFS_DeActivateHooks_DS32 38

UCHAR PAT_DeActivateHooks_DS32[] =
{
      0x0F, 0xB6, 0x0D, _XX_, _XX_, _XX_, _XX_,	// movzx   ecx, int3_dword          
      0xE3, _XX_,				// jecxz   short loc_A5CD6          
						//loc_A5CBA:                                                                         
      0x8D, 0x1C, 0x8D, _XX_, _XX_, _XX_, _XX_,	// lea     ebx, ds:0FFFFFFFCh[ecx*4]               
      0x03, 0x1D, _XX_, _XX_, _XX_, _XX_,       // add     ebx, dword_1980C0        
      0x8B, _XX_,				// mov     ebx, [ebx]               
      0x03, 0x1D, _XX_, _XX_, _XX_, _XX_,       // add     ebx, dword_16C2EB        
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call    sub_A5E2A                
      0xE2, _XX_,				// loop    loc_A5CBA                
						//loc_A5CD6:                                  
      0xE8, _XX_, _XX_, _XX_, _XX_		// call    pDeactivateHooks                                      
};

//////////////////////////////////////////////////////////////////////////////
//                             si_DumpFilter
//////////////////////////////////////////////////////////////////////////////

UCHAR PAT_DumpFilter[] =
{
      0x3C, 0x20,                               // cmp     al, ' '
      0x72, 0x04,                               // jb      short loc_34E98
      0x3C, 0x80,                               // cmp     al, 'A'
      0x72, 0x02,                               // jb      short loc_34E9A
//                                            loc_34E98:
      0xB0, 0x2E                                // mov     al, '.'
//                                            loc_34E9A:
};

//////////////////////////////////////////////////////////////////////////////
//                             si_RecordLastBranchInfo
//                              si_MSR_LAST_BRANCH_0
//                              si_MSR_LAST_BRANCH_1
//////////////////////////////////////////////////////////////////////////////
#define       OFS_MSR_LAST_BRANCH_0    23

#define       TYPE_RecordLastBranchInfo (VOID(__stdcall*)(VOID))

UCHAR PAT_RecordLastBranchInfo[] =
{
      0x60,                                     // pusha
      0x8B, 0xEC,                               // mov      ebp, esp
      0x1E,                                     // push     ds
      0x66,                                     // db       66h
      0x2E, 0x8E, 0x1D, _XX_, _XX_, _XX_, _XX_, // mov      ds, cs:wNTICE_SS
      0xB9, 0xDB, 0x01, 0x00, 0x00,             // mov      ecx, MSR_LASTBRANCH_0
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call     rdmsr_sub
      0xA3                                      // mov      dMSR_LAST_BRANCH_0, eax 
};

//////////////////////////////////////////////////////////////////////////////
//                               WDBG_ExtensionApis
//////////////////////////////////////////////////////////////////////////////
#define       OFS_WDBG_ExtensionApis    6

UCHAR PAT_WDBG_ExtensionApis[] =
{
      0xFD,                                     // ...
      0x83, 0xC0, 0x0F,                         // add     eax, 0Fh
      0x50,                                     // push    eax
      0x68, _XX_, _XX_, _XX_, _XX_,             // push    offset ExtensionApis
      0xFF, 0xD6,                               // call    esi     ; call WinDbgExtensionDllInit
      0xEB                                      // jmp     short loc_983CB
};

//////////////////////////////////////////////////////////////////////////////
//                                   pLoadKDE
//////////////////////////////////////////////////////////////////////////////
#define       OFS_LoadKDE               12
#define       TYPE_LoadKDE (VOID(__stdcall*)(ULONG))

UCHAR PAT_LoadKDE[] =
{     
      0x8B, 0x46, 0x17,                         // mov     eax, [esi+17h]
      0xA3, _XX_, _XX_, _XX_, _XX_,             // mov     dword_146DA4, eax
      0xFF, 0x76, 0x17,                         // push    dword ptr [esi+17h]
      0xE8, _XX_, _XX_, _XX_, _XX_,             // call    pLoadKDE
      0x83, 0x4E, 0x23, 0x02                    // or      dword ptr [esi+23h], 2
};

//////////////////////////////////////////////////////////////////////////////
//                                 pEnableIRQ
//////////////////////////////////////////////////////////////////////////////
#define       OFS_EnableIRQ            46
#define       TYPE_EnableIRQ (VOID(__stdcall*)(VOID))

UCHAR PAT_EnableIRQ[] =
{
      0xE2, 0xFE,                               // loop    loc_318A2
      0x59,                                     // pop     ecx
      0xE4, 0x21,                               // in      al, 21h         ; Interrupt controller, 8259A.
      0x51,                                     // push    ecx
      0xB9, 0x14, 0x00, 0x00, 0x00,             // mov     ecx, 14h
      
                                                //loc_318AD:                             
      0xE2, 0xFE,                               // loop    loc_318AD
      0x59,                                     // pop     ecx
      0x24, 0xFB,                               // and     al, 0FBh
      0xE6, 0x21,                               // out     21h, al         ; Interrupt controller, 8259A.
      0x51,                                     // push    ecx
      0xB9, 0x14, 0x00, 0x00, 0x00              // mov     ecx, 14h
};

//////////////////////////////////////////////////////////////////////////////
//                                  pIRQ2INT
//////////////////////////////////////////////////////////////////////////////
#define       OFS_IRQ2INT             0
#define       TYPE_IRQ2INT (VOID(__stdcall*)(VOID))

UCHAR PAT_IRQ2INT[] =
{
      0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00, // cmp   fAPIC, 0
      0x74, _XX_,                               // jz    short loc_3177D
      0x83, 0xF8, 0x10,                         // cmp   eax, 10h
      0x73, _XX_,                               // jnb   short loc_3175B
      0x0F, 0xB6, 0x80, _XX_, _XX_, _XX_, _XX_, // movzx eax, byte ptr unk_AEAAF[eax]
      0xC3,                                     // retn
                                                //loc_3175B:
      0x53,                                     // push  ebx
      0x51,                                     // push  ecx
      0x8B, 0x0D, _XX_, _XX_, _XX_, _XX_,       // mov   ecx, dword_AEABF
      0x33, 0xDB                                // xor   ebx, ebx
};

//////////////////////////////////////////////////////////////////////////////
//                                 __chkstk
//////////////////////////////////////////////////////////////////////////////
#define OFS__chkstk                  10

/*
 *  SoftICE has a bug in __chkstk implementation that leads to BSOD if KDE 
 *  calls this function. Fix bug, so that my MP3 decoder can work correctly 
 */

UCHAR PAT__chkstk[] =
{
      0x8B, 0x0C, 0x24,                         // mov     ecx, [esp+0]    
      0x8B, 0xD4,                               // mov     edx, esp        
      0x83, 0xC2, 0x04,                         // add     edx, 4          
      0x2B, 0xD0,                               // sub     edx, eax        
      0x8B, 0xE0,                               // mov     esp, eax   ; BUG!! should be 'mov esp, EDX'
      0x51,                                     // push    ecx
      0xC3                                      // retn
};

//////////////////////////////////////////////////////////////////////////////
//                                 IceIsActive
//////////////////////////////////////////////////////////////////////////////
#define OFS_IceIsActive                23

UCHAR PAT_IceIsActive[] =
{
      0x2E, 0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp     cs:VidDrv_IsInactive, 1
      0x74, _XX_,                                     // jz      short locret_2EF15
                                                      //pIRQ_0C:
      0x2E, 0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x01, // cmp     cs:fVER_TOUCH, 1
      0x74, _XX_,                                     // jz      short locret_2EF15
      0x2E, 0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00, // cmp     cs:IceIsActive, 0
      0x75, _XX_,                                     // jnz     short loc_2EF16
      0x2E, 0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00  // cmp     cs:byte_AC5A3, 0
};

//////////////////////////////////////////////////////////////////////////////
//                              SendSpecificEOI
//////////////////////////////////////////////////////////////////////////////
#define OFS_SendSpecificEOI                0
#define TYPE_SendSpecificEOI (VOID(__stdcall*)(VOID))

UCHAR PAT_SendSpecificEOI[] =
{
      0x50,                                           // push    eax
      0x2E, 0x80, 0x3D, _XX_, _XX_, _XX_, _XX_, 0x00, // cmp     cs:fAPIC, 0
      0x74, _XX_,                                     // jz      short loc_317FD
      0xA1, _XX_, _XX_, _XX_, _XX_,                   // mov     eax, localAPICregisters
      0x05, 0xB0, 0x00, 0x00, 0x00,                   // add     eax, 0B0h
      0xC7, 0x00, 0x00, 0x00, 0x00, 0x00,             // mov     dword ptr [eax], 0
      0xEB, _XX_,                                     // jmp     short loc_31802
                                                      //loc_317FD:                              
      0xE8, _XX_, _XX_, _XX_, _XX_,                   // call    pSendSpecificEOI_
                                                      //loc_31802:
      0x58,                                           // pop     eax
      0xC3                                            // retn
};

//////////////////////////////////////////////////////////////////////////////
//                              pINT_0E
//////////////////////////////////////////////////////////////////////////////
#define OFS_INT_0E               0
#define TYPE_INT_0E (VOID(__stdcall*)(VOID))

UCHAR PAT_INT_0E[] =
{
      0x6A, 0x0E,                                     // push    0Eh
      0xE8, _XX_, _XX_, _XX_, _XX_,                   // call    pGeneralProtectionFault
      0x8D, 0x64, 0x24, 0x04,                         // lea     esp, [esp+4]
      0x81, 0x64, 0x24, 0x0C, 0xFF, 0xFF, 0xFE, 0xFF  // and     dword ptr [esp+12], 0FFFEFFFFh
};

//////////////////////////////////////////////////////////////////////////////
//                            pBangFuncsArray
//                            dKDEFuncNum
//////////////////////////////////////////////////////////////////////////////
#define OFS_BangFuncsArray              3
#define OFS_KDEFuncNum                 30
#define TYPE_BangFuncsArray (PUCHAR)

UCHAR PAT_BangFuncsArray[] =
{
      0x6A, 0x30,                                     // push    48
      0xBF, _XX_, _XX_, _XX_, _XX_,                   // mov     edi, offset bang_funcs_array
      0x5E,                                           // pop     esi
                                                      //print_bang_funcs: 
      0xFF, 0x77, 0xFC,                               // push    dword ptr [edi-4]
      0x57,                                           // push    edi
      0x68, _XX_, _XX_, _XX_, _XX_,                   // push    offset a20s08x_10 ; "%-20s  %08x"
      0xE8, _XX_, _XX_, _XX_, _XX_,                   // call    pPrintErrorMessage2
      0x83, 0xC4, 0x0C,                               // add     esp, 0Ch
      0x43,                                           // inc     ebx
      0x03, 0xFE,                                     // add     edi, esi
      0x3B, 0x1D, _XX_, _XX_, _XX_, _XX_              // cmp     ebx, KDEFuncNum
};

#define OFS_BangFuncsArray_DS32         7
#define OFS_KDEFuncNum_DS32            38

UCHAR PAT_BangFuncsArray_DS32[] =
{
      0x0F, 0x86, _XX_, _XX_, _XX_, _XX_,             // jbe     loc_9C692
      0xBF, _XX_, _XX_, _XX_, _XX_,                   // mov     edi, offset bang_funcs_array
      0xBE, _XX_, _XX_, _XX_, _XX_,                   // mov     esi, 10Ch
                                                      //loc_9C390:
      0xFF, _XX_, _XX_,                               // push    dword ptr [edi-4]
      0x57,                                           // push    edi
      0x68, _XX_, _XX_, _XX_, _XX_,                   // push    offset asc_9C148 ; "%-20s  %08x"
      0xE8, _XX_, _XX_, _XX_, _XX_,                   // call    pPrintErrorMessage2
      0x83, _XX_, _XX_,                               // add     esp, 0Ch
      0x43,                                           // inc     ebx
      0x03, 0xFE,                                     // add     edi, esi
      0x3B, 0x1D, _XX_, _XX_, _XX_, _XX_              // cmp     ebx, KDEFuncNum
};

//////////////////////////////////////////////////////////////////////////////
//                            pProcessIF
//////////////////////////////////////////////////////////////////////////////
#define TYPE_ProcessIF        (ULONG (__stdcall*)(PCHAR))
#define OFS_ProcessIF    	       15

UCHAR PAT_ProcessIF[] =
{
     0x66, 0x0D, 0x20, 0x20,                          // or    ax, 2020h
     0x66, 0x3D, 0x69, 0x66,                          // cmp   ax, 'fi'
     0x75, _XX_,               	                      // jnz   short loc_A3289

                        	                      //parse_BP_condition:
     0x8D, 0x46, 0x02,                                // lea   eax, [esi+2]
     0x50,                  	                      // push  eax
     0xE8, _XX_, _XX_, _XX_,_XX_,                     // call  pProcessIFstatement
     0x85, 0xC0,               	                      // test  eax, eax
     0x74, _XX_               	                      // jz    short loc_A32C1
};

//////////////////////////////////////////////////////////////////////////////
//                          pClearCompiledIF
//////////////////////////////////////////////////////////////////////////////
#define TYPE_ClearCompiledIF  (VOID  (__stdcall*)(ULONG))
#define OFS_ClearCompiledIF            24

UCHAR PAT_ClearCompiledIF[] =
{
     0xB8, _XX_, _XX_, _XX_, _XX_,                    // mov     eax, offset aSyntaxError ; "Syntax error"
     0x8B, 0xF0,                                      // mov     esi, eax
     0xE8, _XX_, _XX_, _XX_, _XX_,                    // call    sub_3CADA
                                                      //     
                                                      //loc_43BCD:
     0x8B, 0x83, _XX_, _XX_, _XX_, _XX_,              // mov     eax, dword ptr ds:byte_D87F7[ebx]
     0x0B, 0xC0,                                      // or      eax, eax
     0x74, 0x06,                                      // jz      short loc_43BDD
     0x50,                                            // push    eax
     0xE8, _XX_, _XX_, _XX_, _XX_                     // call    pClearCompiledIF
                                                      //loc_43BDD:
};

#define OFS_ClearCompiledIF_DS32       21

UCHAR PAT_ClearCompiledIF_DS32[] =
{
     0xB8, _XX_, _XX_, _XX_, _XX_,                    // mov     eax, offset aSyntaxError ; "Syntax error"
     0x8B, 0xF0,                                      // mov     esi, eax
     0xE8, _XX_, _XX_, _XX_, _XX_,                    // call    pPrintErrorMessage
                                                      //     
                                                      //loc_A6F05::
     0x8B, 0x43, 0x37,                                // mov     eax, [ebx+37h]
     0x0B, 0xC0,                                      // or      eax, eax
     0x74, 0x06,                                      // jz      short loc_A6F12
     0x50,                                            // push    eax
     0xE8, _XX_, _XX_, _XX_, _XX_                     // call    pClearCompiledIF
                                                      //loc_A6F12:
};

//////////////////////////////////////////////////////////////////////////////
//                            pCheckCondition
//////////////////////////////////////////////////////////////////////////////
#define TYPE_CheckCondition  (BOOLEAN (__stdcall*)(ULONG))
#define OFS_CheckCondition              1

UCHAR PAT_CheckCondition[] =
{
      0xE8, _XX_, _XX_, _XX_, _XX_,      	                  // call  pCheckCondition
      0x72, _XX_,			                          // jb short condition_not_met
      0xC7, 0x83, _XX_, _XX_, _XX_, _XX_, 0x00, 0x00, 0x00, 0x00, // mov   dBP_StatusCode[ebx], 0
      0x85, 0xC0,              		               	          // test  eax, eax
      0x75, _XX_,              				          // jnz   short condition_met
                                                                  
                        			                  //condition_not_met:     
      0xFF, 0x83, _XX_, _XX_, _XX_, _XX_,   		          // inc   dBP_TotalMissesCount[ebx]
      0xFF, 0x83, _XX_, _XX_, _XX_, _XX_   		          // inc   dBP_CurrentMissesCount[ebx]
};

UCHAR PAT_CheckCondition_DS32[] =
{
      0xE8, _XX_, _XX_, _XX_, _XX_,                               // call    pCheckCondition
      0x72, 0x0B,                                                 // jb      short loc_A56D5
      0xC7, 0x43, _XX_, 0x00, 0x00, 0x00, 0x00,                   // mov     dword ptr [ebx+5Fh], 0
      0x85, 0xC0,                                                 // test    eax, eax       
      0x75, _XX_,                                                 // jnz     short loc_A56EE
                                                                  //loc_A56D5:
      0xFF, 0x43, _XX_,                                           // inc     dword ptr [ebx+57h]
      0xFF, 0x43, _XX_                                            // inc     dword ptr [ebx+5Bh]
                                                                  //loc_A56D5:
};

//////////////////////////////////////////////////////////////////////////////
//                            pQueueMacroExec
//////////////////////////////////////////////////////////////////////////////
#define       OFS_QueueMacroExec   15
#define       OFS_fMacroQueued     25

UCHAR PAT_QueueMacro[] =                    
{
      0x89, 0x91, _XX_, _XX_, _XX_, _XX_,               	  // mov   ds:param_No[ecx], edx
      0x75, 0x19,                           		   	  // jnz   short loc_626EF
      0xE8, _XX_, _XX_, _XX_, _XX_,                    		  // call  pSomeErrIDhandling
      0xC7, 0x05, _XX_, _XX_, _XX_, _XX_, _XX_, _XX_, _XX_, _XX_, // mov   ds:oExecuteMacro, offset pExecuteMacro_
      0xC7, 0x05, _XX_, _XX_, _XX_, _XX_, 0x01, 0x00, 0x00, 0x00, // mov   ds:fExecuteMacro?, 1
      0x33, 0xC0                            			  // xor   eax, eax
};

//////////////////////////////////////////////////////////////////////////////
//                            pPatchDE
//////////////////////////////////////////////////////////////////////////////
#define       OFS_PatchDE_JZ      9

UCHAR PAT_PatchDE[] =
{
      0xE2, _XX_,                                                 // loop    loc_A2228
      0xF6, 0x05, _XX_, _XX_, _XX_, _XX_, 0x02,                   // test    dw_cr4_flags?, 2
      0x74, 0x09,                                                 // jz      short loc_A2276
      0x0F, 0x20, 0xE0,                                           // mov     eax, cr4
      0x83, 0xC8, 0x08,                                           // or      eax, 8
      0x0F, 0x22, 0xE0                                            // mov     cr4, eax
                                                                  //loc_A2276:
};                                                                


#endif // __SOFTICE_C__

#undef  EXPORT
#undef  INIT

#endif // __SOFTICE_H__