//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains procedures linked to STTB section.
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
//This function sets String table. (STTB)
//
// stringT - Pointer to string we want to include.
//
// retutn - index name (iName in nms32.h) or
//          STATUS_ERROR( Zero index is reserved for zero string ('\x0'). )
//
unsigned long ida2softice_c::STTB_SetStringTable
(
	char*	pString
)
{
	STATUS			Status;

	char			currentChar;
	unsigned long	i;
	char			hashTest[4];
	unsigned long   strLength;

//Test if the pointer exist
//(IDA sometimes returns NULL even if it should return a pointer).
	if ( pString == NULL )
	{
		msg( "I2S: IDA returned NULL pointer for a name pointer.\n" );
		return STATUS_ERROR;
	}

//Check if we have enough memory.
//
//Notice:
//As strings part must finish on DWORD boundary we'll add +4 every time
//so that there wont be any problems when we'll copy those zero bytes at the end.
	if ( sttb.freeStrings <= MAXSTR + 4 )
	{
	//There is not enough memory left -> reallocate.
		Status = ReallocateMemory(
		  ALLOCATE_BIG,
		  sttb.hStrings,
		  (void**)&(sttb.pStrings),
		  (void**)&(sttb.pStrings_current),
		  &sttb.freeStrings,
		  &sttb.sizeStrings
		);
		if ( S_FAILED( Status ) )
		{
			return STATUS_ERROR;
		}
	}
	if ( sttb.freeOffsets <= sizeof( unsigned long ) )
	{
	//There is not enough memory left -> reallocate.
		Status = ReallocateMemory(
		  ALLOCATE_SMALL,
		  sttb.hOffsets,
		  (void**)&(sttb.pOffsets),
		  (void**)&(sttb.pOffsets_current),
		  &sttb.freeOffsets,
		  &sttb.sizeOffsets
		);
		if ( S_FAILED( Status ) )
		{
			return STATUS_ERROR;
		}

	//Reallocate memory for simple hash table also.
		Status = ReallocateMemory(
		  ALLOCATE_SMALL,
		  sttb.hHash,
		  (void**)&(sttb.pHash),
		  (void**)&(sttb.pHash_current),
		  &sttb.freeHash,
		  &sttb.sizeHash
		);
		if ( S_FAILED( Status ) )
		{
			return STATUS_ERROR;
		}
	}

//Copy and change all spaces with'_' -> SoftIce can't handle spaces ->
//it uses them as a delimiters.
//
//Notice:
//We'll save the string already to the sttb buffer, but we wont update other variables
//until we'll be sure that this string doesn't exist in the buffer yet.
	i = 0;
	currentChar = pString[0];
	if ( currentChar == '\x0' )
	{
	//It's a NUL string.
	//
	//Notice:
	//Even if we support this type of string I don't the use of this type.
	//But hay you never know what's going on in SIce. :)
		return 0;
	}
	while( currentChar != '\x0' )
	{
	//Is current char a space?
		if ( currentChar == ' ' )
		{
		//Yes -> change it to underscore.
			currentChar = '_';
		}
	//Save.
		sttb.pStrings_current[i] = currentChar;

	//Update.
		++i;
		currentChar = pString[i];
	}

//Test if we have same string already in our buffer.
//
//As comparing string is a really slow process, we'll use a little trick.
//We'll use first 4 chars of the string and compare it to others first 4 chars.
//It's a simple HASH test.
//
	//Get first for chars of the string.
	//
	//Notice:
	//We don't have to worry if the string is not 4 chars long as
	//memory is initialized to zeroes.
	hashTest[0] = sttb.pStrings_current[0];
	hashTest[1] = sttb.pStrings_current[1];
	hashTest[2] = sttb.pStrings_current[2];
	hashTest[3] = sttb.pStrings_current[3];

	//Scan for similar strings.
	//
	//Notice:
	//We don't have to scan a zero string at the start so scan from 1.
	i = 1;
	while ( i < sttb.nStrings )
	{
	//Do strings have the same simple hash value?
		if ( *( (unsigned long*)&hashTest ) == sttb.pHash[i] )
		{
		//Yep they are the same -> check if whole strings match.
			//We don't need pString anymore so we'll use it here.
			pString = sttb.pStrings + sttb.pOffsets[i];
			if( 0 == strcmp( pString, sttb.pStrings_current ) )
			{
			//The string is already in the database -> return the string index.
				return i;
			}
		}

	//Update.
		++i;
	}

//The new string is not present in the database yet -> create a new reference.
//
//Get string length.
	strLength = strlen( sttb.pStrings_current ) + 1;	//+ '\x0'

//Add the new string to the database.
//
//Notice:
//We have already copied the string to the buffer. All we have to do now is to
//update other variables and with this we'll define that there is a new string
//in the buffer.
	sttb.pStrings_current += strLength;
	sttb.freeStrings -= strLength;
	//Increase number of strings in the buffer.
	++sttb.nStrings;

	//Set the new offset.
	*( sttb.pOffsets_current + 1 ) = *sttb.pOffsets_current + strLength;
	++sttb.pOffsets_current;
	sttb.freeOffsets -= sizeof( unsigned long );

	//Set new hash.
	*sttb.pHash_current = *( (unsigned long*)&hashTest );
	++sttb.pHash_current;
	sttb.freeHash -= sizeof( unsigned long );

//Return the string index.
	return ( sttb.nStrings - 1 );
}
