//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  TYTB and HSHT section functions
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
//This function creates hash number from name.
//
// name - pointer to string.
//
// return - hash number.
//
unsigned long ida2softice_c::HSHT_GetHashNumber
(
	char*	name
)
{
	unsigned long	hashNumber=0;

	unsigned long*	nameD = (unsigned long*)name;
	unsigned long	temp;

	unsigned long	strLength;
	unsigned long	counter;
	unsigned long	i;

//Get string length.
	strLength = strlen(name);

//Hash code -> check into nm32.h
//
//Loop1 -> DWORDs
	counter = strLength / 4;
	if ( counter != 0 )
	{
		i = 0;
		while( i < counter )
		{
			hashNumber ^= ( nameD[i] & 0xDFDFDFDF );
			hashNumber = _lrotl( hashNumber, 4  );
			++i;
		}
	}
//Loop2 -> BYTEs
	counter = strLength & 3;
	if ( counter != 0 )
	{
		temp = 0;
		i = 0;
		while( i < counter )
		{
			temp |= name[strLength - 1 - i];
			temp <<= 8;
			++i;
		}
		temp &= 0xDFDFDFDF;
		hashNumber ^= temp;
	}

	return hashNumber;
}


//--------------------------------------------------------------------------
//This function gets/sets hashOffsets.
//
// hashNumber - Hash number created from a type name.
//
// return - previous offset.
//
unsigned long ida2softice_c::HSHT_SetHashOffset
(
	unsigned long	hashNumber
)
{
	unsigned long	previousOffset;
	unsigned long	index;

//Get index in 'HSHT Type Table Offsets section'.
	index = hashNumber % 0x25;

//Get offset->write.
	previousOffset = hsht.hashOffsets[index];
	hsht.hashOffsets[index] = hsht.currentOffset; //+1 was already set at initialization

//Update.
	hsht.currentOffset += sizeof( HSHT_TYPETABLE );

//return
	return previousOffset;
}

//--------------------------------------------------------------------------
//This function sets Type and Hash tables;
//
// type -  Type of typeDefs, structs and global procedures.
// name - Pointer to name.
// iName - Index name. (check nm32.h) -> if calle doesn't have this number it must
//                                       set it to STATUS_ERROR
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::Set_TYTB_HSHT
(
	unsigned long	type,
	char*			pName,
	unsigned long	iName
)
{
	STATUS			Status;

	unsigned long	hashNumber;

//Do we have enough memory?
	if ( tytb.freeTypeTables <= sizeof( TYPETABLE ) )
	{
		Status = ReallocateMemory(
		  ALLOCATE_BIG,
		  tytb.hTypeTables,
		  (void**)&(tytb.pTypeTables),
		  (void**)&(tytb.pTypeTables_current),
		  &tytb.freeTypeTables,
		  &tytb.sizeTypeTables
		);
		if ( S_FAILED( Status ) )
		{
			return Status;
		}
	}
	if ( hsht.freeHashTables <= sizeof( HSHT_TYPETABLE ) )
	{
		Status = ReallocateMemory(
		  ALLOCATE_BIG,
		  hsht.hHashTables,
		  (void**)&(hsht.pHashTables),
		  (void**)&(hsht.pHashTables_current),
		  &hsht.freeHashTables,
		  &hsht.sizeHashTables
		);
		if ( S_FAILED( Status ) )
		{
			return Status;
		}
	}

//Get iName.
	if ( iName == STATUS_ERROR )
	{
	//The iName was not set yet -> get it.
		iName = STTB_SetStringTable( pName );
		if ( iName == STATUS_ERROR )
		{
			return STATUS_FAILED;
		}
	}

//Set TYTB and update tytb variables.
	tytb.pTypeTables_current->type = type;
	tytb.pTypeTables_current->iName = iName;

	++tytb.pTypeTables_current;
	tytb.freeTypeTables -= sizeof( TYPETABLE );
	++tytb.nTypeTables;

//Set HSHT and update hsht variables.
	hashNumber = HSHT_GetHashNumber( pName );

	hsht.pHashTables_current->offPreviousTable = HSHT_SetHashOffset( hashNumber );
	hsht.pHashTables_current->hashNumber = hashNumber;
	hsht.pHashTables_current->iName = iName;
	hsht.pHashTables_current->type = type;

	++hsht.pHashTables_current;
	hsht.freeHashTables -= sizeof( HSHT_TYPETABLE );
	++hsht.nHashTables;

	return STATUS_SUCCESS;
}
