//
//  PlugIn name: IDA to SoftIce converter
//
// Authors requests:
//
// -If you don't like or you want to add something please write to me.
//  I would be more than happy to help.
//
// -If you find a bug, it's your duty to mail me.
//
// -Because my 1st language isn't C/C++, I don't know much about it.
//  If anything could be done easier I'm waiting for your mail.
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
//Variables
//
//Classes
ida2softice_c		i2s;	//class
progressBar_c		pBar;	//class

//lineArrayDissasemblyType: - 0 return dissasembly
//                          - 1 return hex values
unsigned long		lineArrayDissasemblyType = 0;
linearray_t			lineArray( &lineArrayDissasemblyType );
idaplace_t			IDAPlace( 0, 0 );

//Variables
unsigned long		plugInFlags = 0;

HWND				hwnd_mainWindow;
HWND				hWnd_pleaseWait;	//current "IDA to SoftIce - Please wait..." window (all IDA's commands are disabled)

//--------------------------------------------------------------------------
//void main()
//{
//}
int idaapi init(void)
{
//What kind of file type did we get?
//
//Only PE and LE are supported.
	if ( inf.filetype == f_PE )
	{
	//PE file type
		return PLUGIN_OK;
	}
	if ( inf.filetype == f_LE )
	{
	//LE file type (VXD)
		return PLUGIN_OK;
	}

//If we came to here then unsuported file type was opened -> show warning only 1 time.
//
//I have to do it like this as sometimes 'term' procedure is not called at all
	HKEY			hKeyIda2SIce;
	unsigned long	wasWarning=0;

	hKeyIda2SIce = GetRegistryKey(
	  HKEY_LOCAL_MACHINE,
	  "SOFTWARE\\IdaToSoftIce",
	  KEY_ALL_ACCESS,
	  I2S_REG_TYPE_CREATE
	);
	if ( S_SUCCESS( hKeyIda2SIce ) )
	{
	//Get number of times the warning "was" shown.
		GetRegistryValue( hKeyIda2SIce, "warning", (char*)&wasWarning, 4 );

	//Did i2s show the warning already?
		if ( wasWarning == 0 )
		{
			msg( "I2S: Sorry, but I2S supports only PE and LE file types.\n" );
		}
		++wasWarning;	//increase how many times init procedure was started
		//Normally the procedure is started 4 times so we are around -> reset the counter.
		if ( wasWarning > 3 )
		{
			wasWarning = 0;
		}

	//Set the waiting counter value back to registry.
		SetRegistryValue(
		  hKeyIda2SIce,
		  "warning",
		  REG_DWORD_LITTLE_ENDIAN,
		  (char*)&wasWarning,
		  4
		);
		CloseRegistryKey( hKeyIda2SIce );
	}
	else
	{
	//If something is wrong show the warning every time.
		msg( "I2S: Sorry, but I2S supports only PE and LE file types.\n" );
	}
	return PLUGIN_SKIP;
}

//--------------------------------------------------------------------------
//Main
void idaapi run( int arg )
{
//  arg: 0 = Make NM32 file and load it to SoftIce.      (hotkey: F12)
//       1 = Make NM32 file and save to wanted location. (hotkey: Shift-F12)
//       2 = Source files definiton list.                (hotkey: Ctrl-F12)
//       2 = PlugIn Setup.                               (hotkey: non)

//Get main window handle.
	hwnd_mainWindow = GetForegroundWindow();

//Create progressBar window.
	if ( S_FAILED( pBar.CreateProgressBar() ) )
	{
		return;
	}

//Show "Wait box" as it disables all IDA's commands.
//If commands aren't disabled you can in some circumstances close IDA -> plugIn crash.
	show_wait_box( "IDA to SoftIce - Please wait..." );

//Get 'Please wait...' window handle.
	hWnd_pleaseWait = GetForegroundWindow();

//--------------------------------------------------------------------------
//One time definitions and test if SoftIce is loaded.
//
//Some things can be initialized only once as i2s memory stays resident
//when IDA loads it.
	if ( ( plugInFlags & ONE_TIME_ALREADY ) == 0  )
	{
	//Display that i2s is initializing for the first time.
		msg( "I2S: Initialization.\n" );

	//Intialize/create netnodes.
		i2s.i2sNetNode = netnode( I2S_NETNODE_NAME, 0, true );
		i2s.sourceNetNode = netnode( I2S_SOURCE_NETNODE_NAME, 0, true );
		i2s.sectionTablesNetNode = netnode( I2S_SECTION_TABLES_NETNODE_NAME, 0, true );

	//I2S'es one time initializations.
		if ( S_FAILED( i2s.Initialize_oneTime() ) )
		{
			msg( "I2S: PlugIn failed to initialize." );
			hide_wait_box();
			pBar.DestroyProgressBar();
			return;
		}
		plugInFlags |= ONE_TIME_ALREADY;
	}

//--------------------------------------------------------------------------
//Check if source file database is valid.
//
//As the 'source files' database is created when the i2s is started the first time on
//current IDA database, so if IDA created code from data (which can happen) and that user
//converted that code back to data it can happen that there is a source file
//without any code in it -> a possible problem (haven't tested how SIce
//would behave under this circumstances -> but better be save than sorry).
//
	msg( "I2S: Checking source files database -> " );
	if ( S_FAILED( i2s.CheckSourceFilesDatabase() ) )
	{
	//There must be at least 1 file that is showing the upper problem ->
	//destroy the database and create it again.
		msg( "error.\nI2S: There is a problem in 'source file' database -> the database will be destroyed and created again.\n" );
		i2s.sourceNetNode.kill();

		msg( "I2S: Source file boundaries creation (only once).\n" );
		i2s.SetSourceFilesBoundaries();
	}
	else
	{
		msg( " all ok.\n" );
	}

//--------------------------------------------------------------------------
//Set flags
	if (
	  ( i2s.i2sNetNode.altval( NVAL_I2S__FLAGS, atag ) & I2S_FLAGS_INCLUDE_SOURCE )
	  !=
	  0
	)
	{
	//Load source files too.
		i2s.creationFlags = CN_T_SYMBOLS_SOURCE | CN_L_SYBOLSONLY;

	//Should the source be attached to the end of NMS file?
	//
	//User can set this by default or if it presses the F12 button.
		unsigned long flagsDatabase = i2s.i2sNetNode.altval( NVAL_I2S__FLAGS, atag );
		if (
		  ( ( flagsDatabase & I2S_FLAGS_ATTACH_SOURCE ) != 0 )
		  ||
		  ( arg == 0 )
		)
		{
			i2s.creationFlags |= CN_T_INCLUDESOURCE;
		}
		i2s.includeSource = TRUE;
	}
	else
	{
	//Symbols only.
		i2s.creationFlags = CN_T_SYMBOLSONLY | CN_L_SYBOLSONLY;
		i2s.includeSource = FALSE;
	}

//--------------------------------------------------------------------------
//Make NM32 file and save it if requested.
	if (
	  ( arg <= 1)
	  &&
	  ( ( plugInFlags & PLUGIN_RUNNING ) == 0 )
	)
	{
		plugInFlags |= PLUGIN_RUNNING;

	//Change import names -> if we wouldn't do this the global import function
	//names in SoftIce would be substituted with executable ones.
		if ( S_SUCCESS( i2s.Imports_renameNames( IMPORTNAMES_SET ) ) )
		{
			NM32_HEADER*	pFileMapped;

		//Create source file directory path (relative).
		//
		//ex.
		//myFile.exe -> 'myFile Source\'
			STATUS	Status = STATUS_SUCCESS;
			if (
			  ( arg != 0 )
			  &&
			  ( ( i2s.creationFlags & CN_T_INCLUDESOURCE ) == 0 )
			)
			{
			//The source listing files are saved to separate directory -> create the relative path.
				Status = i2s.CreateSourceRelativePath();
			}
			else
			{
			//The source listing fiels are appened to the end of NMS database ->
			//clear the relative path.
				i2s.sourcePath[0] = '\x0';
			}

		//Do the honky tonk.
			if ( S_SUCCESS( Status ) )
			{
			//Initialize progressBar.
				pBar.Initialize();

			//Create NMS database.
				pFileMapped = i2s.CreateNmsDatabase();

			//Load nms database or save it.
				if ( S_SUCCESS( pFileMapped ) )
				{
				//Should we load it to SIce?
				//
				//If F12 was pressed, but be careful Sice must be running also.
					if (
					( arg == 0 )
					&&
					( ( plugInFlags & SOFTICE_LOADED ) != 0 )
					)
					{
					//Load to Softice.
						if ( S_FAILED( i2s.LoadNMSFile( pFileMapped, i2s.sections.fullFileSize ) ) )
						{
							msg( "I2S: Failed to load symbols to SoftIce.\n" );
						}
						else
						{
							msg( "I2S: Symbols loaded successfully.\n" );
						}
					}
					else
					{
						i2s.SaveFiles();
					}
				}
				else
				{
					if ( ( plugInFlags & USER_CANCELLED ) != 0 )
					{
						plugInFlags &= USER_NOT_CANCELLED;
					}
					else
					{
						msg( "I2S: PlugIn failed to create nms file.\n" );
					}
				}
			}

		//Release acquired resources.
			i2s.FreeMemory();

		//Convert import names back to their original form.
			i2s.Imports_renameNames( IMPORTNAMES_RESET );
		}

	//PlugIn has finished.
		plugInFlags &= PLUGIN_NOT_RUNNING;

	//Close wait box.
		hide_wait_box();
		pBar.DestroyProgressBar();
	}
	else if ( arg == 2 )
	{
	//It must be here or some window problems can occur.
		hide_wait_box();
		pBar.DestroyProgressBar();

	//Show Source Window
		i2s.ShowSourceFilesInfo();
	}
	else if ( arg == 3 )
	{
	//It must be here or some window problems can occur.
		hide_wait_box();
		pBar.DestroyProgressBar();

	//Setup Window
		DialogBoxParam(
		  GetModuleHandle( "i2s.plw" ),
		  (char*)DIALOG_SETUP,
		  hWnd_pleaseWait,
		  SetupDialogBox,
		  1		//1 - open dialog (0-enable ALWAYSDEFAULT)
		);
	}
	return;
}
//******************************************************************************************************
//******************************************************************************************************
//
//  End Of Main Program
//
//******************************************************************************************************
//******************************************************************************************************
//--------------------------------------------------------------------------
//      terminate
//      usually this callback is empty
//
//      IDA will call this function when the user asks to exit.
//      This function won't be called in the case of emergency exits.

void idaapi term( void )
{
	return;
}

//   PLUGIN structure definitions
char comment[] = "IDA to SoftIce plugIn. For setup press Ctrl-F12";

char help[] = "IDA to SoftIce plugIn.\n"
              "\n"
              "For conversion press F12.\n"
			  "For saving nms file press Shift-F12.\n"
              "For setup press Ctrl-F12.\n";

//--------------------------------------------------------------------------
// This is the preferred name of the plugin module in the menu system
// The preferred name may be overriden in plugins.cfg file

char wanted_name[] = "IDA to SoftIce";

// This is the preferred hotkey for the plugin module
// The preferred hotkey may be overriden in plugins.cfg file
// Note: IDA won't tell you if the hotkey is not correct
//       It will just disable the hotkey.

char wanted_hotkey[] = "F12";


//--------------------------------------------------------------------------
//
//      PLUGIN DESCRIPTION BLOCK
//
//--------------------------------------------------------------------------

extern "C" plugin_t PLUGIN = {
  IDP_INTERFACE_VERSION,//IDA SDK version
  0,                    // plugin flags
  init,                 // initialize
  term,		            // terminate. this pointer may be NULL.
  run,                  // invoke plugin
  comment,              // long comment about the plugin
                        // it could appear in the status line
                        // or as a hint
  help,                 // multiline help about the plugin
  wanted_name,          // the preferred short name of the plugin
  wanted_hotkey         // the preferred hotkey to run the plugin
};
