//  IDA to SoftIce and NMTrans common definitions
//
//  Author: Mostek
//   mail:  mostekaccess@mailcity.com
#ifndef _I2S
#define _I2S
#pragma pack(push, 1)
#pragma comment(lib, "ida.lib")
#pragma comment(lib, "Advapi32.lib")
#pragma comment(lib, "user32.lib")
#pragma comment(lib, "kernel32.lib")
#pragma comment(lib, "shell32.lib")
#pragma comment(lib, "gdi32.lib")
#pragma comment(lib, "winspool.lib")
#pragma comment(lib, "comdlg32.lib")
#pragma comment(lib, "Comctl32.lib")
#pragma comment(lib, "ole32.lib")
#pragma comment(lib, "oleaut32.lib")
#pragma comment(lib, "uuid.lib")
#pragma comment(lib, "odbc32.lib") 
#pragma comment(lib, "odbccp32.lib")
//---------------------------------------------------------------------------
#include <windows.h>
#include <commctrl.h>
#include <shlobj.h>

#define BYTES_SOURCE	//for bytes.hpp

#include "ida/ida.hpp"
#include "ida/bytes.hpp"
#include "ida/loader.hpp"
#include "ida/kernwin.hpp"
#include "ida/funcs.hpp"
#include "ida/struct.hpp"
#include "ida/area.hpp"
#include "ida/frame.hpp"
#include "ida/name.hpp"
#include "ida/diskio.hpp"
#include "ida/typeinf.hpp"
#include "ida/entry.hpp"

#include "nm32.h"
#include "registry.h"
#include "progressBar.h"
#include "sections.h"
#include "resource.h"
 
#include <time.h>

//#include <AUTO.HPP>
//#include <IDP.HPP>
//#include <NETNODE.HPP>
//#include <LINES.HPP>
//#include <AREG.HPP>
//#include <SEGMENT.HPP>

//#include <err.h>
//#include <exehdr.h>
//#include <FPRO.H>
//#include <HELP.H>
//#include <IEEE.H>
//#include <PRO.H>
//#include <PRODIR.H>
//#include <DEMANGLE.HPP>
//#include <DISKIO.HPP>
//#include <ENUM.HPP>
//#include <EXPR.HPP>
//#include <FIXUP.HPP>
//#include <INTS.HPP>
//#include <ITYPE.HPP>
//#include <LLONG.HPP>
//#include <MICRO.HPP>
//#include <NALT.HPP>
//#include <OFFSET.HPP>
//#include <QUEUE.HPP>
//#include <SRAREA.HPP>
//#include <UA.HPP>
//#include <VA.HPP>
//#include <VM.HPP>
//#include <XREF.HPP>

//Ilfak: IDA saves the PE header and section headers in the node called "$PE header".
#define PE_NODE "$ PE header" // netnode name for PE header
                              // value()        -> peheader_t
                              // altval(segnum) -> s->startEA
                              // altval(-1)     -> translated fpos of debuginfo
                              // altval(-2)     -> loading address (usually pe.imagebase)
                              // supval(segnum) -> pesection_t

//No use: it's only _IMAGE_FILE_HEADER and _IMAGE_OPTIONAL_HEADER and I can't get anything from supVal.

//*****************************************************************************
//Defines
//
typedef	unsigned long	STATUS;
#define	STATUS_ERROR	-1	//this is a special case the return should be signed value
#define STATUS_FAILED	0
#define	STATUS_SUCCESS	1

#define S_SUCCESS( status ) ( status > STATUS_FAILED )
#define S_FAILED( status ) ( status == STATUS_FAILED )

//Primitive types (to see all look into 'Primitive Type Listing.txt'
#define TP_NOTYPE       0x0000    //Uncharacterized type (no type)
#define TP_VOID         0x0003    //Void
#define TP_CHAR         0x0010    //8-bit signed
#define TP_UCHAR        0x0020    //8-bit unsigned
#define TP_WCHAR        0x0071    //wide char
#define TP_SHORT        0x0011    //16-bit signed
#define TP_USHORT       0x0021    //16-bit unsigned
#define TP_LONG         0x0012    //32-bit signed
#define TP_ULONG        0x0022    //32-bit unsigned
#define TP_UINT8        0x0077    //64-bit unsigned int (__int64)
#define TP_QUAD         0x0013    //64-bit signed
#define TP_UQUAD        0x0023    //64-bit unsigned
#define TP_REAL32       0x0040    //32-bit real
#define TP_REAL64       0x0041    //64-bit real
#define TP_REAL80       0x0042    //80-bit real
#define TP_REAL128      0x0043    //128-bit real

//*****************************************************************************
//Global functions
extern BOOL CALLBACK SetupDialogBox(HWND,UINT,WPARAM,LPARAM);
extern BOOL CALLBACK SourceFileInfoDialogBox(HWND,UINT,WPARAM,LPARAM);

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//Global variables
extern HWND					hwnd_mainWindow;
extern HWND					hWnd_pleaseWait;

extern unsigned long		plugInFlags;	//bit flags
#define SOFTICE_LOADED				0x0001
#define ONE_TIME_ALREADY			0x0002
#define PLUGIN_RUNNING				0x0004
#define PLUGIN_NOT_RUNNING			0xFFFFFFFB	//not (PLUGIN_RUNNING)
#define USER_CANCELLED				0x0008
#define USER_NOT_CANCELLED			0xFFFFFFF7	//not (USER_CANCELLED)


extern unsigned long		userDefine;
extern idaplace_t			IDAPlace;	//class
extern linearray_t			lineArray;

struct sourceFiles_s	//for 1 segment (this is for source listing)
{
	unsigned long	indexInSupVal;	//index of supval where the 1st sourceInfo_s
									//of current segment starts
	unsigned long	nEnabled;	//number of enabled source files
	unsigned long	nAll;		//number of all source files in the database
};
struct sourceInfo_s
{
//common info
	BOOL					enable_symbols;		//if this is FALSE, enable_source will be too
	BOOL					enable_source;		//Will current source listing be included
												//in NMS database or not?
	char					nameSource[32];
	ea_t					startEA;		//address in IDA
	ea_t					endEA;
	unsigned long			segmentNumber;	//in which IDA segment is source files's code

//NMS database part
	SEGDATA_SOURCESECTION	sourceSection;
	SEGDATA_SOURCEFILE		sourceFile;
};

struct peHeader_sectionTables_s	//for 1 file segment
{
	unsigned short			nSection;	//serial number of the section (0 based)
	char					name[10];
	unsigned long			sizeOfRawData;
};


//*****************************************************************************
//IDA to SoftIce class
class ida2softice_c {
public:
//uredi
	STATUS			Initialize_oneTime( void );

	unsigned long	creationFlags;

//-----------------------------------------------------------------------------
//Main loop.
	NM32_HEADER*	CreateNmsDatabase( void );

//-----------------------------------------------------------------------------
//Various memory manegement.
	void	FreeMemory( void );
	STATUS	InitializeMemory( void );
	STATUS	InitializeMemory_STTB( void );
	STATUS	ReallocateMemory( unsigned long size, HLOCAL handle, void** ppBuffer, void** ppBuffer_current, unsigned long* pFreeBuffer, unsigned long* pSizeBuffer );
#define ALLOCATE_SMALL		0x4000		//0x4000=0x1000*4 (allocate 4096 DWORDs)
#define ALLOCATE_BIG		0x40000		//256kB
#define ALLOCATE_REALLYBIG	0x400000	//4MB

//-----------------------------------------------------------------------------
//Import names renaming.
	void	Imports_initialize( void );
	STATUS	Imports_renameNames( unsigned long set );

	char			imports_appendName[24];
	size_t			imports_appendNameLength;

#define	IMPORTNAMES_SET		0	//Append the file name to import names.
#define IMPORTNAMES_RESET	1	//Reset the function names back to normal state.

//-----------------------------------------------------------------------------
//i2s netnode
//
//Contains flags and default paths.
//altval 0 = flags
//altval 1 = sourceNetNode version
//altval 2 = size of the biggest source listing size
//supval 0 = nms path
//
	netnode			i2sNetNode;
#define I2S_NETNODE_NAME				"@I2S"

//We'll use same flags in registry flags variable too
//(so some bits will be usefull in the program and some in registry).
//Flags stored with the database has precedence over registry flags value.
#define NVAL_I2S__FLAGS					0
#define I2S_FLAGS_DEFINED				0x80000000		//the flags are defined (we need this so that the altval will return a value)
#define I2S_FLAGS_INCLUDE_SOURCE		0x00000001		//create source files (bit: 0 - No, 1 - Yes)
#define I2S_FLAGS_ATTACH_SOURCE			0x00000002		//attach source files to NMS file
#define I2S_FLAGS_SAVE_TO_PROJECT_DIR	0x00000004		//save NMS file to the IDA project dir (idb file is in this dir).
#define I2S_FLAGS_ALWAYS_DEFAULT		0x40000000		//use default values in every new database (bit: 0- No, 1 - Yes) (registry)

#define NVAL_I2S__SOURCE_INFO_VER		1				//Version of sourceFile netnode.
#define SOURCE_INFO_VERSION				4

#define NVAL_I2S__MAX_SOURCE_SIZE		2

#define	NSUP_I2S__NMSPATH				0	//nms file path

//-----------------------------------------------------------------------------
//Source netnode
//
//Contains sourceFile definitions(borders, names, offset in big source,...).
//
//netnode value = number of source files defined
//altvals (atag)= numberOfSourceFilesInSegment(index 0->seg.1, index 1->seg.2,...)
//supvals (stag)= sourceFilesInfo (sourceInfo_s) (index 0->file 1, index 1->file 2,...)
//
//NOTICE:
//Be careful sourceNetNode uses IDA's segment indexing and not how many i2s will create them.
//
netnode				sourceNetNode;
#define I2S_SOURCE_NETNODE_NAME			"@I2S_sourceFiles"

//-----------------------------------------------------------------------------
//PE header file section table.
//
//Contains executable section table datas(original name of the segment and
//raw data size). Data is written into peHeader_sectionTables_s structure.
//
//netnode value = number of sections defined
//supvals (stag)= sectionTables
netnode				sectionTablesNetNode;
#define I2S_SECTION_TABLES_NETNODE_NAME	"@I2S_sectionTables"

unsigned long SetSectionTableNetnode( void );

//-----------------------------------------------------------------------------
//SoftIce comunication.
	STATUS	GetSIceProtectedPath( char* pRetPath, size_t pathLength );
	STATUS	LoadNMSFile( NM32_HEADER* pNmsMapped, unsigned long fullFileSize );

	//Variable contains the softIce deviceIo path.
	char			sicePath[24];

//-----------------------------------------------------------------------------
//NMTP - NM types
//
	unsigned long	NMTP_UpdateNMTPStruct( unsigned long size );

	unsigned long	NMTP_SetArray( unsigned long elemType, unsigned long nElements, unsigned long lengthInBytes );
	unsigned long	NMTP_SetArglist( struc_t* pFrame, unsigned long argCount, unsigned long argOffset );
	unsigned long	NMTP_SetProcedure( func_t* pProcedure );
	unsigned long	NMTP_SetMember( member_t* pMember, unsigned long memberSize );
	unsigned long	NMTP_SetDerived( struc_t* pStructure, unsigned long structSize );
	unsigned long	NMTP_SetStructure( struc_t* pStructure, unsigned long structSize );
	NMTP_S			nmtp;
#define NMTP_DEFAULT_NEAR_LABEL			0x1000
#define NMTP_DEFAULT_LOCAL_PROCEDURE	0x1001

	//Get type
	unsigned long	GetType_flag(flags_t);			//supports (byte, word, dword, qword, float, double, packreal) (intended for arguments)
	unsigned long	GetType_ea(ea_t);					//supports all types (intended for DATA segment)
	unsigned long	GetType_member(member_t*,unsigned long);	//supports all types (intended for argument/lVariables (procedure frame))
	unsigned long	GetType_structureByName(char*);	//supports only structures/unions (intended for register pointers)

//-----------------------------------------------------------------------------
//STTB - String table section
//
	unsigned long	STTB_SetStringTable( char* );
	STTB_S			sttb;

//-----------------------------------------------------------------------------
//TYTB - Type tables
//and
//HSHT - Hash tables
	STATUS			Set_TYTB_HSHT( unsigned long type, char* pName, unsigned long iName);
	unsigned long	HSHT_GetHashNumber( char* name );
	unsigned long	HSHT_SetHashOffset( unsigned long hashNumber );

	TYTB_S			tytb;
	HSHT_S			hsht;

//-----------------------------------------------------------------------------
//SYMD - Symbol data
//
	STATUS	SYMD_AllocateMemory__SourceListing( unsigned long size );
	STATUS	SYMD_AllocateMemory__SEGMENT_DATA( void );
	STATUS	SYMD_AllocateMemory__SYMD( void );

	STATUS				SYMD_SetVLP( ea_t address, flags_t flags );
	STATUS				SYMD_SetProcedureVariables( func_t* pProcedure );
	SEGDATA_VLPTABLE*	SYMD_SetLocalStructMembers( struc_t* pStructure, char* pName, unsigned long structOffset, SEGDATA_VLPTABLE* pLocalVariables );

	//pointer to 1st segment(=>2.seg(=>3.seg(...))) ->tree structure
	SEGMENT_DATA*	pSegments;
	SEGMENT_DATA*	pSegmentCurrent;
	unsigned long	nSegmentsPresent;

//Procedures.
	STATUS			SYMD_GetNumberOfProcedureVariables( func_t* pProcedure,	unsigned long* pLVarCount, unsigned long* pArgCount, unsigned long* pArgFirstOffset	);
//	unsigned long	SYMD_GetProcedureArgCount( func_t* pProcedure );
	unsigned long	SYMD_GetProcedureArgCountAndFirstOffset( func_t* pProcedure, unsigned long* pOffsetArgFirst );
	unsigned long	SYMD_GetProcedureLVarCount( func_t* pProcedure );
	unsigned long	SYMD_GetProcedureSourceLines( func_t* pProcedure, unsigned long* pSourceListingSize );

//registers
	struct regType_s
	{
		unsigned long	regNumber;
		unsigned long	regType; //type of register TP_UCHAR,TP_USHORT,TP_ULONG,...
	};
	unsigned long	SYMD_GetRegisterType( char* pRegName, regType_s* pRegType );
	unsigned long	SYMD_GetRegisterVariablesData
	(
		func_t*		pProcedure,
		regvar_t*	pRegArray
	);

//Structures
	unsigned long	SYMD_GetStructureMemberCount( struc_t* pStructure );

//Source files definitions
	STATUS			CheckSourceFilesDatabase( void );
	STATUS			DefineSourceFilesNames( void );
	unsigned long	SYMD_GetSizeOfSourceListing( ea_t address );
	STATUS			SYMD_GetSizeOfSourceListingAndSaveSource( ea_t address, unsigned long* pSourceSize );
	STATUS			CreateSourceRelativePath( void );

	BOOL			currentSourceFileEnabled;
	BOOL			includeSource;	//same as I2S_FLAGS_INCLUDE_SOURCE
	unsigned long	minEA;	//First ea in segment (code normaly 401000).
							//Must be set for every area (check CreateNmsDatabase())
							//(If you're in code segment => codeStart=start of code segment;
							// if you're in data segment => codeStart=start of data segment)

	SOURCE_S		source;	//all enabled files source listing
	char			sourcePath[32];

//-----------------------------------------------------------------------------
//Sections
//
	STATUS	SetSection_NMTP( void );
	STATUS	SetSection_STTB( void );
	STATUS	SetSection_TYTB( void );
	STATUS	SetSection_HSHT( void );
	STATUS	SetSection_SYMD( void );
	STATUS	SetSection_NM32( void );

	SECTIONS_S		sections;

//-----------------------------------------------------------------------------
//Source files.
	void			SaveFiles( void );
	unsigned long	SaveSourceFiles(char*);
	void			SetSourceFilesBoundaries(void);
	void			ShowSourceFilesInfo(void);
};
extern ida2softice_c	i2s;

//*********************************************************************************************************************
//---------------------------------------------------------------------------------------------------------------------
//NMTrans
struct MODULE_INFO
{
	char*			pModuleName;
	NM32_HEADER*	pMappedFile;
	unsigned long	fileSize;
	char*			pSourceCode;
	unsigned long	sourceLength;
};
// pModuleName - Pointer to original module name. (from exe,..)
// pMappedFile - Pointer to mapped view of NMS file.
// fileSize - Size of NMS file.
// pSourceCode - Pointer to source files buffer.
//               NULL if source is in NMS file OR there is no source.
// sourceLength - Length of source files buffer.
//
//sourceCodeBuffer = All source files one after onother as they would be in NMS file.
//


//GetErrorMessage from SoftIce
struct GET_SOFTICE_ERROR
{
	unsigned long	number;	//don't ask me what or where and why (0xA1530003)
	char*			pErrorBuffer;
	unsigned long	bufferSize;
};
// number - Don't know what it means, but probably some internal SoftIce message.
// pErrorBuffer - This buffer will get the error message.

#pragma pack(pop)
#endif

