//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains all functions that are intended imports renaming.
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
//Sets append name for import section.
//
void ida2softice_c::Imports_initialize
(
	void
)
{
	char		currentChar;
	char		fileName[20];
	int			i;

//Clear fileName buffer.
	ZeroMemory( fileName, sizeof( fileName ) );

//Get the file name and convert all dots('.') and spaces (' ') to '_'.
	get_root_filename( fileName, sizeof( fileName ) );

	i = 0;
	currentChar = fileName[0];
	while ( currentChar != '\x0' )
	{
		if ( currentChar == '.' )
		{
			fileName[i]='_';
		}
		if ( currentChar == ' ' )
		{
			fileName[i]='_';
		}

	//Update.
		++i;
		currentChar = fileName[i];
	}

//Create imports append name and get it's length.
	qsnprintf( imports_appendName, sizeof( imports_appendName ), "__%s", (char*)&fileName );
	imports_appendNameLength = strlen( (char*)&imports_appendName );

	return;
}

//--------------------------------------------------------------------------
//Appends/deppens name to import function name.
//
// set - what to do (set / reset ).
//       IMPORTNAMES_SET - appends names
//       IMPORTNAMES_RESET - changes names back to original state
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS	ida2softice_c::Imports_renameNames
(
	unsigned long	set
)
{
	char*		appendNameLocation;
	ea_t		currentAddress;
	flags_t		flags;
	char		funcName[128 + sizeof( imports_appendName )];
	bool		nameRenamed;
	BOOL		newName;
	int			nSegments;
	segment_t*	pSegment;
	ea_t		segmentEnd;
	ea_t		xReference;

//Initialize.
//
//We'll set the real name at the offset of 1, so that if we'll fail to rename the
//import name, we'll try to rename it to "_xxxxxxxx", as this sometimes works then.
	funcName[0] = '_';
	funcName[1] = '\x0';

//Get import segment.
	nSegments = get_segm_qty();
	for ( int i = 0; i < nSegments; i++ )
	{
	//Get current segment.
		pSegment = getnseg(i);

	//Does current segment contain extern definitions? Is it an import segment?
		if ( pSegment->type == SEG_XTRN )
		{
		//Yes current segment cointains extern definitions.
		//
		//Find imports.
			currentAddress = pSegment->startEA;
			segmentEnd = pSegment->endEA;
			while( currentAddress < segmentEnd )
			{
			//Get address flags and check if it has a name -> "import name".
				flags = getFlags( currentAddress );
				if ( has_any_name( flags ) )
				{
				//Current address has an import name (ex.: GetModuleHandleA in .idata).
				//
				//Get the name.
					get_name( currentAddress, currentAddress, (char*)&funcName[1], 127 );

				//Construct the new name.
					appendNameLocation = &funcName[1] + strlen( (char*)&funcName[1] ) - imports_appendNameLength;

					newName = FALSE;
					if ( set == IMPORTNAMES_SET )
					{
					//Append the name.
					//
					//Check if there wasn't an error before and the appendName
					//is still appended to the name.
						if ( 0 != strcmp( appendNameLocation, (char*)&imports_appendName ) )
						{
						//The name is in original form -> append the name.
						//
						//GetModuleHandleA -> GetModuleHandleA__name_xxx
							qstrncat( (char*)&funcName[1], imports_appendName, sizeof( funcName ) - 1 );

							newName = TRUE;
						}
					}
					else
					{
					//Clear the appended name.
					//
					//Check if the appended name is present or not.
						if ( 0 == strcmp( appendNameLocation, (char*)&imports_appendName ) )
						{
						//The appended name is present -> remove it.
						//
						//GetModuleHandleA__name_xxx -> GetModuleHandleA
							appendNameLocation[0] = '\x0';

							newName = TRUE;
						}
					}

				//Rename the address.
					if ( newName == TRUE )
					{
						nameRenamed = set_name( currentAddress, (char*)&funcName[1] );
						if ( nameRenamed == false )
						{
						//Failed to rename.
						//
						//Sometimes it helps if you prepend an underscore.
						//(we already have underscore prepended)
							nameRenamed = set_name( currentAddress, (char*)&funcName );
							if ( nameRenamed == false )
							{
								msg( "I2S: Please rename the failed import name and then try again.\n" );
								return STATUS_FAILED;
							}
						}
					}

				//Rename the import references also, as sometimes those reference functions
				//have the same name as import function.
				//ex.:
				//import name = __imp_CloseHandle => reference procedure name = CloseHandle
				//
				//Does current import name have a reference?
					if ( hasRef( flags ) )
					{
					//Yes it has a reference.
					//
					//Get the address of the reference address.
						xReference = get_first_dref_to( currentAddress );

					//Is the reference address start of a function?
						if ( isFunc( getFlags( xReference ) ) )
						{
						//Yes it's a function -> rename it.
						//
						//Get function name.
							get_func_name( xReference, (char*)&funcName[1], 127 );

						//Construct the new name.
							appendNameLocation =
							  (char*)&funcName[1] + strlen( (char*)&funcName[1] ) - imports_appendNameLength;

							newName = FALSE;
							if ( set == IMPORTNAMES_SET )
							{
							//Append the name.
							//
							//Check if there wasn't an error before and the appendName
							//is still appended to the name.
								if ( 0 != strcmp( appendNameLocation, (char*)&imports_appendName ) )
								{
								//The name is in original form -> append the name.
								//
								//-> j_GetModuleHandleA -> j_GetModuleHandleA__name_xxx
									qstrncat( (char*)&funcName[1], imports_appendName, sizeof( funcName ) - 1 );

									newName = TRUE;
								}
							}
							else
							{
							//Clear the appended name.
							//
							//Check if the appended name is present or not.
								if ( 0 == strcmp( appendNameLocation, (char*)&imports_appendName) )
								{
								//The appended name is present -> remove it.
								//
								//->  j_GetModuleHandleA__name_xxx -> j_GetModuleHandleA
									appendNameLocation[0] = '\x0';

									newName = TRUE;
								}
							}

						//Rename the address.
							nameRenamed = set_name( xReference, (char*)&funcName[1] );
							if ( nameRenamed == false )
							{
							//Failed to rename.
							//
							//Sometimes it helps if you prepend an underscore.
							//(we already have underscore prepended)
								nameRenamed = set_name( xReference, (char*)&funcName );
								if ( nameRenamed == false )
								{
									msg( "I2S: Please rename the failed import reference name and then try again.\n" );
									return STATUS_FAILED;
								}
							}
						}
					}
				}

			//Update.
				currentAddress += get_item_size( currentAddress );
			}
		}
	}

	return STATUS_SUCCESS;
}
