//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains memory function.
//
//
#include "i2s.h"

//Allocate memory for source listing.
//
//return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::SYMD_AllocateMemory__SourceListing
(
	unsigned long	size
)
{
	HLOCAL	hTemp;

	hTemp = LocalAlloc( LHND, size );
	if ( hTemp == NULL )
	{
		msg( "I2S: Failed to allocate memory(SOURCE).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL == ( source.pSource = (char*)LocalLock( hTemp ) ) )
		{
			msg( "I2S: Failed to allocate memory(SOURCE).\n" );
			LocalFree( hTemp );
			return STATUS_FAILED;
		}
		else
		{
			source.hSource = hTemp;
		}
	}
	source.pSource_current = source.pSource;
	source.freeSource = size;
	source.sizeSource = size;

	return STATUS_SUCCESS;
}

//Allocate new SEGMENT_DATA structure and insert it into the
//segments tree.
//
//Check for old SEGMENT_DATA-s and sets new one.
//This procedure should be called when you want to set a new segment.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::SYMD_AllocateMemory__SEGMENT_DATA
(
	void
)
{
	SEGMENT_DATA*	pSegmentTemp;

//Alocate memory.
	pSegmentTemp = (SEGMENT_DATA*)LocalAlloc( LPTR, sizeof( SEGMENT_DATA ) );
	if ( pSegmentTemp == NULL )
	{
		msg( "I2S: Failed to allocate memory(SEGMENT_DATA).\n" );
		return STATUS_FAILED;
	}

//Insert the new data into the segment data tree.
	if ( pSegments == NULL )
	{
	//This is the first segment data struct.
		pSegments = pSegmentTemp;
	}
	else
	{
	//This is the n-th segment data struct.
		pSegmentTemp->pPrevious = pSegmentCurrent;
		pSegmentCurrent->pNext = pSegmentTemp;
	}
	pSegmentCurrent = pSegmentTemp;
	++nSegmentsPresent;

	return STATUS_SUCCESS;
}

//Allocate data of current SEGMENT_DATA structure.
//
//Before you call this procedure set all nXXXX variables.
//
// return - STATUS_FAILED/STATUS_SUCCESS
//
STATUS ida2softice_c::SYMD_AllocateMemory__SYMD
(
	void
)
{
	char*			pMemory;
	unsigned long	size_full;

//Calculate the size of all resources together.
//
//Note:
//We need to allocate 1 DWORD more as VLP offsets are set in advanced ->
//this means that i2s will set the VLP offset for the next VLP already at in current
//process. So if we wouldn't do this we would overwrite the system data that is
//written at the end of the data chunk.
	size_full =
	  pSegmentCurrent->nProcDefinitions * sizeof( SEGDATA_PROCEDURE_V2 )
	  +
	  pSegmentCurrent->nLocalVariables * sizeof( SEGDATA_VLPTABLE )
	  +
	  pSegmentCurrent->nRegisters * sizeof( SEGDATA_REGISTER )
	  +
	  pSegmentCurrent->nSourceLines * sizeof( SEGDATA_SOURCELINES )
	  +
	  pSegmentCurrent->nVLP * ( sizeof( SEGDATA_VLPTABLE ) + sizeof( unsigned long ) )
	  +
	  sizeof( unsigned long );
							
	if ( size_full == 0 )
	{
		return STATUS_SUCCESS;
	}

//Allocate memory.
	pMemory = (char*)LocalAlloc( LPTR, size_full );
	if ( pMemory == NULL )
	{
	//Failed.
		msg( "I2S: Failed to allocate memory(3).\n" );
		return STATUS_FAILED;
	}

//Set pointers...
	pSegmentCurrent->hMemory = (HLOCAL)pMemory;
	pSegmentCurrent->pEnd = pMemory + size_full;

	//..for procedure definitions.
	if ( pSegmentCurrent->nProcDefinitions != 0 )
	{
	    pSegmentCurrent->pProcDefinitions = (SEGDATA_PROCEDURE_V2*)pMemory;
		pSegmentCurrent->pProcDefinitions_current = (SEGDATA_PROCEDURE_V2*)pMemory;
	//Advance pointer.
		pMemory += pSegmentCurrent->nProcDefinitions * sizeof( SEGDATA_PROCEDURE_V2 );
	}

	//..for EBP based local variables (+arguments).
	if ( pSegmentCurrent->nLocalVariables != 0 )
	{
	    pSegmentCurrent->pLocalVariables = (SEGDATA_VLPTABLE*)pMemory;
		pSegmentCurrent->pLocalVariables_current = (SEGDATA_VLPTABLE*)pMemory;
	//Advance pointer.
		pMemory += pSegmentCurrent->nLocalVariables * sizeof( SEGDATA_VLPTABLE );
	}

	//..for renamed register.
	if ( pSegmentCurrent->nRegisters != 0 )
	{
	    pSegmentCurrent->pRegisters = (SEGDATA_REGISTER*) pMemory;
		pSegmentCurrent->pRegisters_current = (SEGDATA_REGISTER*) pMemory;
	//Advance pointer.
		pMemory += pSegmentCurrent->nRegisters * sizeof( SEGDATA_REGISTER );
	}

	//..for source lines tables.
	if ( pSegmentCurrent->nSourceLines != 0 )
	{
		pSegmentCurrent->pSourceLines = (SEGDATA_SOURCELINES*)pMemory;
		pSegmentCurrent->pSourceLines_current = (SEGDATA_SOURCELINES*)pMemory;
	//Advance pointer.
		pMemory += pSegmentCurrent->nSourceLines * sizeof( SEGDATA_SOURCELINES );
	}

	//..for VLP definitions.
	if ( pSegmentCurrent->nVLP != 0 )
	{
	    pSegmentCurrent->pVLP = (SEGDATA_VLPTABLE*)pMemory;
		pSegmentCurrent->pVLP_current = (SEGDATA_VLPTABLE*)pMemory;
	//Advance pointer.
		pMemory += pSegmentCurrent->nVLP * sizeof( SEGDATA_VLPTABLE );

	//..for VLP Offsets.
		pSegmentCurrent->pVLPOffsets = (unsigned long*)pMemory;
		pSegmentCurrent->pVLPOffsets_current = (unsigned long*)pMemory;
	//Advance pointer.
		//pMemory += pSegmentCurrent->nVLP * sizeof( unsigned long );
	}

	return STATUS_SUCCESS;
}

//Initialze memory for dinamic allocating memory parts.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::InitializeMemory_STTB
(
	void
)
{
	HLOCAL		hTemp;

//STTB
	if ( NULL == ( hTemp = LocalAlloc( LHND, ALLOCATE_BIG ) ) )
	{
		msg( "I2S: Failed to allocate memory(STTB).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL == ( sttb.pStrings = (char*)LocalLock( hTemp ) ) )
		{
			LocalFree( hTemp );
			msg( "I2S: Failed to allocate memory(STTB).\n" );
			return STATUS_FAILED;
		}
		else
		{
			sttb.hStrings = hTemp;
		}
	}
	//first byte in buffer is a zero string -> '\x0'
	sttb.pStrings_current = sttb.pStrings + 1;
	sttb.freeStrings = ALLOCATE_BIG - 1;
	sttb.sizeStrings = ALLOCATE_BIG;
	sttb.nStrings = 1;

	if ( NULL == ( hTemp = LocalAlloc( LHND, ALLOCATE_SMALL ) ) )
	{
		msg( "I2S: Failed to allocate memory(STTB).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL == ( sttb.pOffsets = (unsigned long*)LocalLock( hTemp ) ) )
		{
			LocalFree( hTemp );
			msg( "I2S: Failed to allocate memory(STTB).\n" );
			return STATUS_FAILED;
		}
		else
		{
			sttb.hOffsets = hTemp;
		}
	}
	//first byte in buffer is a zero string -> '\x0'
	sttb.pOffsets_current = sttb.pOffsets + 1;	//first offset is zero
	*sttb.pOffsets_current = 1;					//second offset is one (over null string)
	sttb.freeOffsets = ALLOCATE_SMALL - 2 * sizeof( unsigned long );
	sttb.sizeOffsets = ALLOCATE_SMALL;

	if ( NULL == ( hTemp = LocalAlloc( LHND, ALLOCATE_SMALL ) ) )
	{
		msg( "I2S: Failed to allocate memory(STTB).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL == ( sttb.pHash = (unsigned long*)LocalLock( hTemp ) ) )
		{
			LocalFree( hTemp );
			msg( "I2S: Failed to allocate memory(STTB).\n" );
			return STATUS_FAILED;
		}
		else
		{
			sttb.hHash = hTemp;
		}
	}
	sttb.pHash_current = sttb.pHash + 1;
	sttb.freeHash = ALLOCATE_SMALL - sizeof( unsigned long );
	sttb.sizeHash = ALLOCATE_SMALL;

	return STATUS_SUCCESS;
}

STATUS ida2softice_c::InitializeMemory
(
	void
)
{
	HLOCAL		hTemp;

//NMTP
	if ( NULL == ( hTemp = LocalAlloc( LHND, ALLOCATE_BIG ) ) )
	{
		msg( "I2S: Failed to allocate memory(NMTP).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL ==( nmtp.pTypesData =(unsigned char*)LocalLock( hTemp ) ) )
		{
			LocalFree( hTemp );
			msg( "I2S: Failed to allocate memory(NMTP).\n" );
			return STATUS_FAILED;
		}
		else
		{
			nmtp.hTypesData = hTemp;
		}
	}
	nmtp.pTypesData_current = nmtp.pTypesData;
	nmtp.freeData = ALLOCATE_BIG;
	nmtp.sizeData = ALLOCATE_BIG;
	nmtp.nTypes = 0;

	if ( NULL == ( hTemp = LocalAlloc( LHND, ALLOCATE_SMALL ) ) )
	{
		msg( "I2S: Failed to allocate memory(NMTP).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL == ( nmtp.pTypesOffsets = (unsigned long*)LocalLock( hTemp ) ) )
		{
			LocalFree( hTemp );
			msg( "I2S: Failed to allocate memory(NMTP).\n" );
			return STATUS_FAILED;
		}
		else
		{
			nmtp.hTypesOffsets = hTemp;
		}
	}
	nmtp.pTypesOffsets_current = nmtp.pTypesOffsets;
	nmtp.freeOffsets = ALLOCATE_SMALL;
	nmtp.sizeOffsets = ALLOCATE_SMALL;

//Set predefined NM types.
	unsigned char* pTypeData = nmtp.pTypesData;

	//Local label -> NMTP_DEFAULT_NEAR_LABEL(0x1000).
	( (DATAS_LF_LABEL*)pTypeData )->lf_index = TYPE_LF_LABEL;
	//( (DATAS_LF_LABEL*)pTypeData )->mode = LABEL_NEAR;
	pTypeData += sizeof( DATAS_LF_LABEL );

	//Local procedure -> NMTP_DEFAULT_LOCAL_PROCEDURE(0x1001).
	( (DATAS_LF_PROCEDURE*)pTypeData )->lf_index = TYPE_LF_PROCEDURE;
	//( (DATAS_LF_PROCEDURE*)pTypeData )->argList = 0;
	( (DATAS_LF_PROCEDURE*)pTypeData )->rType = TP_VOID;
	( (DATAS_LF_PROCEDURE*)pTypeData )->call = CALL_FAR_PASCAL;
	//( (DATAS_LF_PROCEDURE*)pTypeData )->argCount = 0;

	//Set offsets.
	//*( nmtp.pTypesOffsets + 0 ) = 0;
	*( nmtp.pTypesOffsets + 1 ) = sizeof( DATAS_LF_LABEL );

	//Update.
	nmtp.pTypesData_current =
	  nmtp.pTypesData + sizeof( DATAS_LF_LABEL ) + sizeof( DATAS_LF_PROCEDURE );
	nmtp.pTypesOffsets_current += 2;
	nmtp.nTypes = 2;

//TYTB
	if ( NULL == ( hTemp = LocalAlloc( LHND, ALLOCATE_BIG ) ) )
	{
		msg( "I2S: Failed to allocate memory(TYTB).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL == ( tytb.pTypeTables = (TYPETABLE*)LocalLock( hTemp ) ) )
		{
			LocalFree( hTemp );
			msg( "I2S: Failed to allocate memory(TYTB).\n" );
			return STATUS_FAILED;
		}
		else
		{
			tytb.hTypeTables = hTemp;
		}
	}
	tytb.pTypeTables_current = tytb.pTypeTables;
	tytb.freeTypeTables = ALLOCATE_BIG;
	tytb.sizeTypeTables = ALLOCATE_BIG;
	tytb.nTypeTables = 0;

//HASH
	if ( NULL == ( hTemp = LocalAlloc( LHND, ALLOCATE_BIG ) ) )
	{
		msg( "I2S: Failed to allocate memory(HASH).\n" );
		return STATUS_FAILED;
	}
	else
	{
		if ( NULL == ( hsht.pHashTables = (HSHT_TYPETABLE*)LocalLock( hTemp ) ) )
		{
			LocalFree( hTemp );
			msg( "I2S: Failed to allocate memory(HASH).\n" );
			return STATUS_FAILED;
		}
		else
		{
			hsht.hHashTables = hTemp;
		}
	}
	hsht.pHashTables_current = hsht.pHashTables;
	hsht.freeHashTables = ALLOCATE_BIG;
	hsht.sizeHashTables = ALLOCATE_BIG;
	hsht.nHashTables = 0;
	hsht.currentOffset = 1;
	ZeroMemory( &hsht.hashOffsets, sizeof( hsht.hashOffsets ) );

	return STATUS_SUCCESS;
}

//Reallocate dinamic memory.
//
// choice - REALLOCATE_REALLYBIG (4MB), REALLOCATE_BIG (256kB), REALLOCATE_SMALL (16kB)
// HLOCAL - Local memory handle.
// buffer - Pointer to pointer of the buffer.
// ....
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::ReallocateMemory
(
	unsigned long	size,
	HLOCAL			handle,
	void**			ppBuffer,
	void**			ppBuffer_current,
	unsigned long*	pFreeBuffer,
	unsigned long*	pSizeBuffer
)
{
//WALDEMAR
//Poglej, da je handle, ki ga vrne realloc res enak tistemu, ki ga damo not.
	unsigned long	offset;
	HLOCAL			handle_temp;
	char*			pBuffer_temp;

//Get the offset in current buffer. We'll need it later so that we'll move
//the ppBuffer_current to the right position.
	offset = *( (char**)ppBuffer_current ) - *( (char**)ppBuffer );

//Unlock the memory.
	if ( 0!= LocalUnlock( handle ) )
	{
	//Something seriously wrong -> the memory is locked number of times when it should
	//be only once.
		msg( "I2S: Failed to re-allocate memory (memory still locked).\n" );
		return STATUS_FAILED;
	}

//Reallocate the memory.
	handle_temp = LocalReAlloc( handle, *pSizeBuffer + size, LMEM_ZEROINIT | LMEM_MOVEABLE );
	//All ok?
	if ( handle_temp == NULL )
	{
	//Nope the reallocation failed.
	//
	//Lock memory back and return.
		*ppBuffer = LocalLock( handle );
		msg( "I2S: Failed to re-allocate memory (could not re-allocate).\n" );
		return STATUS_FAILED;
	}

//Update.
	pBuffer_temp = (char*)LocalLock( handle_temp );
	*ppBuffer = (void*)pBuffer_temp;
	*( (char**)ppBuffer_current ) = pBuffer_temp + offset;
	*pFreeBuffer += size;
	*pSizeBuffer += size;

	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Frees all the memory that was allocated in the program.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
void ida2softice_c::FreeMemory(void)
{
//Free allocated memory.
//
//sections
	if ( sections.pNms != NULL )
	{
		LocalFree( sections.pNms );
		sections.pNms = NULL;
	}
	sections.fullFileSize = 0;
	if ( sections.pNmtp != NULL )
	{
		LocalFree( sections.pNmtp );
		sections.pNmtp = NULL;
	}
	if ( sections.pSttb != NULL )
	{
		LocalFree( sections.pSttb );
		sections.pSttb = NULL;
	}
	if ( sections.pTytb != NULL )
	{
		LocalFree( sections.pTytb );
		sections.pTytb = NULL;
	}
	if ( sections.pHsht != NULL )
	{
		LocalFree( sections.pHsht );
		sections.pHsht = NULL;
	}
	if ( sections.pSymd != NULL )
	{
		LocalFree( sections.pSymd );
		sections.pSymd = NULL;
	}

//Segment data.
	while( pSegments != NULL )
	{
	//Free segment allocated memory.
		if ( pSegments->hMemory != NULL )
		{
			LocalFree( pSegments->hMemory );
		}

	//Free segment.
		pSegmentCurrent = pSegments->pNext;
		LocalFree( pSegments );
		pSegments = pSegmentCurrent;
		--nSegmentsPresent;
	}
//HASH
	if ( hsht.hHashTables != NULL )
	{
		LocalFree( hsht.hHashTables );
		hsht.hHashTables = NULL;
	}
//TYTB
	if ( tytb.hTypeTables != NULL )
	{
		LocalFree( tytb.hTypeTables );
		tytb.hTypeTables = NULL;
	}
//STTB
	if ( sttb.hStrings != NULL )
	{
		LocalFree( sttb.hStrings );
		sttb.hStrings = NULL;
	}
	if ( sttb.hOffsets != NULL )
	{
		LocalFree( sttb.hOffsets );
		sttb.hOffsets = NULL;
	}
	if ( sttb.hHash != NULL )
	{
		LocalFree( sttb.hHash );
		sttb.hHash = NULL;
	}
//NMTP
	if ( nmtp.hTypesData != NULL )
	{
		LocalFree( nmtp.hTypesData );
		nmtp.hTypesData = NULL;
	}
	if ( nmtp.hTypesOffsets != NULL )
	{
		LocalFree( nmtp.hTypesOffsets );
		nmtp.hTypesOffsets = NULL;
	}

//Source
	if ( source.hSource != NULL )
	{
		LocalFree( source.hSource );
		source.hSource = NULL;
	}

	return;
}
