//   NM32 File data arrangement (NMS file from SIce)
//   NM32 File includes every wish you would have. :)
//        version: 0.16
//
//   NOTICE!
//   All names represented abridgements like NMDR, ...
//   are my (that means, that they are my logical representatives of Numega's ones).
//
//   This text and all attributes in it were tested on ASM and some C/C++ programs,
//   so for everything else it doesn't have to be this way.
//   Questions to: mostekaccess@mailcity.com
//
//   BEFORE you mail me:
//   Look into 'Borland_subSectionTypes.txt' for additional explanations.
//   If you don't find the answer, than check the net(normally newer versions of this text
//   will first appear on Tsehp 'Fravia's Page of Reverse Engineering'),
//   if even then your question won't be answered mail me.
//
//   Peace
//   Mostek
//

//Changes from in:
// 1.16   - Small changes to FPD section.
// 1.15   - Update in NMS database update -> old version of Softice aren't supported anymore.
//          ( SEGDATA_PROCEDURE updated )
//        - Some variables were renamed.
// 1.14   - Source Files Definition is not part of variablesData.
//          It's a subSection on it's own.
//        - Meaning of SEGMENTDATA_HEADER.subSectionLength is changed because of this.

#ifndef _NM32_
#define _NM32_
#pragma pack(push, 1)

//***********************************************************************************************************
//***********************************************************************************************************
//***********************************************************************************************************
//***********************************************************************************************************
//   NM32 file structure
//
//   -----------------------
//   |NM32 Header          |
//   -----------------------
//   |debug info           |
//   |...                  |
//   -----------------------
//   |NMDR                 |
//   -----------------------
//   |sourceCode (optional)|
//   -----------------------
//
//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   NM32 Header:
//
//   offset  data     name
//   0       ULONG    NM32(ASCII)
//   4       ULONG    verMajor(10)
//   8       ULONG    verMinor 1(old SoftIce), 2 (new version of SoftIce)
//   C       ULONG    offNMDR
//   10      ULONG    creationTime
//   14      ULONG    creationFlags
//   18      ULONG    fileType
//   1C      ULONG    fileLength
//   20    8*ULONG    NULL
//   40      *        filePath (104h bytes)
//   144     *        copyrightString (100h bytes)
//   244              (End of NM32 Header)
//
struct NM32_HEADER
{
	unsigned long	NM32;
	unsigned long	verMajor;	//I think version MAJOR
	unsigned long	verMinor;	//        version MINOR
	unsigned long	offNMDR;
	unsigned long	creationTime;
	unsigned long	creationFlags;
	unsigned long	fileType;
	unsigned long	fileLength;
	unsigned long	N1;
	unsigned long	N2;
	unsigned long	N3;
	unsigned long	N4;
	unsigned long	N5;
	unsigned long	N6;
	unsigned long	N7;
	unsigned long	N8;
	char			filePath[0x104];	//MAX_PATH
	char			copyrightString[0x100];
};

#define	NM32s		0x32334D4E
#define copyright	"NM32 Symbol Format - (C) Copyright Numega Technologies, 1996-2004. All Rights Reserved.  DataBase created with Ida2SoftIce plugin."
#define NM32_DATABASE_MAJOR_VERSION		0x10
#define NM32_DATABASE_MINOR_VERSION		0x02

//   verMajor - Major version of the NM32 file. This file is made for verMajor=10.
//   verMinor - Minor version of the NM32 file. This file is made for verMinor=1.
//   offNMDR - Offset in file to NM debug record.
//   creationTime - function: Time(NULL)
//   ---------------------------------------------------------------------
//   creationFlags:
//             -translate:    1000         *Public Only Checked
//                            2000         *Type Information Only Checked
//                            4000         *Symbols only (Includes locals and structures) Checked
//                            8000-Default *Symbols and Source code Checked
//                           10000         *Include source in NMS file Checked
//
//             -load:    1 *Load Only Symbol Information Checked
//                       2 *Load Executable Checked (Load Only Symbol Information Unchecked)
//                       4 *Load Executable As Debug Process Checked (Disabled)
//
//             -ini:     000-Default *Ignore DLL Loads Checked (Diasbled)
//                       100         *Load Exports For DLLs Checked (Disabled)
//                       200         *Load Symbols For DLLs Checked (Disabled)
//
//             -button:  10 *Stop at WinMain Checked
//                       40 *Prompt For Missing Code UnChecked
//          
//             The number is made by ORing master and minor choises (one of every group
//             (execept in translate where you can select 'Include source in NMS...' button too)).
#define	CN_T_PUBLICONLY		0x001000
#define	CN_T_TYPEONLY		0x002000
#define	CN_T_SYMBOLSONLY	0x004000
#define	CN_T_SYMBOLS_SOURCE	0x008000
#define	CN_T_INCLUDESOURCE	0x010000
//
#define	CN_L_SYBOLSONLY		0x01
#define	CN_L_EXECUTABLE		0x02
//#define	CN_L_EXECUTABLED	0x04
//
#define	CN_I_IGNOREDLL		0x0000
//#define	CN_I_DLLEXPORTS		0x0100
//#define	CN_I_DLLSYMBOLS		0x0200
//
#define	CN_B_STOPATWINMAIN	0x010
#define	CN_B_PROMPTFORCODE	0x040


//   ---------------------------------------------------------------------
//   filetype - Type of file loaded(converted) file.
//              *2h-PE_EXE
//              *4h-PE_DLL
//              *6h-LE_VXD
//              *7h-NE			//this one is not tested yet
//              *Ah-NMS
//              *Bh-map->sym->nms
//              *Dh-tds (TurboDebug symbols) <- could be the same type for other debug files too, but currently I know only for this one
//              *Eh-LX
//              *
//              *There are others,but I don't think they would make any use in this text.
#define	FT_PEEXE	0x02
#define	FT_PEDLL	0x04
#define	FT_LEVXD	0x06
#define FT_NE		0x07
#define	FT_NMS		0x0A
#define	FT_MAP		0x0B
#define FT_TDS      0x0D
#define	FT_LX		0x0E

//   ---------------------------------------------------------------------
//   fileLength - Length of *.NMS file (without appended source).
//   filePath - Path to module(*.exe, *.dll, ...).
//
//   copyrightString - 'NM32 Symbol Format - (C) Copyright Numega Technologies, 1996-1997. All Rights Reserved'
//                     *(If *.NMS file will be created with IDA plugin ' IDA2NMS plugin version:x.xx' text will be added.)

//   ***********************************************************************************************************
//   ***********************************************************************************************************
//   NMDR (NM debug record)
//
//   NMDR_header:
//   offset  data     name
//   0       ULONG    NMDR(ASCII)
//   4       ULONG    cNMDE
//   8       ULONG    offGTYP
//   C       ULONG    offSTTB
//   10      ULONG    offSYMD
//   14      ULONG    offSRCP
//   18      ULONG    offFPOD
//   1C    7*ULONG    NULL
//
//   nNMDE - count of NMDEs (NMDE - NM debug entry)
//   offGTYP - Offset in file to GTYP.
//   offSTTB - Offset in file to STTB.
//   offSYMD - Offset in file to SYMD.
//   offSRCP - Offset in file to SRCP.
//   offFPOD - Offset in file to FPOD.
struct	NMDR_HEADER
{
	unsigned long	NMDR;
	unsigned long	nNMDE;
	unsigned long	offGTYP;
	unsigned long	offSTTB;
	unsigned long	offSYMD;
	unsigned long	offSRCP;
	unsigned long	offFPOD;
	unsigned long	N1;
	unsigned long	N2;
	unsigned long	N3;
	unsigned long	N4;
	unsigned long	N5;
	unsigned long	N6;
	unsigned long	N7;
};
#define	NMDRs	0x52444D4E

//   ---------------------------------------------------------------------
//   NMDE (NM debug entry)
//   It's right after NMDR_header.
//
//   offset  data     name
//   0       ULONG    NMDE(ASCII)
//   4       ULONG    entryIndex
//   8       ULONG    offEntry
//   C       ULONG    entryLength
//   10    5*ULONG    NULL
//
//   entryIndex - Type of entry.
//                *(Sequence of types are as they appear in NMDR. 
//                  You MUST obey this sequence or SoftIce will fail.)
//                *NMTP - 3
//                *STTB - 2
//                *TYTB - 4
//                *HSHT - 5
//                *SYMD - 6
//                *FPOD - 8
//                *SRCP - 7
//                *GTYP - 1
//   offEntry - Offset in file to entry.
//   entryLength - Length of entry.
struct	NMDE_S
{
	unsigned long	NMDE;
	unsigned long	entryIndex;
	unsigned long	offEntry;
	unsigned long	entryLength;
	unsigned long	N1;
	unsigned long	N2;
	unsigned long	N3;
	unsigned long	N4;
	unsigned long	N5;
};
#define	NMDEs	0x45444D4E

#define INDEX_GTYP 1
#define INDEX_STTB 2
#define INDEX_NMTP 3
#define INDEX_TYTB 4
#define INDEX_HSHT 5
#define INDEX_SYMD 6
#define INDEX_SRCP 7
#define INDEX_FPOD 8

//   ---------------------------------------------------------------------
//   NRDS (NM record source)
//   (NMDR finishes with this string.)
//   After this text we can add source code files
//   (one after another without any bytes inbetween).
//
//   offset  data     name
//   0       ULONG    NRDS(ASCII)
//   4       *        sourceCode (optional)
//
//   CAUTION!
//   File MUST finish on dword boundary.
#define	NRDSs	0x5344524E

//   ***********************************************************************************************************
//   ***********************************************************************************************************
//   ***********************************************************************************************************
//   NMTP (NM types)
//
//   -----------------------
//   |NMTP Header          |
//   -----------------------
//   |Offset to Types Data |
//   -----------------------
//   |Types Data           |
//   -----------------------
//
//   NMTP_header:
//   offset    data      name
//   0         ULONG     NMTP(ASCII)
//   4         ULONG     sectionLength
//   8         ULONG     nTypes
//   C       2*ULONG     NULL
//
//   nTypes - Number of types defined in this section.
struct NMTP_HEADER
{
	unsigned long	NMTP;
	unsigned long	sectionLength;
	unsigned long	nTypes;
	unsigned long	N1;
	unsigned long	N2;
};
#define NMTPs 0x50544D4E 


//   ---------------------------------------------------------------------
//   Offset to Types Data:
//   offset      data      name
//   0    nTypes*ULONG     offType
//
//   offType - Are offsets from begining of the 'Types Data' subsection.
//             (So the first offType is 0.)

//   ---------------------------------------------------------------------
//   Types Data:
//   TypeData section is a series of consecutive types structures.
//   First type has type index of 1000h, next 1001h, ....
//   Indexes are counted in NMS file and are NOT the same as in original file debug section.
//
//   offset    data      name
//   0         ULONG     type1Number (index:1000h)
//   4         *         type1Data
//   *         ULONG     type2Number (index:1001h)
//   *         ULONG     type2Data
//   ...
//
//   typeNumber - Type leaf number. Look into 'Type Strings Explained.txt' .
//
//
//   Types currently defined:
//   name                  SIce type string number
//   LF_ARRAY            = 1003h
//   LF_STRUCT(5h)       = 1005h
//   TYPE_LF_UNION       = 1006h
//   LF_PROCEDURE(8h)    = 8h
//   LF_LABEL(Eh)        = Eh
//
//   LF_ARGLIST(201h)    = 2201h
//   TYPE_LF_DERIVED     = 2204h
//
//   LF_MEMBER(406h)     = 1406h
#define TYPE_LF_ARRAY		0x1003		//type SoftIce LF_ARRAY
#define TYPE_LF_STRUCT		0x1005
#define TYPE_LF_UNION		0x1006
#define TYPE_LF_PROCEDURE	0x8
#define TYPE_LF_LABEL		0xE

#define TYPE_LF_ARGLIST		0x2201
#define TYPE_LF_DERIVED		0x2204

#define TYPE_LF_MEMBER		0x1406


//   ------------------------------------------------
//   Array:
//   offset    data      name
//   0         ULONG     1003h ("LF_ARRAY"=3h)
//   4         ULONG     elemType		//for strings T_UCHAR, it can be one of NMTP types too
//   8         ULONG     NULL
//   C         SHORT     NULL
//   E         ULONG     length
//   12        ULONG     indexType		//normaly T_ULONG
//   16        ULONG     NULL
//   1A        ULONG     nElements
//   1E        SHORT     NULL
//
//   elemType - Type index of each array element (look into 'Primitive Type Listing.txt').
//   length - Length of array in bytes.
//   indexType - Type index of indexing variable (look into 'Primitive Type Listing.txt').
//   nElements - Number of elements in array. (For strings this value is the same as length.)
//
//example for 3 dimensional array:
//
//unsigned long testArray[3][5][7];
//  DATAS_LF_ARRAY (type: 0x4472) (offset: 0x75F7C) -> the [7] part
//    type         name             value
//    ULONG        lf_index         0x1003(TYPE_LF_ARRAY)
//    ULONG        elemType         0x22(unsigned long)
//    ULONG        N1               0x0
//    USHORT       N2               0x0
//    ULONG        length           28 bytes
//    ULONG        indexType        0x21(unsigned short)
//    ULONG        N3               0x0
//    ULONG        nElements        7
//    USHORT       N4               0x0
//
//  DATAS_LF_ARRAY (type: 0x4473) (offset: 0x75F9C) -> the [5][7] part
//    type         name             value
//    ULONG        lf_index         0x1003(TYPE_LF_ARRAY)
//    ULONG        elemType         0x4472(unknown type - it can be one of NM types)
//    ULONG        N1               0x0
//    USHORT       N2               0x0
//    ULONG        length           140 bytes
//    ULONG        indexType        0x21(unsigned short)
//    ULONG        N3               0x0
//    ULONG        nElements        0
//    USHORT       N4               0x0
//
//  DATAS_LF_ARRAY (type: 0x4474) (offset: 0x75FBC) -> the [3][5][7] part
//    type         name             value
//    ULONG        lf_index         0x1003(TYPE_LF_ARRAY)
//    ULONG        elemType         0x4473(unknown type - it can be one of NM types)
//    ULONG        N1               0x0
//    USHORT       N2               0x0
//    ULONG        length           420 bytes
//    ULONG        indexType        0x21(unsigned short)
//    ULONG        N3               0x0
//    ULONG        nElements        0
//    USHORT       N4               0x0
//
struct DATAS_LF_ARRAY
{
	unsigned long	lf_index;
	unsigned long	elemType;
	unsigned long	N1;
	unsigned short	N2;
	unsigned long	length;
	unsigned long	indexType;
	unsigned long	N3;
	unsigned long	nElements;
	unsigned short	N4;
};


//   ------------------------------------------------
//   Struct:
//   For member definition use LF_DERIVED.
//
//   offset    data      name
//   0         ULONG     1005h ("LF_STRUCT"=5h)
//   4         ULONG     derivedType
//   8         ULONG     iName
//   C         SHORT     property+reserved byte
//   E         ULONG     cFields
//   12        ULONG     length
//   16        ULONG     NULL
//   1A        ULONG     NULL
//   1E        SHORT     NULL
//
//   derivedType - Type record that specifies all of the classes that are directly derived
//                 from the class that references this type record.
//                 (used for struct members too)
//   iName - Index name in STTB.
//   ----------------------
//   property - Property bit field. (+ reserved byte)
//   Boolean: 0(No)/1(Yes)
//
//   offset(bit)    size   name
//   0(1.bit)       1bit   packed
//   1(2.bit)       1bit   ctor
//   2(3.bit)       1bit   overops
//   3(4.bit)       1bit   isnested
//   4(5.bit)       1bit   cnested
//   5(6.bit)       1bit   opassign
//   6(7.bit)       1bit   opcast
//   7(8.bit)       1bit   fwref
//
//   packed - Structure is packed.
//   ctor - Class has constructors and/or destructors.
//   overops - Class has overloaded operators.
//   isnested - Class is a nested class.
//   cnested - Class contains nested classes.
//   opassign - Class has overloaded assignment.
//   opcast - Class has casting methods.
//   fwdref - Class/structure is a forward (incomplete) reference.
//   ----------------------
//   nFields - Number of elements in the structure.
//   length - length of structure.
struct DATAS_LF_STRUCT
{
	unsigned long	lf_index;
	unsigned long	derivedType;
	unsigned long	iName;
	unsigned short	property;
	unsigned long	nFields;
	unsigned long	length;
	unsigned long	N1;
	unsigned long	N2;
	unsigned short	N3;
};
#define PROPERTY_NULL		0x00
#define PROPERTY_PACKED		0x01
#define PROPERTY_CTOR		0x02
#define PROPERTY_OVEROPS	0x04
#define PROPERTY_ISNESTED	0x08
#define PROPERTY_CNESTED	0x10
#define PROPERTY_OPASSIGN	0x20
#define PROPERTY_OPCAST		0x40
#define PROPERTY_FWREF		0x80

//   ------------------------------------------------
//   Union:
//   Same as LF_STRUCT except that all members have offset 0.

//   ------------------------------------------------
//   Procedure:
//   offset    data      name
//   0         ULONG     8h (LF_PROCEDURE)
//   4         ULONG     argList
//   8         ULONG     rType
//   C         ULONG     call
//   10        ULONG     argCount
//
//
//   argList - Type index of argument list type record.
//   rType -  Type index of the value returned by the procedure.
//            (Look into 'Primitive Type Listing.txt'.)
//   ----------------------
//   call - Calling convention of the procedure.
//   0    Near C (arguments pushed right to left, caller pops arguments)
//   1    Far C
//   2    Near pascal  (arguments pushed left to right, callee pops arguments)
//   3    Far pascal
//   4    Near fastcall
//   5    Far fastcall
//   6    PCode
//   7    Near stdcall
//   8    Far stdcall
//   9    Near syscall
//   10   Far syscall
//   11   This call
//   12   MIPS call
//   13   Generic
//   14-255    Reserved
//   Borland supports from 0 to 10 (with 10).
//   Borland:- if bit 40h is set => Variable args (don't ask me what this means)
//           - if bit 80h is set => Fast This
//   ----------------------
//   argCount - Number of arguments passed to procedure.
struct DATAS_LF_PROCEDURE
{
	unsigned long	lf_index;
	unsigned long	argList;
	unsigned long	rType;
	unsigned long	call;
	unsigned long	argCount;
};

enum calling
{
	CALL_NEAR_C,
	CALL_FAR_C,
	CALL_NEAR_PASCAL,
	CALL_FAR_PASCAL,
	CALL_NEAR_FASTCALL,
	CALL_FAR_FASTCALL,
	CALL_PCODE,
	CALL_NEAR_STDCALL,
	CALL_FAR_STDCALL,
	CALL_NEAR_SYSCALL,
	CALL_FAR_SYSCALL,
	CALL_THIS,
	CALL_MIPS,
	CALL_GENERIC,
};

//   ------------------------------------------------
//   Label:
//   offset    data      name
//   0         ULONG     Eh (LF_LABEL)
//   4         ULONG     mode
//
//   mode - Addressing mode of the label
//          (0 NEAR label)
//          (4 FAR label)
//
//   Normaly NEAR and FAR label types are the first ones in NMTP.
struct DATAS_LF_LABEL
{
	unsigned long	lf_index;
	unsigned long	mode;
};
#define LABEL_NEAR	0x0
#define LABEL_FAR	0X4


//   ------------------------------------------------
//   Arglist:
//   offset       data      name
//   0            ULONG     2201h ("LF_ARGLIST"=201h)
//   4            ULONG     NULL
//   8            ULONG     argCount
//   C   argCount*ULONG     type
//
//
//   argCount - Count of number of indices in list.
//   type - Type index of each array element (look into 'Primitive Type Listing.txt').
struct DATAS_LF_ARGLIST
{
	unsigned long	lf_index;
	unsigned long	N1;
	unsigned long	nTypes;
};

//   ------------------------------------------------
//   Derived Classes(in nms file used for structure members too):
//   This type record specifies all of the classes that are directly derived
//   from the class that references this type record.
//
//   offset       data      name
//   0            ULONG     2204h ("LF_DERIVED"=204h)
//   4            ULONG     NULL
//   8            ULONG     nTypes
//   C      cType*ULONG     type
//
//   nTypes - Number of types in the list.
//   type - Type indices of the classes that directly inherit from the class that
//          references this type record.(in nms file: member types)
//
struct DATAS_LF_DERIVED
{
	unsigned long	lf_index;
	unsigned long	N1;
	unsigned long	nTypes;
};

//   ------------------------------------------------
//   Member:
//   This leaf specifies nonstatic data members of a structure/class.
//   It must be defined in front of structure.
//
//   offset    data      name
//   0         ULONG     1406h ("LF_MEMBER"=406h)
//   4         ULONG     indexType
//   8         ULONG     iName
//   C         SHORT     access
//   E         SHORT     offset
//   10        ULONG     NULL //probably browserOffset
//
//   indexType - Type index of "LF_MEMBER" in "LF_FIELDLIST" (look into 'Primitive Type Listing.txt').
//               If member is an array of bytes than you must set an array type.
//   iName - Index name of indexType in STTB.
//   ----------------------------------------
//   access - ?(Normally none.(TASM))
//   0 none
//   1 private
//   2 protected
//   3 public
//   ----------------------------------------
//   offset - Offset of member(variable) in struct.
//   browserOffset - ?
struct DATAS_LF_MEMBER
{
	unsigned long	lf_index;
	unsigned long	indexType;
	unsigned long	iName;
	unsigned short	access;
	unsigned short	offset;
	unsigned long	N1;
}; 
#define ACCESS_NONE 0
#define ACCESS_PRIVATE 1
#define ACCESS_PROTECTED 2
#define ACCESS_PUBLIC 3


//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   STTB (String table)
//
//   ------------------------
//   |STTB Header           |
//   ------------------------
//   |Offsets               |
//   ------------------------
//   |String (Names Section)|
//   ------------------------
//
//
//   STTB_header
//   offset     data     name
//   0          ULONG    STTB(ASCII)
//   4          ULONG    sectionLength
//   8          ULONG    nNames (+ 1)
//   C        2*ULONG    NULL
//
//   sectionLength - Length of STTB section.
//   nNames - Number of names(string).
//            * (+1)=>it's because zero string(just one zero byte) at the begining
struct STTB_HEADER
{
	unsigned long	STTB;
	unsigned long	sectionLength;
	unsigned long	nNames;
	unsigned long	N1;
	unsigned long	N2;
};
#define STTBs		0x42545453

//   ---------------------------------------------------------------------
//   Offsets to strings:
//   14         ULONG    NULL     |
//   18  cNames*ULONG    offNames | =>offsets to names (NULL at the begining is for iName=NULL)
//
//   offNames - Offsets of names in namesSubSection(first name starts with offset of 1h).
//   *          BYTE     0h				;zero ended string '\x0'
//   *          *        namesSection	;"1st" string
//
//   namesSection - All names with zero ended.
//                 (Section ends with so many zeros that next section
//                  starts on DWORD boundary.)
//
//
//
//

											  
//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   TYTB (Type table)
//   This section defines typeDefs, structs and global procedures.
//   Same types are defined in HSHT too.
//
//   ------------------------
//   |TYTB Header           |
//   ------------------------
//   |Type Tables           |
//   ------------------------
//
//   TYTB_header:
//   offset    data      name
//   0         ULONG     TYTB(ASCII)
//   4         ULONG     sectionLength
//   8         ULONG     nTypes
//   C         ULONG     offTypeTables
//   10      2*ULONG     NULL
//
//   nTypes - Number of types defined in this section.
//   offTypeTables - Offset from start of file to 'Type Tables'.
struct TYTB_HEADER
{
	unsigned long	TYTB;
	unsigned long	sectionLength;
	unsigned long	nTypes;
	unsigned long	offTypeTables;
	unsigned long	N1;
	unsigned long	N2;
};
#define TYTBs		0x42545954

//
//
//   TypeTable:
//   offset    data      name
//   0         ULONG     type
//   4         ULONG     iName
//
//   type - This is the type of typeDef(ex. ULONG) or struct or global procedure.
//   iName - Index name in STTB of typeDef or structure or global procedure.
struct	TYPETABLE
{
	unsigned long	type;
	unsigned long	iName;
};


//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   HSHT (Hash table)
//   This section defines typeDefs, structs and global procedures.
//   Same types are defined in TYTB too.
// 
//   ------------------------
//   |HSHT Header           |
//   ------------------------
//   |Offsets               |
//   ------------------------
//   |Hash tables           |
//   ------------------------
//
//
//   HSHT_header:
//   offset    data      name
//   0         ULONG     HSHT(ASCII)
//   4         ULONG     sectionLength
//   8         ULONG     sizeTableTOffsets
//   C         ULONG     nTypes
//   10        ULONG     offTableOffsets
//   14        ULONG     offTypeTables
//   18      2*DWORD     NULL
//
//   nTypes - Number of types included in this section.
//   sizeTableOffsets - Size of 'HSHT Type Table Offsets section' in DWORDs (25h normaly);
//   offTablesOffsets - Offset to "HSHT Type Table Offsets section" in file.
//   offTypeTables - Offset to "HSHT Type Tables section" in file.
struct HSHT_HEADER
{
	unsigned long	HSHT;
	unsigned long	sectionLength;
	unsigned long	sizeTableOffsets;
	unsigned long	nTypes;
	unsigned long	offTableOffsets;
	unsigned long	offTypeTables;
	unsigned long	N1;
	unsigned long	N2;
};
#define HSHTs		0x54485348

//   ---------------------------------------------------------------------
//   HSHT Type Table Offsets section:
//   offset    data      name
//   0         ULONG     x
//   4         ULONG     x
//   8         ULONG     x
//   C         ULONG     x
//   10        ULONG     x
//   14        ULONG     x
//   18        ULONG     x
//   1C        ULONG     x
//   20        ULONG     x
//   24        ULONG     x
//   28        ULONG     x
//   2C        ULONG     x
//   30        ULONG     x
//   34        ULONG     x
//   38        ULONG     x
//   3C        ULONG     x
//   40        ULONG     x
//   44        ULONG     x
//   48        ULONG     x
//   4C        ULONG     x
//   50        ULONG     x
//   54        ULONG     x
//   58        ULONG     x
//   5C        ULONG     x
//   60        ULONG     x
//   64        ULONG     x
//   68        ULONG     x
//   6C        ULONG     x
//   70        ULONG     x
//   74        ULONG     x
//   78        ULONG     x
//   7C        ULONG     x
//   80        ULONG     x
//   84        ULONG     x
//   88        ULONG     x
//   8C        ULONG     x
//   90        ULONG     x
//
//   x - (Offset to specificied HSHTTypeTable + 1) from begining of HSHT Type Tables..
//        *How to get variable offset:
//        *
//        *hashNumber/25h => remainder*4=offset in "HSHT Type Table Offset section"
//        *
//        *25h=size of HSHTTypeTablesOffsets section DWORDs.

//   ---------------------------------------------------------------------
//   HSHT Type Table section:
//
//   TypeTable:
//   offset    data      name
//   0         ULONG     offPreviousTable
//   4         ULONG     hashNumber
//   8         ULONG     iNameType
//   C         ULONG     type
//   10        ULONG     NULL
//
//   offPreviousTable - Offset from begining of "HSHT Type Tables section" + 1 to
//                      previous TypeTable that had same variable in
//                      "HSHT Type Table Offsets section".
//   ------------------------------------------------
//   hashNumber - It's created from string in STTB(iNameType).
//        *This is the code:
//        *
//        *    mov     esi, pToString_InSTTB
//        *    xor     edx, edx
//        *    mov     ecx, stringLength
//        *    shr     ecx, 2
//        *    jecxz   @LessThan4Letters
//        *@Loop1:
//        *    lodsd
//        *    and     eax, 0DFDFDFDFh       ;to big letters
//        *    xor     edx, eax
//        *    rol     edx, 4
//        *    loop    @Loop1
//        *
//        *@LessThan4Letters:
//        *    mov     ecx, stringLength
//        *    and     ecx, 3
//        *    jecxz   @NoLettersLeft
//        *    xor     eax, eax
//        *    add     esi, ecx
//        *    dec     esi
//        *    std
//        *
//        *@Loop2:
//        *    lodsb
//        *    and     al, 0DFh
//        *    shl     eax, 8
//        *    loop    @Loop2
//        *    cld
//        *    xor     edx, eax
//        *
//        *@NoLettersLeft:
//        *    mov     eax, edx
//   ------------------------------------------------
//   iName - Index name in STTB of typeDef or structure or global procedure.
//   type - This is the type of typeDef(ex. ULONG) or struct or global procedure.
struct HSHT_TYPETABLE
{
	unsigned long	offPreviousTable;
	unsigned long	hashNumber;
	unsigned long	iName;
	unsigned long	type;
	unsigned long	N1;
};

//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   SYMD (Symbol data)
//
//   This segment must finish on DWORD boundary, so you must add 0 bytes at the end.
//
//   -----------------------
//   |SYMD Header          |
//   ----------------------- 
//   |SegmentData Header   | |
//   - - - - - - - - - - - - |
//   |SegmentData          | |
//   |...                  | |- subSection
//   ----------------------- |
//   |VariablesData        | |
//   |...                  | |
//   ----------------------- 
//   |Source Files Def.    | 
//   -----------------------
//
//   SegmentData:
//   -----------------------
//   |1. SegmentData table |
//   -----------------------
//   |2. SegmentData table |
//   -----------------------
//   | ....                |
//   -----------------------
//
//   VariableData(seg1):
//   -------------------------------
//   |Procedures Def.              |
//   -------------------------------
//   |LocalVariables Def.          |
//   -------------------------------
//   |RegisterVariables Def.       |
//   -------------------------------
//   |SourceCode Line Offsets  Def.|
//   -------------------------------
//   |Source Sections Def.         |
//   -------------------------------
//   |Variable/Label/Procedure     |
//   |Offsets in Program Def.      |
//   -------------------------------
//
//   VariableData(seg2):
//   -------------------------------
//   |Procedures Def.              |
//   -------------------------------
//   |LocalVariables Def.          |
//   -------------------------------
//   |RegisterVariables Def.       |
//   -------------------------------
//   |SourceCode Line Offsets  Def.|
//   -------------------------------
//   |Source Sections Def.         |
//   -------------------------------
//   |Variable/Label/Procedure     |
//   |Offsets in Program Def.      |
//   -------------------------------
//   .
//   .
//   .
//
//
//   ------------------------------------------------------------------------------
//   SYMD_header:
//   offset    data     name
//   0         ULONG    SYMD(ASCII)
//   4         ULONG    sectionLength
//   8         ULONG    offSegmentData_header
//   C       8*ULONG    NULL
//
//   sectionLength - Length of whole section (NULL bytes at the end are included).
//   offSegmentData_header - Offset in file to SegmentData_header.
struct SYMD_HEADER
{
	unsigned long	SYMD;
	unsigned long	sectionLength;
	unsigned long	offSegmentData_header;
	unsigned long	N1;
	unsigned long	N2;
	unsigned long	N3;
	unsigned long	N4;
	unsigned long	N5;
	unsigned long	N6;
	unsigned long	N7;
	unsigned long	N8;
};
#define SYMDs		0x444D5953

//   ------------------------------------------------------------------------------
//   SegmentData_header(subsection):
//   0         ULONG    subSectionLength
//   4         ULONG    nSourceFiles
//   8         ULONG    nSegments
//   C         *        segmentData
//
//   subSectionLength - This is length of whole segment data.
//                      If you add this number to SegmentData_header offset in
//                      file you will come to Source Files Definition.
//   nSourceFiles - Number of files that contribute to source code.
//   nSegments - Number of segments that are present in SYMD.
//               *NOTICE!
//               *Ex. We have 3 segments. In first two, we have some definitions
//				 *(labels/variables/whatever), but not in 3rd one,
//               *then only first two will be in SYMD. BUT if we have something
//               *defined only in third one, then we must include all 3 segments
//               *(but first two will have everything zero(well almost).
struct SEGMENTDATA_HEADER
{
	unsigned long	subSectionLength;
	unsigned long	nSourceFiles;
	unsigned long	nSegments;
};

//   ------------------------------------------------------------------------------
//   SegmentData Table:
//   0         SHORT    nSeg
//   2         ULONG    iNameSegment
//   6         ULONG    NULL
//   A         ULONG    physSize
//   E         ULONG    offProcDef
//   12        ULONG    cProcedures
//   16        ULONG    offLVarDef
//   1A        ULONG    offRegDef
//   1E        ULONG    offVLPDef
//   22        ULONG    cVLP
//   26        ULONG    offVLPOffsets
//   2A        ULONG    offSourceSDef
//   2E        ULONG    cSourceSec
//   32        ULONG    offSCLineDef
//
//   nSeg - Segment number. (Normaly 1-CODE, 2-DATA)
//   iName - Index name in STTB of this segment.
//   physSize - Size of the segment in the program.
//             (If you make a PE header dump you'll see this numbers quite clearly.)
//
//   offProcDef - Offset to Procedures Definitions from start of it's SegmentData Table.
//   nProcedure - Number of procedures defined in Procedures Definitions.
//
//   offLVarDef - Offset to LocalVariables Definition from start of it's SegmentData Table.
//   offRegDef - Offset to RegisterVariables Definition from start of it's SegmentData table.
//
//   offVLPDef - Offset to Variable/Label/Procedure tables from start of it's SegmentData Table.
//   nVLP - Number of Variables/Labels/Procedures in
//          Variable/Label/Procedure Offset Definitions section.
//          Notice:
//          If there aren't any in this segment, than this number is -1.
//   offVLPOffsets - Offset to VLP_Tables offsets from start of it's SegmentData Table.
//
//   offSourceSDef - Offset to Source Sections Definition from start of it's SegmentData Table.
//   nSourceSec - Number of Source Section Tables in Source Sections Definition.
//
//   offSCLineDef - Offset to 'SourceCode Line Offset Definition' from start of it's
//                  SegmentData Table.
//
//   Notice!
//   If some offset variable don't have it's section than they point to the first
//   usefull section.(Probably we could just leave them at 0 and nothing would be wrong.)
struct SEGMENTDATA
{
	unsigned short	nSeg;
	unsigned long	iName;
	unsigned long	N1;
	unsigned long	physSize;
	unsigned long	offProcDef;
	unsigned long	nProcedures;
	unsigned long	offLVarDef;
	unsigned long	offRegDef;
	unsigned long	offVLPDef;
	unsigned long	nVLP;
	unsigned long	offVLPOffsets;
	unsigned long	offSourceSDef;
	unsigned long	nSourceSec;
	unsigned long	offSCLineDef;
};

//   ------------------------------------------------------------------------------
//   variablesData:
//
//   -------------------------------
//   |Procedures Def.              |
//   -------------------------------
//   |LocalVariables Def.          |  <=you can get number of them from procedures def. (sum)
//   -------------------------------
//   |Register Variables           |
//   -------------------------------
//   |SourceCode Line Offsets  Def.|
//   -------------------------------
//   |Source Sections Def.         |
//   -------------------------------
//   |Variable/Label/Procedure     |
//   |Offsets Def.                 |
//   -------------------------------
//

//   ------------------------------------------------
//   Procedures Definitions:
//   This section defines ALL procedures in the program.
//   (Notice: There are minor differences between verMinor 1 and 2.)
//
//offset    data      name
//   0         ULONG     offStartProc
//   4         ULONG     offEndProc
//   8         ULONG     offLocalVariables
//   C         ULONG     nLocalVariables
//   10        ULONG     offRegisterVariables
//   14        ULONG     sizeRegisterVariables
//   18        ULONG     -1
//   1C        ULONG     N1
//
//   offStartProc - Offset in CODE segment to beginning of the procedure.
//   offEndProc - Offset in CODE segment to the last byte/opcode in the procedure.
//                If procedure has only 1 command, then offEndProc is sizeof(opcode)-1.
//                If procedure has many commands,  then offEndProc is offset to the last command in procedure.
//                Notice:
//                Probably if we would set offset to last command + sizeof( command ) -1 it would be good to.
//						
//   offLocalVariables - Offset to procedure local variables in
//                       LocalVariables Definition section.
//   nLocalVariables - Number of local variables.
//                    (Variables push-ed before calling the procedure are defined as local too.)
//   offRegisterVariables - Offset to procedure register variables in
//                          RegisterVariables Definition section.
//   sizeRegisterVariables - numberOfRegisterVariables*size(SEGDATA_REGISTER) .
//   -1 - This value is used for nested procedures, but I couldn't figure it out
//        what it means -> it's like an offset to something, but I don't know what.
//        I would have to reverse the Loader32 again to figure this out, but I don't have any time.
//        Well for normal procedure this is '-1' so who cares.
//
//   Notice!
//   'Local sections' from Main:
//	 to the first PROC definiton must have their own 'PROC' definition. (ONLY IN ASM)
//   *ex.
//   *Main:
//   *	call GetModuleHandle, NULL
//   *	jmp	@JumpSetOne
//   *	nop
//   *@JumpSetOne:
//   *	call	GetOnly, offset Only, offset NextData
//   *	call	ExitProcess, NULL
//   *
//   *GetOnly PROC pOnly:POINTER, pNextData:POINTER
//   *...
//   *
//   *1.section: from Main: -> @JumpSetOne:
//   *2.section: from @JumpSetOne -> GetOnly PROC ...
//   *
struct SEGDATA_PROCEDURE_V1
{
	unsigned long	offStartProc;
	unsigned long	offEndProc;
	unsigned long	offLocalVariables;
	unsigned long	nLocalVariables;
	unsigned long	offRegisterVariables;
	unsigned long	sizeRegisterVariables;
	unsigned long	M1;
};
struct SEGDATA_PROCEDURE_V2
{
	unsigned long	offStartProc;
	unsigned long	offEndProc;
	unsigned long	offLocalVariables;
	unsigned long	nLocalVariables;
	unsigned long	offRegisterVariables;
	unsigned long	sizeRegisterVariables;
	unsigned long	M1;
	unsigned long	N1;
};

//   ------------------------------------------------
//   LocalVariables Definition:
//   This section defines ALL local variables.
//   Variables push-ed before calling the procedure are defined as local too.
//
//   Local variable table:
//   offset    data      name
//   0         SHORT     10h  => probably size of structure
//   2         SHORT     1h   => Procedure Local Variable (look in VLP section for more details)
//   4         ULONG     type
//   8         ULONG     iNameLocal
//   C         ULONG     offLocal
//
//   type -  Type of variable.
//   iNameLocal - Index name in STTB.
//   offLocal - Signed offset relative to EBP(- for localy defined, + for pushed).
//
//   Structure is defined in VLP section. (struct SEGDATA_VLPTABLE)

//   ------------------------------------------------
//   RegisterVariables Definition:
//   This section defines ALL procedure register variables.
//
//   Register variable table:
//   offset    data      name
//   0         SHORT     size (12h)
//   2         SHORT     tableType
//   4         ULONG     type
//   8         ULONG     iNameRegister
//   C         ULONG     parameterOffset
//   10        ULONG     registerNumber
//
//   tableType - Is it value(TT_REGISTER) or a pointer(TT_REGISTER_POINTER).
//   type -  Type of variable. (Check 'Variable/Label/Procedure Offset Definitions' below.)
//   iName - Index name in STTB.
//   parameterOffset - If the register is the parameter this value should be 0.
//                     If register is a pointer to a parameter than this is the
//					   offset from that pointer
//                     (this can be used for 'this' based variables).
//
//   register - The register index enumeration is specific to the processor model for
//              the module.
//
struct SEGDATA_REGISTER
{
	unsigned short		size; 
	unsigned short      tableType;
	unsigned long       type;
	unsigned long       iName;
	unsigned long	    parameterOffset;
	unsigned short      registerNumber;
};

// Intel 80x86/80x87 Architectures Register Numbers
#define REGISTER_NONE		0
	//8-bit registers
#define REGISTER_AL			1
#define REGISTER_CL			2
#define REGISTER_DL			3
#define REGISTER_BL			4
#define REGISTER_AH			5
#define REGISTER_CH			6
#define REGISTER_DH			7
#define REGISTER_BH			8
	//16-bit registers
#define REGISTER_AX			9
#define REGISTER_CX			10
#define REGISTER_DX			11
#define REGISTER_BX			12
#define REGISTER_SP			13
#define REGISTER_BP			14
#define REGISTER_SI			15
#define REGISTER_DI			16
	//32-bit registers
#define REGISTER_EAX		17
#define REGISTER_ECX		18
#define REGISTER_EDX		19
#define REGISTER_EBX		20
#define REGISTER_ESP		21
#define REGISTER_EBP		22
#define REGISTER_ESI		23
#define REGISTER_EDI		24
	//Segment registers
#define REGISTER_ES			25
#define REGISTER_CS			26
#define REGISTER_SS			27
#define REGISTER_DS			28
#define REGISTER_FS			29
#define REGISTER_GS			30
	//Special cases
#define REGISTER_IP			31
#define REGISTER_FLAGS		32
#define REGISTER_EIP		33
#define REGISTER_EFLAGS		34
	//PCODE Registers
#define REGISTER_TEMP		40
#define REGISTER_TEMPH		41
#define REGISTER_QUOTE		42
//43-47    Reserved
	//System Registers
#define REGISTER_CR0		80
#define REGISTER_CR1		81
#define REGISTER_CR2		82
#define REGISTER_CR3		83
#define REGISTER_DR0		90
#define REGISTER_DR1		91
#define REGISTER_DR2		92
#define REGISTER_DR3		93
#define REGISTER_DR4		94
#define REGISTER_DR5		95
#define REGISTER_DR6		96
#define REGISTER_DR7		97
	//Register extensions for 80x87
#define REGISTER_ST0		128
#define REGISTER_ST1		129
#define REGISTER_ST2		130
#define REGISTER_ST3		131
#define REGISTER_ST4		132
#define REGISTER_ST5		133
#define REGISTER_ST6		134
#define REGISTER_ST7		135
#define REGISTER_CONTROL	136
#define REGISTER_STATUS		137
#define REGISTER_TAG		138
#define REGISTER_FPIP		139
#define REGISTER_FPCS		140
#define REGISTER_FPDO		141
#define REGISTER_FPDS		142
#define REGISTER_ISEM		143
#define REGISTER_FPEIP		144
#define REGISTER_FPEDO		145

//   ------------------------------------------------
//   SourceCode Line Offset Definition:
//   This section defines ALL commands that are present in a program.
//   It doesn't matter if your program has multiple source files, when
//   program is assembled source CODEs are one behind another.
//
//   Source Line Table:
//   offset    data      name
//   0         ULONG     offInCode
//   4         ULONG     lineNumber
//
//   offInCode - Offset in CODE segment of specific command.
//   lineNumber - Line number where command begins.
//
//   *ex.
//   *
//   *offsetInCode  lineNumber
//   * 0             10  |
//   * 7             11  |
//   * 9             12  |
//   * A             13  | -> first file with source CODE
//   * B             15  |
//   * 1A            16  |
//   * 1F            17  |
//   * 29            18  /
//   * 2A            C   |
//   * 2B            D   |
//   * 3A            E   |
//   * 41            F   | -> second file with source CODE
//   * 48            10  |
//   * 4B            11  |
//   * 4D            12  /
//
//   For more detailed explanation read sstSrcModule in 'Borland_subSectionTypes.txt'
//
//   !!(This sections is only present if nProcedures is not zero.)
struct SEGDATA_SOURCELINES
{
	unsigned long	offInCode;
	unsigned long	lineNumber;
};

//   ------------------------------------------------
//   Source Sections Definition:
//   This section defines ALL sections in CODE segment.
//   Every CODE section can be one source file.
//
//   Source Section Table:
//   offset    data      name
//   0         ULONG     offStartSourceSection
//   4         ULONG     offEndSourceSection
//   8         ULONG     offSourceLine
//   C         ULONG     nLinesTables
//   10        ULONG     offInSFDef
//
//   offStart - Offset in CODE segment to beginning of source section
//              (offset where the current source file starts in current CODE segment).
//   offEnd - Offset in CODE segment to ending of source section.
//            (offset where the current source file ends in current CODE segment).
//   offSourceLines - Offset in segments's source line tables in
//                   'SourceCode Line Offsets Definition'.
//                   Offset to start of current source file source lines
//                   (0 offset = start of 'SourceCode Line Offsets Definition').
//   nLineTables - Number of source line tables.
//   offInSFDef - Offset in sections sourceFiles table in 'Source Files Definitions'.
//
//   NOTICE!
//   MAX lines per file = 64319 (or maybe it's file size aprox. 3Mb)
//                        or probably 65536 = 2^16
//
struct SEGDATA_SOURCESECTION
{
	unsigned long	offStart;
	unsigned long	offEnd;
	unsigned long	offSourceLines;
	unsigned long	nLineTables;
	unsigned long	offInSFDef;
};

//   ------------------------------------------------
//   Variable/Label/Procedure Offset Definitions:
//
//   --------------------------------
//   |1.Seg Var.././.. Tables       |
//   --------------------------------
//   |1.Seg offsets to VLP Tables   |
//   --------------------------------
//
//   Variable/Label/Procedure Table:
//   offset    data      name
//   0         SHORT     size (10h)
//   2         SHORT     tableType
//   4         ULONG     type
//   8         ULONG     iName
//   C         ULONG     offVLP
//
//   tableType - Defines table type.
//               *1 Procedure Local Variable (used in 'Local variable table')
//               *2 Procedure Register variable (use only with SEGDATA_REGISTER)
//               *4 Label
//               *5 Variable
//               *6 Global Variable
//               *7 Local Procedure
//               *8 Global Procedure
//               *9 Import Descriptor (Don't take me for my word with this one.)
//   type - Defines Var.././.. type.
//          For local procedure this one defines an empty ARGLIST type (in NM Types).
//          For global procedure this one defines ARGLIST type (in NM Types)
//          appropriate to the number and type of pushed variables.
//
//   iName - Index name in STTB of Variable or Label or Procedure.
//   offVLP - Offset in segment.
//
struct SEGDATA_VLPTABLE
{
	unsigned short	size;
	unsigned short	tableType;
	unsigned long	type;
	unsigned long	iName;
	unsigned long	offVLP;
};
#define TT_LOCALV				0x1
#define TT_REGISTER				0x2
#define TT_REGISTER_POINTER		0x3	//register is used as pointer and not as variable
#define TT_LABEL				0x4
#define TT_VARIABLE				0x5
#define TT_GLOBALV				0x6
#define TT_LOCALP				0x7
#define TT_GLOBALP				0x8
#define TT_IMPORTD				0x9

//   VLP offsets:
//   offset    data      name
//   0         ULONG     offToVLPTable1
//   4         ULONG     offToVLPTable2
//   *         ULONG     *
//
//   offToVLPTableX - Offset to VLP table from start of VLP section.
//                    So 0 means at the beginning of VLP section.
//
//   There are nVLP offsets!
//
//
//   Well when loader32 makes nms file this number are mixed
//   (otVLPT4, ..1, ..8, or whatever).
//   So I didn't find any pattern in those numbers.
//   In IDA2NMS this numbers will be from offToVLPTable1 forward.


//   ------------------------------------------------------------------------------
//   Source Files Definitions:
//   This section defines ALL files with source code.
//
//   sourceFiles Table:
//   offset    data      name
//   0         ULONG     iName
//   4         ULONG     offSource
//   8         ULONG     sourceLength
//   C         ULONG     NULL
//   10        ULONG     NULL
//
//
//   iName - Index name in STTB of source file.
//           Notice:
//           The name can be a path to source file also.
//           example:
//           If there is a code in header file, the name really be a path to the header file.
//
//   offSource - Because all files with source code are put together to one big text section.
//               This offset defines where in this big text section current
//				 file starts.
//
//               NOTICE:
//               Only if your source is included in NMS file, else it's 0.
//
//   sourceLength - Length of source code file.
//
//               NOTICE:
//               Only if your source is included in NMS file, else it's 0.
struct SEGDATA_SOURCEFILE
{
	unsigned long	iName;
	unsigned long	offSource;
	unsigned long	sourceLength;
	unsigned long	N1;
	unsigned long	N2;
};


//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   FPOD
//
//   -----------------------
//   |Header               |
//   -----------------------
//   |Tables               |
//   -----------------------
//
//   FPOD_header:
//   offset  data     name
//   0       ULONG    FPOD(ASCII)
//   4       ULONG    sectionLength
//   8       ULONG    nTables
//   C       ULONG    offTables
//   10    8*ULONG    NULL
//
//   sectionLength - Length of FPOD section.
//   nTables - Number of tables in the section.
//   offTables - Offset to tables in nms file.
//
struct FPOD_HEADER
{
	unsigned long	FPOD;
	unsigned long	sectionLength;
	unsigned long	nTables; //number of tables in this section
	unsigned long	offTables;	//offsetToTables
	unsigned long	N1;
	unsigned long	N2;
	unsigned long	N3;
	unsigned long	N4;
	unsigned long	N5;
	unsigned long	N6;
	unsigned long	N7;
	unsigned long	N8;
};
#define FPODs		0x444F5046

//Tables:
//Don't have a clue what were those numbers.
//
//The layout goes something like this:

//   offset    data      name
//   0         ULONG     offset to something 
//   4         ULONG     size of the section at the offset
//   8         ULONG     looks like some kind of 'nXXX' value  ????
//   C         ULONG     looks like some kind of 'flags' parameter   ????

//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   SRCP (Source copy)
//
//   SRCP_header:
//   offset  data     name
//   0       ULONG    SRCP(ASCII)
//   4       ULONG    sectionLength
//   8       ULONG    offSourceFiles
//   C     2*ULONG    NULL
//
//   sectionLength - Length of SRCP section.
//   offSourceLength - Offset in file to source code files. They are one after another
//                     without any free byte.
//                     If source files are not in nms file than this one is 0.
//
//   NOTICE!
//   Because file must finish on DWORD boundary you must add zeros at the end of
//   source code text.
struct SRCP_HEADER
{
	unsigned long	SRCP;
	unsigned long	sectionLength;
	unsigned long	offSourceFiles;
	unsigned long	N1;
	unsigned long	N2;
};
#define SRCPs		0x50435253

//   -----------------------------------------------------------------------------------------------------------
//   -----------------------------------------------------------------------------------------------------------
//   GTYP (Global types)
//
//   GTYP_header:
//   offset  data     name
//   0       ULONG    GTYP(ASCII)
//   4       ULONG    sectionLength
//   8       ULONG    offNMTP
//   C       ULONG    offSTTB
//   10      ULONG    offTYTB
//   14      ULONG    offHSHT
//   18    2*ULONG    NULL
//
//   sectionLength - Length of GTYP section.
//   offNMTP - Offset in file to NMTP.
//   offSTTB - Offset in file to STTB.
//   offTYTB - Offset in file to TYTB.
//   offHSHT - Offset in file to HSHT.
struct GTYP_HEADER
{
	unsigned long	GTYP;
	unsigned long	sectionLength;
	unsigned long	offNMTP;
	unsigned long	offSTTB;
	unsigned long	offTYTB;
	unsigned long	offHSHT;
	unsigned long	N1;
	unsigned long	N2;
};
#define GTYPs		0x50595447

#pragma pack(pop)
#endif	//_NM32_
