//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains function for ProgressBar window.
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
// Function creates progressBar.
//
//As progressBar can't be a child window anymore(it looks that Delphi
//doesn't like that -> the pBar is not showen) I've created it like this.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS progressBar_c::CreateProgressBar( void )
{
	RECT	mainWindowRect;

//Initialize common controls.
	InitCommonControls();

//Get IDA's main window handle and get it's size.
	GetWindowRect( hwnd_mainWindow, &mainWindowRect );

//Create progressBar window.
	hwnd_progressBar = CreateWindowEx(
	  WS_EX_TOOLWINDOW,
	  PROGRESS_CLASS,
	  NULL,
	  WS_VISIBLE,
	  mainWindowRect.left,
	  mainWindowRect.top,
	  mainWindowRect.right - mainWindowRect.left,
	  mainWindowRect.bottom - mainWindowRect.top,
	  hwnd_mainWindow,
	  0,
	  GetModuleHandle( NULL ),
	  0
	);
	if ( hwnd_progressBar == NULL )
	{
	//Stop I2S until IDA restarts.
		plugInFlags |= PLUGIN_RUNNING;
		msg( "I2S: Failed to initialize progressBar.\n" );
		return STATUS_FAILED;
	}
	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Function showes or hides progressBar.
//
void progressBar_c::DestroyProgressBar( void )
{
//First hide progressBar so that IDA will get the focus and then destroy the window.
	ShowWindow( hwnd_progressBar, SW_HIDE );
	SetActiveWindow( hwnd_mainWindow );
	DestroyWindow( hwnd_progressBar );

	return;
}

//--------------------------------------------------------------------------
//This function initializes progressBar.
//
void progressBar_c::Initialize( void )
{
	ssize_t			ret;

	ea_t			currentAddress;
	int				nSegments;
	func_t*			pProcedure;
	segment_t*		pSegment;
	unsigned long	segmentEnd;

	unsigned long	commandLinesPresent;
	unsigned long	indexInSourceNetNodeSupVal = 0;
	sourceInfo_s*	pSourceInfo = NULL;
	sourceInfo_s	sourceInfo;

	RECT			waitWindowRect;
	long			waitWindowHeight;
	long			waitWindowWidth;

//Show progress bar.
//
//Get number of shown addresses(commands) in IDA's disassembly.
	nLines = 0;
	nSegments = get_segm_qty();
	for ( int i = 0; i < nSegments; i++ )
	{
		pSegment = getnseg( i );

		currentAddress = pSegment->startEA;
		segmentEnd = pSegment->endEA;
		commandLinesPresent = FALSE;

	//Get the 1st source file in segment.
		ret = i2s.sourceNetNode.supval( indexInSourceNetNodeSupVal, &sourceInfo, sizeof( sourceInfo ), stag );
		if ( ret == -1 )
		{
		//Doesn't exist... -> set the flag.
			pSourceInfo = NULL;
		}
		else
		{
		//Exist... -> set the flag.
			pSourceInfo = &sourceInfo;
		}

	//Start analysing -> check every "byte" in the segment.
		while ( currentAddress < segmentEnd )
		{
		//Increase number of lines.
			++nLines;

		//Do we have to change sourceFile?
		//
		//Some info:
		//If there are DATA segments before first CODE IDA listing will be 'prepended'
		//to 1st source file.
		//
		//Every DATA segments listing will be appended to 'last' source file.
		//
			//Are we still in source file boundaries?
			if ( currentAddress > sourceInfo.endEA )
			{
			//We are over the boundary -> update the current sourceFile info
			//and switch to new one.

			//Check if only DATA segments remained.
			//
			//Notice:
			//DATA segments will be updated at the end of segment loop.
			//
				//Was the source file info defined?
				if ( pSourceInfo != NULL )
				{
				//Yes source file info was defined.
				//
				//Update variables.
					++indexInSourceNetNodeSupVal;

				//Get next source file info.
					ret = i2s.sourceNetNode.supval( indexInSourceNetNodeSupVal, &sourceInfo, sizeof( sourceInfo ), stag );
					if ( ret == -1 )
					{
					//Doesn't exist... -> set the flag.
						pSourceInfo = NULL;
					}
					else
					{
					//Exist... -> set the flag.
						pSourceInfo = &sourceInfo;
					}
				}
			}

		//Are symbols enabled in current file?
			if ( sourceInfo.enable_symbols == FALSE )
			{
			//No symbols are not enabled -> skip file.
			//
			//But be careful if current source file is the last one.
				if ( currentAddress < sourceInfo.endEA )
				{
					currentAddress = sourceInfo.endEA + 1;
					continue;
				}
			}

		//Update.
			flags_t	flags = getFlags( currentAddress );
			if ( isCode( flags ) )
			{
				commandLinesPresent = TRUE;
			}

		//Get next address.
			if ( isFunc( flags ) )
			{
				pProcedure = get_func( currentAddress );
				if ( ( pProcedure->flags & FUNC_HIDDEN ) != 0 )
				{
				//Function is hidden -> represent as only 1 line ->
				//jump to the end of the function.
					currentAddress = pProcedure->endEA;
					continue;
				}
			}

		//Update.
			currentAddress += get_item_size( currentAddress );
		}

	//Did this segment have any code in it
		if ( commandLinesPresent == TRUE )
		{
		//Yes current segment had code lines.
		//
		//Update variables.
			++indexInSourceNetNodeSupVal;

		//Set next sourceInfo.
		//
		//Well this will happen at beginning of segment FOR loop.
		}
	}

//Reset position bar.
	currentLine = 0;
	//The next line the progressBar will get updated.
	nextLine = nLines/100;
	position = 0;	//from 0..100
	SendMessage( hwnd_progressBar, PBM_SETRANGE, 0, MAKELPARAM(0,100) );
	SendMessage( hwnd_progressBar, PBM_SETSTEP, (WPARAM) 1, 0);
	SendMessage( hwnd_progressBar, PBM_SETPOS, (WPARAM) 0, 0 );

//Get 'Please wait...' window size and resize progressBar.
	GetWindowRect( hWnd_pleaseWait, &waitWindowRect );
	waitWindowHeight = waitWindowRect.bottom - waitWindowRect.top;
	waitWindowWidth = waitWindowRect.right - waitWindowRect.left;

	MoveWindow(
	  hwnd_progressBar,
	  waitWindowRect.left,
	  waitWindowRect.bottom - 20,
	  waitWindowWidth,
	  45,
	  TRUE
	);
	return;
}

//--------------------------------------------------------------------------
//This function sets the position. It should be called on every new address.
//
void progressBar_c::SetPosition(void)
{
//Do we have to update the progressbar?
	if ( currentLine >= nextLine )
	{
	//Yes we have to -> update and calculate the new nextLine.
		//Update.
		++position;
		SendMessage( hwnd_progressBar, PBM_SETPOS, (WPARAM)( position ), 0 );

		//nextLine
		nextLine = ( ( position + 1 ) * nLines )/100;
	}

//Increse the number of lines we have already done.
	++currentLine;
	return;
}
//--------------------------------------------------------------------------
//This function resets the position to 0.
//
void progressBar_c::ResetPosition(void)
{
//Reset class variables.
	currentLine = 0;
	//The next line the progressBar will get updated.
	nextLine = nLines/100;
	position = 0;	//from 0..100

//Reset window position.
	SendMessage( hwnd_progressBar, PBM_SETPOS, (WPARAM) 0, 0 );
	return;
}



