//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains procedure that deal with registry.
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
//Get ida2sice registry handle.
//
// openedKey -Identifies a currently open key or any of the following predefined reserved handle values (check win32.hlp)
// path - Path to the subkey.
// type - If 0 than registry KEY will be created if doesn't exist.
//        If 1 than registry KEY will be opened. If the KEY is not present in registry than function returns STATUS_FAILED.
// return - HKEY or STATUS_FAILED.
//
//NOTICE:
//Close the handle as soon as posible. Get the values and close it!!
HKEY GetRegistryKey
(
	HKEY			openedKey,
	char*			pPath,
	unsigned long	access,
	unsigned long	type
)
{
	unsigned long	Status;

	HKEY			handle;
	unsigned long	disposition;

	if ( type == I2S_REG_TYPE_CREATE )
	{
	//Open/Create key.
		Status = RegCreateKeyEx(
		  openedKey,
		  pPath,
		  0,
		  "\x0",
		  REG_OPTION_NON_VOLATILE,
		  access,
		  NULL,
		  &handle,
		  &disposition
		);
		if ( Status == ERROR_SUCCESS )
		{
			return handle;
		}
	}
	else
	{
	//Just open key.
		Status = RegOpenKeyEx( openedKey, pPath, 0, access, &handle );
		if ( Status == ERROR_SUCCESS )
		{
			return handle;
		}
	}

	return STATUS_FAILED;
}

//--------------------------------------------------------------------------
//Close ida2sice registry handle.  -> DEFINED IN registry.h
//
//
// return - ErrorCode.
//inline unsigned long CloseRegistryKey(HKEY handle)
//{
//	return( RegCloseKey(handle) );
//}


//--------------------------------------------------------------------------
//Get registry value -> DEFINED IN registry.h
//
// subKey - Opened subkey.
// value - pointer to name of value to query
// buffer - pointer to buffer that will get the value
// bufferSize - size of buffer that will get the value
//
// return - ErrorCode.
//unsigned long GetRegistryValue(HKEY subKey, char* value, char* buffer, unsigned long bufferSize)
//{
//	return(RegQueryValueEx( subKey, value, NULL, NULL, (uchar*)buffer, &bufferSize) )
//}

//--------------------------------------------------------------------------
//Set registry value -> DEFINED IN registry.h
//
// subKey - Opened subkey.
// value - pointer to name of value to query
// buffer - pointer to buffer that will get the value
// bufferSize - size of buffer that will get the value
//
// return - ErrorCode.
//inline unsigned long SetRegistryValue(HKEY subKey, char* value, unsigned long type, char* buffer, unsigned long bufferSize)
//{
//	return (RegSetValueEx( subKey, value, 0, type, (uchar*)buffer, bufferSize) );
//}
