//  IDA to SoftIce and NMTrans common definitions
//
//  Author: Mostek
//   mail:  mostekaccess@mailcity.com
#ifndef _I2S__REGISTRY
#define _I2S__REGISTRY
#pragma pack(push, 1)

//-----------------------------------------------------------------------------
//Global functions
extern HKEY GetRegistryKey(HKEY, char*, unsigned long,unsigned long);
#define I2S_REG_TYPE_CREATE	0
#define I2S_REG_TYPE_OPEN	1
inline unsigned long CloseRegistryKey(HKEY handle)
{
	return( RegCloseKey(handle) );
}
inline unsigned long GetRegistryValue(HKEY subKey, char* value, char* buffer, unsigned long bufferSize)
{
	return(RegQueryValueEx( subKey, value, NULL, NULL, (uchar*)buffer, &bufferSize) );
}
inline unsigned long SetRegistryValue(HKEY subKey, char* value, unsigned long type, char* buffer, unsigned long bufferSize)
{
	return (RegSetValueEx( subKey, value, 0, type, (uchar*)buffer, bufferSize) );
}

#pragma pack(pop)
#endif	//_I2S__REGISTRY

