//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains procedure that deal with resource dialogBoxes.
//
//
#include "i2s.h"

//---------------------------------------------------------------------------------------
//Copy of BrowseForFolder from MASM32 library
int APIENTRY BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	return (SetWindowText(hwnd,(char*)lpData));
}
 
//Function from MASM32 library.
bool BrowseForFolder(HWND hParent, char *lpBuffer, char *lpTitle, char *lpString)
{
	LPITEMIDLIST	lpIDList;
	BROWSEINFO		browseInfo;
	bool			retval;

	lpBuffer[0] = '\x0';	//just to be 100% sure

	browseInfo.hwndOwner=hParent;
	browseInfo.pidlRoot=0;
	browseInfo.pszDisplayName=0;
	browseInfo.lpszTitle=lpString;
	browseInfo.ulFlags = BIF_RETURNONLYFSDIRS | BIF_DONTGOBELOWDOMAIN;
	browseInfo.lpfn=BrowseCallbackProc;
	browseInfo.lParam=(LPARAM)lpTitle;
	browseInfo.iImage=0;
	if ( 0!=(lpIDList=SHBrowseForFolder(&browseInfo)) )
	{
		SHGetPathFromIDList(lpIDList, lpBuffer);
		retval = true;
	}
	else
	{
		retval = false;
	}
	
	CoTaskMemFree(lpIDList);
	return retval;
}

//--------------------------------------------------------------------------
//Does path exist, if not try to create it.
//At least one dir must exist or I2S will assume there is a mistake in path->error.
//
//return: STATUS_FAILED or STATUS_SUCCESS.
unsigned long CheckPath(char* pathMain)
{
//preserve path
	char	path[MAX_PATH];
	qstrncpy( path, pathMain, sizeof( path ) );
//------------------------------------
	HANDLE				hDir;
	WIN32_FIND_DATA		findStruct;

	hDir=FindFirstFile(path, &findStruct);
	if ( INVALID_HANDLE_VALUE==hDir )
	{
		register	int	currentEnd=strlen(path);
					int	fullPathLength=currentEnd;

		register DWORD	error=GetLastError();
		if ( (ERROR_PATH_NOT_FOUND==error)|(ERROR_FILE_NOT_FOUND==error) )
		{
		//Get partial path.
		//
		//At least one dir must exist or plugIn will assume there is a mistake in path.
			while ( hDir==INVALID_HANDLE_VALUE)
			{
			//get path-last dir
				while ( 0<currentEnd )
				{
					if ( '\\'==path[currentEnd] ) break;
					--currentEnd;
				}

				if ( (currentEnd==0)|(path[currentEnd-1]==':') )
				{
				//faulty path or root dir was defined (the plug will not save to root)
					return(STATUS_FAILED);
				}
				path[currentEnd]='\x0';
			//check if current path exist
				hDir=FindFirstFile(path, &findStruct);
			}
		//Got the path -> create the rest.
			FindClose(hDir);
			while ( currentEnd<fullPathLength )
			{
			//create the new dir
				path[currentEnd]='\\';
				if ( 0==CreateDirectory(path, NULL) ) return(STATUS_FAILED);
			//include next dir name to path
				while ( currentEnd<fullPathLength )
				{
					if ( '\x0'==path[currentEnd] ) break;
					++currentEnd;
				}
			}
		}
		else
		{
			return(STATUS_FAILED);
		}
	}
	else
	{
		FindClose(hDir);
	}
	return(STATUS_SUCCESS);
}


//--------------------------------------------------------------------------
//Setup dBox procedure.
//
//
//local variables
unsigned long	flagsDatabase;
char			nmsPath[MAX_PATH];
HWND			hwndOK;
HWND			hwndNMS;

BOOL CALLBACK SetupDialogBox( HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	register HKEY			hKeyIda2SIce;
	register int			fileLength;
	char					inputFilePath[MAX_PATH];
	char					inputFileName[MAX_PATH];

//commands
	switch ( uiMsg )
	{
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
	case WM_COMMAND : 
	//Get the path from dialog windows.
		if ( LOWORD(wParam) == IDC__IDADIR )
		{
			if ( BST_CHECKED==IsDlgButtonChecked(hDlg, IDC__IDADIR) )
			{
				EnableWindow( hwndNMS, FALSE );

			//set to project dir
				qstrncpy( nmsPath, database_idb, sizeof( nmsPath ) );

			//Remove name of the database.
				int i = 0;
				while( nmsPath[i] != '\x0' )
				{
					++i;
				}
				//Check if there is a '.' before '\'.
				while( i > 0 )
				{
					if ( nmsPath[i] == '.' )
					{
					//'.' was before '\' -> there is a file name -> remove it from the path.
						while ( nmsPath[i] != '\\' )
						{
							--i;
							if ( i <= 0 )
							{
								break;
							}
						}
						nmsPath[i] = '\x0';

					//Exit loop.
						break;
					}
					else if ( nmsPath[i] == '\\' )
					{
					//'\' was before the '.' -> the dir is already in right form
						break;
					}

				//Update.
					--i;
				}
				SetWindowText( hwndNMS, (char*)nmsPath );
			}
			else
			{
				EnableWindow( hwndNMS, TRUE );
			}
		}
//---------------------------------------------------------------------------------------
		switch ( LOWORD(wParam) )
		{
	//---------------------------------------------------------------------------------------
		case IDC__BROWSE_NMSFILES :
			if ( TRUE==BrowseForFolder(hDlg, nmsPath, "Select nms directory", NULL) )
			{
				SetDlgItemText(hDlg, IDC__NMSFILES, nmsPath);
			}
		break;
	//---------------------------------------------------------------------------------------
		case IDC__SET_DEFAULT :
		//Get nms file path.
			GetDlgItemText(hDlg, IDC__NMSFILES, (char*)nmsPath, MAX_PATH);

			//clear '\' if it's the last char in path
			fileLength=strlen(nmsPath);
			--fileLength;
			while ( nmsPath[fileLength]=='\\' )
			{
			//normally this will execute only once, but you never know 
				nmsPath[fileLength]='\x0';
				--fileLength;
				SetDlgItemText(hDlg, IDC__NMSFILES, (char*)nmsPath);
			}

		//create flagsDatabase
			flagsDatabase = I2S_FLAGS_DEFINED;

		//check path
			if ( STATUS_FAILED==CheckPath( nmsPath ) )
			{
				char	tempBufferSetup[128];

				qsnprintf(
				  tempBufferSetup,
				  sizeof( tempBufferSetup ),
				  "I2S: Current nms path (%s) can't be created!",
				  nmsPath
				);
				MessageBox( hDlg, tempBufferSetup, "Error!", MB_OK | MB_ICONWARNING | MB_APPLMODAL );
				break;
			}
			if ( BST_CHECKED == IsDlgButtonChecked(hDlg, IDC__IDADIR) )
			{
				flagsDatabase |= I2S_FLAGS_SAVE_TO_PROJECT_DIR;
			}

		//check INCLUDESOURCE
			if ( BST_CHECKED==IsDlgButtonChecked(hDlg, IDC__INCLUDE_SOURCE) )
			{
				flagsDatabase |= I2S_FLAGS_INCLUDE_SOURCE;
			}
			if ( BST_CHECKED==IsDlgButtonChecked(hDlg, IDC__ADDSOURCE) )
			{
				flagsDatabase |= I2S_FLAGS_ATTACH_SOURCE;
			}

		//check ALWAYSDEFAULT
			if ( BST_CHECKED==IsDlgButtonChecked(hDlg, IDC__ALWAYS_DEFAULT) )
			{
				flagsDatabase |= I2S_FLAGS_ALWAYS_DEFAULT;
			}

		//save to registry
			hKeyIda2SIce = GetRegistryKey(
			  HKEY_LOCAL_MACHINE,
			  "SOFTWARE\\IdaToSoftIce",
			  KEY_SET_VALUE,
			  I2S_REG_TYPE_CREATE
			);
			if ( S_SUCCESS( hKeyIda2SIce ) )
			{
				SetRegistryValue( hKeyIda2SIce, "flags", REG_DWORD_LITTLE_ENDIAN, (char*)&flagsDatabase, 4 );
				SetRegistryValue( hKeyIda2SIce, "nmsPath", REG_SZ, nmsPath, strlen(nmsPath)+1 );
				CloseRegistryKey( hKeyIda2SIce );
			}
			else
			{
				msg( "I2S: Registry error(res.cpp - IDC__SET_DEFAULT)\n." );
				MessageBox( hDlg, "I2S: Registry error.", "Error!", MB_OK | MB_ICONWARNING | MB_APPLMODAL );
			}
		break;
	//---------------------------------------------------------------------------------------
		case IDC__OK :
		//------------------------------------------------
		//Input file path.
			GetDlgItemText( hDlg, IDC__INPUTFILE, inputFilePath, MAX_PATH );

		//Check if we have file name.
			_splitpath( inputFilePath, NULL, NULL, inputFileName, NULL );
			if ( 0 == strlen( inputFileName ) )
			{
				MessageBox( hDlg, "I2S: Input file name has 0 length.", "Error!", MB_OK | MB_ICONWARNING | MB_APPLMODAL );
				break;
			}
			else
			{
				RootNode.set( inputFilePath, 0);  
			}
			i2s.Imports_initialize();

		//------------------------------------------------
		//nms output path
			GetDlgItemText(hDlg, IDC__NMSFILES, (char*)nmsPath, MAX_PATH);

			//clear '\' if it's the last char in path
			fileLength = strlen( nmsPath );
			--fileLength;
			while ( nmsPath[fileLength] == '\\' )
			{
			//Normally this will execute only once, but you never know.
				nmsPath[fileLength] = '\x0';
				--fileLength;
				SetDlgItemText( hDlg, IDC__NMSFILES, (char*)nmsPath );
			}
			i2s.i2sNetNode.supset( NSUP_I2S__NMSPATH, nmsPath, 0, stag );

		//Create flagsDatabase.
			flagsDatabase = I2S_FLAGS_DEFINED;

		//Check path.
			if ( STATUS_FAILED == CheckPath( nmsPath ) )
			{
				char	tempBufferSetup[128];

				qsnprintf(
				  tempBufferSetup,
				  sizeof( tempBufferSetup ),
				  "I2S: Current nms path (%s) can't be created!",
				  nmsPath
				);
				msg( "%s\n.", tempBufferSetup );
				MessageBox( hDlg, tempBufferSetup, "Error!", MB_OK | MB_ICONWARNING | MB_APPLMODAL );
				break;
			}
			if ( BST_CHECKED == IsDlgButtonChecked( hDlg, IDC__IDADIR ) )
			{
				flagsDatabase |= I2S_FLAGS_SAVE_TO_PROJECT_DIR;
			}

		//Check INCLUDESOURCE.
			if ( BST_CHECKED == IsDlgButtonChecked( hDlg, IDC__INCLUDE_SOURCE ) )
			{
				flagsDatabase |= I2S_FLAGS_INCLUDE_SOURCE;
			}
			if ( BST_CHECKED == IsDlgButtonChecked( hDlg, IDC__ADDSOURCE ) )
			{
				flagsDatabase |= I2S_FLAGS_ATTACH_SOURCE;
			}

		//Check ALWAYSDEFAULT.
			if ( BST_CHECKED == IsDlgButtonChecked( hDlg, IDC__ALWAYS_DEFAULT ) )
			{
				flagsDatabase |= I2S_FLAGS_ALWAYS_DEFAULT;
			}

		//Set in database.
			i2s.i2sNetNode.altset( NVAL_I2S__FLAGS, flagsDatabase, atag );
			i2s.i2sNetNode.supset( NSUP_I2S__NMSPATH, nmsPath, 0, stag );

		//Close dialog.
			EndDialog( hDlg, TRUE );
		break;
	//---------------------------------------------------------------------------------------
		case IDC__FIX_IMPORT_NAMES :
		//------------------------------------------------
		//Check all import names and delete appended file name.
		//e.g. 'CloseHandle__myfile_exe' -> 'CloseHandle'
			i2s.Imports_renameNames( IMPORTNAMES_RESET );
		break;
	//---------------------------------------------------------------------------------------
//		default :
//		break;
		}
	break;
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
//	case WM_DESTROY :
	case WM_CLOSE :
		EndDialog(hDlg, FALSE);
	break;
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
	case WM_INITDIALOG :
	{
		unsigned long	flagsRegistry;
		flagsRegistry = 0;
		flagsDatabase = 0;

		nmsPath[0] = '\x0';

		hwndOK = GetDlgItem( hDlg, IDC__OK );
		hwndNMS = GetDlgItem( hDlg, IDC__NMSFILES );

	//center the window
		RECT	dlgRect;
		RECT	desktopRect;
		HWND	hDesktopWindow;
		LONG	dlgHeight;
		LONG	dlgWidth;
		
		GetWindowRect( hDlg, &dlgRect );
		dlgHeight = dlgRect.bottom-dlgRect.top;
		dlgWidth = dlgRect.right-dlgRect.left;

		hDesktopWindow = GetDesktopWindow();
		GetWindowRect( hDesktopWindow, &desktopRect );

		MoveWindow(
		  hDlg,
		  ( desktopRect.right - dlgWidth )/2,
		  ( desktopRect.bottom - dlgHeight )/2,
		  dlgWidth,
		  dlgHeight,
		  FALSE
		);

	//get values
		register HKEY	hKeyNumega;
		hKeyIda2SIce = GetRegistryKey(
		  HKEY_LOCAL_MACHINE,
		  "SOFTWARE\\IdaToSoftIce",
		  KEY_QUERY_VALUE,
		  I2S_REG_TYPE_CREATE
		);
		if ( S_SUCCESS( hKeyIda2SIce ) )
		{
			GetRegistryValue( hKeyIda2SIce, "nmsPath", nmsPath, MAX_PATH);
			GetRegistryValue( hKeyIda2SIce, "flags", (char*)&flagsRegistry, 4 );
			CloseRegistryKey( hKeyIda2SIce );

		//If NMS directory was not set yet, check if user has set NMS output dir in SIce
			if ( nmsPath[0] != '\x0' )
			{
				hKeyNumega = GetRegistryKey(
				  HKEY_LOCAL_MACHINE,
				  "SOFTWARE\\Numega\\Loader32",
				  KEY_QUERY_VALUE,
				  I2S_REG_TYPE_OPEN
				);
				if ( S_SUCCESS( hKeyNumega ) )
				{
					GetRegistryValue( hKeyNumega, "NmsOutputDir", nmsPath, MAX_PATH );
					CloseRegistryKey( hKeyNumega );
				}
			}
		}
		else
		{
			msg( "I2S: Registry error(res.cpp - WM_INITDIALOG).\n" );
			MessageBox( hDlg, "I2S: Registry error.", "Error!", MB_OK | MB_ICONWARNING | MB_APPLMODAL );
			EndDialog( hDlg, FALSE );
		}

		//override path if it's already in database
		flagsDatabase = i2s.i2sNetNode.altval(NVAL_I2S__FLAGS, atag );
		if ( ( flagsDatabase & I2S_FLAGS_DEFINED ) != 0 )
		{
		//if flagsDatabase is defined then paths are defined too
		//NMS Path
			i2s.i2sNetNode.supval( NSUP_I2S__NMSPATH, nmsPath, sizeof( nmsPath ), stag );
			if ( ( flagsDatabase & I2S_FLAGS_SAVE_TO_PROJECT_DIR ) != 0 )
			{
				CheckDlgButton( hDlg, IDC__IDADIR, BST_CHECKED );
			
			//Disable NMS path window.
				EnableWindow( hwndNMS, FALSE );
			}

		//Include source.
			if ( ( flagsDatabase & I2S_FLAGS_INCLUDE_SOURCE ) != 0 )
			{
				CheckDlgButton( hDlg, IDC__INCLUDE_SOURCE, BST_CHECKED );
			}
			if ( ( flagsDatabase & I2S_FLAGS_ATTACH_SOURCE ) != 0 )
			{
				CheckDlgButton( hDlg, IDC__ADDSOURCE, BST_CHECKED );
			}

		//Use default values.
			if ( ( flagsDatabase & I2S_FLAGS_ALWAYS_DEFAULT ) != 0 )
			{
				CheckDlgButton( hDlg, IDC__ALWAYS_DEFAULT, BST_CHECKED );
			}
		}
		else	//nothing has been set yet -> new database
		{
		//check registry flags
			if ( flagsRegistry != 0 )
			{
			//NMS Path
				if ( ( flagsRegistry & I2S_FLAGS_SAVE_TO_PROJECT_DIR ) != 0 )
				{
				//set to project dir
					qstrncpy( nmsPath, database_idb, sizeof( nmsPath ) );

					//Remove name of the database.
					int i = 0;
					while( nmsPath[i] != '\x0' ) 
					{
						++i;
					}
					//Check if there is a '.' before '\'.
					while( i > 0 )
					{
						if ( nmsPath[i] == '.' )
						{
						//'.' was before '\' -> there is a file name -> remove it from the path.
							while ( nmsPath[i] != '\\' )
							{
								--i;
								if ( i <= 0 )
								{
									break;
								}
							}
							nmsPath[i] = '\x0';

						//Exit loop.
							break;
						}
						else if ( nmsPath[i] == '\\' )
						{
						//'\' was before the '.' -> the dir is already in right form
							break;
						}

					//Update.
						--i;
					}

				//check
					CheckDlgButton( hDlg, IDC__IDADIR, BST_CHECKED );
					EnableWindow( hwndNMS, FALSE );
				}
			//include source
				if ( ( flagsRegistry & I2S_FLAGS_INCLUDE_SOURCE ) != 0 )
				{
					CheckDlgButton( hDlg, IDC__INCLUDE_SOURCE, BST_CHECKED );
				}
				if ( ( flagsRegistry & I2S_FLAGS_ATTACH_SOURCE ) != 0 )
				{
					CheckDlgButton( hDlg, IDC__ADDSOURCE, BST_CHECKED );
				}
			//use default values
				if ( ( flagsRegistry & I2S_FLAGS_ALWAYS_DEFAULT ) != 0 )
				{
					CheckDlgButton( hDlg, IDC__ALWAYS_DEFAULT, BST_CHECKED);
				}
			}
		}

	//Set paths to the window.
		if ( nmsPath[0] != '\x0' )
		{
			SetDlgItemText( hDlg, IDC__NMSFILES, (char*)nmsPath );
		}

	//Check if we are initializing the plugIn.
		if ( lParam == 0 )
		{
			if ( BST_CHECKED == IsDlgButtonChecked( hDlg, IDC__ALWAYS_DEFAULT ) )
			{
				PostMessage( hDlg, WM_COMMAND, IDC__OK, 0 );
			}
		}

	//set input file path
		char	pathRN_temp[MAX_PATH];
		RootNode.valobj( pathRN_temp, sizeof( pathRN_temp ) );
		SetDlgItemText( hDlg, IDC__INPUTFILE, (char*)&pathRN_temp );
	break;
	}
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
	default : return FALSE;
	}
	return TRUE;
}

//--------------------------------------------------------------------------
//Source File Information dBox procedure.
//
// lParam - Selected file number.
unsigned long nSelectedFile;
BOOL CALLBACK SourceFileInfoDialogBox( HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam )
{
	ssize_t			ret;

	char			buffer_temp[MAXSTR];
	sourceFiles_s	NSources;
	func_t			procedure;
	func_t*			pProcedure;
	char			procedureName[MAXSTR];
	char*			pSubString;
	sourceInfo_s	sourceInfo;
	LONG			windowHeight_dlg;
	LONG			windowHeight_main;
	RECT			windowRect;
	LONG			windowWidth_dlg;
	LONG			windowWidth_main;

//commands
	switch ( uiMsg )
	{
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
	case WM_COMMAND : 
//---------------------------------------------------------------------------------------
		switch ( LOWORD(wParam) )
		{
	//---------------------------------------------------------------------------------------
		case IDC__OK :
		{
		//Get source file info.
			ret = i2s.sourceNetNode.supval( nSelectedFile, &sourceInfo, sizeof( sourceInfo ), stag );
			if ( ret == -1 )
			{
				msg( "I2S: Internal error, please contact author about this.\n" ,0 );
				MessageBox(
				  hDlg,
				  "I2S: Internal error, please contact author about this.",
				  "Failed",
				  MB_OK
				);
				EndDialog( hDlg, FALSE );
				break;
			}

		//Get source file name.
			GetDlgItemText( hDlg, IDC__SOURCE_NAME, (char*)&buffer_temp, MAXSTR );

		//Check if it's full name (name.asm) -> if not add '.asm'
			pSubString = strstr( (char*)&buffer_temp, ".asm" );
			if ( pSubString == NULL )
			{
			//Check if it's '.ASM'.
				pSubString = strstr( (char*)&buffer_temp, ".ASM" );
				if ( pSubString == NULL )
				{
				//'.asm' is missing -> add it to the end of file.
					qstrncat( buffer_temp, ".asm", sizeof( buffer_temp ) );
				}
			}
			else
			{
			//We have '.asm' but to be sure we will put a NUL at the end
				pSubString[4] = '\x0';
			}

		//Is file name longer than the supported length.
			if ( strlen( (char*)&buffer_temp ) >= 32 )
			{
				MessageBox(
				  hDlg,
				  "Sorry but maximum size of the name is set to 31 chars.",
				  "Failed",
				  MB_OK
				);
				break;
			}
			//Set the new name.
			qstrncpy( sourceInfo.nameSource, (char*)&buffer_temp, sizeof( sourceInfo.nameSource ) );

		//Set startEA, endEA and enable_xxx.
			ret = i2s.sourceNetNode.supval( sourceInfo.segmentNumber, &NSources, sizeof( NSources ), atag );
			if ( ret == -1 )
			{
				msg( "I2S: Internal error, please contact author about this.\n" ,0 );
				MessageBox(
				  hDlg,
				  "I2S: Internal error, please contact author about this.",
				  "Failed",
				  MB_OK
				);
				EndDialog( hDlg, FALSE );
				break;
			}
			if ( BST_CHECKED == IsDlgButtonChecked( hDlg, IDC__ENABLE_SYMBOLS ) )
			{
			//Set sourceInfo.
				sourceInfo.enable_symbols = TRUE;
			}
			else
			{
			//Symbols are disabled so we need to disable the source also.
				CheckDlgButton( hDlg, IDC__ENABLE_SOURCE, BST_UNCHECKED );

			//Set sourceInfo.
				sourceInfo.enable_symbols = FALSE;
			}
			if ( BST_CHECKED == IsDlgButtonChecked( hDlg, IDC__ENABLE_SOURCE ) )
			{
			//Source listing is enabled.
			//
			//Was this source file enabled before?
				if ( sourceInfo.enable_source == FALSE )
				{
				//No this source was previously disabled.
				//
				//Enable source
					sourceInfo.enable_source = TRUE;

				//Increase number of enabled source.
					++NSources.nEnabled;
				}
			}
			else
			{
			//Source lisitng is enabled.
			//
			//Was this source file enabled before?
				if ( sourceInfo.enable_source == TRUE )
				{
				//This source was previously enabled.
				//
				//Disable source
					sourceInfo.enable_source = FALSE;

				//Decrease number of enabled sources.
					--NSources.nEnabled;
				}
			}
			//Save pNSources struct.
			i2s.sourceNetNode.supset( sourceInfo.segmentNumber, &NSources, sizeof( NSources ), atag );					

		//Save sourceInfo struct.
			i2s.sourceNetNode.supset( nSelectedFile, &sourceInfo, sizeof( sourceInfo_s ), stag );

		//Close dialog.
			EndDialog( hDlg, TRUE );
		break;
		}
	//---------------------------------------------------------------------------------------
		case IDC__CHOOSE_START : 
		case IDC__CHOOSE_END : 
			MessageBox(hDlg, "Sorry this option is not set yet.", "Failed", MB_OK);
		break;
	//---------------------------------------------------------------------------------------
//		case IDC__CHOOSE_END : 
//		break;
	//---------------------------------------------------------------------------------------
//		default :
//		break;
		}
	break;
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
//	case WM_DESTROY :
	case WM_CLOSE :
		EndDialog( hDlg, FALSE );
	break;
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
	case WM_INITDIALOG :
	{
	//Save selected file number.
		nSelectedFile = lParam;

	//Get source file info.
		ret = i2s.sourceNetNode.supval( lParam, &sourceInfo, sizeof( sourceInfo ), stag );
		if ( ret == -1 )
		{
			msg( "I2S: Internal error, please contact author about this.\n" ,0 );
			MessageBox(
			  hDlg,
			  "I2S: Internal error, please contact author about this.",
			  "Failed",
			  MB_OK
			);
			EndDialog( hDlg, FALSE );
			break;
		}

	//Set dialog box parameters.
	//
		//Set filename
		SetDlgItemText( hDlg, IDC__SOURCE_NAME, sourceInfo.nameSource );

		//Set startEA.
		pProcedure = get_func( sourceInfo.startEA );
		if ( pProcedure != NULL )
		{
		//There is a procedure at current address.
		//
		//Is current address the start of the procedure.
			if ( pProcedure->startEA == sourceInfo.startEA )
			{
			//Source listing starts at the start of the procedure.
			//
			//Get procedure's name.
				get_short_name(
				  pProcedure->startEA,
				  pProcedure->startEA,
				  (char*)&procedureName,
				  MAXSTR
				);

			//Construct a display string.
				qsnprintf(
				  buffer_temp,
				  sizeof( buffer_temp ), 
				  "0x%X (start of  %s)",
				  sourceInfo.startEA,
				  (char*)&procedureName
				);
			}
			else
			{
			//Source files doesn't start at start of procedure.
				qsnprintf( buffer_temp, sizeof( buffer_temp ),  "0x%X", sourceInfo.startEA );
			}
		}
		else
		{
		//Current address is not part of the procedure.
			qsnprintf( buffer_temp, sizeof( buffer_temp ), "0x%X", sourceInfo.startEA );
		}
			//Set dialogBox startEA text.
		SetDlgItemText( hDlg, IDC__START_EA, (char*)&buffer_temp );

		//Set endEA
		pProcedure = get_func( sourceInfo.endEA );
		if ( pProcedure != NULL )
		{
		//There is a procedure at current address.
		//
		//Is current address the end of the procedure.
			if ( pProcedure->endEA == sourceInfo.endEA + 1 )
			{
			//Source listing ends at the end of the procedure.
			//
			//Get procedure's name.
				get_short_name(
				  pProcedure->endEA,
				  pProcedure->endEA,
				  (char*)&procedureName,
				  MAXSTR
				);

			//Construct a display string.
				qsnprintf(
				  buffer_temp,
				  sizeof( buffer_temp ),
				  "0x%X (end of  %s)",
				  sourceInfo.endEA,
				  (char*)&procedureName
				);
			}
			else
			{
			//Source files doesn't end at end of procedure.
				qsnprintf( buffer_temp, sizeof( buffer_temp ), "0x%X", sourceInfo.endEA );
			}
		}
		else
		{
		//Current address is not part of the procedure.
			qsnprintf( buffer_temp, sizeof( buffer_temp ), "0x%X", sourceInfo.endEA );
		}
			//Set dialogBox endEA text.
		SetDlgItemText( hDlg, IDC__END_EA, (char*)&buffer_temp );

		//Are symbols enabled?
		if ( sourceInfo.enable_symbols != FALSE )
		{
			CheckDlgButton( hDlg, IDC__ENABLE_SYMBOLS, BST_CHECKED );
		}

		//Is source listing enabled?
		if ( sourceInfo.enable_source != FALSE )
		{
			CheckDlgButton( hDlg, IDC__ENABLE_SOURCE, BST_CHECKED );
		}

	//Center dialogBox.
		GetWindowRect( hDlg, &windowRect );
		windowHeight_dlg = windowRect.bottom - windowRect.top;
		windowWidth_dlg = windowRect.right - windowRect.left;

		GetWindowRect( hwnd_mainWindow, &windowRect );
		windowHeight_main = windowRect.bottom - windowRect.top;
		windowWidth_main = windowRect.right - windowRect.left;

		MoveWindow(
		  hDlg,
		  windowRect.left + windowWidth_main/2 - windowWidth_dlg/2,
		  windowRect.top + windowHeight_main/2 - windowHeight_dlg/2,
		  windowWidth_dlg,
		  windowHeight_dlg,
		  FALSE
		);
	break;
	}
//---------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------
	default : return FALSE;
	}
	return TRUE;
}


