//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains function that sets all sections.
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
//Set NMTP section.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::SetSection_NMTP(void)
{
	unsigned long	align;
	char*			pNmtp;
	unsigned long	size_data;
	unsigned long	size_offsets;
	unsigned long	size_section;

//Get size of NMTP section.
	size_offsets = nmtp.nTypes * sizeof( unsigned long );
	size_data = nmtp.pTypesData_current - nmtp.pTypesData;
		//Set size_data to DWORD boundary.
		//
		//Get lower 2 bits and substract from 4.
		//ex.: address = xxxxxxx3 => 4 - 3 = 1 => add 1 to the address
	align = 0x00000003 & size_data;
	if ( align != 0 )
	{
		size_data += 4 - align;
	}

	size_section = sizeof( NMTP_HEADER ) + size_offsets + size_data;

//Allocate memory.
	pNmtp = (char*) LocalAlloc( LPTR, size_section );
	if ( pNmtp == NULL )
	{
		msg( "I2S: Failed to allocate memory(SetSection_NMTP).\n" );
		return STATUS_FAILED;
	}
	sections.pNmtp = pNmtp;

//Set NMTP section.
	//Set header.
	( (NMTP_HEADER*)pNmtp )->NMTP = NMTPs;
	( (NMTP_HEADER*)pNmtp )->sectionLength = size_section;
	( (NMTP_HEADER*)pNmtp )->nTypes = nmtp.nTypes;
		//Update.
	pNmtp += sizeof( NMTP_HEADER );

	//Copy offsets.
	CopyMemory( pNmtp, nmtp.pTypesOffsets, size_offsets );
		//Update.
	pNmtp += size_offsets;

	//Copy data.
	CopyMemory( pNmtp, nmtp.pTypesData, size_data );

//Free nmtp data -> we'll need a lot of memory for other sections.
	LocalFree( nmtp.hTypesData );
	nmtp.hTypesData = NULL;

	LocalFree( nmtp.hTypesOffsets );
	nmtp.hTypesOffsets = NULL;
	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Set STTB section.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::SetSection_STTB(void)
{
	unsigned long	align;
	char*			pSttb;
	unsigned long	size_data;
	unsigned long	size_offsets;
	unsigned long	size_section;

//Get size of NMTP section.
	size_offsets = sttb.nStrings * sizeof( unsigned long );
	size_data = sttb.pStrings_current - sttb.pStrings;
		//Set size_data to DWORD boundary.
		//
		//Get lower 2 bits and substract from 4.
		//ex.: address = xxxxxxx3 => 4 - 3 = 1 => add 1 to the address
	align = 0x00000003 & size_data;
	if ( align != 0 )
	{
		size_data += 4 - align;
	}

	size_section = sizeof( STTB_HEADER ) + size_offsets + size_data;

//Allocate memory.
	pSttb = (char*) LocalAlloc( LPTR, size_section );
	if ( pSttb == NULL )
	{
		msg( "I2S: Failed to allocate memory(SetSection_STTB).\n" );
		return STATUS_FAILED;
	}
	sections.pSttb = pSttb;

//Set STTB section.
	//Set header.
	( (STTB_HEADER*)pSttb )->STTB = STTBs;
	( (STTB_HEADER*)pSttb )->sectionLength = size_section;
	( (STTB_HEADER*)pSttb )->nNames = sttb.nStrings;
		//Update.
	pSttb += sizeof( STTB_HEADER );

	//Copy offsets.
	CopyMemory( pSttb, sttb.pOffsets, size_offsets );
		//Update.
	pSttb += size_offsets;

	//Copy data.
	CopyMemory( pSttb, sttb.pStrings, size_data );

//Free sttb data -> we'll need a lot of memory for other sections.
	LocalFree( sttb.hStrings );
	sttb.hStrings = NULL;

	LocalFree( sttb.hOffsets );
	sttb.hOffsets = NULL;

	LocalFree( sttb.hHash );
	sttb.hHash = NULL;
	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Set TYTB section.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::SetSection_TYTB(void)
{
	char*			pTytb;
	unsigned long	size_data;
	unsigned long	size_section;

//Get size of TYTP section.
	size_data = (char*)tytb.pTypeTables_current - (char*)tytb.pTypeTables;

	size_section = sizeof( TYTB_HEADER ) + size_data;

//Allocate memory.
	pTytb = (char*) LocalAlloc( LPTR, size_section );
	if ( pTytb == NULL )
	{
		msg( "I2S: Failed to allocate memory(SetSection_TYTB).\n" );
		return STATUS_FAILED;
	}
	sections.pTytb = pTytb;

//Set TYTB section.
	//Set header.
	( (TYTB_HEADER*)pTytb )->TYTB = TYTBs;
	( (TYTB_HEADER*)pTytb )->sectionLength = size_section;
	( (TYTB_HEADER*)pTytb )->nTypes = tytb.nTypeTables;
		//We'll update next number in SetSection_NM32.
	( (TYTB_HEADER*)pTytb )->offTypeTables = sizeof( TYTB_HEADER );
		//Update.
	pTytb += sizeof( TYTB_HEADER );

	//Copy data.
	CopyMemory( pTytb, tytb.pTypeTables, size_data );

//Free tytb data -> we'll need a lot of memory for other sections.
	LocalFree( tytb.hTypeTables );
	tytb.hTypeTables = NULL;
	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Set HSHT section.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::SetSection_HSHT(void)
{
	char*			pHsht;
	unsigned long	size_data;
	unsigned long	size_offsets;
	unsigned long	size_section;

//Get size of HSHT section.
	size_offsets = sizeof( hsht.hashOffsets );
	size_data = (char*)hsht.pHashTables_current - (char*)hsht.pHashTables;

	size_section = sizeof( HSHT_HEADER ) + size_offsets + size_data;

//Allocate memory.
	pHsht = (char*) LocalAlloc( LPTR, size_section );
	if ( pHsht == NULL )
	{
		msg( "I2S: Failed to allocate memory(SetSection_HSHT).\n" );
		return STATUS_FAILED;
	}
	sections.pHsht = pHsht;

//Set HSHT section.
	//Set header.
	( (HSHT_HEADER*)pHsht )->HSHT = HSHTs;
	( (HSHT_HEADER*)pHsht )->sectionLength = size_section;
	( (HSHT_HEADER*)pHsht )->sizeTableOffsets = 0x25;
	( (HSHT_HEADER*)pHsht )->nTypes = hsht.nHashTables;
		//We'll update next two numbers in SetSection_NM32.
	( (HSHT_HEADER*)pHsht )->offTableOffsets = sizeof(HSHT_HEADER);
	( (HSHT_HEADER*)pHsht )->offTypeTables =
	  sizeof(HSHT_HEADER) + sizeof( unsigned long ) * 0x25;
		//Update.
	pHsht += sizeof( HSHT_HEADER );

	//Copy offsets.
	CopyMemory( pHsht, &hsht.hashOffsets, size_offsets );
		//Update.
	pHsht += size_offsets;

	//Copy data.
	CopyMemory( pHsht, hsht.pHashTables, size_data );

//Free hsht data -> we'll need a lot of memory for other sections.
	LocalFree( hsht.hHashTables );
	hsht.hHashTables = NULL;
	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Set SYMD section.
//
// return - Memory pointer to section or STATUS_FAILED.
//
//NOTICE!
//All the dword boundary alignment were disables as it looks that SoftIce doesn't like them.
//Only the dword alignment of the whole buffer is obligatory.
STATUS ida2softice_c::SetSection_SYMD(void)
{
	unsigned long	align;
	unsigned long	indexInSourceNetNodeSupVal;
	unsigned long	nEnabledSourceFiles;
	unsigned long	nSourceFiles;
	sourceInfo_s	sourceInfo;

	char*			pSymd;
	char*			pSymd_variables;
	unsigned long	size;
	unsigned long	size_procDefinitions = 0;
	unsigned long	size_localVariables = 0;
	unsigned long	size_registers = 0;
	unsigned long	size_sourceLines = 0;
	unsigned long	size_sourceSections = 0;
	unsigned long	size_VLPTables = 0;
	unsigned long	size_VLPOffsets = 0;
	unsigned long	size_section;
	unsigned long	size_subSection;

//Get the number of enabled source files and size of SYMD section.
	//Initialize.
	nEnabledSourceFiles = 0;

	pSegmentCurrent = pSegments;
	while ( pSegmentCurrent != NULL )
	{
	//Number of enabled source files.
	//
	//Is current segment in IDA?
	//If not than there are no source files in there for sure.
		if ( pSegmentCurrent->includedInIDA == TRUE )
		{
		//Current segment is present in IDA -> get number of enabled source files.
			unsigned long	nSegments_to = pSegmentCurrent->segmentIndexInIDA + pSegmentCurrent->nOfIDAsSegments;
			for ( unsigned long i = pSegmentCurrent->segmentIndexInIDA; i < nSegments_to; i++ )
			{
			//Get current segment sourceFiles_s structure.
				sourceFiles_s	nSourceFiles_temp;

				if ( -1 == sourceNetNode.supval( i, &nSourceFiles_temp, sizeof( nSourceFiles_temp ), atag ) )
				{
					msg( "I2S: A serious internal error, please contact author about this.\n"  );
					return STATUS_FAILED;
				}

				nEnabledSourceFiles += nSourceFiles_temp.nEnabled;
			}
		}

	//Size of SYMD section ( part 1 -> get number of ... ).
		size_procDefinitions += pSegmentCurrent->nProcDefinitions;
		size_localVariables += pSegmentCurrent->nLocalVariables;
		size_registers += pSegmentCurrent->nRegisters;
		size_sourceLines += pSegmentCurrent->nSourceLines;
		size_VLPTables += pSegmentCurrent->nVLP;
		size_VLPOffsets += pSegmentCurrent->nVLP;

	//Update.
		pSegmentCurrent = pSegmentCurrent->pNext;
	}
	//Size of SYMD section ( part 2 -> multiply with the structure sizes )
	size_procDefinitions *= sizeof( SEGDATA_PROCEDURE_V2 );
	size_localVariables *= sizeof( SEGDATA_VLPTABLE );
	size_registers *= sizeof( SEGDATA_REGISTER );
	size_sourceLines *= sizeof( SEGDATA_SOURCELINES );
	size_VLPTables *= sizeof( SEGDATA_VLPTABLE );
	size_VLPOffsets *= sizeof( unsigned long );

	//Get whole size of SYMD sections.
	size_section = sizeof( SYMD_HEADER );

	size_subSection =
	  sizeof( SEGMENTDATA_HEADER )
	  +
	  nSegmentsPresent * sizeof( SEGMENTDATA )
	  +
	  size_procDefinitions
	  +
	  size_localVariables
	  +
	  size_registers
	  +
	  size_sourceLines
	  +
	  size_VLPTables
	  +
	  size_VLPOffsets;

	if ( includeSource == TRUE )
	{
	//Add source file definitions to SYMD section.
		size_section += nEnabledSourceFiles * sizeof( SEGDATA_SOURCEFILE );
		size_subSection += nEnabledSourceFiles * sizeof( SEGDATA_SOURCESECTION );
	}
	else
	{
	//Disable nEnabledSourceFiles if master source listing flag was cleared.
	//Master flag doesn't influence sourceNetNode.
		nEnabledSourceFiles = 0;
	}

	size_section += size_subSection;
		//Set size_section to DWORD boundary.
		//
		//Get lower 2 bits and substract from 4.
		//ex.: address = xxxxxxx3 => 4 - 3 = 1 => add 1 to the address
		//
		//Notice:
		//For some strange reason SoftIce needs additional 4 bytes at the end of this
		//section, so we'll convert the 4 to 8.
		//Maybe this is just of some bug of previous version of i2s????
	align = 0x00000003 & size_section;
	if ( align != 0 )
	{
		size_section += 8 - align;
	}

//Allocate memory.
	pSymd = (char*) LocalAlloc( LPTR, size_section );
	if ( pSymd == NULL )
	{
		msg( "I2S: Failed to allocate memory(SetSection_SYMD).\n" );
		return STATUS_FAILED;
	}
	sections.pSymd = pSymd;

//Set SYMD section.
	//Set header.
	( (SYMD_HEADER*)pSymd )->SYMD = SYMDs;
	( (SYMD_HEADER*)pSymd )->sectionLength = size_section;
		//We'll update next number in SetSection_NM32.
	( (SYMD_HEADER*)pSymd )->offSegmentData_header = sizeof( SYMD_HEADER );
		//Update.
	pSymd += sizeof( SYMD_HEADER );

	//Set SegmentData_header.
	( (SEGMENTDATA_HEADER*)pSymd )->subSectionLength = size_subSection;
	( (SEGMENTDATA_HEADER*)pSymd )->nSourceFiles = nEnabledSourceFiles;
	( (SEGMENTDATA_HEADER*)pSymd )->nSegments = nSegmentsPresent;
		//Update.
	pSymd += sizeof( SEGMENTDATA_HEADER );

	//Set SEGMENTDATA and segment's data.
	indexInSourceNetNodeSupVal = 0;

	pSymd_variables	= pSymd + nSegmentsPresent * sizeof( SEGMENTDATA );
	pSegmentCurrent = pSegments;
	while ( pSegmentCurrent != NULL )
	{
	//We'll be setting the SEGMENTDATA through the whole loop in the
	//mean time we'll be settings it's variables.
	//
		//Set common SEGEMENTDATA part.
		( (SEGMENTDATA*)pSymd )->nSeg = (unsigned short)pSegmentCurrent->nSeg;
		( (SEGMENTDATA*)pSymd )->iName = pSegmentCurrent->iName;
		if ( pSegmentCurrent->includedInIDA == FALSE )
		{
		//Segment size retrieved from original ( executable )file.
			( (SEGMENTDATA*)pSymd )->physSize = pSegmentCurrent->physSize;
		}
		else
		{
		//Calculate the size of the segment.
			( (SEGMENTDATA*)pSymd )->physSize = pSegmentCurrent->endEA - pSegmentCurrent->startEA;
		}

		//Set procedures.
		( (SEGMENTDATA*)pSymd )->offProcDef = pSymd_variables - pSymd;
		( (SEGMENTDATA*)pSymd )->nProcedures = pSegmentCurrent->nProcDefinitions;

		size =
		  (char*)pSegmentCurrent->pProcDefinitions_current
		  -
		  (char*)pSegmentCurrent->pProcDefinitions;
		//Test if everything is ok.
		if ( size != ( pSegmentCurrent->nProcDefinitions * sizeof( SEGDATA_PROCEDURE_V2 ) ) )
		{
			msg( "I2S: ERROR -> Procedures structures size is wrong (please contact author).\n" );
		}
		if ( size != 0 )
		{
			CopyMemory( pSymd_variables, pSegmentCurrent->pProcDefinitions, size );
			pSymd_variables += size;
		}

		//Set local variables.
		( (SEGMENTDATA*)pSymd )->offLVarDef = pSymd_variables - pSymd;

		size =
		  (char*)pSegmentCurrent->pLocalVariables_current
		  -
		  (char*)pSegmentCurrent->pLocalVariables;
		//Test if everything is ok.
		if ( size != ( pSegmentCurrent->nLocalVariables * sizeof( SEGDATA_VLPTABLE ) ) )
		{
			msg( "I2S: ERROR -> LocalVariables structures size is wrong (please contact author).\n" );
		}
		if ( size != 0 )
		{
			CopyMemory( pSymd_variables, pSegmentCurrent->pLocalVariables, size );
			pSymd_variables += size;
		}

		//Set registers.
		( (SEGMENTDATA*)pSymd )->offRegDef = pSymd_variables - pSymd;

		size = (char*)pSegmentCurrent->pRegisters_current - (char*)pSegmentCurrent->pRegisters;
		//Test if everything is ok.
		if ( size != ( pSegmentCurrent->nRegisters * sizeof( SEGDATA_REGISTER ) ) )
		{
			msg( "I2S: ERROR -> Registers structures size is wrong (please contact author).\n" );
		}
		if ( size != 0 )
		{
			CopyMemory( pSymd_variables, pSegmentCurrent->pRegisters, size );
			pSymd_variables += size;
		}

		//Set 'SourceCode offset definitions'.
		( (SEGMENTDATA*)pSymd )->offSCLineDef = pSymd_variables - pSymd;

		size =
		  (char*)pSegmentCurrent->pSourceLines_current
		  -
		  (char*)pSegmentCurrent->pSourceLines;
		//Test if everything is ok.
		if ( size != ( pSegmentCurrent->nSourceLines * sizeof( SEGDATA_SOURCELINES ) ) )
		{
			msg( "I2S: ERROR -> SourceLines structures size is wrong (please contact author).\n" );
		}
		if ( size != 0 )
		{
			CopyMemory( pSymd_variables, pSegmentCurrent->pSourceLines, size );
			pSymd_variables += size;

		//	if ( pSegmentCurrent->nProcDefinitions == 0 )
		//	{
		//		msg(
		//		  "I2S: The database has code outside the function definition. If SoftIce crashes when loading nms file to it please contact author.\n",
		//		  0
		//		);
		//	}
		}

		//Set 'Source Sections Definitions'.
		( (SEGMENTDATA*)pSymd )->offSourceSDef = pSymd_variables - pSymd;

		if ( includeSource == TRUE )
		{
			if ( pSegmentCurrent->includedInIDA == TRUE )
			{
			//Current segment is present in IDA -> set enabled source files.
				unsigned long	nSegments_to = pSegmentCurrent->segmentIndexInIDA + pSegmentCurrent->nOfIDAsSegments;
				for ( unsigned long i = pSegmentCurrent->segmentIndexInIDA; i < nSegments_to; i++ )
				{
				//Get current segment sourceFiles_s structure.
					sourceFiles_s	nSourceFiles_temp;
					sourceNetNode.supval( i, &nSourceFiles_temp, sizeof( nSourceFiles_temp ), atag );

				//Initialize.
					indexInSourceNetNodeSupVal = nSourceFiles_temp.indexInSupVal;
					nSourceFiles = nSourceFiles_temp.nAll;
					nEnabledSourceFiles = nSourceFiles_temp.nEnabled;

				//Set SEGMENTDATA struct.
					( (SEGMENTDATA*)pSymd )->nSourceSec += nEnabledSourceFiles;

				//Scan for enabled source files.
					nSourceFiles += indexInSourceNetNodeSupVal;
					for ( ulong j = indexInSourceNetNodeSupVal; j < nSourceFiles; j++ )
					{
					//Have we found all enabled files?
						if ( nEnabledSourceFiles == 0 )
						{
						//Yes, no more enabled source files.
							break;
						}

					//Get the current source file.
						if ( -1 == sourceNetNode.supval( j, &sourceInfo, sizeof( sourceInfo ), stag ) )
						{
							msg( "I2S: Serious error: failed to retrive source file information.\n", 0 );
							return STATUS_FAILED;
						}

					//Copy required data.
						if ( sourceInfo.enable_source == TRUE )
						{
						//Copy data.
							size = sizeof( SEGDATA_SOURCESECTION );
							CopyMemory( pSymd_variables, &sourceInfo.sourceSection, size );
							pSymd_variables += size;

						//Update.
							--nEnabledSourceFiles;
						}
					}
				}
			}
		}

		//Set VLP tables.
		( (SEGMENTDATA*)pSymd )->offVLPDef = pSymd_variables - pSymd;
		( (SEGMENTDATA*)pSymd )->nVLP = pSegmentCurrent->nVLP;

		size = (char*)pSegmentCurrent->pVLP_current - (char*)pSegmentCurrent->pVLP;
		//Test if everything is ok.
		if ( size != ( pSegmentCurrent->nVLP * sizeof( SEGDATA_VLPTABLE ) ) )
		{
			msg(
			  "I2S: ERROR -> VLP structures size is wrong (please contact author)(trueSize: %d, shouldBeSize: %d).\n",
			  size,
			  pSegmentCurrent->nVLP * sizeof( SEGDATA_VLPTABLE )
			);
		}
		if ( size != 0 )
		{
			CopyMemory( pSymd_variables, pSegmentCurrent->pVLP, size );
			pSymd_variables += size;
		}

		//Set VLP offsets.
		( (SEGMENTDATA*)pSymd )->offVLPOffsets = pSymd_variables - pSymd;

		size = (char*)pSegmentCurrent->pVLPOffsets_current - (char*)pSegmentCurrent->pVLPOffsets;
		//Test if everything is ok.
		if ( size != ( pSegmentCurrent->nVLP * sizeof( unsigned long ) ) )
		{
			msg(
			  "I2S: ERROR -> VLP offsets size is wrong (please contact author)(trueSize: %d, shouldBeSize: %d).\n",
			  size,
			  pSegmentCurrent->nVLP * sizeof( unsigned long )
			);
		}
		if ( size != 0 )
		{
			CopyMemory( pSymd_variables, pSegmentCurrent->pVLPOffsets, size );
			pSymd_variables += size;
		}

	//Update.
		pSymd += sizeof( SEGMENTDATA );
		pSegmentCurrent = pSegmentCurrent->pNext;
	}

//Set 'Source files definitions'.
	if ( includeSource == TRUE )
	{
		BOOL sourceIsAppended;

	//Initialize.
		nSourceFiles = sourceNetNode.long_value();
		pSymd = sections.pSymd + sizeof( SYMD_HEADER );
		nEnabledSourceFiles = ( (SEGMENTDATA_HEADER*)pSymd )->nSourceFiles;

		if ( ( i2s.creationFlags & CN_T_INCLUDESOURCE ) != 0 )
		{
			sourceIsAppended = TRUE;
		}
		else
		{
			sourceIsAppended = FALSE;
		}

	//Set data.
		for ( ulong i = 0; i < nSourceFiles; i++ )
		{
		//Have we found all the enabled source files?
			if ( nEnabledSourceFiles == 0 )
			{
			//Yes we have.
				break;
			}

		//Get source file information.
			if ( -1 == sourceNetNode.supval( i, &sourceInfo, sizeof( sourceInfo ), stag ) )
			{
				msg( "I2S: Serious error: failed to retrive source file information.\n" );
				return STATUS_FAILED;
			}

		//Copy required data.
			if ( sourceInfo.enable_source == TRUE )
			{
			//Fix values if needed.
			//
			//If source files are not appended at the end of the NMS database
			//then we must clear offSource and sourceLength variables.
			//
			//But we will not update the netnode as we will need those values later.
				if ( sourceIsAppended == FALSE )
				{
					sourceInfo.sourceFile.offSource = 0;
					sourceInfo.sourceFile.sourceLength = 0;
				}

			//Copy data.
				size = sizeof( SEGDATA_SOURCEFILE );
				CopyMemory( pSymd_variables, &sourceInfo.sourceFile, size );
				pSymd_variables += size;

			//Update.
				--nEnabledSourceFiles;
			}
		}
	}

//Free symd data -> we'll need a lot of memory for other sections.
//
//Free memory from first to last.
	while ( pSegments != NULL )
	{
	//Was memory allocated in this segment?
		if ( pSegments->hMemory != NULL )
		{
			LocalFree( pSegments->hMemory );
		}

	//Go to next segment.
		pSegmentCurrent = pSegments->pNext;
		LocalFree( pSegments );
		pSegments = pSegmentCurrent;
		--nSegmentsPresent;
	}
	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Set whole file.
//
// return -  Memory pointer to mappedFile or STATUS_FAILED.
//
STATUS ida2softice_c::SetSection_NM32(void)
{
	unsigned long	align;
	char			inputFile[MAX_PATH];
	char*			pNms;
	BOOL			sourceIsAppended;

	unsigned long	offset_nmtp;
	unsigned long	offset_sttb;
	unsigned long	offset_tytb;
	unsigned long	offset_hsht;
	unsigned long	offset_symd;
	unsigned long	offset_fpod;
	unsigned long	offset_srcp;
	unsigned long	offset_gtyp;
	unsigned long	offset_nmdr;

	unsigned long	size_full;
	unsigned long	size_nms_core;
	unsigned long	size_nmtp;
	unsigned long	size_sttb;
	unsigned long	size_tytb;
	unsigned long	size_hsht;
	unsigned long	size_symd;
	unsigned long	size_sourceListing = 0;

//Is source appended?
	if ( ( i2s.creationFlags & CN_T_INCLUDESOURCE ) != 0 )
	{
		sourceIsAppended = TRUE;
	}
	else
	{
		sourceIsAppended = FALSE;
	}

//Get sections size and calculate the size of the nms database.
	size_nmtp = ( (NMTP_HEADER*)sections.pNmtp )->sectionLength;
	size_sttb = ( (STTB_HEADER*)sections.pSttb)->sectionLength;
		//Do we have any types.
	if ( ((TYTB_HEADER*)sections.pTytb )->nTypes != 0 )
	{
		size_tytb = ( (TYTB_HEADER*)sections.pTytb )->sectionLength;
		size_hsht = ( (HSHT_HEADER*)sections.pHsht )->sectionLength;
		size_nms_core = sizeof( NMDE_S ) * 8;
	}
	else
	{
		size_tytb = 0;
		size_hsht = 0;
		size_nms_core = sizeof( NMDE_S ) * 6;
	}
	size_symd = ( (SYMD_HEADER*)sections.pSymd )->sectionLength;

	if ( sourceIsAppended == TRUE )
	{
	//Add the source listing.
		size_sourceListing = source.pSource_current - source.pSource;

	//Fix the size for DWORD alignment.
		align = 0x00000003 & size_sourceListing;
		if ( align != 0 )
		{
			size_sourceListing += 4 - align;
		}
	}

	//Get size of whole nms database.
	size_nms_core +=
	  sizeof( NM32_HEADER )
	  +
	  size_nmtp
	  +
	  size_sttb
	  +
	  size_tytb
	  +
	  size_hsht
	  +
	  size_symd
	  +
	  sizeof( FPOD_HEADER )
	  +
	  sizeof( SRCP_HEADER )
	  +
	  sizeof( GTYP_HEADER )
	  +
	  sizeof( NMDR_HEADER )
	  +
	  sizeof( unsigned long );	//NRDS string

	size_full = size_nms_core + size_sourceListing;

//Allocate memory.
	pNms = (char*) LocalAlloc( LPTR, size_full );
	if ( pNms == NULL )
	{
		msg( "I2S: Failed to allocate memory(SetSection_NM32).\n" );
		return STATUS_FAILED;
	}
	sections.pNms = pNms;

//Set nms database.
//
//Skip NM32_HEADER we'll set it the last.
	pNms += sizeof( NM32_HEADER );

//Set NMTP.
	offset_nmtp = sizeof( NM32_HEADER );
	( (GTYP_HEADER*)sections.pGtyp )->offNMTP = offset_nmtp;
	//Copy memory.
	CopyMemory( pNms, sections.pNmtp, size_nmtp );
	pNms += size_nmtp;

//Set STTB.
	offset_sttb = offset_nmtp + size_nmtp;
	( (GTYP_HEADER*)sections.pGtyp )->offSTTB = offset_sttb;
	//Copy memory.
	CopyMemory( pNms, sections.pSttb, size_sttb );
	pNms += size_sttb;

//Set TYTB and HSHT.
	offset_tytb = offset_sttb + size_sttb;
	offset_hsht = offset_tytb + size_tytb;

	if ( size_tytb != 0 )
	{
	//Set TYTB.
		( (GTYP_HEADER*)sections.pGtyp)->offTYTB = offset_tytb;
		//Update TYTB section.
		( (TYTB_HEADER*)sections.pTytb)->offTypeTables += offset_tytb;
		//Copy memory.
		CopyMemory( pNms, sections.pTytb, size_tytb );
		pNms += size_tytb;

	//Set HSHT.
		( (GTYP_HEADER*)sections.pGtyp )->offHSHT = offset_hsht;
		//Update HSHT section.
		( (HSHT_HEADER*)sections.pHsht )->offTableOffsets += offset_hsht;
		( (HSHT_HEADER*)sections.pHsht )->offTypeTables += offset_hsht;
		//Copy memory.
		CopyMemory( pNms, sections.pHsht, size_hsht );
		pNms += size_hsht;
	}

//Set SYMD.
	offset_symd = offset_hsht + size_hsht;
	//Update SYMD section.
	( (SYMD_HEADER*)sections.pSymd )->offSegmentData_header += offset_symd;
	//Copy memory.
	CopyMemory( pNms, sections.pSymd, size_symd );
	pNms += size_symd;

//Set FPOD.
	offset_fpod = offset_symd + size_symd;
	//Copy memory.
	CopyMemory( pNms, sections.pFpod, sizeof( FPOD_HEADER ) );
	pNms += sizeof( FPOD_HEADER );

//Set SRCP.
	offset_srcp = offset_fpod + sizeof( FPOD_HEADER );
	//Update section.
	if ( sourceIsAppended == TRUE )
	{
	//Source is appended at the end of the file.
		( (SRCP_HEADER*)sections.pSrcp )->offSourceFiles = size_nms_core;
	}
	else
	{
	//Source is appended at the end of the file.
		( (SRCP_HEADER*)sections.pSrcp )->offSourceFiles = 0;
	}
	//Copy memory.
	CopyMemory( pNms, sections.pSrcp, sizeof( SRCP_HEADER ) );
	pNms += sizeof( SRCP_HEADER );

//Set GTYP.
	offset_gtyp = offset_srcp + sizeof( SRCP_HEADER );
	//Copy memory.
	CopyMemory( pNms, sections.pGtyp, sizeof( GTYP_HEADER ) );
	pNms += sizeof( GTYP_HEADER );

//Set NMDR.
	offset_nmdr = offset_gtyp + sizeof( GTYP_HEADER );

	//Set NMDR_HEADER.
	( (NMDR_HEADER*)pNms )->NMDR = NMDRs;
		//Do we have any types defined?
	if ( size_tytb != 0 )
	{
	//Yes we have types defined -> include TYTP and HSHT sections into nms database.
		( (NMDR_HEADER*)pNms )->nNMDE = 8;
	}
	else
	{
	//No we don't have any types defined -> exclude TYTP and HSHT sections from nms database.
		( (NMDR_HEADER*)pNms )->nNMDE = 6;
	}
	( (NMDR_HEADER*)pNms )->offGTYP = offset_gtyp;
	( (NMDR_HEADER*)pNms )->offSTTB = offset_sttb;
	( (NMDR_HEADER*)pNms )->offSYMD = offset_symd;
	( (NMDR_HEADER*)pNms )->offSRCP = offset_srcp;
	( (NMDR_HEADER*)pNms )->offFPOD = offset_fpod;
	pNms += sizeof( NMDR_HEADER );

	//Set NMDEs.
		//NMTP
	( (NMDE_S*)pNms )->NMDE = NMDEs;
	( (NMDE_S*)pNms )->entryIndex = INDEX_NMTP;
	( (NMDE_S*)pNms )->offEntry = offset_nmtp;
	( (NMDE_S*)pNms )->entryLength = size_nmtp;
	pNms += sizeof( NMDE_S );
		//STTB
	( (NMDE_S*)pNms )->NMDE = NMDEs;
	( (NMDE_S*)pNms )->entryIndex = INDEX_STTB;
	( (NMDE_S*)pNms )->offEntry = offset_sttb;
	( (NMDE_S*)pNms )->entryLength = size_sttb;
	pNms += sizeof( NMDE_S );
		//TYTB and HSHT.
		//Do we have any types defined?
	if ( size_tytb != 0 )
	{
	//TYTB
		( (NMDE_S*)pNms )->NMDE = NMDEs;
		( (NMDE_S*)pNms )->entryIndex = INDEX_TYTB;
		( (NMDE_S*)pNms )->offEntry = offset_tytb;
		( (NMDE_S*)pNms )->entryLength = size_tytb;
		pNms += sizeof( NMDE_S );

	//HSHT
		( (NMDE_S*)pNms )->NMDE = NMDEs;
		( (NMDE_S*)pNms )->entryIndex = INDEX_HSHT;
		( (NMDE_S*)pNms )->offEntry = offset_hsht;
		( (NMDE_S*)pNms )->entryLength = size_hsht;
		pNms += sizeof( NMDE_S );
	}
		//SYMD
	( (NMDE_S*)pNms )->NMDE = NMDEs;
	( (NMDE_S*)pNms )->entryIndex = INDEX_SYMD;
	( (NMDE_S*)pNms )->offEntry = offset_symd;
	( (NMDE_S*)pNms )->entryLength = size_symd;
	pNms += sizeof( NMDE_S );
		//FPOD
	( (NMDE_S*)pNms )->NMDE = NMDEs;
	( (NMDE_S*)pNms )->entryIndex = INDEX_FPOD;
	( (NMDE_S*)pNms )->offEntry = offset_fpod;
	( (NMDE_S*)pNms )->entryLength = sizeof( FPOD_HEADER );
	pNms += sizeof( NMDE_S );
		//SRCP
	( (NMDE_S*)pNms )->NMDE = NMDEs;
	( (NMDE_S*)pNms )->entryIndex = INDEX_SRCP;
	( (NMDE_S*)pNms )->offEntry = offset_srcp;
	( (NMDE_S*)pNms )->entryLength = sizeof( SRCP_HEADER );
	pNms += sizeof( NMDE_S );
		//GTYP
	( (NMDE_S*)pNms )->NMDE = NMDEs;
	( (NMDE_S*)pNms )->entryIndex = INDEX_GTYP;
	( (NMDE_S*)pNms )->offEntry = offset_gtyp;
	( (NMDE_S*)pNms )->entryLength = sizeof( GTYP_HEADER );
	pNms += sizeof( NMDE_S );
		//NRDS
	*( (unsigned long*)pNms ) = NRDSs;
	if ( sourceIsAppended == TRUE )
	{
		pNms += sizeof( unsigned long );

	//Copy source listing.
		CopyMemory( pNms, source.pSource, size_sourceListing );
	}

//Set NM32_HEADER all the data we need now.
	pNms = sections.pNms;

	( (NM32_HEADER*)pNms )->NM32 = NM32s;
	( (NM32_HEADER*)pNms )->verMajor = NM32_DATABASE_MAJOR_VERSION;
	( (NM32_HEADER*)pNms )->verMinor = NM32_DATABASE_MINOR_VERSION;
	( (NM32_HEADER*)pNms )->offNMDR = offset_nmdr;
	( (NM32_HEADER*)pNms )->creationTime = time(NULL);
	( (NM32_HEADER*)pNms )->creationFlags = creationFlags;
	//What kind of type is the original file.
	get_input_file_path( inputFile, sizeof( inputFile ) );
	if ( inf.filetype == f_PE )
	{
	//It's PE type -> exe or dll.
		if (
		  ( NULL != strstr( inputFile, ".exe" ) )
		  ||
		  ( NULL != strstr( inputFile, ".EXE" ) )
		)
		{
		//It's exe.
			( (NM32_HEADER*)pNms )->fileType = FT_PEEXE;
		}
		else
		{
		//It's dll type -> dll, sys,...
			( (NM32_HEADER*)pNms )->fileType = FT_PEDLL;
		}
	}
	else if ( inf.filetype==f_LE )
	{
		( (NM32_HEADER*)pNms )->fileType = FT_LEVXD;
	}
	( (NM32_HEADER*)pNms )->fileLength = size_nms_core;
	if ( sourceIsAppended == TRUE )
	{
		sections.fullFileSize = size_nms_core + size_sourceListing;
	}
	else
	{
		sections.fullFileSize = size_nms_core;
	}
	qstrncpy(
	  (char*)( &( (NM32_HEADER*)pNms )->filePath ),
	  inputFile,
	  sizeof( ( (NM32_HEADER*)pNms )->filePath )
	);
	qstrncpy(
	  (char*)( &( (NM32_HEADER*)pNms )->copyrightString ),
	  copyright,
	  sizeof( ( (NM32_HEADER*)pNms )->copyrightString )
	);

	return STATUS_SUCCESS;
}


