//  IDA to SoftIce and NMTrans common definitions
//
//  Author: Mostek
//   mail:  mostekaccess@mailcity.com
#ifndef _I2S__SECTIONS
#define _I2S__SECTIONS
#pragma pack(push, 1)

//Created sections
struct SECTIONS_S
{
	char*					pNms;
	unsigned long			fullFileSize;
	char*					pNmtp;
	char*					pSttb;
	char*					pTytb;
	char*					pHsht;
	char*					pSymd;
	char*					pFpod;	//on stack
	char*					pSrcp;	//on stack
	char*					pGtyp;	//on stack
};

//NMTP
struct NMTP_S
{
	HLOCAL					hTypesData;
	HLOCAL					hTypesOffsets;

	unsigned char*			pTypesData;
	unsigned char*			pTypesData_current;
	unsigned long			freeData;
	unsigned long			sizeData;

	unsigned long*			pTypesOffsets;
	unsigned long*			pTypesOffsets_current;
	unsigned long			freeOffsets;
	unsigned long			sizeOffsets;

	unsigned long			nTypes;
};

//STTB
struct	STTB_S
{
	HLOCAL					hStrings;
	HLOCAL					hOffsets;

	char*					pStrings;
	char*					pStrings_current;
	unsigned long			freeStrings;
	unsigned long			sizeStrings;

	unsigned long*			pOffsets;
	unsigned long*			pOffsets_current;
	unsigned long			freeOffsets;
	unsigned long			sizeOffsets;

	unsigned long			nStrings;

//A simple hash test to speed up string searching.
	HLOCAL					hHash;

	unsigned long*			pHash;
	unsigned long*			pHash_current;
	unsigned long			freeHash;
	unsigned long			sizeHash;
};

//typesData:
//|---------------------------|              |
//|local label                | type: 0x1000 |
//|---------------------------|              |
//|local procedure(arglist=0) | type: 0x1001 |  this two are predefined in i2s plugIn
//|---------------------------|              |
//
//Local procedure(near pascal): pushed data is defined as local variable => arglist = 0.
//TYTB
struct TYTB_S
{
	HLOCAL					hTypeTables;

	TYPETABLE*				pTypeTables;
	TYPETABLE*				pTypeTables_current;
	unsigned long			freeTypeTables;
	unsigned long			sizeTypeTables;

	unsigned long			nTypeTables;
};

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
struct HSHT_S
{
	HLOCAL					hHashTables;

	HSHT_TYPETABLE*			pHashTables;
	HSHT_TYPETABLE*			pHashTables_current;
	unsigned long			freeHashTables;
	unsigned long			sizeHashTables;
	unsigned long			nHashTables;

	unsigned long			currentOffset;

	unsigned long			hashOffsets[0x25];
};

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//SYMD 
struct SEGMENT_DATA
{
//Pointer to next segment.
	SEGMENT_DATA*			pNext;
	SEGMENT_DATA*			pPrevious;

//Is current segment part of IDA segment or is it a representation of a file segment
//Why? IDA trows out some segments.
	WORD					includedInIDA;	//use BOOL defines on this one

//Does this segment data struct represent more than one IDA segment?
//(IDA can made more segments from one.)
	WORD					nOfIDAsSegments;
	unsigned long			segmentIndexInIDA;	//of the first one

//Common segment data.
	unsigned long			nSeg;
	unsigned long			iName;
	unsigned long			physSize;   //set when includedInIDA = FALSE, else you should
	ea_t					startEA;    //get it from endEA - startEA
	ea_t					endEA;

//-------------------------------
//Memory.
	HLOCAL					hMemory;
	char*					pEnd;

//-------------------------------
//Procedure definitions
//
//Notice:
//pProcDefinitions will have the memory handle for allocated memory.
//I2S allocates one big chunk for all the resources.
	SEGDATA_PROCEDURE_V2*	pProcDefinitions;
	SEGDATA_PROCEDURE_V2*	pProcDefinitions_current;
	unsigned long			nProcDefinitions;

//-------------------------------
//EBP based local parameters
	SEGDATA_VLPTABLE*		pLocalVariables;
	SEGDATA_VLPTABLE*		pLocalVariables_current;
	unsigned long			nLocalVariables;
	unsigned long			offsetLVarCurrent;	//current offset in localVariables buffer

//-------------------------------
//Local register variables
	SEGDATA_REGISTER*		pRegisters;
	SEGDATA_REGISTER*		pRegisters_current;
	unsigned long			nRegisters;
	unsigned long			offsetRVarCurrent;	//current offset in registerVariables buffer

//-------------------------------
//Source lines tables
	SEGDATA_SOURCELINES*	pSourceLines;
	SEGDATA_SOURCELINES*	pSourceLines_current;
	unsigned long			nSourceLines;
#define MAX_SOURCE_LINES_PER_FILE		0x1000

//-------------------------------
//VLP definitions
	SEGDATA_VLPTABLE*		pVLP;
	SEGDATA_VLPTABLE*		pVLP_current;

	unsigned long*			pVLPOffsets;
	unsigned long*			pVLPOffsets_current;

	unsigned long			nVLP;
};

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//This structure contains IDA listing.
struct SOURCE_S
{
	HLOCAL					hSource;

	char*					pSource;
	char*					pSource_current;
	unsigned long			freeSource;
	unsigned long			sizeSource;
};

#pragma pack(pop)
#endif //_I2S__SECTIONS
