//
//  PlugIn name: IDA to SoftIce converter (only for 32bit programs)
//
//
//  This file contains functions that are intended for communicating with SoftIce.
//
//
#include "i2s.h"

//--------------------------------------------------------------------------
//Get the protected SIce path (for using with CreateFile). 
//
// name - On output it containts protected CreateFile name.
//
//return : STATUS_SUCCESS/STATUS_FAILED
STATUS ida2softice_c::GetSIceProtectedPath( char* pRetPath, size_t pathLength )
{
	HKEY	hKeyNumega;
	char	revSerial[64] = "\x0";

//Get registry handle to SoftIces directory.
	hKeyNumega = GetRegistryKey(
	  HKEY_LOCAL_MACHINE,
	  "SOFTWARE\\Numega\\SoftIce",
	  KEY_QUERY_VALUE,
	  I2S_REG_TYPE_OPEN
	);

//Create protected path.
	if ( S_SUCCESS( hKeyNumega ) )
	{
	//Get serial.
		GetRegistryValue( hKeyNumega, "Serial", (char*)&revSerial, 64 );
		CloseRegistryKey( hKeyNumega );

	//Create protected sice path.
		qstrncpy( pRetPath, "\\\\.\\NTICE", pathLength );
		char*	pAddProtection = pRetPath + strlen( pRetPath );

		strrev( revSerial );
		int revSerialLength = strlen( revSerial );

		int i = 2;
		while ( i < revSerialLength )
		{
			if ( 0 != isalnum( revSerial[i] ) )
			{
				*pAddProtection = revSerial[i];
				++pAddProtection;
				*pAddProtection = '\x0';
			}

		//Update.
			i += 2;
			if ( i > 8 )
			{
				break;
			}
		}
	}
	else
	{
		msg( "I2S: Failed to get SoftIce protected path -> this wont stop the plugIn.\n" );
		return STATUS_FAILED;
	}
	return STATUS_SUCCESS;
}

//--------------------------------------------------------------------------
//Load mapped nms file to Softice.
//
// pNmsMapped - Pointer to mapped nms file in memory.
//
// return - STATUS_SUCCESS/STATUS_FAILED
//
STATUS ida2softice_c::LoadNMSFile( NM32_HEADER* pNmsMapped, unsigned long fullFileSize )
{
	HANDLE		hSoftIce;
	BOOL		retValue = FALSE;

//Get handle to SoftIce.
	hSoftIce = CreateFile(
	  (char*)&sicePath,
	  GENERIC_READ,
	  FILE_SHARE_READ | FILE_SHARE_WRITE,
	  NULL,
	  OPEN_EXISTING,
	  FILE_ATTRIBUTE_NORMAL,
	  0
	);
	if ( hSoftIce != INVALID_HANDLE_VALUE )
	{
		char			fileName[MAX_PATH];
		MODULE_INFO		moduleInfo;
		unsigned long	bytesReturned;

	//We got the access -> load file to SoftIce.
	//
	//Get the name of the file to load and fill load structure.
		get_root_filename( fileName, sizeof( fileName ) );
		( strstr( fileName, "." ) )[0]='\x0';		//we want only name

		moduleInfo.pModuleName = fileName;
		moduleInfo.pMappedFile = pNmsMapped;
		moduleInfo.fileSize = fullFileSize;
		moduleInfo.pSourceCode = NULL;
		moduleInfo.sourceLength = NULL;
		
	//Send the data to SIce.
		retValue = DeviceIoControl(
		  hSoftIce,
		  0x9C406004,
		  &moduleInfo,
		  sizeof( MODULE_INFO ),
		  NULL,
		  NULL,
		  &bytesReturned,
		  NULL
		);
		if ( retValue == FALSE )
		{
		//I2S failed to send the data to SoftIce.
		//
		//Get error message from SoftIce.
			GET_SOFTICE_ERROR	errorInfo;

			errorInfo.number = 0xA1530003;
			errorInfo.pErrorBuffer = fileName;
			errorInfo.bufferSize = MAX_PATH;
			DeviceIoControl(
			  hSoftIce,
			  0x9C406014,
			  &errorInfo,
			  sizeof( GET_SOFTICE_ERROR ),
			  NULL,
			  NULL,
			  &bytesReturned,
			  NULL
			);
			msg( "I2S: SoftIce ERROR: %s\n", fileName );
		}
	//Close opened resources.
		CloseHandle( hSoftIce );
	}
	if ( retValue == FALSE )
	{
		return STATUS_FAILED;
	}
	return STATUS_SUCCESS;
}

