/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.hook;

import com.aspect.snoop.FunctionHook;
import com.aspect.snoop.agent.SnoopAgent;
import com.aspect.snoop.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FunctionsHookedTableModel
extends AbstractTableModel {
    private static String[] columnNames = new String[]{"Enabled", "Class/Method", "Inheritable"};
    private static Class[] columnTypes = new Class[]{Boolean.class, String.class, Boolean.class};
    List<FunctionHook> hooks = new ArrayList<FunctionHook>();

    public FunctionsHookedTableModel(List<FunctionHook> hooks) {
        if (hooks != null) {
            this.hooks = hooks;
        }
    }

    @Override
    public int getRowCount() {
        if (this.hooks == null) {
            return 0;
        }
        return this.hooks.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return true;
        }
        if (columnIndex == 2) {
            FunctionHook hook = this.getHookFromRow(rowIndex);
            return !ReflectionUtil.isInterfaceOrAbstract(hook.getClazz());
        }
        return false;
    }

    public FunctionHook getHookFromRow(int rowIndex) {
        if (rowIndex > this.hooks.size() || rowIndex < 0) {
            return null;
        }
        return this.hooks.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FunctionHook hook = this.hooks.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return hook.isEnabled();
            }
            case 1: {
                String methodSignature = " " + hook.getClazz().getName();
                methodSignature = methodSignature + "." + hook.getMethodName() + "(";
                for (Class param : hook.getParameterTypes()) {
                    methodSignature = methodSignature + param.getSimpleName() + ", ";
                }
                if (hook.getParameterTypes().length > 0) {
                    methodSignature = methodSignature.substring(0, methodSignature.length() - 2);
                }
                methodSignature = methodSignature + ")";
                return methodSignature;
            }
            case 2: {
                return hook.isAppliedToSubtypes();
            }
        }
        return null;
    }

    public void setHooks(List<FunctionHook> functionHooks) {
        this.hooks = functionHooks;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        FunctionHook hook = this.hooks.get(rowIndex);
        if (columnIndex == 0) {
            hook.setEnabled((Boolean)aValue);
        } else if (columnIndex == 2) {
            hook.setApplyToSubtypes((Boolean)aValue);
        }
        SnoopAgent.getMainView().sendAgentNewRules();
    }

    public void disableAll() {
        for (int i = 0; i < this.hooks.size(); ++i) {
            FunctionHook hook = this.hooks.get(i);
            hook.setEnabled(false);
        }
    }

    public void enableAll() {
        for (int i = 0; i < this.hooks.size(); ++i) {
            FunctionHook hook = this.hooks.get(i);
            hook.setEnabled(true);
        }
    }

    public void removeHook(FunctionHook hook) {
        this.hooks.remove(hook);
    }
}

