/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.agent.manager;

import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.agent.manager.ClassHistory;
import com.aspect.snoop.agent.manager.InstrumentationException;
import com.aspect.snoop.agent.manager.LocalVariable;
import com.aspect.snoop.agent.manager.MethodChanges;
import com.aspect.snoop.agent.manager.SmartURLClassPath;
import com.aspect.snoop.util.ReflectionUtil;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public class InstrumentationManager {
    private HashMap<Integer, ClassHistory> modifiedClasses;
    private Instrumentation inst;
    private List<ClassLoader> classloaders;
    HashMap<URL, SmartURLClassPath> urlSources;
    Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

    public List<String> getLoadedClassesAsStrings() {
        ArrayList<String> classes = new ArrayList<String>();
        for (Class c : this.inst.getAllLoadedClasses()) {
            if (c.isArray() || c.isPrimitive() || c.isSynthetic()) continue;
            classes.add(c.getName());
        }
        return classes;
    }

    public List<Class> getLoadedClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Class c : this.inst.getAllLoadedClasses()) {
            if (c.isArray() || c.isPrimitive() || c.isSynthetic()) continue;
            classes.add(c);
        }
        return classes;
    }

    public InstrumentationManager(Instrumentation inst) {
        this.inst = inst;
        this.modifiedClasses = new HashMap();
        this.classloaders = new ArrayList<ClassLoader>();
        this.urlSources = new HashMap();
        this.updateClassPool();
    }

    public List<URL> getCodeSourceURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL u : this.urlSources.keySet()) {
            urls.add(u);
        }
        return urls;
    }

    public final void updateClassPool() {
        ClassPool classPool = ClassPool.getDefault();
        for (Class c : this.inst.getAllLoadedClasses()) {
            ClassLoader cl;
            CodeSource cs = c.getProtectionDomain().getCodeSource();
            if (cs != null && cs.getLocation() != null) {
                URL url = cs.getLocation();
                SmartURLClassPath cp = this.urlSources.get(url);
                if (cp == null) {
                    cp = new SmartURLClassPath(url);
                    this.urlSources.put(url, cp);
                    classPool.appendClassPath((ClassPath)cp);
                    AgentLogger.debug("Adding " + url.toExternalForm() + " to classpath lookup");
                }
                cp.addClass(c.getName());
            }
            if ((cl = c.getClassLoader()) == null || this.classloaders.contains(cl)) continue;
            this.classloaders.add(cl);
            classPool.insertClassPath((ClassPath)new LoaderClassPath(cl));
        }
    }

    public boolean hasClassBeenModified(String clazz) throws ClassNotFoundException {
        return this.hasClassBeenModified(Class.forName(clazz));
    }

    public boolean hasClassBeenModified(Class c) {
        return this.modifiedClasses.get(c.hashCode()) != null;
    }

    public void resetClass(Class clazz) throws ClassNotFoundException, UnmodifiableClassException {
        ClassHistory history = this.modifiedClasses.get(clazz.hashCode());
        if (history != null) {
            ClassDefinition def = new ClassDefinition(clazz, history.getOriginalClass());
            this.inst.redefineClasses(def);
            this.modifiedClasses.remove(clazz.hashCode());
        }
    }

    public void ensureClassIsLoaded(String clazz, ClassLoader loader) throws ClassNotFoundException {
        Class.forName(clazz, true, loader);
    }

    public void deinstrument(Class clazz) throws InstrumentationException {
        ClassHistory history = this.modifiedClasses.get(clazz.hashCode());
        try {
            if (history == null) {
                throw new InstrumentationException("Class to deinstrument '" + clazz.getName() + "' not found in history");
            }
            ClassDefinition definition = new ClassDefinition(clazz, history.getOriginalClass());
            this.inst.redefineClasses(definition);
            AgentLogger.debug("Just de-instrumented " + clazz.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstrumentationException(cnfe);
        }
        catch (UnmodifiableClassException cnfe) {
            throw new InstrumentationException(cnfe);
        }
    }

    public void instrument(Class clazz, MethodChanges[] methodChanges) throws InstrumentationException {
        try {
            ClassPool classPool = ClassPool.getDefault();
            CtClass cls = classPool.get(clazz.getName());
            ClassHistory ch = this.modifiedClasses.get(clazz.hashCode());
            byte[] originalByteCode = null;
            byte[] lastVersionByteCode = null;
            if (ch != null) {
                originalByteCode = ch.getOriginalClass();
                AgentLogger.trace("Restoring saved bytes for " + clazz.getName() + " (" + InstrumentationManager.md5(originalByteCode) + ")");
                ClassPool cp = new ClassPool(classPool);
                cp.childFirstLookup = true;
                cp.insertClassPath((ClassPath)new ByteArrayClassPath(clazz.getName(), originalByteCode));
                cls = cp.get(clazz.getName());
                cp.childFirstLookup = false;
                AgentLogger.trace("Retrieved bytes after save: " + InstrumentationManager.md5(cls.toBytecode()));
                lastVersionByteCode = ch.getCurrentClass();
            } else {
                originalByteCode = cls.toBytecode();
                AgentLogger.trace("Instrumenting new class " + clazz.getName() + " (" + InstrumentationManager.md5(originalByteCode) + ")");
                lastVersionByteCode = originalByteCode;
            }
            cls.defrost();
            for (MethodChanges change : methodChanges) {
                AccessibleObject methodToChange = change.getMethod();
                Class[] parameterTypes = ReflectionUtil.getParameterTypes(methodToChange);
                CtClass[] classes = new CtClass[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    classes[i] = classPool.get(parameterTypes[i].getName());
                }
                String methodName = null;
                methodName = methodToChange instanceof Method ? ((Method)methodToChange).getName() : "<init>";
                Object method = null;
                method = "<init>".equals(methodName) ? cls.getDeclaredConstructor(classes) : cls.getDeclaredMethod(methodName, classes);
                LocalVariable[] newVars = change.getNewLocalVariables();
                for (int i = 0; i < newVars.length; ++i) {
                    LocalVariable newVar = newVars[i];
                    method.addLocalVariable(newVar.getName(), newVar.getType());
                }
                AgentLogger.trace("Adding to class " + clazz.getName());
                if (change.getNewStartSrc().length() > 0) {
                    AgentLogger.trace("Compiling code at beginnging of function:");
                    AgentLogger.trace(change.getNewStartSrc());
                    method.insertBefore(" { " + change.getNewStartSrc() + " } ");
                }
                if (change.getNewEndSrc().length() > 0) {
                    AgentLogger.trace("Compiling code for end of function:");
                    AgentLogger.trace(change.getNewEndSrc());
                    method.insertAfter(" { " + change.getNewEndSrc() + " } ");
                }
                AgentLogger.debug("Done bytecode modification for " + clazz.getName());
            }
            byte[] newByteCode = cls.toBytecode();
            ClassDefinition definition = new ClassDefinition(clazz, newByteCode);
            try {
                this.inst.redefineClasses(definition);
            }
            catch (VerifyError error) {
                // empty catch block
            }
            ClassHistory history = new ClassHistory(clazz, originalByteCode, newByteCode);
            history.setLastClass(lastVersionByteCode);
            this.modifiedClasses.put(clazz.hashCode(), history);
        }
        catch (UnmodifiableClassException uce) {
            throw new InstrumentationException(uce);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstrumentationException(cnfe);
        }
        catch (IOException ioe) {
            throw new InstrumentationException(ioe);
        }
        catch (CannotCompileException cce) {
            throw new InstrumentationException((Exception)((Object)cce));
        }
        catch (NotFoundException nfe) {
            throw new InstrumentationException((Exception)((Object)nfe));
        }
    }

    public byte[] getClassBytes(String clazz) {
        try {
            byte[] bytes = this.classBytes.get(clazz);
            if (bytes != null) {
                return bytes;
            }
            CtClass cls = ClassPool.getDefault().get(clazz);
            bytes = cls.toBytecode();
            this.classBytes.put(clazz, bytes);
            return bytes;
        }
        catch (IOException ex) {
        }
        catch (CannotCompileException ex) {
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    public Class getFromAllClasses(String className) throws ClassNotFoundException {
        Class[] allClasses;
        for (Class c : allClasses = this.inst.getAllLoadedClasses()) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        try {
            Class<?> cls = Class.forName(className);
            return cls;
        }
        catch (Throwable throwable) {
            throw new ClassNotFoundException(className);
        }
    }

    public Class getFromAllClasses(int hash) throws ClassNotFoundException {
        Class[] allClasses;
        for (Class c : allClasses = this.inst.getAllLoadedClasses()) {
            if (c.hashCode() != hash) continue;
            return c;
        }
        throw new ClassNotFoundException("For hash: " + hash);
    }

    public void resetAllClasses() throws InstrumentationException {
        for (Integer i : this.modifiedClasses.keySet()) {
            try {
                Class c = this.getFromAllClasses(i);
                this.deinstrument(c);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public static String md5(byte[] bytes) {
        String res = "";
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(bytes);
            byte[] md5 = algorithm.digest();
            String tmp = "";
            for (int i = 0; i < md5.length; ++i) {
                tmp = Integer.toHexString(0xFF & md5[i]);
                res = tmp.length() == 1 ? res + "0" + tmp : res + tmp;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return res;
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classloaders;
    }
}

