// Labeler by DokoDon (dokodon@hotmail.com)

// VERY IMPORTANT NOTICE: COMPILE THIS DLL WITH BYTE ALIGNMENT OF STRUCTURES
// AND UNSIGNED CHAR!

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>

#include <odbg\plugin.h>
#include "resource.h"

#define NAMELEN 32
#define TYPELEN 16

#define LBL_MAKELABEL       0
#define LBL_DELETELABEL     1
#define LBL_EDITSTRUCTDEF   2
#define LBL_RELOADSTRUCTDEF 3
#define LBL_ABOUT           63


typedef struct {
  char Name[NAMELEN];
  char Type[TYPELEN];
  int  Index;
  char szIndex[8];
  char Address[16];
  int  Number;
  char szNumber[16];
  int  Align;
  char szAlign[4];
} LBLLABELDEF,*LPLBLLABELDEF;

#define NUM_DEC  1
#define NUM_HEX  2

#define PNAME   "Labeler"
#define PVERS   "v1.33.108"
#define ANAME   "Gigapede"

#ifndef min
#define min(a,b)  (a > b) ? b : a;
#endif

LPCTSTR szStructDefFileName = "Labeler.def";
char    szPluginPath[MAX_PATH],szStructDefFile[MAX_PATH],szODini[MAX_PATH];

enum INDEXTYPE {
  DEC,
  HEX,
} indextype = HEX;

typedef struct t_type {
  char *type;
  int size;
} t_type;

static t_type typ[] = {
  {"char"     , sizeof(char)     },
  {"short"    , sizeof(short)    },
  {"int"      , sizeof(int)      },
  {"long"     , sizeof(long)     },
  {"float"    , sizeof(float)    },
  {"double"   , sizeof(double)   },
  {"CHAR"     , sizeof(CHAR)     },
  {"SHORT"    , sizeof(SHORT)    },
  {"INT"      , sizeof(INT)      },
  {"LONG"     , sizeof(LONG)     },
  {"LONGLONG" , sizeof(LONGLONG) },
  {"UCHAR"    , sizeof(UCHAR)    },
  {"TCHAR"    , sizeof(TCHAR)    },
  {"USHORT"   , sizeof(USHORT)   },
  {"UINT"     , sizeof(UINT)     },
  {"ULONG"    , sizeof(ULONG)    },
  {"BYTE"     , sizeof(BYTE)     },
  {"WORD"     , sizeof(WORD)     },
  {"DWORD"    , sizeof(DWORD)    },
  { NULL      , 0                }
};

typedef struct {
  char StructName[NAMELEN];
} LBLSTNAME,*LPLBLSTNAME;

typedef struct {
  char Name[NAMELEN];
  char Type[TYPELEN];
  int  size;
  int  ary;
} LBLSTMEMBER, *LPLBLSTMEMBER;

typedef struct {
  char Name[NAMELEN];
  int  NumOfMember;
  LPLBLSTMEMBER lpMember;
} LBLSTRUCT,*LPLBLSTRUCT;

int NumOfStruct,SelStruct;
char SelStructName[NAMELEN];
LPLBLSTNAME lpName  = NULL;
LBLSTRUCT   LmStruct;

char inipath[MAX_PATH];

HINSTANCE        hinst;                // DLL instance
HWND             hwmain;               // Handle of main OllyDbg window

INITCOMMONCONTROLSEX ic;
DWORD dwImageBase,dwSizeOfImage;
char label[NAMELEN],addr[10];
UINT number,vsize;
int  dalign;

LRESULT CALLBACK MakLblDlgProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DelLblDlgProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DelLstDlgProc(HWND, UINT, WPARAM, LPARAM);
int MakeLabel(int origin, char *addr);
int DeleteLabel(LPLBLLABELDEF lpLblInfo);
int GetSelItemInfo(HWND hList, int nItem, LPLBLLABELDEF lpLblInfo);
void RefreshLabelHist(int nItem);
BOOL LoadDefinedStructName(void);
BOOL LoadStructMember(char *);
BOOL IsValidNumber(char *, int, int);
BOOL GetPEInfo(void);
void WriteLabelHistToIni(void);

WNDPROC   DelLstDlgProcOrg;

BOOL WINAPI DllEntryPoint(HINSTANCE hi,DWORD reason,LPVOID reserved) {
  if (reason==DLL_PROCESS_ATTACH)
    hinst=hi;                          // Mark plugin instance
  return 1;                            // Report success
};

extc int _export cdecl ODBG_Plugindata(char shortname[32]) {
  strcpy(shortname,PNAME);       // Name of plugin
  return PLUGIN_VERSION;
};

extc int _export cdecl ODBG_Plugininit(int ollydbgversion,HWND hw,ulong *features) {
#ifdef DEB
  int i,j;
#endif

  char* pdest;

  if(ollydbgversion<PLUGIN_VERSION)
    return -1;
  hwmain=hw;

  GetModuleFileName(NULL, inipath, sizeof(inipath));
  pdest = strrchr(inipath, '\\');
  pdest[1] = '\0';
  SetCurrentDirectory(inipath);
  sprintf(szODini,"%s\\ollydbg.ini",inipath);
  GetPrivateProfileString("History","Plugin path",inipath,szPluginPath,sizeof(szPluginPath),szODini);
  //strcat(inipath, PNAME".ini");
  sprintf(inipath,"%s\\%s.ini",szPluginPath,PNAME);
  sprintf(szStructDefFile,"%s\\%s",szPluginPath,szStructDefFileName);


  InitCommonControlsEx(&ic);
  LoadDefinedStructName();

  Addtolist(0, 0,PNAME" "PVERS"  by "ANAME);
  return 0;
};

extc int _export cdecl ODBG_Pluginmenu(int origin,char data[4096],void *item) {
  switch (origin) {
  case PM_MAIN: // Plugin menu in main window
    strcpy(data,
           "0 &Make Label ,"
           "1 &Delete Label |"
           "2 &Edit Struct Definition ,"
           "3 &Reload Struct Definition |"
           "63 &About"
          );
    return 1;

  case PM_DISASM:
    if(Getstatus() == STAT_NONE) {
      return 0;
    }
    strcpy(data,"#0 Labeler");
    return 1;
  case PM_CPUREGS:
    if(Getstatus() == STAT_NONE) {
      return 0;
    }
    strcpy(data,"#0 Labeler");
    return 1;
  case PM_CPUDUMP:
    if(Getstatus() == STAT_NONE) {
      return 0;
    }
    strcpy(data,"#0 Labeler");
    return 1;
  default:
    break; // Any other window
  }
  return 0; // Window not supported by plugin
}

extc void _export cdecl ODBG_Pluginaction(int origin,int action,void *item) {
  t_dump *pdmp;
  //t_reg  *preg;
  t_thread *pthread;
  ulong cmdsize,decodesize;
  char cmd[MAXCMDSIZE],*pdecode;
  t_memory *pmem;
  t_disasm da;
  UINT adrs;
  int i;

  switch(origin) {
  case PM_MAIN:
    switch (action) {
    case LBL_MAKELABEL:
      if(Getstatus() == STAT_NONE) {
        return;
      }
      MakeLabel(origin, NULL);
      return;
    case LBL_DELETELABEL:
      if(Getstatus() == STAT_NONE) {
        return;
      }
      DialogBoxParam(hinst,MAKEINTRESOURCE(IDD_LABELDELETE),hwmain,(DLGPROC)DelLblDlgProc,(LPARAM)0L);
      return;
    case LBL_EDITSTRUCTDEF:
      ShellExecute(NULL,NULL,"notepad.exe",szStructDefFile,NULL,SW_SHOWNORMAL);
      return;
    case LBL_RELOADSTRUCTDEF:
      LoadDefinedStructName();
      return;
    case LBL_ABOUT:
      // Menu item "About", displays plugin info.
      MessageBox(hwmain,
                 PNAME" "PVERS
                 "\n    "
                 "by "ANAME"  ",
                 "About "PNAME"  ",
                 MB_OK|MB_ICONINFORMATION);
      return;
    default:
      break;
    }
  case PM_DISASM:
    GetPEInfo();
    memset(addr,0,sizeof(addr));
    pdmp=(t_dump *)item;
    pmem = Findmemory(pdmp->sel0);
    if(pmem == NULL){
      return;
    }
    cmdsize = pmem->base + pmem->size - pdmp->sel0;
    if(cmdsize > MAXCMDSIZE)
      cmdsize = MAXCMDSIZE;
    if(Readmemory(cmd, pdmp->sel0, cmdsize, MM_RESTORE | MM_SILENT) != cmdsize){
      return;
    }
    pdecode = Finddecode(pdmp->sel0, &decodesize);
    if(decodesize < cmdsize) {
      pdecode = NULL;
    }
    Disasm(cmd, cmdsize, pdmp->sel0, pdecode, &da, DISASM_CODE, NULL);
    for(i=0; i<3; i++) {
      if(da.op[i].optype==DEC_DWORD || da.op[i].optype==DEC_WORD || da.op[i].optype==DEC_BYTE || da.op[i].optype==DEC_PBODY) {
        wsprintf(addr,"%08X",da.op[i].opconst);
        sscanf(addr,"%X",&adrs);
        if(Findmemory(adrs) != NULL) {
          break;
        }
        /*
        if(adrs >= dwImageBase && adrs <= dwImageBase+dwSizeOfImage) {
          break;
        }
        else {
          memset(addr,0,sizeof(addr));
        }
        */
      }
    }
    if(!IsValidNumber(addr,strlen(addr),NUM_HEX)) {
      memset(addr,0,sizeof(addr));
    }
    MakeLabel(origin, addr);
    break;
  case PM_CPUREGS:
    GetPEInfo();
    memset(addr,0,sizeof(addr));
    //preg=(t_reg *)item; // <= can't get t_reg*
    //if((preg->selected & RS_GROUP) == RS_INT) {
      //wsprintf(addr,"%08X",preg->r[preg->selected&RS_INDEX]);
    pthread = Findthread(Getcputhreadid()); // <= This works. why??
    if((pthread->reg.selected & RS_GROUP) == RS_INT) {
      wsprintf(addr,"%08X",pthread->reg.r[pthread->reg.selected&RS_INDEX]);
      if(!IsValidNumber(addr,strlen(addr),NUM_HEX)) {
        memset(addr,0,sizeof(addr));
      }
    }
    //adrs = strtoul(addr,&stop,16);
    sscanf(addr,"%X",&adrs);
    if(Findmemory(adrs) != NULL) {
      MakeLabel(origin, addr);
    }
    break;
  case PM_CPUDUMP:
    pdmp=(t_dump *)item;
    Addtolist(0,-1,"in PM_CPUDUMP sel0:%08X",pdmp->sel0);
    wsprintf(addr,"%08X",pdmp->sel0);
    MakeLabel(origin, addr);
    break;
  default:
    break;
  }
  return;
}

extc void _export cdecl ODBG_Plugindestroy(void) {
  if(LmStruct.lpMember) {
    free(LmStruct.lpMember);
  }
}

void WriteLabelHistToIni(void)
{
  char *exename,buf[256],key[256];
  int i,entry;

  exename = (char*)Plugingetvalue(VAL_EXEFILENAME);
  entry = (int)GetPrivateProfileInt(exename, "entry", 0, inipath);

  for(i=0; i<entry; i++) {
    wsprintf(key,"Address%d",i);
    GetPrivateProfileString(exename,key,"0",buf,sizeof(buf),inipath);
    if(!strcmp(buf,addr)) {
      Addtolist(0,-1,"This address already has a label!!");
    }
  }

  wsprintf(buf,"%d",entry+1);
  WritePrivateProfileString(exename,"entry",buf,inipath);
  wsprintf(key,"Label%d",entry);
  WritePrivateProfileString(exename,key,label,inipath);
  wsprintf(key,"Type%d",entry);
  WritePrivateProfileString(exename,key,SelStructName,inipath);
  wsprintf(key,"Index%d",entry);
  wsprintf(buf,"%d",indextype);
  WritePrivateProfileString(exename,key,buf,inipath);
  wsprintf(key,"Address%d",entry);
  WritePrivateProfileString(exename,key,addr,inipath);
  wsprintf(key,"Number%d",entry);
  wsprintf(buf,"%d",number);
  WritePrivateProfileString(exename,key,buf,inipath);
  wsprintf(key,"Align%d",entry);
  wsprintf(buf,"%d",dalign);
  WritePrivateProfileString(exename,key,buf,inipath);
}

void RefreshLabelHist(int nItem)
{
  char *exename,key[256];
  int entry,i;
  LPLBLLABELDEF lpLabel;
  char buf[256];

  exename = (char*)Plugingetvalue(VAL_EXEFILENAME);
  entry = (int)GetPrivateProfileInt(exename, "entry", 0, inipath);
  lpLabel = (LPLBLLABELDEF)malloc(sizeof(LBLLABELDEF)*entry);

  for(i=0; i<entry; i++) {
    wsprintf(key,"Label%d",i);
    GetPrivateProfileString(exename,key,"name",lpLabel[i].Name,NAMELEN,inipath);
    WritePrivateProfileString(exename,key,NULL,inipath);

    wsprintf(key,"Type%d",i);
    GetPrivateProfileString(exename,key,"type",lpLabel[i].Type,TYPELEN,inipath);
    WritePrivateProfileString(exename,key,NULL,inipath);

    wsprintf(key,"Index%d",i);
    GetPrivateProfileString(exename,key,"index",lpLabel[i].szIndex,8,inipath);
    WritePrivateProfileString(exename,key,NULL,inipath);

    wsprintf(key,"Address%d",i);
    GetPrivateProfileString(exename,key,"address",lpLabel[i].Address,16,inipath);
    WritePrivateProfileString(exename,key,NULL,inipath);

    wsprintf(key,"Number%d",i);
    GetPrivateProfileString(exename,key,"number",lpLabel[i].szNumber,16,inipath);
    WritePrivateProfileString(exename,key,NULL,inipath);

    wsprintf(key,"Align%d",i);
    GetPrivateProfileString(exename,key,"align",lpLabel[i].szAlign,4,inipath);
    WritePrivateProfileString(exename,key,NULL,inipath);
  }
  for(i=nItem; i<entry-1; i++) {
    memset(lpLabel[i].Name,0,sizeof(LBLLABELDEF));
    strcpy(lpLabel[i].Name,    lpLabel[i+1].Name);
    strcpy(lpLabel[i].Type,    lpLabel[i+1].Type);
    strcpy(lpLabel[i].szIndex, lpLabel[i+1].szIndex);
    strcpy(lpLabel[i].Address, lpLabel[i+1].Address);
    strcpy(lpLabel[i].szNumber,lpLabel[i+1].szNumber);
    strcpy(lpLabel[i].szAlign, lpLabel[i+1].szAlign);
  }
  entry--;
  if(entry <= 0) {
    WritePrivateProfileString(exename,"entry",NULL,inipath);
    WritePrivateProfileString(exename,NULL,NULL,inipath);
  }
  else {
    wsprintf(buf,"%d",entry);
    WritePrivateProfileString(exename,"entry",buf,inipath);
  }
  for(i=0; i<entry; i++) {
    wsprintf(key,"Label%d",i);
    WritePrivateProfileString(exename,key,lpLabel[i].Name,inipath);

    wsprintf(key,"Type%d",i);
    WritePrivateProfileString(exename,key,lpLabel[i].Type,inipath);

    wsprintf(key,"Index%d",i);
    WritePrivateProfileString(exename,key,lpLabel[i].szIndex,inipath);

    wsprintf(key,"Address%d",i);
    WritePrivateProfileString(exename,key,lpLabel[i].Address,inipath);

    wsprintf(key,"Number%d",i);
    WritePrivateProfileString(exename,key,lpLabel[i].szNumber,inipath);

    wsprintf(key,"Align%d",i);
    WritePrivateProfileString(exename,key,lpLabel[i].szAlign,inipath);
  }

  free(lpLabel);
}

int MakeLabel(int origin, char *addr)
{
  int id,i,j,k;
  UINT adrs;
  char lbl[255],fmt[10],buf[TEXTLEN];
  int align[] = {1,2,4,8,16};

  id = DialogBoxParam(hinst,MAKEINTRESOURCE(IDD_LABELMAKER),hwmain,(DLGPROC)MakLblDlgProc,(LPARAM)origin);
  if(id != IDOK) {
    return -1;
  }
  WriteLabelHistToIni();
  //adrs = strtoul(addr,&stop,16);
  sscanf(addr,"%X",&adrs);
  if(vsize > 0) {  // ϐTCY0傫\̕ϐ
    if(number <= 1) {  // zwȂ
      wsprintf(lbl,"%s",label);
      if(Findlabel(adrs,NULL) == NM_NONAME) {
        Insertname(adrs,NM_LABEL,lbl);
      }
      else {
        id = MessageBox(hwmain,"̃AhXɂ͊ɃxtĂ܂B\r\n㏑܂H","Labeler",MB_YESNO | MB_ICONEXCLAMATION);
        if(id == IDYES) {
          Insertname(adrs,NM_LABEL,lbl);
        }
        else {
          return -1;
        }
      }
    }
    else {
      switch(indextype) {
      case DEC:
        strcpy(fmt,"%s[%d]");
        break;
      case HEX:
        strcpy(fmt,"%s[%X]");
        break;
      }
      for(i=0; i<(int)number; i++) {
        wsprintf(lbl,fmt,label,i);
        Insertname(adrs,NM_LABEL,lbl);
        adrs += vsize;
      }
    }
  }
  else {
    LoadStructMember(SelStructName);
    if(number <= 1) {
      for(j=0; j<(int)LmStruct.NumOfMember; j++) {
        wsprintf(lbl,"%s.%s",label,LmStruct.lpMember[j].Name);
        Insertname(adrs,NM_LABEL,lbl);
        if(j < (int)LmStruct.NumOfMember-1) {
          adrs += LmStruct.lpMember[j].size * ((LmStruct.lpMember[j].ary > 1) ? LmStruct.lpMember[j].ary : 1);
          if(dalign >= 0) {
            for(k=0; k<align[dalign]; k++) {
              if((adrs % min(LmStruct.lpMember[j+1].size,align[dalign])) == 0) {
                break;
              }
              adrs++;
            }
          }
        }
      }
    }
    else {
      switch(indextype) {
      case DEC:
        strcpy(fmt,"%s[%d].%s");
        break;
      case HEX:
        strcpy(fmt,"%s[%X].%s");
        break;
      }
      for(i=0; i<(int)number; i++) {
        for(j=0; j<(int)LmStruct.NumOfMember; j++) {
          wsprintf(lbl,fmt,label,i,LmStruct.lpMember[j].Name);
          Insertname(adrs,NM_LABEL,lbl);
          if(j < (int)LmStruct.NumOfMember) {
            adrs += LmStruct.lpMember[j].size * ((LmStruct.lpMember[j].ary > 1) ? LmStruct.lpMember[j].ary : 1);
            if(dalign >= 0) {
              for(k=0; k<align[dalign]; k++) {
                if((adrs % min(LmStruct.lpMember[j+1].size,align[dalign])) == 0) {
                  break;
                }
                adrs++;
              }
            }
          }
        }
      }
    }
  }
  return id;
}

LRESULT CALLBACK MakLblDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  POINT pos;
  RECT  rect;
  UINT x,y,w,h,r,b,bMax,rMax;
  int l1,l2,l3;
  int i,spnLo = 1,spnHi = 0x1000;
  DWORD adrs;
  BOOL ans;
  static int nPos;
  char buf[255];
  t_memory *pmem;
  t_module *pmod;

  switch (msg) {
    case WM_INITDIALOG:
      if(lp == PM_DISASM || lp==PM_CPUDUMP || lp==PM_CPUREGS) {
        if(addr != NULL || addr[0] != '\0') {
          //adrs = strtoul(addr,&stop,16);
          sscanf(addr,"%X",&adrs);
          if(adrs != 0) {
            SetDlgItemText(hDlgWnd,IDC_EDT_TOPADDR,addr);
          }
        }
      }
      SendMessage(GetDlgItem(hDlgWnd, IDC_RDO_DWORD), BM_SETCHECK, (WPARAM)1, 0L);
      SendMessage(GetDlgItem(hDlgWnd, IDC_RDO_HEX),   BM_SETCHECK, (WPARAM)1, 0L);
      for(i=0; i<NumOfStruct; i++) {
        SendMessage(GetDlgItem(hDlgWnd,IDC_CMB_STRUCT), CB_INSERTSTRING, (WPARAM)i, (LPARAM)lpName[i].StructName);
      }
      SendMessage(GetDlgItem(hDlgWnd,IDC_CMB_STRUCT), CB_SETCURSEL, (WPARAM)0L, (LPARAM)0L);

      for(i=0; i<5; i++) {
        wsprintf(buf,"%d",1<<i);
        SendMessage(GetDlgItem(hDlgWnd,IDC_CMB_ALIGN), CB_INSERTSTRING, (WPARAM)i, (LPARAM)buf);
      }
      SendMessage(GetDlgItem(hDlgWnd,IDC_CMB_ALIGN),  CB_SETCURSEL, (WPARAM)3L, (LPARAM)0L);

      SendMessage(GetDlgItem(hDlgWnd,IDC_EDT_LABELNAME), EM_LIMITTEXT, (WPARAM)30L, (LPARAM)0L);

      SendMessage(GetDlgItem(hDlgWnd,IDC_SPN_NUMBER),UDM_SETRANGE32,(WPARAM)spnLo, (LPARAM)spnHi);
      SendMessage(GetDlgItem(hDlgWnd,IDC_SPN_NUMBER),UDM_SETPOS,    (WPARAM)0L,    (LPARAM)1);

      GetWindowRect(hDlgWnd,&rect);
      h = rect.bottom - rect.top;
      w = rect.right  - rect.left;
      GetCursorPos(&pos);
      b = pos.y + h;
      r = pos.x + w;
      rMax = GetSystemMetrics(SM_CXMAXIMIZED)-30;
      bMax = GetSystemMetrics(SM_CYMAXIMIZED)-30;
      if(b > bMax) {
        y = bMax - h;
      }
      else {
        y = pos.y;
      }
      if(r > rMax) {
        x = rMax - w;
      }
      else {
        x = pos.x;
      }
      MoveWindow(hDlgWnd,x,y,w,h,TRUE);

      return TRUE;
    case WM_COMMAND:
      switch (LOWORD(wp)) {
      case IDC_RDO_STRUCT:
        EnableWindow(GetDlgItem(hDlgWnd,IDC_CMB_STRUCT),TRUE);
        EnableWindow(GetDlgItem(hDlgWnd,IDC_CMB_ALIGN),TRUE);
        break;
      case IDC_RDO_BYTE:
      case IDC_RDO_WORD:
      case IDC_RDO_DWORD:
        EnableWindow(GetDlgItem(hDlgWnd,IDC_CMB_STRUCT),FALSE);
        EnableWindow(GetDlgItem(hDlgWnd,IDC_CMB_ALIGN),FALSE);
        break;
      case IDC_EDT_NUMBER:
        nPos = GetDlgItemInt(hDlgWnd,IDC_EDT_NUMBER,NULL,FALSE);
        if(nPos < spnLo) {
          SetDlgItemInt(hDlgWnd,IDC_EDT_NUMBER,spnLo,FALSE);
        }
        if(nPos > spnHi) {
          SetDlgItemInt(hDlgWnd,IDC_EDT_NUMBER,spnHi,FALSE);
        }
        break;
      case IDOK:
        // size
        //Addtolist(0,-1,"OK Button Pushed");
        if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_BYTE) == BST_CHECKED) {
          vsize = 1;
          dalign = -1;
          SelStruct = -1;
          strcpy(SelStructName,"BYTE");
        }
        if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_WORD) == BST_CHECKED) {
          vsize = 2;
          dalign = -1;
          SelStruct = -1;
          strcpy(SelStructName,"WORD");
        }
        if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_DWORD) == BST_CHECKED) {
          vsize = 4;
          dalign = -1;
          SelStruct = -1;
          strcpy(SelStructName,"DWORD");
        }
        if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_STRUCT) == BST_CHECKED) {
          vsize = 0;
          SelStruct = SendMessage(GetDlgItem(hDlgWnd,IDC_CMB_STRUCT),CB_GETCURSEL,0L,0L);
          memset(SelStructName,0,NAMELEN);
          SendMessage(GetDlgItem(hDlgWnd,IDC_CMB_STRUCT),CB_GETLBTEXT,(WPARAM)SelStruct,(LPARAM)SelStructName);
          dalign = SendMessage(GetDlgItem(hDlgWnd,IDC_CMB_ALIGN),CB_GETCURSEL,0L,0L);
        }

        // Get Number and Check
        l1 = GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_EDT_LABELNAME));
        l2 = GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_EDT_TOPADDR));
        l3 = GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_EDT_NUMBER));
        if(l1 == 0) {
          MessageBox(hDlgWnd,"Please specify label name.",PNAME,MB_OK | MB_ICONINFORMATION);
          break;
        }
        else {
          GetDlgItemText(hDlgWnd,IDC_EDT_LABELNAME,label,21);
        }
        if(l2 == 0) {
          MessageBox(hDlgWnd,"Please specify address.",PNAME,MB_OK | MB_ICONINFORMATION);
          break;
        }
        else {
          GetDlgItemText(hDlgWnd,IDC_EDT_TOPADDR,addr,9);
          Addtolist(0,-1,"Check Memory %s",addr);
          sscanf(addr,"%X",&adrs);
          //adrs = strtoul(addr,&stop,16);
          pmem = Findmemory(adrs);
          if(pmem == NULL) {
            return FALSE;
          }
          Addtolist(0,1,"The address 0x%08X type:%X  access:%X  owner:%X  sect:%s",adrs,pmem->type,pmem->access,pmem->owner,pmem->sect);
          pmod = Findmodule(pmem->owner);
          if(pmod != NULL) {
            Addtolist(0,1,"The module name of address:%s",pmod->path);
          }

          /*
          if(adrs < dwImageBase || adrs > dwImageBase+dwSizeOfImage) {
            wsprintf(buf,"The address 0x0%X is out of Debugee range.\nReally do you want to set label at this address?",adrs);
            ret = MessageBox(hwmain,buf,PNAME,MB_OKCANCEL);
            if(ret == IDCANCEL) {
              return FALSE;
            }
          }
          */
        }

        if(l3 == 0) {
          number = 0;
        }
        else {
          number = GetDlgItemInt(hDlgWnd,IDC_EDT_NUMBER, &ans, FALSE);
        }


        if(!IsValidNumber(addr,strlen(addr),NUM_HEX)) {
          goto NUM_INVALID;
        }

        // index type
        if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_DEC) == BST_CHECKED) {
          indextype = DEC;
        }
        if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_HEX) == BST_CHECKED) {
          indextype = HEX;
        }

        EndDialog(hDlgWnd, IDOK);
        break;

NUM_INVALID:
        MessageBox(hDlgWnd,"It is invalid address.",PNAME,MB_OK | MB_ICONINFORMATION);
        break;
      case IDCANCEL:
        EndDialog(hDlgWnd, IDCANCEL);
        break;

      default:
        return FALSE;
      }
    default:
      return FALSE;
  }
  return FALSE;
}

int DeleteLabel(LPLBLLABELDEF lpLblInfo)
{
  int i,j,k,size;
  DWORD adrs;

  sscanf(lpLblInfo->Address,"%X",&adrs);
  //adrs = strtoul(lpLblInfo->Address,&stop,16);
  //Setcpu(0,0,adrs,0,CPU_DUMPFIRST|CPU_DUMPFOCUS);
  i = 0;
  size = 0;
  while(typ[i].type) {
    if(!strcmp(typ[i].type,lpLblInfo->Type)) {
      size = typ[i].size;
      break;
    }
    i++;
  }
  if(size > 0) {
    for(i=0; i<lpLblInfo->Number; i++) {
      Deletenamerange(adrs,adrs+1,NM_LABEL);
      adrs += size;
    }
  }
  else {
    LoadStructMember(lpLblInfo->Type);
    for(i=0; i<lpLblInfo->Number; i++) {
      for(j=0; j<(int)LmStruct.NumOfMember; j++) {
        Deletenamerange(adrs,adrs+1,NM_LABEL);
        if(j < (int)LmStruct.NumOfMember-1) {
          adrs += LmStruct.lpMember[j].size * ((LmStruct.lpMember[j].ary > 1) ? LmStruct.lpMember[j].ary : 1);
          if(lpLblInfo->Align >= 0) {
            for(k=0; k<lpLblInfo->Align; k++) {
              if((adrs % min(LmStruct.lpMember[j+1].size,lpLblInfo->Align)) == 0) {
                break;
              }
              adrs++;
            }
          }
        }
      }
    }
  }
  return 0;
}

int GetSelItemInfo(HWND hList, int nItem, LPLBLLABELDEF lpLblInfo)
{

  ListView_GetItemText(hList, nItem, 0, lpLblInfo->Name, sizeof(lpLblInfo->Name));

  ListView_GetItemText(hList, nItem, 1, lpLblInfo->Type, sizeof(lpLblInfo->Type));

  ListView_GetItemText(hList, nItem, 2, lpLblInfo->szIndex, sizeof(lpLblInfo->szIndex));
  if(!strcmp(lpLblInfo->szIndex,"HEX")) {
    lpLblInfo->Index = HEX;
  }
  else {
    lpLblInfo->Index = DEC;
  }

  ListView_GetItemText(hList, nItem, 3, lpLblInfo->Address, sizeof(lpLblInfo->Address));

  ListView_GetItemText(hList, nItem, 4, lpLblInfo->szNumber, sizeof(lpLblInfo->szNumber));
  //lpLblInfo->Number = strtoul(lpLblInfo->szNumber,&stop,10);
  sscanf(lpLblInfo->szNumber,"%d",&(lpLblInfo->Number));

  ListView_GetItemText(hList, nItem, 5, lpLblInfo->szAlign, sizeof(lpLblInfo->szAlign));
  //lpLblInfo->Align = strtoul(lpLblInfo->szAlign,&stop,10);
  sscanf(lpLblInfo->szAlign,"%d",&(lpLblInfo->Align));

  return TRUE;
}

LRESULT CALLBACK DelLblDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  DWORD dwStyle;
  LBLLABELDEF Lbls;
  static HWND hList;
  int i,LblNum,nItem;
  LV_COLUMN lvcol;
  LV_ITEM   item;
  char *head[]  = {"Name","Type","Index","Address","Num","Align"};
  int  colsiz[] = { 100,   80,    50,     80,       50,   50    };
  char *idxtyp[]   = {"DEC","HEX"};
  char *alntyp[]   = {"1","2","4","8","16"};
  char *exename,key[256];
  //char buf[256];

  switch (msg) {
  case WM_INITDIALOG:
    hList = GetDlgItem(hDlgWnd,IDC_LST_LABEL);

    dwStyle = ListView_GetExtendedListViewStyle(hList);
    dwStyle |= LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES;
    ListView_SetExtendedListViewStyle(hList, dwStyle);

    // set column string
    lvcol.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
    lvcol.fmt = LVCFMT_LEFT;
    for(i=0; i<sizeof(head)/sizeof(head[0]); i++) {
      lvcol.cx = colsiz[i];
      lvcol.pszText = head[i];
      lvcol.iSubItem = i;
      ListView_InsertColumn(hList, i, &lvcol);
    }

    exename = (char*)Plugingetvalue(VAL_EXEFILENAME);
    LblNum = GetPrivateProfileInt(exename,"entry",0,inipath);
    item.mask = LVIF_TEXT;
    if(LblNum > 0) {
      for(i=0; i<LblNum; i++) {
        wsprintf(key,"Label%d",i);
        GetPrivateProfileString(exename,key,"NONE",Lbls.Name,NAMELEN,inipath);
        item.pszText = Lbls.Name;
        item.iItem = i;
        item.iSubItem = 0;
        ListView_InsertItem(hList, &item);

        wsprintf(key,"Type%d",i);
        GetPrivateProfileString(exename,key,"NONE",Lbls.Type,TYPELEN,inipath);
        item.pszText = Lbls.Type;
        item.iItem = i;
        item.iSubItem = 1;
        ListView_SetItem(hList, &item);

        wsprintf(key,"Index%d",i);
        Lbls.Index = GetPrivateProfileInt(exename,key,0,inipath);
        item.pszText = idxtyp[Lbls.Index];
        item.iItem = i;
        item.iSubItem = 2;
        ListView_SetItem(hList, &item);

        wsprintf(key,"Address%d",i);
        GetPrivateProfileString(exename,key,"NONE",Lbls.Address,16,inipath);
        item.pszText = Lbls.Address;
        item.iItem = i;
        item.iSubItem = 3;
        ListView_SetItem(hList, &item);

        wsprintf(key,"Number%d",i);
        GetPrivateProfileString(exename,key,"NONE",Lbls.szNumber,16,inipath);
        item.pszText = Lbls.szNumber;
        item.iItem = i;
        item.iSubItem = 4;
        ListView_SetItem(hList, &item);

        wsprintf(key,"Align%d",i);
        Lbls.Align = GetPrivateProfileInt(exename,key,-1,inipath);
        if(Lbls.Align == -1) {
          item.pszText = "NONE";
        }
        else {
          item.pszText = alntyp[Lbls.Align];
        }
        item.iItem = i;
        item.iSubItem = 5;
        ListView_SetItem(hList, &item);
      }
    }
    DelLstDlgProcOrg = (WNDPROC)SetWindowLong(hList,GWL_WNDPROC, (LONG)DelLstDlgProc);
    return TRUE;
  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDC_BTN_DELETE:
      nItem = ListView_GetItemCount(hList);
      for(i=nItem-1; i>=0; i--) {
        GetSelItemInfo(hList, i, &Lbls);
        DeleteLabel(&Lbls);
        RefreshLabelHist(i);
        ListView_DeleteItem(hList,i);
      }
      Redrawdisassembler();
      break;
    case IDC_BTN_DELSEL:
      nItem = ListView_GetNextItem(hList,(-1),LVNI_ALL|LVNI_SELECTED);
      GetSelItemInfo(hList, nItem, &Lbls);
      DeleteLabel(&Lbls);
      RefreshLabelHist(nItem);
      ListView_DeleteItem(hList,nItem);
      Redrawdisassembler();
      break;
    case IDOK:
      EndDialog(hDlgWnd, IDOK);
      break;
    case IDCANCEL:
      EndDialog(hDlgWnd, IDCANCEL);
      break;
    default:
      break;
    }
    break;
  default:
    break;
  }
  return 0;
}

// x폜_CAÕXg{bNX̃EBhEvV[W
LRESULT CALLBACK DelLstDlgProc(HWND hList, UINT msg, WPARAM wp, LPARAM lp)
{
  POINT pt;
  LV_ITEM item;
  HMENU hMenu,hSubMenu;
  int   nItem;
  char  buf[TEXTLEN];
  DWORD adrs;
  LBLLABELDEF LblInfo;

  switch (msg) {
  case WM_RBUTTONDOWN:
    pt.x = LOWORD(lp);
    pt.y = HIWORD(lp);
    hMenu = LoadMenu(hinst, MAKEINTRESOURCE(IDM_DELLBLLIST));
    hSubMenu = GetSubMenu(hMenu, 0);
    ClientToScreen(hList, &pt);
    TrackPopupMenu(hSubMenu, TPM_LEFTALIGN, pt.x, pt.y, 0, hList, NULL);
    DestroyMenu(hMenu);
    break;

  case WM_LBUTTONDBLCLK:
    nItem = ListView_GetNextItem(hList,(-1),LVNI_ALL|LVNI_SELECTED);
    item.mask       = LVIF_TEXT;
    item.cchTextMax = sizeof(buf);
    item.pszText  = buf;
    item.iItem    = nItem;
    item.iSubItem = 3;
    ListView_GetItem(hList, &item);
    sscanf(buf,"%X",&adrs);
    Setcpu(0,0,adrs,0,CPU_DUMPFIRST|CPU_DUMPFOCUS);
    break;

  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDM_VIEWCPUDUMP:
      nItem = ListView_GetNextItem(hList,(-1),LVNI_ALL|LVNI_SELECTED);
      item.mask       = LVIF_TEXT;
      item.cchTextMax = sizeof(buf);
      item.pszText  = buf;
      item.iItem    = nItem;
      item.iSubItem = 3;
      ListView_GetItem(hList, &item);
      sscanf(buf,"%X",&adrs);
      Setcpu(0,0,adrs,0,CPU_DUMPFIRST);
      break;
    case IDM_DELLABEL:
      nItem = ListView_GetNextItem(hList,(-1),LVNI_ALL|LVNI_SELECTED);
      GetSelItemInfo(hList, nItem, &LblInfo);
      DeleteLabel(&LblInfo);
      RefreshLabelHist(nItem);
      ListView_DeleteItem(hList,nItem);
      Redrawdisassembler();
      break;
    default:
      break;
    }
  default:
    break;
  }
  return (CallWindowProc((WNDPROC)DelLstDlgProcOrg, hList, msg, wp, lp));
}

BOOL IsValidNumber(char *numstr, int size, int mode)
{
  int i;
  char *s;

  s = numstr;
  if(*s == '-' || *s == '+') {
    s++;
    size--;
  }
  for(i=0; i<size; i++) {
    switch(mode) {
    case NUM_DEC:
      if(*(s+i) < '0' || *(s+i) > '9') {
        return FALSE;
      }
      break;
    case NUM_HEX:
      if(!(   (*(s+i) >= '0' && *(s+i) <= '9')
           || (*(s+i) >= 'A' && *(s+i) <= 'F')
           || (*(s+i) >= 'a' && *(s+i) <= 'f') )) {
        return FALSE;
      }
      break;
    default:
      break;
    }
  }
  return TRUE;
}

BOOL GetPEInfo(void)
{
  char msg[TEXTLEN],*DbgePath;
  HANDLE hFile,hHeap;
  PIMAGE_DOS_HEADER idosh;
  PIMAGE_NT_HEADERS ipeh;
  LPBYTE fbuf;
  DWORD dwFsiz,dwRsiz;

  DbgePath = (char*)Plugingetvalue(VAL_EXEFILENAME);

  // Read Debuggee
  hFile = CreateFile(DbgePath,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
  if(hFile == INVALID_HANDLE_VALUE) {
    wsprintf(msg,"Cannot Create File %s",DbgePath);
    MessageBox(hwmain,msg,PNAME,MB_OK);
    return FALSE;
  }
  dwFsiz = GetFileSize(hFile,NULL);
  hHeap = HeapCreate(HEAP_NO_SERIALIZE,1,0);
  fbuf = (char *)HeapAlloc(hHeap, 0, dwFsiz);
  if(ReadFile(hFile,fbuf,dwFsiz,&dwRsiz,NULL) == 0) {
    MessageBox(hwmain,"Can\'t Read File ",PNAME" Error!",MB_OK|MB_ICONEXCLAMATION);
    CloseHandle(hFile);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  CloseHandle(hFile);

  // Get PE Header info
  idosh = (PIMAGE_DOS_HEADER)fbuf;
  if(idosh->e_magic != IMAGE_DOS_SIGNATURE) {
    MessageBox(hwmain,"Bad DOS Signature!!",PNAME,MB_OK | MB_ICONEXCLAMATION);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  ipeh = (PIMAGE_NT_HEADERS)(fbuf + idosh->e_lfanew);
  if(ipeh->Signature != IMAGE_NT_SIGNATURE) {
    MessageBox(hwmain,"Bad PE Signature!!",PNAME,MB_OK | MB_ICONEXCLAMATION);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  dwImageBase   = ipeh->OptionalHeader.ImageBase;
  dwSizeOfImage = ipeh->OptionalHeader.SizeOfImage;

  HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
  return TRUE;
}

BOOL LoadDefinedStructName(void)
{
  HANDLE hFile,hHeap;
  LPBYTE fbuf;
  DWORD dwFsiz,dwRsiz;
  char *p,*q,*b,*e;
  char msg[TEXTLEN];
  int i,j;

  if(lpName) {
    free(lpName);
    lpName = NULL;
  }
  hFile = CreateFile(szStructDefFile,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
  if(hFile == INVALID_HANDLE_VALUE) {
    wsprintf(msg,"Cannot Create File");
    MessageBox(hwmain,msg,PNAME,MB_OK);
    return FALSE;
  }
  dwFsiz = GetFileSize(hFile,NULL);
  hHeap = HeapCreate(HEAP_NO_SERIALIZE,1,0);
  fbuf = (char *)HeapAlloc(hHeap, HEAP_ZERO_MEMORY, dwFsiz+20); // no reason but +20
  if(ReadFile(hFile,fbuf,dwFsiz,&dwRsiz,NULL) == 0) {
    MessageBox(hwmain,"Can\'t Read File ",PNAME" Error!",MB_OK|MB_ICONEXCLAMATION);
    CloseHandle(hFile);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  CloseHandle(hFile);

  // count the number of struct
  p = fbuf;
  NumOfStruct = 0;
  while(p) {
    q = strstr(p,"struct");
    if(q) {
      NumOfStruct++;
      p = q+1;
    }
    else {
      p = NULL;
    }
  }

  // store struct name
  lpName = (LPLBLSTNAME)malloc(sizeof(LBLSTNAME)*NumOfStruct);
  memset(lpName,0,sizeof(LBLSTNAME)*NumOfStruct);
  p = fbuf;
  i = 0;
  while(p) {
    b = strstr(p,"struct");
    if(b) {
      b+=strlen("struct");
      p = b;
      e = strstr(p,"{");
      e--;
      j = 0;
      for(q=b; q<=e; q++) {
        if(*q != ' ') {
          lpName[i].StructName[j] = *q;
          j++;
        }
      }
      i++;
    }
    else {
      p = NULL;
    }
  }

  HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
  return TRUE;
}

BOOL LoadStructMember(char *StructName)
{
  HANDLE hFile,hHeap;
  LPBYTE fbuf,mbuf;
  DWORD dwFsiz,dwRsiz;
  char *p,*q,*b,*e,*token;
  char msg[TEXTLEN],arraybuf[10];
  int i,j,ityp;

  if(LmStruct.lpMember) {
    free(LmStruct.lpMember);
  }
  memset(&LmStruct,0,sizeof(LBLSTRUCT));
  strcpy(LmStruct.Name,StructName);

  hFile = CreateFile(szStructDefFile,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
  if(hFile == INVALID_HANDLE_VALUE) {
    wsprintf(msg,"Cannot Create File");
    MessageBox(hwmain,msg,PNAME,MB_OK);
    return FALSE;
  }
  dwFsiz = GetFileSize(hFile,NULL);
  hHeap = HeapCreate(HEAP_NO_SERIALIZE,1,0);
  fbuf = (char *)HeapAlloc(hHeap, HEAP_ZERO_MEMORY, dwFsiz+20); // no reason but +20
  if(ReadFile(hFile,fbuf,dwFsiz,&dwRsiz,NULL) == 0) {
    MessageBox(hwmain,"Can\'t Read File ",PNAME" Error!",MB_OK|MB_ICONEXCLAMATION);
    CloseHandle(hFile);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  CloseHandle(hFile);

  // count the number of members of each struct
  p = strstr(fbuf,StructName);
  if(!p) {
    return FALSE;
  }
  b = strstr(p,"{");
  if(!b) {
    return FALSE;
  }
  e = strstr(p,"}");
  if(!e) {
    return FALSE;
  }
  q = b;
  LmStruct.NumOfMember = 0;
  while(q) {
    q = strstr(q,";");
    if(q == NULL) {
      break;
    }
    if(q > e) {
      break;
    }
    else {
      LmStruct.NumOfMember++;
      q++;
    }
  }
Addtolist(0,-1,"NumOfMember:%d",LmStruct.NumOfMember);

  // store the struct members
  LmStruct.lpMember = (LPLBLSTMEMBER)malloc(sizeof(LBLSTMEMBER)*LmStruct.NumOfMember);
  memset(LmStruct.lpMember,0,sizeof(LBLSTMEMBER)*LmStruct.NumOfMember);
  p = strstr(fbuf,StructName);
  b = strstr(p,"{")+1;
  e = strstr(p,"}");
  mbuf = (LPBYTE)malloc(e-b+2);
  memset(mbuf,0,e-b+2);
  for(i=0,q=b; q!=e; i++,q++) {
    mbuf[i] = *q;
  }
//Addtolist(0,-1,"mbuf:%s",mbuf);
  q = mbuf;
  for(i=0; i<LmStruct.NumOfMember; i++) {
    token = strtok(q," ;\t\r\n");
    wsprintf(LmStruct.lpMember[i].Type,"%s",token);
//Addtolist(0,-1,"LmStruct.lpMember[%d].Type:%s",i,LmStruct.lpMember[i].Type);
    ityp = 0;
    while(typ[ityp].type) {
      if(!strcmp(typ[ityp].type,LmStruct.lpMember[i].Type)) {
        LmStruct.lpMember[i].size = typ[ityp].size;
        break;
      }
      ityp++;
    }
    if(LmStruct.lpMember[i].size == 0) {
      wsprintf(msg,"The undefined type %s is detected in struct %s !\n\nSet it's size ZERO.",LmStruct.lpMember[i].Type,LmStruct.Name);
      MessageBox(hwmain,msg,PNAME,MB_OK);
    }
    token = strtok(NULL," ;\t\r\n");
    wsprintf(LmStruct.lpMember[i].Name,"%s",token);
//Addtolist(0,-1,"LmStruct.lpMember[%d].Name:%s",i,LmStruct.lpMember[i].Name);
    q = token+strlen(token)+1;
    b = strchr(LmStruct.lpMember[i].Name,'[');
    e = strchr(LmStruct.lpMember[i].Name,']');
    if(b && e) {
      memset(arraybuf,0,sizeof(arraybuf));
      for(j=0,b++; b<e; j++,b++) {
        arraybuf[j] = *b;
      }
      LmStruct.lpMember[i].ary  = atoi(arraybuf);
//Addtolist(0,-1,"LmStruct.lpMember[%d].ary:%d",i,LmStruct.lpMember[i].ary);
    }
  }
  free(mbuf);

  HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
  return TRUE;
}
