/******************************************************************************
*                                                                             *
*   Module:     Keymaps.c                                                     *
*                                                                             *
*   Date:       08/26/02                                                      *
*                                                                             *
*   Copyright (c) 2002-2005 Goran Devic                                       *
*                                                                             *
*   Author:     Goran Devic                                                   *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA   *
*                                                                             *
*******************************************************************************

    Module Description:

        This module contains alternate keymaps for internationalization.

*******************************************************************************
*                                                                             *
*   Major changes:                                                            *
*                                                                             *
*   DATE     DESCRIPTION OF CHANGES                               AUTHOR      *
* --------   ---------------------------------------------------  ----------- *
* 08/26/02   Initial version                                      Goran Devic *
* --------   ---------------------------------------------------  ----------- *
*******************************************************************************
*   Include Files                                                             *
******************************************************************************/

#include <stdlib.h>                     // Include standard library
#include <string.h>                     // Include string library

#ifndef WIN32
#define stricmp     strcasecmp          // Weird gnu c call..
#endif // WIN32

#include "ice-keycode.h"                // Include keyboard code defines
#include "ice-ioctl.h"                  // Include shared header file

/******************************************************************************
*                                                                             *
*   Global Variables                                                          *
*                                                                             *
******************************************************************************/

/******************************************************************************
*                                                                             *
*   Local Defines, Variables and Macros                                       *
*                                                                             *
******************************************************************************/
/*
* (C) Copyright 1992, ..., 2001 the "DOSEMU-Development-Team".
*
* for details see file COPYING in the DOSEMU distribution
*/

const BYTE key_map_finnish[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', 0,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_finnish[] =
{
  0, ESC, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_finnish[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_finnish_latin1[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, 168,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 167, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_finnish_latin1[] =
{
  0, ESC, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 171, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_finnish_latin1[] =
{
  0, 0, 0, '@', 156, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_us[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '\\', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_us[] =
{
  0, ESC, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '_', '+', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '"', '~', '0', '|', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_us[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_jp106[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '^', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '@', '[',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  ':', '`', 0, ']', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '0', 0,
  0, '\\', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '\\', 0, 0, 0, 0,
  0, 0, 0, 0, 0, '\\', 0, 0,
  0};

const BYTE shift_map_jp106[] =
{
  0, ESC, '!', '"', '#', '$', '%', '&',
  '\'', '(', ')', '~', '=', '~', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '`', '{', 1, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '+',
  '*', '~', '0', '}', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '0', 0,
  0, '_', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '_', 0, 0, 0, 0,
  0, 0, 0, 0, 0, '|', 0, 0,
  0};

const BYTE alt_map_jp106[] =
{
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};


const BYTE key_map_uk[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '-', '=', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '[', ']',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', ';',
  '\'', '`', 0, '#', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '/', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_uk[] =
{
  0, ESC, '!', '"', 156, '$', '%', '^',
  '&', '*', '(', ')', '_', '+', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '{', '}',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', ':',
  '@', '~', '0', '~', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '<', '>', '?', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_uk[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_de[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 0xe1, '\'', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0x81, '+',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0x94,
  0x84, '^', 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_de[] =
{
  0, ESC, '!', '"', 0x9c, '$', '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0x9A, '*',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0x99,
  0x8e, 0xf8, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_de[] =
{
  0, 0, 0, 0xfd, 0xfc, 0, 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0xe6, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_de_latin1[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 225, 0, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 129, '+',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 0, 0, '#', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_de_latin1[] =
{
  0, ESC, '!', '"', 21, '$', '%', '&',
  '/', '(', ')', '=', '?', 0, BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 154, '*',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 248, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_de_latin1[] =
{
  0, 0, 0, 253, 252, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 230, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_fr[] =
{
  0, ESC, '&', '{', '"', '\'', '(', '-',
  '}', '_', '/', '@', ')', '=', BACKSPACE,TAB,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '^', '$',ENTER, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  '|', '`', 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_fr[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', ']', '+', BACKSPACE,TAB,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '<', '>',ENTER, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', '~', 0, '#', 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '\\', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_fr[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_fr_latin1[] =
{
  0, ESC, '&', 0x82, '"', '\'', '(', '-',
  0x8a, '_', 0x87, 0x85, ')', '=', BACKSPACE,TAB,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 0, '$',ENTER, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  0x97, 0xfd, 0, 42, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '!', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_fr_latin1[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 0xf8, '+', BACKSPACE,TAB,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 0, 0x9c,ENTER, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', '~', 0, 0xe6, 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', 167, 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_fr_latin1[] =
{
  0, 0, 0, '~', '#', '{', '[', '|',
  '`', '\\', '^', '@', ']', '}', 0, 0,
  '@', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 164,ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_dk[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, 0,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 145,
  155, 0, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_dk[] =
{
  0, ESC, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 146,
  157, 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_dk[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_dk_latin1[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', 180, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 229, 168,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 230,
  162, 189, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_dk_latin1[] =
{
  0, ESC, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 197, '^',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 198,
  165, 167, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_dk_latin1[] =
{
  0, 0, 0, '@', 163, '$', 0, 0,
  '{', '[', ']', '}', 0, '|', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_dvorak[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\\', '=', BACKSPACE,TAB,
  '\'', ',', '.', 'p', 'y', 'f', 'g', 'c',
  'r', 'l', '/', ']',ENTER, 0, 'a', 'o',
  'e', 'u', 'i', 'd', 'h', 't', 'n', 's',
  '-', '`', 0, '[', ';', 'q', 'j', 'k',
  'x', 'b', 'm', 'w', 'v', 'z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_dvorak[] =
{
  0, ESC, '!', '@', '#', '$', '%', '^',
  '&', '*', '(', ')', '|', '+', BACKSPACE,TAB,
  '"', '<', '>', 'P', 'Y', 'F', 'G', 'C',
  'R', 'L', '?', '}',ENTER, 0, 'A', 'O',
  'E', 'U', 'I', 'D', 'H', 'T', 'N', 'S',
  '_', '~', 0, '{', ':', 'Q', 'J', 'K',
  'X', 'B', 'M', 'W', 'V', 'Z', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_dvorak[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_sg[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_sg[] =
{
  0, ESC, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_sg[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_sg_latin1[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 192, 0,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_sg_latin1[] =
{
  0, ESC, '+', '"', '*', 128, '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 154, '!',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_sg_latin1[] =
{
  0, 0, 179, '@', '#', 0, 0, 170,
  '|', 162, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 233,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_no[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\\', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '}', '~',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', '|',
  '{', '|', 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_no[] =
{
  0, ESC, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', ']', '^',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '\\',
  '[', 0, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_no[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', 0, '\'', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_no_latin1[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\\', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, 0,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 155,
  145, '|', 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_no_latin1[] =
{
  0, ESC, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', 0, BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, 0,ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 157,
  146, 245, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_no_latin1[] =
{
  0, 0, 0, '@', 156, 207, 0, 0,
  '{', '[', ']', '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0,ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_sf[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 0, 0,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 0,
  0, 0, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_sf[] =
{
  0, ESC, '+', '"', '*', 0, '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 0, '!',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 0,
  0, 0, 0, 0, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_sf[] =
{
  0, 0, 0, '@', '#', 0, 0, 0,
  '|', 0, 0, 0, '\'', '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_sf_latin1[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '^', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 232, 168,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 233,
  224, 167, 0, '$', 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_sf_latin1[] =
{
  0, ESC, '+', '"', '*', 231, '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 252, '!',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 246,
  228, 176, 0, 163, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_sf_latin1[] =
{
  0, 0, 0, '@', '#', 0, 0, 172,
  '|', 162, 0, 0, 180, '~', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '{', 0, 0, '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_es[] = {
      0,   ESC,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',    0,  BACKSPACE,   TAB,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  '`',  '+',  ENTER,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',    0,
   '\'',  '`',    0,    0,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

const BYTE shift_map_es[] = {
      0,   ESC,  '!',  '"',  '#',  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',    0,  BACKSPACE,   TAB,
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  '^',  '*',  ENTER,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',    0,
      0,  '~',    0,    0,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

const BYTE alt_map_es[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,    0,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',  ENTER,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

const BYTE key_map_es_latin1[] = {
      0,   ESC,  '1',  '2',  '3',  '4',  '5',  '6',
    '7',  '8',  '9',  '0', '\'',  173,  BACKSPACE,   TAB,
    'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
    'o',  'p',  0,  '+',  ENTER,    0,  'a',  's',
    'd',  'f',  'g',  'h',  'j',  'k',  'l',  164,
    0,  167,    0,  135,  'z',  'x',  'c',  'v',
    'b',  'n',  'm',  ',',  '.',  '-',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '<',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

const BYTE shift_map_es_latin1[] = {
      0,   ESC,  '!',  '"',  250,  '$',  '%',  '&',
    '/',  '(',  ')',  '=',  '?',  168,  BACKSPACE,   TAB,
    'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
    'O',  'P',  0,  '*',  ENTER,    0,  'A',  'S',
    'D',  'F',  'G',  'H',  'J',  'K',  'L',  165,
    0,  166,    0,  128,  'Z',  'X',  'C',  'V',
    'B',  'N',  'M',  ';',  ':',  '_',    0,  '*',
      0,   32,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '-',    0,    0,    0,  '+',    0,
      0,    0,    0,    0,    0,    0,  '>',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

const BYTE alt_map_es_latin1[] = {
      0,    0,  '|',  '@',  '#',  '$',    0,  172,
    '{',  '[',  ']',  '}', '\\',  '~',    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '[',  ']',  ENTER,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
    '{', '\\',    0,  '}',    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0,    0,  '~',    0,    0,    0,    0,    0,
      0,    0,    0,    0,    0,    0,  '|',    0,
      0,    0,    0,    0,    0,    0,    0,    0,
      0 };

/* keyboard driver for BELGIAN KEYBOARD */

const BYTE key_map_be[] =
{
  0, ESC, '&', 130, '"', '\'', '(', 21,
  138, '!', 128, 133, ')', '-', BACKSPACE,TAB,
  'a', 'z', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 0, '$',ENTER, 0, 'q', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm',
  151, 253, 0, 230, 'w', 'x', 'c', 'v',
  'b', 'n', ',', ';', ':', '=', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_be[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', 248, '_', BACKSPACE,TAB,
  'A', 'Z', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 0, '*',ENTER, 0, 'Q', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M',
  '%', 252, 0, 156, 'W', 'X', 'C', 'V',
  'B', 'N', '?', '.', '/', '+', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_be[] =
{
  0, 0, '|', '@', '#', 0, 0, '^',
  0, 0, '{', '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '\\', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_po[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '`', 174, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', '+', 0,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 135,
  167, '\\', 0, 0, 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_po[] =
{
  0, ESC, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', 175, BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '*', 0,ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 128,
  166, '|', '0', 0, 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_po[] =
{
  0, 0, 0, '@', 156, 21, 0, 0,
  '{', '[', ']', '}', 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_it[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', 141, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 138, '+',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 149,
  133, '\\', 0, 151, 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_it[] =
{
  0, ESC, '!', '\"', 156, '$', '%', '&',
  '/', '(', ')', '=', '?', '^', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 130, '*',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 135,
  248, '|', '0', 21, 'Z', 'X', 'C', 'V',
   'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_it[] =
{
  0, 0, 0, '@', 0, '$', 0, 0,
  '{', '[', ']', '}', '{', '}', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '[', ']',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, '@',
  '#', 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_sw[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 134, '~',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 148,
  132, 21, 0, '\'', 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_sw[] =
{
  171, 0, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '`', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', 143, '^',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 153,
  142, 171, 0, '*', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_sw[] =
{
  0, 0, 0, '@', 156, '$', 0, 0,
  '{', '[', ']', '}', '\\', 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, '~',ENTER, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_hu[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', 148, 129, 162, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 139, 163,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 130,
  160, '0', 0, 251, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 161, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_hu[] =
{
  0, ESC, '\'', '"', '+', '!', '%', '/',
  '=', '(', ')', 153, 154, '\'', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 138, 233,ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 144,
  181, 21, '0', 235, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 146, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_hu[] =
{
  0, 0, '~', 0, 0, 0, 248, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 146,
  0, 0, 246, 158,ENTER, 0, 0, 208,
  209, '[', ']', 0, 161, 136, 157, '$',
  225, 0, 0, 207, '>', '#', '&', '@',
  '{', '}', 0, ';', 0, '*', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_hu_cwi[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', 148, 129, 162, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 147, 163,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 130,
  160, '0', 0, 150, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 161, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_hu_cwi[] =
{
  0, ESC, '\'', '"', '+', '!', '%', '/',
  '=', '(', ')', 153, 154, 149, BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 167, 151,ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 144,
  143, 21, '0', 152, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 141, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_hu_cwi[] =
{
  0, 0, '~', 0, 0, 0, 248, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 141,
  0, 0, 246, 0,ENTER, 0, 0, 0,
  0, '[', ']', 0, 161, 0, 0, '$',
  225, 0, 0, 0, '>', '#', '&', '@',
  '{', '}', 0, ';', 0, '*', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_hu_latin2[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', 246, 252, 243, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 245, 250,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 233,
  225, '0', 0, 251, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 237, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_hu_latin2[] =
{
  0, ESC, '\'', '"', '+', '!', '%', '/',
  '=', '(', ')', 214, 220, 211, BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 213, 218,ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 201,
  193, 21, '0', 219, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, 205, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_hu_latin2[] =
{
  0, 0, '~', 0, 0, 0, 248, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 205,
  0, 0, 247, 215,ENTER, 0, 0, 240,
  208, '[', ']', 0, 237, 179, 163, '$',
  223, 0, 0, 164, '>', '#', '&', '@',
  '{', '}', 0, ';', 0, '*', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

/* Polish keyboard */
const BYTE key_map_pl[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '+', '\'', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 190, 152,ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 136,
  165, 0, 0, 162, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_pl[] =
{
  0, ESC, '!', '"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '*', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 228, 134,ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 157,
  169, 0, '0', 171, 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_pl[] =
{
  0, 0, '~', 0, 0, 0, 248, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\\', '|', 169, 0, 0, 0, 0, 0,
  162, 0, 246, 158, 0, 0, 165, 208,
  209, '[', ']', 0, 0, 0, 136, '$',
  225, 0, 0, 0, 190, 171, 134, '@',
  '{', '}', 21, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_hr_cp852[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '+', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 231, 208,ENTER, 0, 'a', 's',     /*231=s, 208=d*/
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 159,  /*159=c tvrdo*/
  134, 0, 0, 167, 'y', 'x', 'c', 'v',      /*134=c meko,167=z*/
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_hr_cp852[] =
{
  0, ESC, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '*', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 230, 209,ENTER, 0, 'A', 'S',     /*230=S, 209=D*/
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 172,  /*172=C tvrdo*/
  143, 0, 0, 166, 'Y', 'X', 'C', 'V',      /*143=C meko,166=Z*/
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_hr_cp852[] =
{
  0, 0, 126, 183, '^', 244, 248, 242,
  '`', 250, 239, 241, 249, 247, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 0,
  0, 0, 246, 158,ENTER, 0, 0, 0,
  0, '[', ']', 0, 0, 146, 145, '\\',
  225, 0, 0, 207, 0, 0, 0, '@',
  '{', '}', 245, 0, '|', '/', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE key_map_hr_latin2[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '\'', '+', BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 185, 240,ENTER, 0, 'a', 's',     /*185=s, 240=d*/
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 232,  /*232=c tvrdo*/
  230, 0, 0, 190, 'y', 'x', 'c', 'v',      /*230=c meko,190=z*/
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_hr_latin2[] =
{
  0, ESC, '!', '\"', '#', '$', '%', '&',
  '/', '(', ')', '=', '?', '*', BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', 169, 208,ENTER, 0, 'A', 'S',     /*169=S, 208=D*/
  'D', 'F', 'G', 'H', 'J', 'K', 'L', 200,  /*200=C tvrdo*/
  198, 0, 0, 174, 'Y', 'X', 'C', 'V',      /*198=C meko,174=Z*/
  'B', 'N', 'M', ';', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '>', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_hr_latin2[] =
{
  0, 0, 126, 183, '^', 162, 176, 178,
  '`', 255, 180, 189, 168, 184, 0, 0,
  '\\', '|', 0, 0, 0, 0, 0, 0,
  0, 0, 247, 215,ENTER, 0, 0, 0,
  0, '[', ']', 0, 0, 179, 163, '\\',
  223, 0, 0, 164, 0, 0, 0, '@',
  '{', '}', 167, 0, '|', '/', 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '|', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};


/* Czech keyboard QWERTY */
const BYTE key_map_cz_qwerty[] =
{
  0, ESC, '+', 216, 231, 159, 253, 167,
  236, 160, 161, 130, '=', 0, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i',
  'o', 'p', 163, ')',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 133,
  245, ';', 0, 0, 'z', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '&', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_cz_qwerty[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '%', 0, BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I',
  'O', 'P', '/', '(',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '"',
  '!', 248, 0, '\'', 'Z', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '*', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_cz_qwerty[] =
{
  0, 0, '~', 0, 0, 0, 248, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\\', '|', 169, 0, 0, 0, 0, 0,
  162, 0, 246, 158, 0, 0, 165, 208,
  209, '[', ']', 0, 0,136, 157, '$',
  225, 0, 0, 207, '>', '#', 134, '@',
  '{', '}', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

/* Czech keyboard QWERTZ */
const BYTE key_map_cz_qwertz[] =
{
  0, ESC, '+', 216, 231, 159, 253, 167,
  236, 160, 161, 130, '=', 0, BACKSPACE,TAB,
  'q', 'w', 'e', 'r', 't', 'z', 'u', 'i',
  'o', 'p', 163, ')',ENTER, 0, 'a', 's',
  'd', 'f', 'g', 'h', 'j', 'k', 'l', 133,
  245, ';', 0, 0, 'y', 'x', 'c', 'v',
  'b', 'n', 'm', ',', '.', '-', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '&', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE shift_map_cz_qwertz[] =
{
  0, ESC, '1', '2', '3', '4', '5', '6',
  '7', '8', '9', '0', '%', 0, BACKSPACE,TAB,
  'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I',
  'O', 'P', '/', '(',ENTER, 0, 'A', 'S',
  'D', 'F', 'G', 'H', 'J', 'K', 'L', '"',
  '!', 248, 0, '\'', 'Y', 'X', 'C', 'V',
  'B', 'N', 'M', '?', ':', '_', 0, '*',
  0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, '-', 0, 0, 0, '+', 0,
  0, 0, 0, 0, 0, 0, '*', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

const BYTE alt_map_cz_qwertz[] =
{
  0, 0, '~', 0, 0, 0, 248, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  '\\', '|', 169, 0, 0, 0, 0, 0,
  162, 0, 246, 158, 0, 0, 165, 208,
  209, '[', ']', 0, 0, 136, 157, '$',
  225, 0, 0, 207, '>', '#', 134, '@',
  '{', '}', 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, '<', 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0};

//----------------------------------------------------------------------------

typedef struct
{
    char *sLayout;
    BYTE *KeyPageNormal;
    BYTE *KeyPageShift;
    BYTE *KeyPageAlt;

} TKEYTABLE;

static TKEYTABLE keytable_list[] = {
  {"finnish",
    (BYTE*)key_map_finnish, (BYTE*)shift_map_finnish, (BYTE*)alt_map_finnish },
  {"finnish-latin1",
    (BYTE*)key_map_finnish_latin1, (BYTE*)shift_map_finnish_latin1, (BYTE*)alt_map_finnish_latin1 },
  {"us",
    (BYTE*)key_map_us, (BYTE*)shift_map_us, (BYTE*)alt_map_us },
  {"uk",
    (BYTE*)key_map_uk, (BYTE*)shift_map_uk, (BYTE*)alt_map_uk },
  {"de",
    (BYTE*)key_map_de, (BYTE*)shift_map_de, (BYTE*)alt_map_de },
  {"de-latin1",
    (BYTE*)key_map_de_latin1, (BYTE*)shift_map_de_latin1, (BYTE*)alt_map_de_latin1 },
  {"fr",
    (BYTE*)key_map_fr, (BYTE*)shift_map_fr, (BYTE*)alt_map_fr },
  {"fr-latin1",
    (BYTE*)key_map_fr_latin1, (BYTE*)shift_map_fr_latin1, (BYTE*)alt_map_fr_latin1 },
  {"dk",
    (BYTE*)key_map_dk, (BYTE*)shift_map_dk, (BYTE*)alt_map_dk },
  {"dk-latin1",
    (BYTE*)key_map_dk_latin1, (BYTE*)shift_map_dk_latin1, (BYTE*)alt_map_dk_latin1 },
  {"dvorak",
    (BYTE*)key_map_dvorak, (BYTE*)shift_map_dvorak, (BYTE*)alt_map_dvorak },
  {"sg",
    (BYTE*)key_map_sg, (BYTE*)shift_map_sg, (BYTE*)alt_map_sg },
  {"sg-latin1",
    (BYTE*)key_map_sg_latin1, (BYTE*)shift_map_sg_latin1, (BYTE*)alt_map_sg_latin1 },
  {"keyb-no",
    (BYTE*)key_map_no, (BYTE*)shift_map_no, (BYTE*)alt_map_no },
  {"no-latin1",
    (BYTE*)key_map_no_latin1, (BYTE*)shift_map_no_latin1, (BYTE*)alt_map_no_latin1 },
  {"sf",
    (BYTE*)key_map_sf, (BYTE*)shift_map_sf, (BYTE*)alt_map_sf },
  {"sf-latin1",
    (BYTE*)key_map_sf_latin1, (BYTE*)shift_map_sf_latin1, (BYTE*)alt_map_sf_latin1 },
  {"es",
    (BYTE*)key_map_es, (BYTE*)shift_map_es, (BYTE*)alt_map_es },
  {"es-latin1",
    (BYTE*)key_map_es_latin1, (BYTE*)shift_map_es_latin1, (BYTE*)alt_map_es_latin1 },
  {"be",
    (BYTE*)key_map_be, (BYTE*)shift_map_be, (BYTE*)alt_map_be },
  {"po",
    (BYTE*)key_map_po, (BYTE*)shift_map_po, (BYTE*)alt_map_po },
  {"it",
    (BYTE*)key_map_it, (BYTE*)shift_map_it, (BYTE*)alt_map_it },
  {"sw",
    (BYTE*)key_map_sw, (BYTE*)shift_map_sw, (BYTE*)alt_map_sw },
  {"hu",
    (BYTE*)key_map_hu, (BYTE*)shift_map_hu, (BYTE*)alt_map_hu },
  {"hu-cwi",
    (BYTE*)key_map_hu_cwi, (BYTE*)shift_map_hu_cwi, (BYTE*)alt_map_hu_cwi },
  {"hu-latin2",
    (BYTE*)key_map_hu_latin2, (BYTE*)shift_map_hu_latin2, (BYTE*)alt_map_hu_latin2 },
  {"jp106",
    (BYTE*)key_map_jp106, (BYTE*)shift_map_jp106, (BYTE*)alt_map_jp106 },
  {"pl",
    (BYTE*)key_map_pl, (BYTE*)shift_map_pl, (BYTE*)alt_map_pl },
  {"hr-cp852",
    (BYTE*)key_map_hr_cp852, (BYTE*)shift_map_hr_cp852, (BYTE*)alt_map_hr_cp852 },
  {"hr-latin2",
    (BYTE*)key_map_hr_latin2, (BYTE*)shift_map_hr_latin2, (BYTE*)alt_map_hr_latin2 },
  {"cz-qwerty",
    (BYTE*)key_map_cz_qwerty, (BYTE*)shift_map_cz_qwerty, (BYTE*)alt_map_cz_qwerty },
  {"cz-qwertz",
    (BYTE*)key_map_cz_qwertz, (BYTE*)shift_map_cz_qwertz, (BYTE*)alt_map_cz_qwertz },
  {0},
  {0}
};


/******************************************************************************
*                                                                             *
*   BOOL ReadKbdMapping(BYTE TargetLayout[2][128], char *pRequestedLayout)    *
*                                                                             *
*******************************************************************************
*
*   Find the alternate keyboard mapping and copy it to TargetLayout
*
*   Where:
*       TargetLayout is the init string to pass to linice (preinit to 0)
*       pRequestedLayout is the string with the layout name
*
*   Returns:
*       TRUE - layout name found and data copied
*       FALSE - layout name not found
*
******************************************************************************/
BOOL ReadKbdMapping(BYTE TargetLayout[3][128], char *pRequestedLayout)
{
    TKEYTABLE *pTable = keytable_list;
    int i, j;

    while( pTable->sLayout )
    {
        if( !stricmp(pTable->sLayout, pRequestedLayout) )
        {
            // Found the requested keyboard layout - copy the mapping

            memcpy(TargetLayout[0], pTable->KeyPageNormal,  97);
            memcpy(TargetLayout[1], pTable->KeyPageShift,   97);
            memcpy(TargetLayout[2], pTable->KeyPageAlt,   97);

            // Finally, add some checks since our current keyboard data
            // set is not processed well:
            //  1. Ignore all non-ascii characters - we are not a word processor :p

            for(i=0; i<3; i++)
            {
                for(j=0; j<128; j++)
                {
                    if( TargetLayout[i][j] < 32 )
                        TargetLayout[i][j] = 0;
                }
            }

            return( TRUE );
        }

        pTable++;
    }

    // We did not find a requested keyboard layout
    return( FALSE );
}

