/*************************************************************************
 *   tracer driver Copyright (c) 2008 deroko of ARTeam
 *   This file is part of tracer driver.
 *
 *   xtracer is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   xtracer is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with xtracer.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************************************************************************/
 
#include        "defs.h"

ULONG   old_int01;
ULONG   old_int03;
ULONG   old_int06;
ULONG   old_ints01[32];
ULONG   old_ints03[32];
ULONG   old_ints06[32];
ULONG   rdr0, rdr1, rdr2, rdr3, rdr6, rdr7;

extern  TRACER_DATA td;
extern  HANDLE      traced_pid;
extern  PKEVENT     ring3event;
extern  ULONG       tracer_init;


extern ULONG   OldInt1Handlers[32];
extern ULONG   OldInt1Handler;
extern ULONG   KiTrap0D;

VOID main_handler(VOID);

__declspec(naked) new_int01(){
        __asm{
                cli
                push    cs:[old_int01]
                push    1
                jmp     main_handler
        }
}

__declspec(naked) new_int03(){
        __asm{
                cli
                push    cs:[old_int03]
                push    3
                jmp     main_handler
       }
}

__declspec(naked) new_int06(){
        __asm{
                cli
                push    cs:[old_int06]
                push    6
                jmp     main_handler
       }
}

VOID __declspec(naked) main_handler(VOID){
        __asm{
                pushad
                push    fs
                push    ds
                push    es
                mov     eax, 30h
                mov     fs, ax
                mov     eax, 23h
                mov     ds, ax
                mov     es, ax
                
                cmp     tracer_init, 0                          ;is tracer inited!?
                je      __old_handler
                
                mov     eax, MmHighestUserAddress               ;do not handle kernel memory!!!
                mov     eax, [eax]
                cmp     [esp.regEip], eax
                ja      __old_handler              
                
                call    dword ptr[PsGetCurrentProcessId]        ;do not handle other processes...
                cmp     traced_pid, eax
                jnz     __check_rf_cond  
             
                
                mov     eax, esp
                push    eax
                push    [eax.reg_handler_index]
                call    HandleException
                cli
                cmp     eax, StatusContinue
                je      __return
                cmp     eax, StatusDefault
                je      __default_handler
                cmp     eax, StatusExecuteSoftice
                je      __execute_si
                
__old_handler:  pop     es
                pop     ds
                pop     fs
                popad
                add     esp, 4                                  ;skip handler index!!
                ret                                             ;return to old handler
                
__return:       pop     es
                pop     ds
                pop     fs
                popad
                add     esp, 8
                iretd

__default_handler:
                mov     eax, [esp.reg_handler_address]
                cmp     byte ptr[eax], 068h
                jne     __old_handler
                mov     eax, [eax+1]
                mov     [esp.reg_handler_address], eax
                jmp     __old_handler

__execute_si:   mov     eax, old_int03
                mov     [esp.reg_handler_address], eax
                call    clean_up                                ; clear drX and all other pending requests...
                jmp     __old_handler

                ; hardware breakpoints are global once set through this engine, so only way to 
                ; properly handle them is to set RF flag once drX is hit, but in other process
                ; we will assume here that this is due to global drX usage, and set RF flag, and exit...
                ; In previous version VMWare didnt know how to handle RF properly as I described here:
                ; http://www.woodmann.com/forum/entry.php?176-VMware-ring3-detection-%28RF-handling%29
                ; True, true, I was doing all debugging on live system, and I have no idea why, but I
                ; tried this code on VMWare and it didnt work, but now, before release as of version
                ; 7.1.3 and my latest test on vmware (linux64 and win64 hosts) RF seems to be handled
                ; properly
                ;
                 

__check_rf_cond:
                cmp     [esp.reg_handler_index], 1
                jne     __old_handler
                ;mov     eax, dr6                                ;check if this int1 was caused by any of drX
                ;bt      eax, 14                                 ;due to TF?
                ;jb      __old_handler                           ;if it isnt due to int1 then we assume its drX
                ;bts     [esp.regEflags], 16                     ;set RF
                bts     [esp.regEflags], 16
                and     [esp.regEflags], 0FFFFFEFFh
                jmp     __return                                ;and return...
                
                
        }
                        
        
        
}

void get_drx(){
        __asm{
                mov     eax, dr0
                mov     rdr0, eax
                mov     eax, dr1
                mov     rdr1, eax
                mov     eax, dr2
                mov     rdr2, eax
                mov     eax, dr3
                mov     rdr3, eax
                mov     eax, dr6
                mov     rdr6, eax
                mov     eax, dr7
                mov     rdr7, eax
        }
}

ULONG   HandleException(ULONG vector, PREGSX86 pregs32){
        ULONG state;
        
        AcquireInternalLock();        
        td.dwProcessId = PsGetCurrentProcessId();
        td.dwThreadId  = PsGetCurrentThreadId();
        InterlockedExchange(&td.dwStatus, StatusException);
        
        td.x86_regs.reg_eax    = pregs32->regEax;
        td.x86_regs.reg_ecx    = pregs32->regEcx;
        td.x86_regs.reg_edx    = pregs32->regEdx;
        td.x86_regs.reg_ebx    = pregs32->regEbx;
        td.x86_regs.reg_esp    = pregs32->regEspR3;
        td.x86_regs.reg_ebp    = pregs32->regEbp;
        td.x86_regs.reg_esi    = pregs32->regEsi;
        td.x86_regs.reg_edi    = pregs32->regEdi;
        td.x86_regs.reg_eip    = pregs32->regEip;
        td.x86_regs.reg_eflags = pregs32->regEflags;
        td.x86_regs.handler    = vector;
        get_drx();
        td.x86_regs.reg_dr0    = rdr0;
        td.x86_regs.reg_dr1    = rdr1;
        td.x86_regs.reg_dr2    = rdr2;
        td.x86_regs.reg_dr3    = rdr3;
        td.x86_regs.reg_dr6    = rdr6;
        td.x86_regs.reg_dr7    = rdr7;
            
        KeSetEvent(ring3event, IO_NO_INCREMENT, FALSE);
        spin_loop();
        
        pregs32->regEax    = td.x86_regs.reg_eax;
        pregs32->regEcx    = td.x86_regs.reg_ecx;
        pregs32->regEdx    = td.x86_regs.reg_edx;
        pregs32->regEbx    = td.x86_regs.reg_ebx;
        pregs32->regEspR3  = td.x86_regs.reg_esp;
        pregs32->regEbp    = td.x86_regs.reg_ebp;
        pregs32->regEsi    = td.x86_regs.reg_esi;
        pregs32->regEdi    = td.x86_regs.reg_edi;
        pregs32->regEip    = td.x86_regs.reg_eip;
        pregs32->regEflags = td.x86_regs.reg_eflags;
        
        // used to set drX on all cpus!!! 
        rdr0               = td.x86_regs.reg_dr0;
        rdr1               = td.x86_regs.reg_dr1;
        rdr2               = td.x86_regs.reg_dr2;
        rdr3               = td.x86_regs.reg_dr3;
        rdr6               = td.x86_regs.reg_dr6;
        rdr7               = td.x86_regs.reg_dr7;
        fire_dpc();
        
        state = td.dwStatus;
        ReleaseInternalLock();
        return state;
}

ULONG   HookInterupt(ULONG NewIntAddress, ULONG IdtVector, PULONG OldIntTable, PULONG OldInterupt){
        ULONG OldIntHandler;
        IDT_BASE idt_base;
        PIDT_ENTRY idt_entry;
        
        __asm   sidt  idt_base      
        idt_entry = (PIDT_ENTRY)((idt_base.IdtBaseHi << 16) + idt_base.IdtBaseLo);

        __asm   pushfd
        __asm   cli

        OldIntHandler = (idt_entry[ IdtVector ].OffsetHigh <<16) + idt_entry[ IdtVector ].OffsetLow;
        idt_entry[ IdtVector ].OffsetHigh = (USHORT)(NewIntAddress >> 16);
        idt_entry[ IdtVector ].OffsetLow  = (USHORT)(NewIntAddress & 0xFFFF);
        
        if (OldIntTable != NULL)
                *OldIntTable = OldIntHandler;
        if (OldInterupt != NULL)
                if (*OldInterupt == 0)
                        *OldInterupt = OldIntHandler;
        
        __asm   popfd                           //if interupts were disabled prior to hook then don't enable them...
        return 0;
}


VOID    hook_interups(){
        PKTHREAD cur_thread;
        UCHAR    i;
        PIDT_ENTRY pidtentry;
        IDT_BASE   idt_base;
        
        cur_thread = PsGetCurrentThread();
        for (i = 0; i < KeNumberProcessors; i++){
                KeSetAffinityThread(cur_thread, 1 << i);
                HookInterupt((ULONG)new_int01, 0x01, &old_ints01[i], &old_int01);
                HookInterupt((ULONG)new_int03, 0x03, &old_ints03[i], &old_int03);
                HookInterupt((ULONG)new_int06, 0x06, &old_ints06[i], &old_int06);
        }
        __asm   sidt  idt_base
               
        pidtentry = (PIDT_ENTRY)((idt_base.IdtBaseHi << 16) + idt_base.IdtBaseLo);
        KiTrap0D = (pidtentry[0x0D].OffsetHigh << 16) + pidtentry[0x0D].OffsetLow;
        for (i = 0; i < KeNumberProcessors; i++){
                KeSetAffinityThread(cur_thread, 1<<i);
                HookInterupt((ULONG)Int1Hook,1, &OldInt1Handlers[i], &OldInt1Handler);
                //as we hook also set dr7 GD bit
                __asm   mov     eax, dr7
                __asm   bts     eax, 13
                __asm   mov     dr7, eax

        }
}