#!/usr/bin/perl

## guidextract.pl - create label/offset map for embedded binary 
## guids found in provided guid list. Should be helpful to decipher
## OLE functions in a disassembly. If the correct hex offset is 
## provided this will produce a file suitable for import into OllyDbg 
## using the LabelMaster plugin.
##
## (c)2004 Joe Stewart <jstewart@lurhq.com>
##
## Usage: ./guidextract.pl <unpacked executable> <outfile> [va hex offset]
##
## Example: ./guidextract.pl bho.dll bho-ole-labels.txt 10000000
## Output in bho-ole-labels.txt might look like:
## 10017B98        DWebBrowserEvents2
## 10017BA8        IConnectionPointContainer
## 10017BC8        IWebBrowser2
## 10017BD8        IDispatch
## 10017BE8        IUnknown
## ...

my $file = $ARGV[0];
my $outfile = $ARGV[1];
my $offset = hex($ARGV[2]) || 0;

die "Usage: $0 <unpacked executable> <outfile> [va hex offset]\n" 
  unless $file && $outfile;

open(GUIDS, "guids.txt") or die "Couldn't open guids.txt : $!\n";

my %guidhash;

while(<GUIDS>) {
  my ($g,$n) = split(/\s+/);
  $g = uc($g);
  $guidhash{$g} = $n;
}
close GUIDS;

open(IN, $file) or die "Couldn't open $file : $!\n";
open(OUT, ">$outfile") or die "Couldn't open $outfile : $!\n";

my $pos = 0;
my $count = 0;

while(!eof(IN)) {
  my $r = 0;
  $r = read(IN, $g1, 4);
  $r += read(IN, $g2, 2);
  $r += read(IN, $g3, 2);
  $r += read(IN, $g4, 2);
  $r += read(IN, $g5, 6);
  last if $r != 16;

  $guid = sprintf("%08X-%04X-%04X-%04X-%s",
	unpack("L", $g1),
	unpack("S", $g2),
	unpack("S", $g3),
	unpack("n", $g4),
        string2hex($g5));
  if ($guidhash{$guid}) { 
    printf OUT "%08X\t%s\n", $pos + $offset, $guidhash{$guid};
    $count++;
  }
  seek(IN, ++$pos, 0) or last;
}
close OUT;
close IN;
printf "Wrote %d labels to $outfile\n", $count;

sub string2hex {
  my $string = shift;
  my $ret;
  my $len = length($string) - 1;
  for (0..$len) {
    $ret .= sprintf("%02X", ord(substr($string,$_,1)));
  }
  return $ret;
}
