#!/usr/bin/perl

## listmethods.pl - search Windows header files for OLE interface Vtbl
## information and show method names with corresponding offsets
##
## (c)2004 Joe Stewart <jstewart@lurhq.com>
##
## Usage: ./listmethods.pl <IID> 
## 
## Quick-and-dirty. Uses grep as a shortcut to find Vtbl names, so you 
## should run on *nix or under Cygwin. Run this file in the same 
## directory as your Windows header files

use strict;

my $interface = $ARGV[0];
die "Usage: $0 <IID>\n" unless $interface;
chomp(my $file = `grep ${interface}Vtbl * | cut -d ':' -f 1 | head -1`);
#print "grep ${interface}Vtbl * | cut -d ':' -f 1 | head -1\n";
die "Could not find ${interface}Vtbl in header files\n" unless $file;

$file =~ s/\s//g;
open(IN, $file) or die "Could not open $file : $!\n";
my ($instruct, $ininterface, $count);

while(<IN>) {
  chomp(my $line = $_);
  if ($line =~ /typedef struct ${interface}Vtbl/i) {
    $instruct = 1;
   } elsif ($line =~ /\}\s+${interface}Vtbl\;/) {
    $instruct = 0;
   } elsif ($line =~ /BEGIN_INTERFACE/) {
    $ininterface = 1;
   } elsif ($line =~ /END_INTERFACE/) {
    $ininterface = 0;
   }

   next unless $instruct && $ininterface;

  if ($line =~ /__RPC_FAR (.*)\)\(/) {
    my $method = $1;
    $method =~ s/\*//g;
    my $formatcount = ($count == 0) ? "[r32]" 
	: sprintf "[r32+%X]", $count*4 ;
    print "$formatcount\t\t$interface" . "->" . "$method\n";
    $count++;
   }
}
