#!/usr/bin/perl

## reg2guidlist.pl - create OLE Interfaces guid-to-name 
## map from registry dump for use with guidextract.pl
##
## (c)2004 Joe Stewart <jstewart@lurhq.com>
##
## Usage: ./reg2guidlist.pl <W9x/NT formatted HKCR registry text export file>

use strict;

my $file = $ARGV[0];
my $outfile = "guids.txt";
my $count = 0;

die "Usage: $0 <W9x/NT (REGEDIT4) formatted HKCR export file>\n" 
  unless $file && $outfile;

open (IN, $file) or die "Couldn't open $file: $!\n";
open (OUT, ">$outfile") or die "Couldn't open $outfile : $!\n";

while(<IN>) {
  chomp (my $line = $_);
  $line =~ s/\r//g;
  if ($line =~ /^\[HKEY_CLASSES_ROOT\\Interface\\\{([A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12})\}\]$/) {
    my $guid = $1;
    chomp(my $next = <IN>);
    $next =~ s/\r//g;
    if ($next =~ /^\@="(.*)"$/) {
      my $name = $1;
      print OUT "$guid\t$name\n";
      $count++;
    }
  }
}
close OUT;
close IN;
printf "Wrote %d GUIDs to $outfile\.\n", $count;
