// OllyDump
// Purpose: Dump debuggee process memory and Rebuild IAT

// VERY IMPORTANT NOTICE: COMPILE THIS DLL WITH BYTE ALIGNMENT OF STRUCTURES
// AND UNSIGNED CHAR!

//#define  DEBUG

#define PNAME   "OllyDump"
#define PVERS   "v3.00.110"
#define ANAME   "Gigapede"


#define _WIN32_WINNT 0x0400

#include <windows.h>
#include <commctrl.h>

#include <odbg\plugin.h>        // Please change for your environment
#include "resource.h"

HINSTANCE hinst;                // DLL instance
HWND      hwmain;               // Handle of main OllyDbg window
WNDPROC   SecLstDlgProcOrg;         // Original Window Procedure of Section info List Control

char      strCurEIP[TEXTLEN];
char      szFileName[MAX_PATH]={0},szFile[MAX_PATH]={0},szWorkPath[MAX_PATH]={0};
BOOL      blFixSect,blRebuild;
LPBYTE    DbgePath,DbgeName,lpszSectName;
int       iRebMethod;

LRESULT CALLBACK MainDlgProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SecLstDlgProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SecEdtDlgProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK OptDlgProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ImptDlgProc(HWND, UINT, WPARAM, LPARAM);
//LRESULT CALLBACK DatDirDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL  GetPEInfo(void);
BOOL  SaveDump(HWND);
BOOL  IsValidNumber(char *, int, int);
void  FreeSectInfo(void);
int   FindOEPbySectionHop(int);
DWORD GetCurrentEIP(void);

t_thread  *pthread;

BOOL RebuildImport(char *szTargetFile);
BYTE RebuildITDeluxe(char *szTargetFile, BYTE byRebuildType);

#define NUM_DEC  1
#define NUM_HEX  2

#define ODP_TRACE_INTO  0
#define ODP_TRACE_OVER  1

char szODPath[MAX_PATH],szODIni[MAX_PATH],szPluginPath[MAX_PATH],szPluginIni[MAX_PATH],*pdest;
BOOL  SearchAnimation;
BOOL  SearchLog;
DWORD AnimationWait;

typedef struct {
  WORD  woNumOfSect;
  DWORD dwImageBase;
  DWORD dwSizeOfImage;
  DWORD dwAddrOfEP;
  DWORD dwBaseOfCode;
  DWORD dwBaseOfData;
} PEFILEINFO, *LPPEFILEINFO;

typedef struct {
  BYTE  byName[IMAGE_SIZEOF_SHORT_NAME];
  DWORD dwVSize;
  DWORD dwVOffset;
  DWORD dwRSize;
  DWORD dwROffset;
  DWORD dwCharacteristics;
} SECTIONINFO, *LPSECTIONINFO;

PEFILEINFO    PEFileInfo,PEFileInfoWrk;
LPSECTIONINFO lpSectInfo = NULL;
SECTIONINFO   SectInfoWrk;
BOOL TraceFlag = FALSE;

BOOL WINAPI DllEntryPoint(HINSTANCE hi,DWORD reason,LPVOID reserved) {
  if (reason==DLL_PROCESS_ATTACH)
    hinst=hi;                          // Mark plugin instance
  return 1;                            // Report success
};

extc int _export cdecl ODBG_Plugindata(char shortname[32]) {
  strcpy(shortname,PNAME);       // Name of plugin
  return PLUGIN_VERSION;
};

extc int _export cdecl ODBG_Plugininit(int ollydbgversion,HWND hw,ulong *features) {
  if(ollydbgversion<PLUGIN_VERSION) {
    return -1;
  }
  hwmain=hw;

  GetModuleFileName(NULL, szODPath, MAX_PATH);
  pdest = strrchr(szODPath, '\\');
  pdest[1] = '\0';
  wsprintf(szODIni,"%sollydbg.ini",szODPath);
  GetPrivateProfileString("History","Plugin path",szODPath,szPluginPath,sizeof(szPluginPath),szODIni);
  wsprintf(szPluginIni,"%s\\%s.ini",szPluginPath,PNAME);
  SearchAnimation = GetPrivateProfileInt("OPTIONS", "Search Animation",  0, szPluginIni);
  SearchLog       = GetPrivateProfileInt("OPTIONS", "Search Log"      ,  0, szPluginIni);
  AnimationWait   = GetPrivateProfileInt("OPTIONS", "Animation Wait"  , 60, szPluginIni);

  Addtolist(0, 0,PNAME " " PVERS "  by " ANAME);
  return 0;
};

extc int _export cdecl ODBG_Pluginmenu(int origin,char data[4096],void *item) {
  switch (origin) {
  case PM_MAIN: // Plugin menu in main window
    strcpy(data,
           "0 &Dump debugged process|"
           "1 Find OEP by Section Hop (Trace &into),"
           "2 Find OEP by Section Hop (Trace &over)|"
           "50 Options|"
           "63 &About"
          );
    return 1;
  case PM_DISASM:
    if(Getstatus() == STAT_NONE) {
      return 0;
    }
    strcpy(data,"0 &Dump debugged process");
    return 1;
  default:
    break; // Any other window
  };
  return 0; // Window not supported by plugin
};

extc void _export cdecl ODBG_Pluginaction(int origin,int action,void *item) {
  int id;
  char buf[TEXTLEN];

  switch(origin) {
  case PM_MAIN:
  case PM_DISASM:
    switch (action) {
    case 0:
      if(Getstatus() == STAT_NONE) {
        MessageBox(hwmain,"No process to dump!!",PNAME,MB_OK);
        return;
      }
      if(lpSectInfo) {
        FreeSectInfo();
      }
      GetPEInfo();
      id = DialogBox(hinst,MAKEINTRESOURCE(IDD_OLLYDUMP),hwmain,(DLGPROC)MainDlgProc);
      if(id == IDOK) {
        SaveDump(hwmain);
      }
      FreeSectInfo();

      break;
    case 1:
      if(Getstatus() == STAT_NONE) {
        MessageBox(hwmain,"No process to monitor!!",PNAME,MB_OK);
        return;
      }
      FindOEPbySectionHop(0);
      break;
    case 2:
      if(Getstatus() == STAT_NONE) {
        MessageBox(hwmain,"No process to monitor!!",PNAME,MB_OK);
        return;
      }
      FindOEPbySectionHop(1);
      break;
    case 50:
      id = DialogBox(hinst,MAKEINTRESOURCE(IDD_OPTIONS),hwmain,(DLGPROC)OptDlgProc);
      if(id == IDOK) {
        wsprintf(buf,"%d",SearchAnimation);
        WritePrivateProfileString("OPTIONS", "Search Animation", buf, szPluginIni);
        wsprintf(buf,"%d",AnimationWait);
        WritePrivateProfileString("OPTIONS", "Animation Wait"  , buf, szPluginIni);
        wsprintf(buf,"%d",SearchLog);
        WritePrivateProfileString("OPTIONS", "Search Log"  , buf, szPluginIni);
      }
      break;
    case 63:
      // Menu item "About", displays plugin info.
      MessageBox(hwmain,
                 PNAME" "PVERS
                 "\n    "
                 "by "ANAME"  ",
                 "About "PNAME,
                 MB_OK|MB_ICONINFORMATION);
      break;
    default:
      break;
    }
  }
}

extc void _export cdecl ODBG_Pluginreset(void) {
  if(lpSectInfo) {
    FreeSectInfo();
    lpSectInfo = NULL;
    Addtolist(0,-1,"==%s DEBUG== in ODBG_Pluginreset  Free allocated memory lpSectInfo",PNAME);
  }
  return;
}

extc int _export cdecl ODBG_Pluginclose(void) {
  if(lpSectInfo) {
    FreeSectInfo();
    lpSectInfo = NULL;
    Addtolist(0,-1,"==%s DEBUG== in ODBG_Pluginclose  Free allocated memory lpSectInfo",PNAME);
  }
  return 0;
}

extc void _export cdecl ODBG_Plugindestroy(void) {
  if(lpSectInfo) {
    FreeSectInfo();
    lpSectInfo = NULL;
  }
  return;
}

extc void _export cdecl ODBG_Pluginmainloop(DEBUG_EVENT *debugevent) {
  t_status  status;

  if(TraceFlag) {
    status = Getstatus();
    if(status == STAT_STOPPED) {
      pthread = Findthread(Getcputhreadid());
      if(!pthread) {
        return;
      }
      if(pthread->reg.ip > PEFileInfo.dwImageBase && pthread->reg.ip < PEFileInfo.dwSizeOfImage) {
        if(PEFileInfo.dwAddrOfEP + PEFileInfo.dwImageBase != pthread->reg.ip) {
          Addtolist(0,-1,"EntryPoint is %X and Original Entry Point may be %X",PEFileInfo.dwAddrOfEP,pthread->reg.ip);
          TraceFlag = FALSE;
        }
      }
    }
  }
}

BOOL GetPEInfo(void)
{
  int i;
  char msg[TEXTLEN];
  HANDLE hFile,hHeap;
  PIMAGE_DOS_HEADER idosh;
  PIMAGE_NT_HEADERS ipeh;
  PIMAGE_SECTION_HEADER isech;
  LPBYTE fbuf;
  DWORD dwFsiz,dwRsiz;

  DbgePath = (char*)Plugingetvalue(VAL_EXEFILENAME);
  DbgeName = strrchr(DbgePath,'\\');
  memset(szWorkPath,0,sizeof(szWorkPath));
  strncpy(szWorkPath,DbgePath,(DbgeName-DbgePath));
  DbgeName++;

  // Read Debuggee
  hFile = CreateFile(DbgePath,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
  if(hFile == INVALID_HANDLE_VALUE) {
    wsprintf(msg,"Cannot Create File %s",DbgePath);
    MessageBox(hwmain,msg,PNAME,MB_OK);
    return FALSE;
  }
  dwFsiz = GetFileSize(hFile,NULL);
  hHeap = HeapCreate(HEAP_NO_SERIALIZE,1,0);
  fbuf = (char *)HeapAlloc(hHeap, 0, dwFsiz);
  if(ReadFile(hFile,fbuf,dwFsiz,&dwRsiz,NULL) == 0) {
    MessageBox(hwmain,"Can\'t Read File ",PNAME" Error!",MB_OK|MB_ICONEXCLAMATION);
    CloseHandle(hFile);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  CloseHandle(hFile);

  // Get PE Header info
  idosh = (PIMAGE_DOS_HEADER)fbuf;
  if(idosh->e_magic != IMAGE_DOS_SIGNATURE) {
    MessageBox(hwmain,"Bad DOS Signature!!",PNAME,MB_OK | MB_ICONEXCLAMATION);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  ipeh = (PIMAGE_NT_HEADERS)(fbuf + idosh->e_lfanew);
  if(ipeh->Signature != IMAGE_NT_SIGNATURE) {
    MessageBox(hwmain,"Bad PE Signature!!",PNAME,MB_OK | MB_ICONEXCLAMATION);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
    return FALSE;
  }
  PEFileInfo.woNumOfSect   = ipeh->FileHeader.NumberOfSections;
  PEFileInfo.dwImageBase   = ipeh->OptionalHeader.ImageBase;
  PEFileInfo.dwSizeOfImage = ipeh->OptionalHeader.SizeOfImage;
  PEFileInfo.dwBaseOfCode  = ipeh->OptionalHeader.BaseOfCode ;
  PEFileInfo.dwBaseOfData  = ipeh->OptionalHeader.BaseOfData ;
  PEFileInfo.dwAddrOfEP    = ipeh->OptionalHeader.AddressOfEntryPoint;

  lpSectInfo = (LPSECTIONINFO)malloc(sizeof(SECTIONINFO)*(PEFileInfo.woNumOfSect+1));
  ZeroMemory(lpSectInfo,sizeof(SECTIONINFO)*(PEFileInfo.woNumOfSect+1));
  isech = IMAGE_FIRST_SECTION(ipeh);
  for(i=0; i<(int)PEFileInfo.woNumOfSect; i++) {
    strcpy((lpSectInfo+i)->byName,(isech+i)->Name);
    (lpSectInfo+i)->dwVSize            = (isech+i)->Misc.VirtualSize;
    (lpSectInfo+i)->dwVOffset          = (isech+i)->VirtualAddress;
    (lpSectInfo+i)->dwRSize            = (isech+i)->SizeOfRawData;
    (lpSectInfo+i)->dwROffset          = (isech+i)->PointerToRawData;
    (lpSectInfo+i)->dwCharacteristics  = (isech+i)->Characteristics;
  }
  HeapFree(hHeap,HEAP_NO_SERIALIZE,fbuf);
  return TRUE;
}

void FreeSectInfo(void)
{
  if(lpSectInfo) {
    free(lpSectInfo);
  }
  lpSectInfo = NULL;
}

int FindOEPbySectionHop(int tracemode)
{
  int i;
  DWORD out0,out1,in0,in1,curEIP,curSectVA1,curSectVA2;
  t_reg reg;

  Deleteruntrace();
  TraceFlag = TRUE;
  // Clear Section Info buffer
  if(lpSectInfo) {
    FreeSectInfo();
  }

  // Get PE file header value
  GetPEInfo();
  curEIP = GetCurrentEIP();
  Addtolist(0,-1,"EP:%X  ImageBase:%X  SizeOfImage:%X  Current EIP:%X",PEFileInfo.dwAddrOfEP,PEFileInfo.dwImageBase,PEFileInfo.dwSizeOfImage,curEIP);

  // Search a section the Entry Point belongs
  out0 = out1 = 0;
  for(i=0; i<PEFileInfo.woNumOfSect; i++) {
//Addtolist(0,-1,"Sect%02d : %8X - %8X",i,lpSectInfo[i].dwVOffset,lpSectInfo[i].dwVOffset+lpSectInfo[i].dwVSize-1);
    curSectVA1 = lpSectInfo[i].dwVOffset + PEFileInfo.dwImageBase;
    curSectVA2 = curSectVA1 + lpSectInfo[i].dwVSize;
    if(curEIP >= curSectVA1 && curEIP < curSectVA2) {
      out0 = lpSectInfo[i].dwVOffset + PEFileInfo.dwImageBase;
      out1 = out0 + lpSectInfo[i].dwVSize - 1;
      break;
    }
  }
  if(out0 != 0 && out1 > out0) {
    Settracecondition(NULL,0,0,0,out0,out1);
    Addtolist(0,-1,"Current EIP\(%08X\) is in Section%02d  %08X - %08X",curEIP,i,curSectVA1,curSectVA2);
    Addtolist(0,-1,"Trace Condition set out0:%X  out1:%X",out0,out1);
  }
  else {
    in0 = lpSectInfo[0].dwVOffset + PEFileInfo.dwImageBase;
    in1 = lpSectInfo[PEFileInfo.woNumOfSect-1].dwVOffset + lpSectInfo[PEFileInfo.woNumOfSect-1].dwVSize + PEFileInfo.dwImageBase;
    Settracecondition(NULL,0,in0,in1,0,0);
    Addtolist(0,-1,"Current EIP\(%08X\) is out of Debuggee image",curEIP);
    Addtolist(0,-1,"Trace Condition set in0:%X  in1:%X",in0,in1);
  }
  Startruntrace(&reg);
  switch(tracemode) {
  case ODP_TRACE_INTO:
    Sendshortcut(PM_MAIN,0,WM_KEYDOWN,1,0,VK_F11); // Trace into
    break;
  case ODP_TRACE_OVER:
    Sendshortcut(PM_MAIN,0,WM_KEYDOWN,1,0,VK_F12); // Trace over
    break;
  }
  return TRUE;
}

BOOL SaveDump(HWND hWnd)
{
  BOOL ans;
  int i;
  OPENFILENAME ofn;
  HANDLE hFile,hHeap;
  LPBYTE lpDumpData;
  DWORD dwFrom,dwSize,dwAccBytes;
  PIMAGE_DOS_HEADER idosh;
  PIMAGE_NT_HEADERS ipeh;
  PIMAGE_SECTION_HEADER isech;

  dwFrom = PEFileInfo.dwImageBase;
  dwSize = PEFileInfo.dwSizeOfImage;

  hHeap = HeapCreate(HEAP_NO_SERIALIZE,1,0);
  lpDumpData = HeapAlloc(hHeap,HEAP_NO_SERIALIZE | HEAP_ZERO_MEMORY,dwSize);
  dwSize = Readmemory(lpDumpData,dwFrom,dwSize,MM_RESTORE);

  idosh = (PIMAGE_DOS_HEADER)lpDumpData;
  if(idosh->e_magic != IMAGE_DOS_SIGNATURE) {
    MessageBox(hwmain,"Bad DOS Signature!!",PNAME,MB_OK | MB_ICONEXCLAMATION);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,lpDumpData);
    return FALSE;
  }
  ipeh = (PIMAGE_NT_HEADERS)(lpDumpData + idosh->e_lfanew);
  if(ipeh->Signature != IMAGE_NT_SIGNATURE) {
    MessageBox(hwmain,"Bad PE Signature!!",PNAME,MB_OK | MB_ICONEXCLAMATION);
    HeapFree(hHeap,HEAP_NO_SERIALIZE,lpDumpData);
    return FALSE;
  }
  ipeh->FileHeader.NumberOfSections        = PEFileInfo.woNumOfSect;
  ipeh->OptionalHeader.ImageBase           = PEFileInfo.dwImageBase;
  ipeh->OptionalHeader.SizeOfImage         = PEFileInfo.dwSizeOfImage;
  ipeh->OptionalHeader.BaseOfCode          = PEFileInfo.dwBaseOfCode;
  ipeh->OptionalHeader.BaseOfData          = PEFileInfo.dwBaseOfData;
  ipeh->OptionalHeader.AddressOfEntryPoint = PEFileInfo.dwAddrOfEP;

  isech = IMAGE_FIRST_SECTION(ipeh);
  if(blFixSect) {
    for(i=0; i<(int)PEFileInfo.woNumOfSect; i++) {
      strcpy((isech+i)->Name,(lpSectInfo+i)->byName);
      (isech+i)->Misc.VirtualSize = (lpSectInfo+i)->dwVSize;
      (isech+i)->VirtualAddress   = (lpSectInfo+i)->dwVOffset;
      (isech+i)->SizeOfRawData    = (lpSectInfo+i)->dwRSize;
      (isech+i)->PointerToRawData = (lpSectInfo+i)->dwROffset;
      (isech+i)->Characteristics  = (lpSectInfo+i)->dwCharacteristics;
    }
  }

  memset(szFileName,0,sizeof(szFileName));
  memset(szFile,0,sizeof(szFile));
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize     = sizeof(OPENFILENAME);
  ofn.hwndOwner       = hWnd;
  ofn.lpstrFilter     = "Executable file(*.exe)\0*.exe\0All files(*.*)\0*.*\0\0";
  ofn.lpstrFile       = szFileName;
  ofn.lpstrFileTitle  = szFile;
  ofn.nMaxFile        = MAX_PATH;
  ofn.lpstrInitialDir = szWorkPath;
  ofn.Flags           = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
  ofn.lpstrDefExt     = "exe";
  ofn.lpstrTitle      = "Save Dump to File";

  ans = GetSaveFileName(&ofn);
  UpdateWindow(hwmain);
  if(ans) {
    hFile = CreateFile(szFileName, GENERIC_READ | GENERIC_WRITE, 0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
    if(hFile != INVALID_HANDLE_VALUE) {
      SetFilePointer(hFile, 0, 0, FILE_BEGIN);
      WriteFile(hFile, lpDumpData, dwSize, &dwAccBytes, NULL);
      CloseHandle(hFile);
    }
  }
  HeapFree(hHeap,HEAP_NO_SERIALIZE,lpDumpData);

  if(blRebuild) {
    switch(iRebMethod) {
    case 1:
      RebuildImport(szFileName);
      break;
    case 2:
      RebuildITDeluxe(szFileName,1);
      break;
    default:
      break;
    }
  }
  return 0;
}

LRESULT CALLBACK OptDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  switch (msg) {
  case WM_INITDIALOG:
    SendMessage(GetDlgItem(hDlgWnd, IDC_CHK_ANIMATION),BM_SETCHECK,(WPARAM)SearchAnimation, 0L);
    SendMessage(GetDlgItem(hDlgWnd, IDC_CHK_SEARCHLOG),BM_SETCHECK,(WPARAM)SearchLog      , 0L);
    SetDlgItemInt(hDlgWnd,IDC_EDT_ANIMWAIT,AnimationWait,FALSE);
    break;
  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDOK:
      SearchAnimation = ((IsDlgButtonChecked(hDlgWnd,IDC_CHK_ANIMATION) == BST_CHECKED) ? 1 : 0);
      SearchLog       = ((IsDlgButtonChecked(hDlgWnd,IDC_CHK_SEARCHLOG) == BST_CHECKED) ? 1 : 0);
      AnimationWait   = GetDlgItemInt(hDlgWnd,IDC_EDT_ANIMWAIT,NULL,FALSE);
      EndDialog(hDlgWnd, IDOK);
      break;
    case IDCANCEL:
      EndDialog(hDlgWnd, IDCANCEL);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

LRESULT CALLBACK ImpDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch(msg) {
	case WM_INITDIALOG:
		break;
	case WM_COMMAND:
		switch(LOWORD(wp)) {
		case IDOK:
			EndDialog(hDlgWnd, IDOK);
			break;
		case IDCANCEL:
			EndDialog(hDlgWnd, IDCANCEL);
			break;
		default:
			break;
		}
	default:
		return FALSE;
	}
	return TRUE;
}
/*
LRESULT CALLBACK DatDirDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  switch (msg) {
  case WM_INITDIALOG:
    break;

  case WM_COMMAND:
    switch (LOWORD(wp)) {
      break;
    case IDOK:
      EndDialog(hDlgWnd, IDOK);
      break;
    case IDCANCEL:
      EndDialog(hDlgWnd, IDCANCEL);
      break;
    }
    break;
  default:
    return FALSE;
    break;
  }
  return TRUE;
}
*/

LRESULT CALLBACK SecLstDlgProc(HWND hList, UINT msg, WPARAM wp, LPARAM lp)
{
  POINT pt;
  LV_ITEM item;
  LPBYTE stop;
  HMENU hMenu,hSubMenu;
  int   nItem,id;
  char  buf[TEXTLEN];

  switch (msg) {
  case WM_RBUTTONDOWN:
    pt.x = LOWORD(lp);
    pt.y = HIWORD(lp);
    hMenu = LoadMenu(hinst, MAKEINTRESOURCE(IDM_SECTLIST));
    hSubMenu = GetSubMenu(hMenu, 0);
    ClientToScreen(hList, &pt);
    TrackPopupMenu(hSubMenu, TPM_LEFTALIGN, pt.x, pt.y, 0, hList, NULL);
    DestroyMenu(hMenu);
    break;

  case WM_LBUTTONDBLCLK:
    SendMessage(hList,WM_COMMAND,(WPARAM)IDM_EDITSECT,0);
    break;

  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDM_EDITSECT:
      //nItem = ListView_GetNextItem(hList,-1,LVNI_ALL|LVNI_SELECTED);
      nItem = SendMessage(hList,(LVM_GETNEXTITEM),(WPARAM)(-1),MAKELPARAM(((UINT)LVNI_SELECTED),0));

      item.mask       = LVIF_TEXT;
      item.cchTextMax = sizeof(buf);

      item.pszText  = buf;
      item.iItem    = nItem;
      item.iSubItem = 0;
      ListView_GetItem(hList, &item);
      wsprintf(SectInfoWrk.byName,"%s",buf);

      item.pszText  = buf;
      item.iItem    = nItem;
      item.iSubItem = 1;
      ListView_GetItem(hList, &item);
      SectInfoWrk.dwVSize = strtoul(buf,&stop,16);

      item.pszText  = buf;
      item.iItem    = nItem;
      item.iSubItem = 2;
      ListView_GetItem(hList, &item);
      SectInfoWrk.dwVOffset = strtoul(buf,&stop,16);

      item.pszText  = buf;
      item.iItem    = nItem;
      item.iSubItem = 3;
      ListView_GetItem(hList, &item);
      SectInfoWrk.dwRSize = strtoul(buf,&stop,16);

      item.pszText  = buf;
      item.iItem    = nItem;
      item.iSubItem = 4;
      ListView_GetItem(hList, &item);
      SectInfoWrk.dwROffset = strtoul(buf,&stop,16);

      item.pszText  = buf;
      item.iItem    = nItem;
      item.iSubItem = 5;
      ListView_GetItem(hList, &item);
      SectInfoWrk.dwCharacteristics = strtoul(buf,&stop,16);

      id = DialogBox(hinst,MAKEINTRESOURCE(IDD_EDITSECT),hList,(DLGPROC)SecEdtDlgProc);
      if(id == IDOK) {
        item.mask       = LVIF_TEXT;
        item.cchTextMax = sizeof(buf);

        item.pszText  = SectInfoWrk.byName;
        item.iItem    = nItem;
        item.iSubItem = 0;
        ListView_SetItem(hList, &item);

        wsprintf(buf,"%08X",SectInfoWrk.dwVSize);
        item.pszText  = buf;
        item.iItem    = nItem;
        item.iSubItem = 1;
        ListView_SetItem(hList, &item);

        wsprintf(buf,"%08X",SectInfoWrk.dwVOffset);
        item.pszText  = buf;
        item.iItem    = nItem;
        item.iSubItem = 2;
        ListView_SetItem(hList, &item);

        wsprintf(buf,"%08X",SectInfoWrk.dwRSize);
        item.pszText  = buf;
        item.iItem    = nItem;
        item.iSubItem = 3;
        ListView_SetItem(hList, &item);

        wsprintf(buf,"%08X",SectInfoWrk.dwROffset);
        item.pszText  = buf;
        item.iItem    = nItem;
        item.iSubItem = 4;
        ListView_SetItem(hList, &item);

        wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
        item.pszText  = buf;
        item.iItem    = nItem;
        item.iSubItem = 5;
        ListView_SetItem(hList, &item);
      }

      break;
    /*
    case IDM_ADDSECT:
      MessageBox(hList,"Add Section","DEBUG",MB_OK);
      break;
    case IDM_DELSECT:
      while(1) {
        nItem = ListView_GetNextItem(hList,-1,LVNI_ALL | LVNI_SELECTED);
        if (nItem == -1) {
          break;
        }
        ListView_DeleteItem(hList, nItem);
      }
      MessageBox(hList,"Delete Section","DEBUG",MB_OK);
      break;
      */
    default:
      break;
    }
  default:
    break;
  }
  return (CallWindowProc((WNDPROC)SecLstDlgProcOrg, hList, msg, wp, lp));
}

LRESULT CALLBACK SecEdtDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  int ichk;
  char buf[TEXTLEN];
  LPBYTE stop;

  switch (msg) {
  case WM_INITDIALOG:
    SetDlgItemText(hDlgWnd,IDC_SE_NAME,SectInfoWrk.byName);
    wsprintf(buf,"%08X",SectInfoWrk.dwVSize);
    SetDlgItemText(hDlgWnd,IDC_SE_VSIZE,buf);
    wsprintf(buf,"%08X",SectInfoWrk.dwVOffset);
    SetDlgItemText(hDlgWnd,IDC_SE_VOFFSET,buf);
    wsprintf(buf,"%08X",SectInfoWrk.dwRSize);
    SetDlgItemText(hDlgWnd,IDC_SE_RSIZE,buf);
    wsprintf(buf,"%08X",SectInfoWrk.dwROffset);
    SetDlgItemText(hDlgWnd,IDC_SE_ROFFSET,buf);
    wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
    SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);

    ichk = (SectInfoWrk.dwCharacteristics & IMAGE_SCN_CNT_CODE) ? 1 : 0;
    SendMessage(GetDlgItem(hDlgWnd, IDC_SE_CONTCODE),BM_SETCHECK,(WPARAM)ichk, 0L);
    ichk = (SectInfoWrk.dwCharacteristics & IMAGE_SCN_CNT_INITIALIZED_DATA) ? 1 : 0;
    SendMessage(GetDlgItem(hDlgWnd, IDC_SE_CONTINI),BM_SETCHECK,(WPARAM)ichk, 0L);
    ichk = (SectInfoWrk.dwCharacteristics & IMAGE_SCN_CNT_UNINITIALIZED_DATA) ? 1 : 0;
    SendMessage(GetDlgItem(hDlgWnd, IDC_SE_CONTUNINI),BM_SETCHECK,(WPARAM)ichk, 0L);

    ichk = (SectInfoWrk.dwCharacteristics & IMAGE_SCN_MEM_SHARED) ? 1 : 0;
    SendMessage(GetDlgItem(hDlgWnd, IDC_SE_SHARE),BM_SETCHECK,(WPARAM)ichk, 0L);
    ichk = (SectInfoWrk.dwCharacteristics & IMAGE_SCN_MEM_EXECUTE) ? 1 : 0;
    SendMessage(GetDlgItem(hDlgWnd, IDC_SE_EXEC),BM_SETCHECK,(WPARAM)ichk, 0L);
    ichk = (SectInfoWrk.dwCharacteristics & IMAGE_SCN_MEM_READ) ? 1 : 0;
    SendMessage(GetDlgItem(hDlgWnd, IDC_SE_READ),BM_SETCHECK,(WPARAM)ichk, 0L);
    ichk = (SectInfoWrk.dwCharacteristics & IMAGE_SCN_MEM_WRITE) ? 1 : 0;
    SendMessage(GetDlgItem(hDlgWnd, IDC_SE_WRITE),BM_SETCHECK,(WPARAM)ichk, 0L);

    break;

  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDC_SE_CONTCODE:
      if(IsDlgButtonChecked(hDlgWnd,IDC_SE_CONTCODE) == BST_CHECKED) {
        SectInfoWrk.dwCharacteristics |= IMAGE_SCN_CNT_CODE;
      }
      else {
        SectInfoWrk.dwCharacteristics ^= IMAGE_SCN_CNT_CODE;
      }
      wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
      SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);
      break;
    case IDC_SE_CONTINI:
      if(IsDlgButtonChecked(hDlgWnd,IDC_SE_CONTINI) == BST_CHECKED) {
        SectInfoWrk.dwCharacteristics |= IMAGE_SCN_CNT_INITIALIZED_DATA;
      }
      else {
        SectInfoWrk.dwCharacteristics ^= IMAGE_SCN_CNT_INITIALIZED_DATA;
      }
      wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
      SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);
      break;
    case IDC_SE_CONTUNINI:
      if(IsDlgButtonChecked(hDlgWnd,IDC_SE_CONTUNINI) == BST_CHECKED) {
        SectInfoWrk.dwCharacteristics |= IMAGE_SCN_CNT_UNINITIALIZED_DATA;
      }
      else {
        SectInfoWrk.dwCharacteristics ^= IMAGE_SCN_CNT_UNINITIALIZED_DATA;
      }
      wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
      SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);
      break;
    case IDC_SE_SHARE:
      if(IsDlgButtonChecked(hDlgWnd,IDC_SE_SHARE) == BST_CHECKED) {
        SectInfoWrk.dwCharacteristics |= IMAGE_SCN_MEM_SHARED;
      }
      else {
        SectInfoWrk.dwCharacteristics ^= IMAGE_SCN_MEM_SHARED;
      }
      wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
      SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);
      break;
    case IDC_SE_EXEC:
      if(IsDlgButtonChecked(hDlgWnd,IDC_SE_EXEC) == BST_CHECKED) {
        SectInfoWrk.dwCharacteristics |= IMAGE_SCN_MEM_EXECUTE;
      }
      else {
        SectInfoWrk.dwCharacteristics ^= IMAGE_SCN_MEM_EXECUTE;
      }
      wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
      SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);
      break;
    case IDC_SE_READ:
      if(IsDlgButtonChecked(hDlgWnd,IDC_SE_READ) == BST_CHECKED) {
        SectInfoWrk.dwCharacteristics |= IMAGE_SCN_MEM_READ;
      }
      else {
        SectInfoWrk.dwCharacteristics ^= IMAGE_SCN_MEM_READ;
      }
      wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
      SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);
      break;
    case IDC_SE_WRITE:
      if(IsDlgButtonChecked(hDlgWnd,IDC_SE_WRITE) == BST_CHECKED) {
        SectInfoWrk.dwCharacteristics |= IMAGE_SCN_MEM_WRITE;
      }
      else {
        SectInfoWrk.dwCharacteristics ^= IMAGE_SCN_MEM_WRITE;
      }
      wsprintf(buf,"%08X",SectInfoWrk.dwCharacteristics);
      SetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf);
      break;
    case IDOK:
      GetDlgItemText(hDlgWnd,IDC_SE_NAME,SectInfoWrk.byName,sizeof(SectInfoWrk.byName));
      GetDlgItemText(hDlgWnd,IDC_SE_VSIZE,buf,sizeof(buf));
      SectInfoWrk.dwVSize = strtoul(buf,&stop,16);
      GetDlgItemText(hDlgWnd,IDC_SE_VOFFSET,buf,sizeof(buf));
      SectInfoWrk.dwVOffset = strtoul(buf,&stop,16);
      GetDlgItemText(hDlgWnd,IDC_SE_RSIZE,buf,sizeof(buf));
      SectInfoWrk.dwRSize = strtoul(buf,&stop,16);
      GetDlgItemText(hDlgWnd,IDC_SE_ROFFSET,buf,sizeof(buf));
      SectInfoWrk.dwROffset = strtoul(buf,&stop,16);
      GetDlgItemText(hDlgWnd,IDC_SE_CHAR,buf,sizeof(buf));
      SectInfoWrk.dwCharacteristics = strtoul(buf,&stop,16);

      EndDialog(hDlgWnd, IDOK);
      break;
    case IDCANCEL:
      EndDialog(hDlgWnd, IDCANCEL);
      break;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

LRESULT CALLBACK MainDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  char *ListHeader[] = {"Section","Virtual Size","Virtual Offset","Raw Size","Raw Offset","Charactaristics"};
  const int  ColX[]  = { 50,       73,            73,              73,        73,          82              };

  RECT  rect;
  UINT  x,y,w,h,xMax,yMax;
  int   i;
  char  buf[TEXTLEN];
  LPBYTE stop;

  HWND  hList;
  DWORD dwStyle;
  LV_COLUMN lvCol;
  LV_ITEM   item;

  switch (msg) {
  case WM_INITDIALOG:
    SendMessage(GetDlgItem(hDlgWnd, IDC_FIXSECT),BM_SETCHECK,(WPARAM)1, 0L);
    blFixSect = TRUE;
    SendMessage(GetDlgItem(hDlgWnd, IDC_REBUILD),BM_SETCHECK,(WPARAM)1, 0L);
    blRebuild = TRUE;
    SendMessage(GetDlgItem(hDlgWnd, IDC_RDO_M1), BM_SETCHECK, (WPARAM)1, 0L);
    iRebMethod = 1;

    // Center Dialog Window
    GetWindowRect(hDlgWnd,&rect);
    h = rect.bottom - rect.top;
    w = rect.right  - rect.left;
    xMax = GetSystemMetrics(SM_CXMAXIMIZED);
    yMax = GetSystemMetrics(SM_CYMAXIMIZED);
    x = xMax/2 - w/2;
    y = yMax/2 - h/2;
    //x = (x < 0) ? 1 : x;
    //y = (y < 0) ? 1 : y;
    MoveWindow(hDlgWnd,x,y,w,h,TRUE);

    wsprintf(buf,"OllyDump - %s",DbgeName);
    SetWindowText(hDlgWnd,buf);

    wsprintf(strCurEIP,"%X",GetCurrentEIP()-PEFileInfo.dwImageBase);
    SetDlgItemText(hDlgWnd,IDC_OEP,strCurEIP);

    wsprintf(buf,"%X",PEFileInfo.dwImageBase);
    SetDlgItemText(hDlgWnd,IDE_FROM,buf);

    wsprintf(buf,"%X",PEFileInfo.dwSizeOfImage);
    SetDlgItemText(hDlgWnd,IDE_SIZE,buf);

    wsprintf(buf,"%X",PEFileInfo.dwAddrOfEP);
    SetDlgItemText(hDlgWnd,IDC_EP,buf);

    wsprintf(buf,"%X",PEFileInfo.dwBaseOfCode);
    SetDlgItemText(hDlgWnd,IDC_BASEOFCODE,buf);

    wsprintf(buf,"%X",PEFileInfo.dwBaseOfData);
    SetDlgItemText(hDlgWnd,IDC_BASEOFDATA,buf);

    hList = GetDlgItem(hDlgWnd,IDC_SECTLIST);

    for(i=0; i<sizeof(ListHeader)/sizeof(&ListHeader[0]); i++) {
      lvCol.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
      lvCol.fmt = LVCFMT_LEFT;
      lvCol.cx = ColX[i];
      lvCol.pszText = ListHeader[i];
      lvCol.iSubItem = 0;
      ListView_InsertColumn(hList, i, &lvCol);
    }

    item.mask = LVIF_TEXT;
    item.cchTextMax = sizeof(buf);
    for(i=0; i<(int)PEFileInfo.woNumOfSect; i++) {
      item.pszText = (lpSectInfo+i)->byName;
      item.iItem = i;
      item.iSubItem = 0;
      ListView_InsertItem(hList, &item);

      wsprintf(buf,"%08X",(lpSectInfo+i)->dwVSize);
      item.pszText = buf;
      item.iItem = i;
      item.iSubItem = 1;
      ListView_SetItem(hList, &item);

      wsprintf(buf,"%08X",(lpSectInfo+i)->dwVOffset);
      item.pszText = buf;
      item.iItem = i;
      item.iSubItem = 2;
      ListView_SetItem(hList, &item);

      wsprintf(buf,"%08X",(lpSectInfo+i)->dwVSize);
      item.pszText = buf;
      item.iItem = i;
      item.iSubItem = 3;
      ListView_SetItem(hList, &item);

      wsprintf(buf,"%08X",(lpSectInfo+i)->dwVOffset);
      item.pszText = buf;
      item.iItem = i;
      item.iSubItem = 4;
      ListView_SetItem(hList, &item);

      wsprintf(buf,"%08X",(lpSectInfo+i)->dwCharacteristics);
      item.pszText = buf;
      item.iItem = i;
      item.iSubItem = 5;
      ListView_SetItem(hList, &item);
    }
    SecLstDlgProcOrg = (WNDPROC)SetWindowLong(hList,GWL_WNDPROC, (LONG)SecLstDlgProc);

    return TRUE;

  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDC_FIXSECT:
      blFixSect = (IsDlgButtonChecked(hDlgWnd,IDC_FIXSECT) == BST_CHECKED) ? TRUE : FALSE;

      hList = GetDlgItem(hDlgWnd,IDC_SECTLIST);
      if(blFixSect) {
        item.mask = LVIF_TEXT;
        item.cchTextMax = sizeof(buf);
        for(i=0; i<(int)PEFileInfo.woNumOfSect; i++) {
          wsprintf(buf,"%08X",(lpSectInfo+i)->dwVSize);
          item.pszText = buf;
          item.iItem = i;
          item.iSubItem = 3;
          ListView_SetItem(hList, &item);

          wsprintf(buf,"%08X",(lpSectInfo+i)->dwVOffset);
          item.pszText = buf;
          item.iItem = i;
          item.iSubItem = 4;
          ListView_SetItem(hList, &item);
        }
      }
      else {
        item.mask = LVIF_TEXT;
        item.cchTextMax = sizeof(buf);
        for(i=0; i<(int)PEFileInfo.woNumOfSect; i++) {
          wsprintf(buf,"%08X",(lpSectInfo+i)->dwRSize);
          item.pszText = buf;
          item.iItem = i;
          item.iSubItem = 3;
          ListView_SetItem(hList, &item);

          wsprintf(buf,"%08X",(lpSectInfo+i)->dwROffset);
          item.pszText = buf;
          item.iItem = i;
          item.iSubItem = 4;
          ListView_SetItem(hList, &item);
        }
      }
      break;
    case IDC_REBUILD:
      blRebuild = (IsDlgButtonChecked(hDlgWnd,IDC_REBUILD) == BST_CHECKED) ? TRUE : FALSE;
      break;
    case IDC_GETEIP:
      wsprintf(strCurEIP,"%X",GetCurrentEIP()-PEFileInfo.dwImageBase);
      SetDlgItemText(hDlgWnd,IDC_OEP,strCurEIP);
      break;

    case IDOK:
      // Get Number and Check
      if(GetWindowTextLength(GetDlgItem(hDlgWnd,IDE_FROM)) == 0) {
        MessageBox(hDlgWnd,"Please specify start address of dumping.",PNAME,MB_OK | MB_ICONINFORMATION);
        break;
      }
      else {
        GetDlgItemText(hDlgWnd,IDE_FROM,buf,sizeof(buf));
        if(!IsValidNumber(buf,strlen(buf),NUM_HEX)) {
          goto NUM_INVALID;
        }
        else {
          PEFileInfo.dwImageBase = strtoul(buf,&stop,16);
        }
      }

      if(GetWindowTextLength(GetDlgItem(hDlgWnd,IDE_SIZE)) == 0) {
        MessageBox(hDlgWnd,"Please specify dump size.",PNAME,MB_OK | MB_ICONINFORMATION);
        break;
      }
      else {
        GetDlgItemText(hDlgWnd,IDE_SIZE,buf,sizeof(buf));
        if(!IsValidNumber(buf,strlen(buf),NUM_HEX)) {
          goto NUM_INVALID;
        }
        else {
          PEFileInfo.dwSizeOfImage = strtoul(buf,&stop,16);
        }
      }

      if(GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_OEP)) > 0) {
        GetDlgItemText(hDlgWnd,IDC_OEP,buf,sizeof(buf));
        if(!IsValidNumber(buf,strlen(buf),NUM_HEX)) {
          goto NUM_INVALID;
        }
        else {
          PEFileInfo.dwAddrOfEP = strtoul(buf,&stop,16);
        }
      }

      if(GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_BASEOFCODE)) > 0) {
        GetDlgItemText(hDlgWnd,IDC_BASEOFCODE,buf,sizeof(buf));
        if(!IsValidNumber(buf,strlen(buf),NUM_HEX)) {
          goto NUM_INVALID;
        }
        else {
          PEFileInfo.dwBaseOfCode = strtoul(buf,&stop,16);
        }
      }

      if(GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_BASEOFDATA)) > 0) {
        GetDlgItemText(hDlgWnd,IDC_BASEOFDATA,buf,sizeof(buf));
        if(!IsValidNumber(buf,strlen(buf),NUM_HEX)) {
          goto NUM_INVALID;
        }
        else {
          PEFileInfo.dwBaseOfData = strtoul(buf,&stop,16);
        }
      }

      hList = GetDlgItem(hDlgWnd,IDC_SECTLIST);
      item.mask = LVIF_TEXT;
      item.cchTextMax = sizeof(buf);
      for(i=0; i<(int)PEFileInfo.woNumOfSect; i++) {
        item.pszText = (lpSectInfo+i)->byName;
        item.iItem = i;
        item.iSubItem = 0;
        ListView_GetItem(hList, &item);

        item.pszText = buf;
        item.iItem = i;
        item.iSubItem = 1;
        ListView_GetItem(hList, &item);
        (lpSectInfo+i)->dwVSize = strtoul(buf,&stop,16);

        item.pszText = buf;
        item.iItem = i;
        item.iSubItem = 2;
        ListView_GetItem(hList, &item);
        (lpSectInfo+i)->dwVOffset = strtoul(buf,&stop,16);

        item.pszText = buf;
        item.iItem = i;
        item.iSubItem = 3;
        ListView_GetItem(hList, &item);
        (lpSectInfo+i)->dwRSize = strtoul(buf,&stop,16);

        item.pszText = buf;
        item.iItem = i;
        item.iSubItem = 4;
        ListView_GetItem(hList, &item);
        (lpSectInfo+i)->dwROffset = strtoul(buf,&stop,16);

        item.pszText = buf;
        item.iItem = i;
        item.iSubItem = 5;
        ListView_GetItem(hList, &item);
        (lpSectInfo+i)->dwCharacteristics = strtoul(buf,&stop,16);
      }

      if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_M1) == BST_CHECKED) {
        iRebMethod = 1;
      }
      if(IsDlgButtonChecked(hDlgWnd, IDC_RDO_M2) == BST_CHECKED) {
        iRebMethod = 2;
      }

      EndDialog(hDlgWnd, IDOK);
      break;

NUM_INVALID:
      MessageBox(hDlgWnd,"Invalid Number!!",PNAME,MB_OK | MB_ICONINFORMATION);
      return FALSE;

    case IDCANCEL:
      EndDialog(hDlgWnd, IDCANCEL);
      break;

    default:
      return FALSE;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

DWORD GetCurrentEIP(void)
{
  t_thread* pth;// t_thread

  pth = Findthread(Getcputhreadid());
  return pth->reg.ip;
}

BOOL IsValidNumber(char *numstr, int size, int mode)
{
  int i;
  char *s;

  s = numstr;
  if(*s == '-' || *s == '+') {
    s++;
    size--;
  }
  for(i=0; i<size; i++) {
    switch(mode) {
    case NUM_DEC:
      if(*(s+i) < '0' || *(s+i) > '9') {
        return FALSE;
      }
      break;
    case NUM_HEX:
      if(!(   (*(s+i) >= '0' && *(s+i) <= '9')
           || (*(s+i) >= 'A' && *(s+i) <= 'F')
           || (*(s+i) >= 'a' && *(s+i) <= 'f') )) {
        return FALSE;
      }
      break;
    default:
      break;
    }
  }
  return TRUE;
}

