#define _WIN32_WINNT 0x0400

#include <windows.h>
#include <string.h>
#include <odbg\plugin.h>

const DWORD ordinalimp         = 0x80000000;
const char  *szNewSecName      = ".NewIID";
const int   MaxDllNameLength   = 40;
const int   MinDllNameLength   =  4;
const int   MaxFunctNameLength = 80;
const int   BadSectionsNum     = 10;
const char  *BadSections[]     = {".rsrc","rsrc",".bss","bss",".reloc","reloc",".code","code",".edata","edata",".tls","tls"};
const int   FineFileExtsNum    = 6;
const char  *FineFileExts[]    = {".dll",".ocx",".exe",".bpl",".drv",".pak"};

static PIMAGE_DOS_HEADER dosh;
static PIMAGE_NT_HEADERS peh;
static PIMAGE_SECTION_HEADER sectionh;
static PIMAGE_DATA_DIRECTORY pDir;
static DWORD tmpnum,hlib;

// for getdllfunctnames
static DWORD    DllNum;
static int      FunctNum[50];
static char     *Dllnames[50];
static HANDLE   Dllhandles[50];
static char     *Functnames[50][1200];
static DWORD    Functaddresses[50][1200];

// for "SearchForFirstThunk"
// pDllThunkBlock                  : array [1..50] of pointer; // with memBase
// infos about the target memory
static BYTE   *pMemBase;
static DWORD  dwMemBase;
static DWORD  MemSize;


DWORD rva2offset(DWORD dwRva)
{
  int i;
  PIMAGE_SECTION_HEADER sectionh2;

  if(dwRva == 0) {
    return(dwRva);
  }

  sectionh2 = sectionh;
  // in which section is the import table ?
  for(i=0; i<peh->FileHeader.NumberOfSections; i++) {
    if(dwRva >= sectionh2->VirtualAddress && dwRva < sectionh2->VirtualAddress+sectionh2->Misc.VirtualSize) {
      break;
    }
    sectionh2++;
  }
  return(dwRva - sectionh2->VirtualAddress + sectionh2->PointerToRawData);
}

DWORD offset2rva(DWORD dwOffset)
{
  int i;
  PIMAGE_SECTION_HEADER sectionh2;

  if(dwOffset == 0) {
    return(dwOffset);
  }
  sectionh2 = sectionh;
  // in which section is the import table ?
  for(i=0; i<peh->FileHeader.NumberOfSections; i++) {
    if(dwOffset >= sectionh2->PointerToRawData && dwOffset < sectionh2->PointerToRawData+sectionh2->SizeOfRawData) {
      break;
    }
    sectionh2++;
  }
  return(dwOffset + sectionh2->VirtualAddress - sectionh2->PointerToRawData);
}

PIMAGE_SECTION_HEADER rva2section(DWORD dwRva)
{
  PIMAGE_SECTION_HEADER sectionh2;
  int i;

  sectionh2 = sectionh;
  for(i=0; i<peh->FileHeader.NumberOfSections; i++) {
    if(dwRva >= sectionh2->VirtualAddress && dwRva < sectionh2->VirtualAddress+sectionh2->Misc.VirtualSize) {
      break;
    }
    sectionh2++;
  }
  return(sectionh2);
}

DWORD GetAddressOrdinal(char *libname, DWORD MemoryAddress)
{
  DWORD functionentry;
  DWORD *pDW;
  DWORD i;
  DWORD functposition;
  DWORD modulebase;
  // export table values
  DWORD expbase;
  DWORD functnum;
  DWORD functaddr;
  DWORD namenum;
  DWORD nameaddr;
  DWORD ordinaladdr;
  // PE structs
  PIMAGE_DOS_HEADER dosh;
  PIMAGE_NT_HEADERS peh;
  IMAGE_DATA_DIRECTORY dir;

  functposition = 0xFFFFFFFF;

  __try {
    // load the dll
    modulebase = (DWORD)GetModuleHandle(libname);
    if(modulebase == 0) {
      modulebase = (DWORD)LoadLibrary(libname);
      if(modulebase == 0) {
        return(functposition);
      }
    }
    if(MemoryAddress <= modulebase) {
      return(functposition);
    }
    functionentry = MemoryAddress - modulebase;
    // check whether hmodule is a valid PE file
    dosh = (PIMAGE_DOS_HEADER)modulebase;
    if(dosh->e_magic != IMAGE_DOS_SIGNATURE) {
      return(functposition);
    }
    peh = (PIMAGE_NT_HEADERS)((DWORD)dosh + dosh->e_lfanew);
    if(peh->Signature != IMAGE_NT_SIGNATURE) {
      return(functposition);
    }

    dir = peh->OptionalHeader.DataDirectory[0];
    pDW = (DWORD*)(dir.VirtualAddress + 0x10 + (DWORD)dosh); // go fast to the base
  
    // get the export values
    expbase     = *pDW;
    pDW++;
    functnum    = *pDW;
    pDW++;
    namenum     = *pDW;
    pDW++;
    functaddr   = *pDW;
    pDW++;
    nameaddr    = *pDW;
    pDW++;
    ordinaladdr = *pDW;
    // search the entry in the RVA array of the export table
    pDW = (DWORD*)((DWORD)dosh + functaddr);
    //functposition = 0xFFFFFFFF;
    for(i=0; i<functnum; i++) {
      if(functionentry == *pDW) {
        functposition = i;
        break;
      }
      pDW++;
    }
    if(functposition != 0xFFFFFFFF) {
      (DWORD)functposition += (expbase + ordinalimp);
    }
  }
  __except(1) {
    return(-1);
  }
  return(functposition);
}

DWORD FindOldIT(BYTE *DataPointer, DWORD SizeOfImage, DWORD OldITRVA)
{
  DWORD *pDW;
  char *pCH, *pcExt;
  DWORD dwCurrRVA, dwCurrRVA2;
  PIMAGE_IMPORT_DESCRIPTOR IID2;
  DWORD dwTargetPos;
  DWORD dwDllPoi;
  int iii;
  DWORD result;

  result = OldITRVA;
  pCH = DataPointer;
  for(dwCurrRVA=0; dwCurrRVA<=SizeOfImage-4; dwCurrRVA++) {
    if(*pCH > 0x30) {
      if(strlen(pCH) < (size_t)MaxDllNameLength) {
        pcExt = &pCH[strlen(pCH)-4];
        for(iii=0; iii<FineFileExtsNum; iii++) {
          if(!stricmp(pcExt,FineFileExts[iii])) {
            if(!LoadLibrary(pCH)) {
            // we found a dll name
              pDW = (DWORD*)DataPointer;
              dwTargetPos = offset2rva(dwCurrRVA);
              for(dwCurrRVA2=0; dwCurrRVA2<=SizeOfImage-4; dwCurrRVA2++) {
                if(*pDW ==dwTargetPos) {
                  // we found a pointer to the dll
                  //IID2 = (PIMAGE_IMAGE_IMPORT_DESCRIPTOR)((DWORD)DataPointer+dwCurrRVA2-12);
                  IID2 = (PIMAGE_IMPORT_DESCRIPTOR)((DWORD)DataPointer+dwCurrRVA2-12);
                  // check whether it's the first IID !
                  do {
                    IID2--;
                    dwDllPoi = rva2offset(IID2->Name) + (DWORD)DataPointer;
                    if(IsBadStringPtr((char*)dwDllPoi,MaxDllNameLength)) {
                      break;
                    }
                    if(!LoadLibrary((char*)dwDllPoi)) {
                      break;
                    }
                  } while(dwCurrRVA != 0); // will never be true !!!
                  IID2++;
                  // some more checking
                  if(IID2->OriginalFirstThunk < SizeOfImage && IID2->FirstThunk < SizeOfImage) {
                    if((DWORD)IID2 - (DWORD)DataPointer != OldITRVA) {
                      goto DONE;
                    }
                  }
                }
                ((DWORD)pDW)++;
              }
              break;
            }
          }
        }
      }
    }
    pCH++;
  }
  return(result);
DONE:
  result = offset2rva((DWORD)IID2 - (DWORD)DataPointer);
  return(result);
}

void GetFunctNamesEx(DWORD dwFrom, DWORD dwSize)
{
  char *pCH;
  DWORD i, ii;
  //HANDLE hlib;

  // Search all function names
  pCH = (char*)((DWORD)pMemBase + dwFrom);
  for(i=0; i<=dwSize-4; i++) {
    if(*pCH > 0x30) {
      if((int)strlen(pCH) < MaxFunctNameLength) {
        for(ii=0; ii<DllNum; ii++) {
          tmpnum = (DWORD)GetProcAddress(Dllhandles[ii],pCH);
          if(tmpnum != 0) {
            //Functnames[ii][FunctNum[ii]] = (char*)((DWORD)pCH - (DWORD)pMemBase + (DWORD)pMemBase);
            Functnames[ii][FunctNum[ii]] = (char*)(DWORD)pCH;
            pCH += strlen(Functnames[ii][FunctNum[ii]]);
            Functaddresses[ii][FunctNum[ii]] = tmpnum;
            FunctNum[ii]++;
            break;
          }
        }
      }
    }
    pCH++;
  }
}

void GetFunctNamesFast(void)
{
  PIMAGE_SECTION_HEADER pSectionh2;
  int i, ii;
  BOOL checkit;

  memset(FunctNum,0,sizeof(FunctNum));
  pSectionh2 = sectionh;
  for(i=0; i<peh->FileHeader.NumberOfSections; i++) {
    checkit = TRUE;
    // is the current section an bad section ?
    for(ii=0; ii<BadSectionsNum; ii++) {
      if(!stricmp(pSectionh2->Name,BadSections[ii])) {
        checkit = FALSE;
        break;
      }
    }
    if(checkit) {
      GetFunctNamesEx(pSectionh2->PointerToRawData,pSectionh2->SizeOfRawData);
    }
    pSectionh2++;
  }
}

void GetDllNames(void)
{
  char *pCH;
  char *pcExt;
  DWORD i, ii, iii;

  DllNum = 0;
  // Search all dll names
  pCH = pMemBase;
  for(i=0; i<=MemSize-4; i++) {
    if(*pCH > 0x30) {
      if((int)strlen(pCH) < MaxDllNameLength && (int)strlen(pCH) > MinDllNameLength) {
        pcExt = &pCH[strlen(pCH)-4];
        for(iii=0; iii<(DWORD)FineFileExtsNum; iii++) {
          if(!stricmp(pcExt,FineFileExts[iii])) {
            hlib = (DWORD)LoadLibrary(pCH);
            if(hlib) {
              // check if we have this dll already
              for(ii=0; ii<=DllNum; ii++) {
                if(hlib == (DWORD)Dllhandles[ii]) {
                  break;
                }
              }
              if(ii > DllNum || DllNum == 0) {
                Dllhandles[DllNum] = (HANDLE)hlib;
                Dllnames[DllNum] = pCH;
                DllNum++;
                break;
              }
            }
            pCH += strlen(pCH);
            break;
          }
        }
      }
    }
    pCH++;
  }
}

void FixIAT(DWORD pointer2IID)
{
  PIMAGE_IMPORT_DESCRIPTOR IID2;
  DWORD  *pDW;
  char   *pCH;
  DWORD  i, ii;
  BOOL   fixed;
  DWORD  tmpnum;

  IID2 = (PIMAGE_IMPORT_DESCRIPTOR)pointer2IID;
  if(IID2 == NULL) {
    return;
  }
  do {
    tmpnum = (DWORD)LoadLibrary((char*)((BYTE*)(rva2offset(IID2->Name)+dwMemBase)));
    for(i=0; i<DllNum; i++) {
      if(Dllhandles[i] == (HANDLE)tmpnum) {
        break;
      }
    }
    pDW = (DWORD*)(rva2offset(IID2->FirstThunk) + (DWORD)pMemBase);
    pCH = (char*)((DWORD*)rva2offset(IID2->Name)+(DWORD)pMemBase);
    while(*pDW != 0) { // for each firstthunk member
      fixed = FALSE;
      for(ii=0; ii<(DWORD)FunctNum[i]; ii++) {
        if(Functaddresses[i][ii] == *pDW) {
          // correct the pointer to the Imported by Name struct
          *pDW = offset2rva((DWORD)Functnames[i][ii] - (DWORD)pMemBase - 2);
          fixed = TRUE;
          break;
        }
      }
      if(!fixed) { // take an ordinal instead
        tmpnum = GetAddressOrdinal(pCH,*pDW);
        if(tmpnum != 0xFFFFFFFF) {
          *pDW = tmpnum;
        }
      }
      pDW++;
    }
    IID2->TimeDateStamp  = 0;
    IID2->ForwarderChain = 0;
    IID2++;
  } while(IID2->FirstThunk != 0);
}

DWORD SearchForFirstThunk(void)
{
  DWORD *pDW;
  BOOL  Found;
  DWORD i,ii,iii;
  DWORD SearchAddress;
  DWORD dwMaxSearchBase;
  DWORD dwFirstThunkBlock;

  dwMaxSearchBase = dwMemBase + MemSize-5;
  // search in the whole file for "AnyAPIAddress" it should be found in an FirstThunk
  // search thunk block for each dll and return a pointer to the topmost (first) Thunk block
  dwFirstThunkBlock = 0xFFFFFFFF;
  for(i=0; i<DllNum; i++) {
    for(ii=0; ii<(DWORD)FunctNum[i]; ii++) {
      SearchAddress = Functaddresses[i][ii];
      if(SearchAddress == 0) {
        continue;
      }
      pDW = (DWORD*)dwMemBase;
      while((DWORD)pDW < dwMaxSearchBase) {
        if(*pDW == SearchAddress) {
          goto SEARCHDONE;
        }
        pDW++;
      }
    }
    continue;

SEARCHDONE:
    // now we go up until the found dword is not 0 and GetaddressOrdinal returns -1
    while((DWORD)pDW > dwMemBase) {
      pDW--;
      if(*pDW == 0) {
        continue;
      }
      Found = FALSE;
      for(iii=0; iii<DllNum; iii++) { // test the found Address with all dll names
        if(GetAddressOrdinal(Dllnames[iii],*pDW) != 0xFFFFFFFF) {
          Found = TRUE;
          break;
        }
      }
      if(!Found) {
        break;
      }
    }
    pDW++;

    // now search again until non-Zero
    do {
      pDW++;
    } while(*pDW == 0);
    if((DWORD)pDW < dwFirstThunkBlock) {
      dwFirstThunkBlock = (DWORD)pDW;
    }
  }
  dwFirstThunkBlock -= ((dwFirstThunkBlock == 0xFFFFFFFF) ? 0 : dwMemBase);
  return(dwFirstThunkBlock);
  //if(dwFirstThunkBlock == 0xFFFFFFFF) {
    //return(dwFirstThunkBlock);
  //}
  //else {
    //return(dwFirstThunkBlock - dwMemBase);
  //}
}

void MakeIID(DWORD FirstThunkAddr)
{
  PIMAGE_IMPORT_DESCRIPTOR pIID;
  PIMAGE_SECTION_HEADER    pSectionh, pNewSectionh;
  PIMAGE_SECTION_HEADER    pItSech;
  DWORD  i,ii,iii;
  DWORD  *pDW;
  DWORD  dwTmpNum;
  DWORD  dwSearchEnd;
  BOOL   bFoundNextThunks;

  bFoundNextThunks = TRUE;
  // make a new section
  pSectionh = sectionh;
  peh->OptionalHeader.FileAlignment = 0x200;
  for(i=0; i<(DWORD)(peh->FileHeader.NumberOfSections); i++) {
    pSectionh++;
  }
  peh->FileHeader.NumberOfSections++;
  for(i=0; i<=7; i++) {
    pSectionh->Name[i] = szNewSecName[i];
  }

  pNewSectionh = pSectionh;
  pNewSectionh->Characteristics  = 0xC0000040;
  pNewSectionh->Misc.VirtualSize = 0x1000;
  pSectionh--;

  // set a valid RawOffset
  dwTmpNum = pSectionh->SizeOfRawData + pSectionh->PointerToRawData;
  if(dwTmpNum%0x200 != 0) {
    dwTmpNum = ((dwTmpNum / 0x200) + 1) * 0x200;
  }
  pNewSectionh->PointerToRawData = dwTmpNum;

  // set a valild VirtualAddress
  dwTmpNum = pSectionh->VirtualAddress + pSectionh->Misc.VirtualSize;
  if(dwTmpNum%0x1000 != 0) {
    dwTmpNum = ((dwTmpNum/0x1000) + 1) * 0x1000;
  }
  pNewSectionh->VirtualAddress = dwTmpNum;

  // set new section RawSize
  pNewSectionh->SizeOfRawData  = 0x200;

  // correct the SizeOfImage
  peh->OptionalHeader.SizeOfImage += 0x1000;

  // write the new IID into the new section
  peh->OptionalHeader.DataDirectory[1].VirtualAddress = pNewSectionh->VirtualAddress;
  pIID = (PIMAGE_IMPORT_DESCRIPTOR)(dwMemBase + rva2offset(pNewSectionh->VirtualAddress));
  pDW  = (DWORD*)(dwMemBase + FirstThunkAddr);

  // get the end of the current section
  //pItSech = rva2section((DWORD)pDW - dwMemBase);
  //dwSearchEnd = (DWORD)dwMemBase + pItSech->VirtualAddress + pItSech->Misc.VirtualSize;
  do {
    // loops until all found thunks were processed
    pIID->OriginalFirstThunk = 0;
    pIID->TimeDateStamp      = 0;
    pIID->ForwarderChain     = 0;
    // find the dll fitting to the current Thunk
    for(i=0; i<=DllNum; i++) {
      if(GetAddressOrdinal(Dllnames[i],*pDW) != 0xFFFFFFFF) {
        break;
      }
    }
    if(i > DllNum-1) { // we passed all dlls
      break;
      
    }
    pIID->Name = offset2rva((DWORD)(Dllnames[i] - dwMemBase));
    pIID->FirstThunk = offset2rva((DWORD)pDW - dwMemBase);
    // go to the zero terminating end of the current thunk block
    do { 
      pDW++;
    } while(*pDW != 0);
    do {
      pDW++;
    } while(*pDW == 0);

//  // needed for older compilers
//  // Search the start of the next thunk block
//  bFoundNextThunks = FALSE;
//  pDW += 3;
//  do {
//    pDW++;
//    for(iii=0; iii<DllNum; iii++) {
//      if(GetAddressOrdinal(Dllnames[iii],*pDW) != 0xFFFFFFFF) {
//        bFoundNextThunks = TRUE;
//      }
//    }
//  } while(bFoundNextThunks != FALSE || (DWORD)pDW == dwSearchEnd);
//

    pIID++;
  } while(bFoundNextThunks != FALSE);

  // write the terminating IID
  pIID->OriginalFirstThunk = 0;
  pIID->TimeDateStamp      = 0;
  pIID->ForwarderChain     = 0;
  pIID->Name               = 0;
  pIID->FirstThunk         = 0;
}

// needed for win2K
// returns:
// TRUE - SizeOfHeaders changed
// FALSE - ... doesn't change
BOOL FixSizeOfHeaders(BYTE *pMemBase)
{
  PIMAGE_NT_HEADERS pPeh;
  PIMAGE_DOS_HEADER pDosh;
  PIMAGE_SECTION_HEADER pSech;
  BYTE i;
  DWORD dwMinRO;
  BOOL result;

  __try {
    pDosh = (PIMAGE_DOS_HEADER)pMemBase;
    pPeh  = (PIMAGE_NT_HEADERS)((DWORD)pDosh + pDosh->e_lfanew);
    pSech = (PIMAGE_SECTION_HEADER)((DWORD)pPeh + 0xF8);
    dwMinRO = 0xFFFFFFFF;
    //find the smallest RawOffset
    for(i=0; i<pPeh->FileHeader.NumberOfSections; i++) {
      if(pSech->PointerToRawData < dwMinRO) {
        dwMinRO = pSech->PointerToRawData;
      }
      pSech++;
    }
    // update the header
    pPeh->OptionalHeader.SizeOfHeaders = dwMinRO;
    // return stuff
    if(pPeh->OptionalHeader.SizeOfHeaders != dwMinRO) {
      result = TRUE;
    }
    else {
      result = FALSE;
    }
  }
  __except(1) {
    return(FALSE);
  }
  return(result);
}

BYTE RebuildIT(BYTE *pMem, DWORD dwMemSize, BYTE byRebuildType)
{
  int i;
  DWORD dwNewFirstThunk;
  //DWORD dwRebTime;
  BYTE result;

  result = 0;
  if(byRebuildType > 1) {
    return(result);
  }

  // save the ram infos
  pMemBase  = pMem;
  dwMemBase = (DWORD)pMem;
  MemSize   = dwMemSize;
  // access the pe header and check whether it's PE
  dosh = (PIMAGE_DOS_HEADER)pMem;
  if(dosh->e_magic != IMAGE_DOS_SIGNATURE) {
    return(result);
  }
  peh = (PIMAGE_NT_HEADERS)((DWORD)dosh + (DWORD)(dosh->e_lfanew));
  if(peh->Signature != IMAGE_NT_SIGNATURE) {
    return(result);
  }
  //sectionh = (PIMAGE_SECTION_HEADER)((DWORD)peh + 0xF8);
  sectionh = (PIMAGE_SECTION_HEADER)peh;
  ((PIMAGE_NT_HEADERS)sectionh)++;
  pDir = (PIMAGE_DATA_DIRECTORY)(dosh->e_lfanew + (DWORD)dosh + 0x80);

  FixSizeOfHeaders(pMem);

  // START
  // dwRebTime = GetTickCount;
  switch(byRebuildType) {
  case 0: // REBUILD IMPORT TABLE
    GetDllNames();
    peh->OptionalHeader.DataDirectory[1].VirtualAddress = FindOldIT(pMemBase,MemSize,peh->OptionalHeader.DataDirectory[1].VirtualAddress);
    GetFunctNamesFast();
    FixIAT(rva2offset(pDir->VirtualAddress) + (DWORD)pMemBase);
    break;
  case 1: // REBUILD NEW IMPORT TABLE
    GetDllNames();
    GetFunctNamesFast();
    dwNewFirstThunk = SearchForFirstThunk();
    if(dwNewFirstThunk == 0xFFFFFFFF) {
      return(result);
    }
    MakeIID(dwNewFirstThunk);
    FixIAT(rva2offset(pDir->VirtualAddress) + (DWORD)pMemBase);
    break;
  }
  result = 1;
  return(result);
}


BYTE RebuildITDeluxe(char *szTargetFile, BYTE byRebuildType)
{
  const DWORD AlignBreaker = 0x1200;
  DWORD dwFsize,dwNewSize,i;
  PIMAGE_DOS_HEADER dosh;
  PIMAGE_NT_HEADERS peh;
  PIMAGE_SECTION_HEADER sectionh;
  HANDLE hFile;
  BYTE *pFileMem;
  DWORD dwBuff;
  BYTE result;

  result = 0;

  // map the file
  hFile = CreateFile(szTargetFile,GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
  if(hFile == INVALID_HANDLE_VALUE) {
    return(result);
  }
  dwFsize = GetFileSize(hFile,0);
  pFileMem = (BYTE*)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,dwFsize + AlignBreaker);
  if(pFileMem == NULL) {
    CloseHandle(hFile);
    return(result);
  }
  ReadFile(hFile,pFileMem,dwFsize,&dwBuff,0);
  if(dwBuff == 0) {
    GlobalFree(pFileMem);
    CloseHandle(hFile);
    return(result);
  }
  // check the PE Signature
  dosh = (PIMAGE_DOS_HEADER)pFileMem;
  if(dosh->e_magic != IMAGE_DOS_SIGNATURE) {
    return(result);
  }
  peh = (PIMAGE_NT_HEADERS)((DWORD)dosh + (DWORD)(dosh->e_lfanew));
  if(peh->Signature != IMAGE_NT_SIGNATURE) {
    return(result);
  }
  sectionh = (PIMAGE_SECTION_HEADER)((DWORD)peh + 0xF8);

  if(byRebuildType == 1) {
    // find out the real new filesize (support for aligned files !)
    dwNewSize = 0;
    for(i=0; i<(DWORD)(peh->FileHeader.NumberOfSections); i++) {
      if(sectionh->SizeOfRawData + sectionh->PointerToRawData > dwNewSize) {
        dwNewSize = sectionh->SizeOfRawData + sectionh->PointerToRawData;
      }
      sectionh++;
    }
    // align the last section and add 0x200
    if((dwNewSize%0x200) != 0) {
      dwNewSize = ((dwNewSize/0x200) + 1) * 0x200;
    }
    dwFsize = dwNewSize + 0x200;
  }
  // rebuild it
  result = RebuildIT(pFileMem,dwFsize + AlignBreaker,byRebuildType);

  // write the file back
  SetFilePointer(hFile,0,NULL,FILE_BEGIN);
  WriteFile(hFile,pFileMem,dwFsize,&dwBuff,0);
  if(dwBuff == 0) {
    result = 0;
  }

  // clean up
  GlobalFree(pFileMem);
  CloseHandle(hFile);
  return(result);
}

//                   // return values:
//                   // 0- an error occurred
//                   // 1- Import Table rebuilded successfully
//                   // byRebuildType:
//                   // 0 - rebuild Import Table
//                   // 1 - rebuild New Import Table
