
/*****************************************************************************
 *                                                                           *
 *  plugcom.cpp: ida plugins OLE/COM routines                                *
 *  (c) 2003-2008 servil                                                     *
 *                                                                           *
 *****************************************************************************/

#ifndef __cplusplus
#error C++ compiler required.
#endif

#if defined(__ICL)
#pragma warning(disable:  186) // pointless comparison of unsigned integer with zero
#endif

#include "mscrtdbg.h"
#include <algorithm>
#include <boost/scoped_array.hpp>
#define NOMINMAX 1
#include <wtypes.h>
#include <ole2.h>
#include "plugcom.hpp"
#include "plugsys.hpp"

#define GUID_FMT "%08lx-%04hx-%04hx-%02x%02x-%02x%02x%02x%02x%02x%02x"
#define GUID_FMT2 "%08lx-%04hx-%04hx-%02x%02x%02x%02x%02x%02x%02x%02x"
#define OLE_GUID_FMT "{" GUID_FMT "}"
#define GUID_FMTW L"%08lx-%04hx-%04hx-%02x%02x-%02x%02x%02x%02x%02x%02x"
#define GUID_FMT2W L"%08lx-%04hx-%04hx-%02x%02x%02x%02x%02x%02x%02x%02x"
#define OLE_GUID_FMTW L"{" GUID_FMTW L"}"

// LPSTR GUIDEX::toString(LPSTR buf, SIZE_T dwSize) const {
// 	return buf != NULL && qsnprintf(buf, size, OLE_GUID_FMT, Data1, Data2,
// 		Data3, Data4[0], Data4[1], Data4[2], Data4[3], Data4[4], Data4[5],
// 		Data4[6], Data4[7]) > 0 ? buf : NULL;
// }

bool GUIDEX::isSet() const throw() {
	return Data1 != 0 || Data2 != 0 || Data3 != 0
		|| Data4[0] != 0 || Data4[1] != 0 || Data4[2] != 0 || Data4[3] != 0
		|| Data4[4] != 0 || Data4[5] != 0 || Data4[6] != 0 || Data4[7] != 0;
}

void GUIDEX::set(uint32 d1, uint16 d2, uint16 d3,
	uint8 d41, uint8 d42, uint8 d43, uint8 d44,
	uint8 d45, uint8 d46, uint8 d47, uint8 d48) throw() {
	Data1 = d1; Data2 = d2; Data3 = d3;
	Data4[0] = d41; Data4[1] = d42; Data4[2] = d43; Data4[3] = d44;
	Data4[4] = d45; Data4[5] = d46; Data4[6] = d47; Data4[7] = d48;
}

void GUIDEX::set(ea_t ea) throw(std::exception) {
	_ASSERTE(isLoaded(ea));
	if (!isLoaded(ea) || !get_many_bytes(ea, this, sizeof GUIDEX))
		std::__stl_throw_invalid_argument("cannot get bytes from address");
}

void GUIDEX::set(LPCSTR s) {
	_ASSERTE(s != NULL);
	uint tmp[8];
	if (s != NULL && (qsscanf(s, OLE_GUID_FMT, &Data1, &Data2, &Data3, &tmp[0],
		&tmp[1], &tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11
		|| qsscanf(s, GUID_FMT, &Data1, &Data2, &Data3, &tmp[0], &tmp[1],
		&tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11
		|| qsscanf(s, "{" GUID_FMT2 "}", &Data1, &Data2, &Data3, &tmp[0], &tmp[1],
		&tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11
		|| qsscanf(s, GUID_FMT2, &Data1, &Data2, &Data3, &tmp[0], &tmp[1],
		&tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11))
		std::copy(tmp, tmp + qnumber(tmp), Data4);
	else
		std::__stl_throw_invalid_argument("GUID string NULL or in invalid format");
}

void GUIDEX::set(LPCOLESTR ws) {
	_ASSERTE(ws != NULL);
	uint tmp[8];
	if (ws != NULL && (swscanf(ws, OLE_GUID_FMTW, &Data1, &Data2, &Data3, &tmp[0],
		&tmp[1], &tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11
		|| swscanf(ws, GUID_FMTW, &Data1, &Data2, &Data3, &tmp[0], &tmp[1],
		&tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11
		|| swscanf(ws, L"{" GUID_FMT2W L"}", &Data1, &Data2, &Data3, &tmp[0], &tmp[1],
		&tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11
		|| swscanf(ws, GUID_FMT2W, &Data1, &Data2, &Data3, &tmp[0], &tmp[1],
		&tmp[2], &tmp[3], &tmp[4], &tmp[5], &tmp[6], &tmp[7]) == 11))
		std::copy(tmp, tmp + qnumber(tmp), Data4);
	else
		std::__stl_throw_invalid_argument("GUID string NULL or in invalid format");
}

LPSTR GUIDEX::toString(LPSTR buf, SIZE_T size) const {
	OLECHAR wbuf[40];
	return buf != NULL && toString(CPY(wbuf)) != NULL
		&& static_cast<int>(wcstombs(buf, wbuf, size)) > 0 ? buf : NULL;
}

std::string GUIDEX::toString() const {
	char s[40];
	return toString(CPY(s)) != NULL ? s : std::string();
}

#define VALUE_SIZE 0x4000 // 16kB

bool interface_t::Load(const IIDEX &id) {
	clear();
	CRegKey hKeyInterface, hKeyClass, hKeyTypeLib, hKeyTmp;
	if (hKeyInterface.Open(HKEY_CLASSES_ROOT,
		std::string("Interface\\").append(id.toString()).c_str()) != ERROR_SUCCESS)
		return false;
	IIDEX::operator =(id);
	boost::scoped_array<char> value(new char[VALUE_SIZE]);
	if (!value) {
		_RPT2(_CRT_ERROR, "%s(...): failed to allocate new string of size 0x%X\n",
			__FUNCTION__, VALUE_SIZE);
		throw std::bad_alloc(); //return false;
	}
	DWORD dwSz;
	if (hKeyInterface.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS)
		name.assign(value.get());
	if (hKeyTmp.Open(hKeyInterface, "ProxyStubClsid32") == ERROR_SUCCESS
		|| hKeyTmp.Open(hKeyInterface, "ProxyStubClsid") == ERROR_SUCCESS) {
		if (hKeyTmp.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS) try {
			Class.Load(value.get());
#ifdef _DEBUG
		} catch (const std::exception &e) {
			_RPTF4(_CRT_WARN, "%s(%s): %s (CLSID=%s)\n", __FUNCTION__,
				toString().c_str(), e.what(), value.get());
#else
		} catch (...) {
#endif // _DEBUG
		}
		hKeyTmp.Close();
	}
	if (hKeyTmp.Open(hKeyInterface, "TypeLib") == ERROR_SUCCESS) {
		if (hKeyTmp.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS) try {
			TypeLib.GUIDEX::operator =(value.get());
			char version[80];
			if (hKeyTmp.QueryValue(version, "Version", &(dwSz = sizeof version)) == ERROR_SUCCESS) {
#ifdef _DEBUG
				BOOL ok =
#endif // _DEBUG
				TypeLib.verFromStr(version);
				_ASSERTE(ok);
				if (hKeyTypeLib.Open(HKEY_CLASSES_ROOT,
					std::string("TypeLib").append(1, '\\').append(value.get()).append(1, '\\').append(version).c_str()) == ERROR_SUCCESS) {
					if (hKeyTypeLib.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS)
						TypeLib.name.assign(value.get());
					if (hKeyClass.Open(hKeyTypeLib, "FLAGS") == ERROR_SUCCESS) {
						if (hKeyClass.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS)
							TypeLib.flags = strtoul(value.get(), 0, 0);
						hKeyClass.Close();
					}
					if (hKeyClass.Open(hKeyTypeLib, "0\\win32") == ERROR_SUCCESS) {
						TypeLib.lcid = LOCALE_NEUTRAL;
						hKeyClass.QueryValue(TypeLib.filename, NULL, &(dwSz = TypeLib.filename.capacity()));
						hKeyClass.Close();
					} else {
						char lcid[0x100];
						FILETIME ft;
						for (DWORD index = 0; RegEnumKeyEx(hKeyTypeLib, index, lcid, &(dwSz = sizeof lcid), NULL, NULL, NULL, &ft) == ERROR_SUCCESS; ++index)
							if (hKeyClass.Open(hKeyTypeLib, std::string(lcid).append("\\win32").c_str()) == ERROR_SUCCESS) {
								TypeLib.lcid = strtoul(lcid, 0, 0);
								hKeyClass.QueryValue(TypeLib.filename, NULL, &(dwSz = TypeLib.filename.capacity()));
								hKeyClass.Close();
								break;
							}
					}
					hKeyTypeLib.Close();
				}
			}
#ifdef _DEBUG
		} catch (const std::exception &e) {
			_RPTF4(_CRT_WARN, "%s(%s): %s (TypeLibGUID=%s)\n", __FUNCTION__,
				toString().c_str(), e.what(), value.get());
#else
		} catch (...) {
#endif // _DEBUG
		}
		hKeyTmp.Close();
	} // has typelib key
	value.reset();
	// Load typeinfo
	//CComPtr<IID_IInterfaceViewer> punk;
	//CComPtr<IDispatch> pdisp;
	//IProvideClassInfo2Impl<&class, this, &TypeLib,
	//	TypeLib.vermajor, TypeLib.verminor> pci;
	if (TypeLib.isSet() && LoadRegTypeLib(TypeLib, TypeLib.vermajor,
		TypeLib.verminor, TypeLib.lcid, &TypeLib.ptlb) != S_OK) TypeLib.ptlb = NULL;
	if (TypeLib.ptlb != NULL && TypeLib.ptlb->GetTypeInfoOfGuid(*this, &pti) != S_OK) {
		TypeLib.ptlb.Release();
		pti = NULL;
	}
	if (!pti && TypeLib.hasTypeLib()) {
		OLECHAR wszTypeLib[MAX_PATH];
		if (mbstowcs(wszTypeLib, TypeLib.filename, qnumber(wszTypeLib)) > 0
			&& LoadTypeLib(wszTypeLib, &TypeLib.ptlb) != S_OK) TypeLib.ptlb = NULL;
		if (TypeLib.ptlb != NULL && TypeLib.ptlb->GetTypeInfoOfGuid(*this, &pti) != S_OK) {
			TypeLib.ptlb.Release();
			pti = NULL;
		}
#ifdef _DEBUG
		if (pti != NULL) _CrtDbgReport(_CRT_WARN, __FILE__, __LINE__, __FUNCTION__,
			"Used alternate api to load typelib: Interface\\%s version %hu.%hu loaded by filename %ls\n",
			toString().c_str(), TypeLib.vermajor, TypeLib.verminor, wszTypeLib);
#endif // _DEBUG
	}
	if (!pti && TypeLib.isSet()) {
		for (int16 vermajor = 32; !pti && vermajor >= 0; --vermajor)
			for (int16 verminor = 99; !pti && verminor >= 0; --verminor) {
				if (LoadRegTypeLib(TypeLib, vermajor, verminor,
					LOCALE_NEUTRAL, &TypeLib.ptlb) != S_OK) TypeLib.ptlb = NULL;
				if (TypeLib.ptlb != NULL && TypeLib.ptlb->GetTypeInfoOfGuid(*this, &pti) != S_OK) {
					TypeLib.ptlb.Release();
					pti = NULL;
				}
#ifdef _DEBUG
				if (pti != NULL) _CrtDbgReport(_CRT_WARN, __FILE__, __LINE__, __FUNCTION__,
					"Used alternate version to load typelib: Interface\\%s version %hi.%hi loaded by version %hi.%hi\n",
					toString().c_str(), TypeLib.vermajor, TypeLib.verminor, vermajor, verminor);
#endif // _DEBUG
			}
	}
	/*
	try { // ...to get typeinfo from object instance
		if (!pti && (punk.CoCreateInstance(CLSID_OLEViewerTypeLibInterfaceViewers,
			NULL, CLSCTX_INPROC_SERVER) != S_OK
			|| punk.QueryInterface(&pdisp) != S_OK
			|| pdisp->GetTypeInfo(0, 0, &pti) != S_OK)) pti = NULL;
	} catch (const std::exception &e) {
#ifdef _DEBUG
		_CrtDbgReport(_CRT_ERROR, __FILE__, __LINE__, __FUNCTION__,
			"%s(...): %s when getting typeinfo from instance iid=%s\n",
			__FUNCTION__, e.what(), Class.toString().c_str());
#else
	} catch (...) {
#endif // _DEBUG
		pti = NULL;
	}
	*/
	return true;
}

void interface_t::clear() {
	reset();
	name.clear();
	Class.clear();
	TypeLib.clear();
	pti.Release();
}

bool clsid_t::Load(const CLSIDEX &id) {
	clear();
	CRegKey hKeyClass, hKeyTmp;
	if (hKeyClass.Open(HKEY_CLASSES_ROOT,
		std::string("CLSID\\").append(id.toString()).c_str()) != ERROR_SUCCESS)
			return false;
	CLSIDEX::operator =(id);
	boost::scoped_array<char> value(new char[VALUE_SIZE]);
	if (!value) {
		_RPT2(_CRT_ERROR, "%s(...): failed to allocate new string of size 0x%X\n",
			__FUNCTION__, VALUE_SIZE);
		throw std::bad_alloc(); //return false;
	}
	DWORD dwSz;
	if (hKeyClass.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS)
		name.assign(value.get());
	if (hKeyTmp.Open(hKeyClass, "InprocServer") == ERROR_SUCCESS) {
		hKeyTmp.QueryValue(server16, NULL, &(dwSz = server16.capacity()));
		hKeyTmp.Close();
	}
	if (hKeyTmp.Open(hKeyClass, "InprocServer32") == ERROR_SUCCESS) {
		hKeyTmp.QueryValue(server32, NULL, &(dwSz = server32.capacity()));
		hKeyTmp.Close();
	}
	return true;
}

void clsid_t::clear() {
	reset();
	name.clear();
	server16.clear();
	server32.clear();
}

bool typelib_t::Load(const GUIDEX &id) {
	clear();
	CRegKey hKeyTypeLib, hKeyTmp1, hKeyTmp2;
	if (hKeyTypeLib.Open(HKEY_CLASSES_ROOT,
		std::string("TypeLib\\").append(id.toString()).c_str()) != ERROR_SUCCESS)
		return false;
	GUIDEX::operator =(id);
	boost::scoped_array<char> value(new char[VALUE_SIZE]);
	if (!value) {
		_RPT2(_CRT_ERROR, "%s(...): failed to allocate new string of size 0x%X\n",
			__FUNCTION__, VALUE_SIZE);
		throw std::bad_alloc(); //return false;
	}
	DWORD dwSz;
	FILETIME ft;
	for (DWORD index = 0; RegEnumKeyEx(hKeyTypeLib, index, value.get(), &(dwSz = VALUE_SIZE), NULL, NULL, NULL, &ft) == ERROR_SUCCESS; ++index)
		if (hKeyTmp1.Open(hKeyTypeLib, value.get()) == ERROR_SUCCESS) {
			verFromStr(value.get());
			if (hKeyTmp1.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS)
				name.assign(value.get());
			if (hKeyTmp2.Open(hKeyTmp1, "FLAGS") == ERROR_SUCCESS) {
				if (hKeyTmp2.QueryValue(value.get(), NULL, &(dwSz = VALUE_SIZE)) == ERROR_SUCCESS)
					flags = strtoul(value.get(), 0, 0);
				hKeyTmp2.Close();
			}
			for (DWORD index = 0; RegEnumKeyEx(hKeyTmp1, index, value.get(), &(dwSz = VALUE_SIZE), NULL, NULL, NULL, &ft) == ERROR_SUCCESS; ++index)
				if (hKeyTmp2.Open(hKeyTmp1, std::string(value.get()).append("\\win32").c_str()) == ERROR_SUCCESS) {
					lcid = strtoul(value.get(), 0, 0);
					hKeyTmp2.QueryValue(filename, NULL, &(dwSz = filename.capacity()));
					hKeyTmp2.Close();
				}
			hKeyTmp1.Close();
		}
	if (LoadRegTypeLib(*this, vermajor, verminor, lcid, &ptlb) != S_OK) ptlb = NULL;
	return true;
}

BOOL typelib_t::verFromStr(LPCSTR ver) {
	_ASSERTE(ver != NULL);
	verminor = 0;
	return ver != NULL && *ver != 0
		&& (qsscanf(ver, "%hx.%hx", &vermajor, &verminor) >= 2
		|| (vermajor = strtoul(ver, 0, 0x10)) > 0);
}

void typelib_t::clear() {
	reset();
	vermajor = 0; verminor = 0; lcid = 0; flags = 0;
	name.clear();
	filename.clear();
	ptlb.Release();
}

bool TokenizePARAMDESCEX(const PARAMDESCEX &paramdescex, std::string &s) {
	if (paramdescex.cBytes <= 0 || paramdescex.varDefaultValue.vt == VT_EMPTY)
		return false;
	const std::wstring ws(TokenizeVariant(paramdescex.varDefaultValue));
	if (ws.empty()) return false;
	boost::scoped_array<std::string::value_type>
		mbs(new std::string::value_type[ws.length() + 1]);
	if (!mbs) {
		_RPT2(_CRT_ERROR, "%s(...): failed to allocate new string of size 0x%IX\n",
			__FUNCTION__, ws.length() + 1);
		throw std::bad_alloc();
	}
	if (static_cast<int>(wcstombs(mbs.get(), ws.c_str(), ws.length() + 1)) <= 0)
		return false;
	s.append(mbs.get());
	return true;
}

// may return NULL when not matched
static BSTR TokenizeSCODE(SCODE scode) {
#define SCODE_ENTRYW(x) x, L#x,
	static const struct {
		SCODE scode;
		BSTR bstr;
	} foo[] = {
		SCODE_ENTRYW(S_OK)
		SCODE_ENTRYW(S_FALSE)
		SCODE_ENTRYW(E_UNEXPECTED)
		SCODE_ENTRYW(E_ACCESSDENIED)
		SCODE_ENTRYW(E_ABORT)
		SCODE_ENTRYW(E_FAIL)
		SCODE_ENTRYW(E_HANDLE)
		SCODE_ENTRYW(E_INVALIDARG)
		SCODE_ENTRYW(E_NOINTERFACE)
		SCODE_ENTRYW(E_NOTIMPL)
		SCODE_ENTRYW(E_OUTOFMEMORY)
		SCODE_ENTRYW(E_PENDING)
		SCODE_ENTRYW(E_POINTER)
		SCODE_ENTRYW(OLE_E_ADVF)
		SCODE_ENTRYW(OLE_E_ADVISENOTSUPPORTED)
		SCODE_ENTRYW(OLE_E_BLANK)
		SCODE_ENTRYW(OLE_E_CANTCONVERT)
		SCODE_ENTRYW(OLE_E_CANT_BINDTOSOURCE)
		SCODE_ENTRYW(OLE_E_CANT_GETMONIKER)
		SCODE_ENTRYW(OLE_E_CLASSDIFF)
		SCODE_ENTRYW(OLE_E_ENUM_NOMORE)
		SCODE_ENTRYW(OLE_E_INVALIDHWND)
		SCODE_ENTRYW(OLE_E_INVALIDRECT)
		SCODE_ENTRYW(OLE_E_NOCACHE)
		SCODE_ENTRYW(OLE_E_NOCONNECTION)
		SCODE_ENTRYW(OLE_E_NOSTORAGE)
		SCODE_ENTRYW(OLE_E_NOTRUNNING)
		SCODE_ENTRYW(OLE_E_NOT_INPLACEACTIVE)
		SCODE_ENTRYW(OLE_E_OLEVERB)
		SCODE_ENTRYW(OLE_E_PROMPTSAVECANCELLED)
		SCODE_ENTRYW(OLE_E_STATIC)
		SCODE_ENTRYW(OLE_E_WRONGCOMPOBJ)
		SCODE_ENTRYW(OLE_S_MAC_CLIPFORMAT)
		SCODE_ENTRYW(OLE_S_STATIC)
		SCODE_ENTRYW(OLE_S_USEREG)
		SCODE_ENTRYW(CO_E_ACCESSCHECKFAILED)
		SCODE_ENTRYW(CO_E_ACESINWRONGORDER)
		SCODE_ENTRYW(CO_E_ACNOTINITIALIZED)
		SCODE_ENTRYW(CO_E_ACTIVATIONFAILED)
		SCODE_ENTRYW(CO_E_ACTIVATIONFAILED_CATALOGERROR)
		SCODE_ENTRYW(CO_E_ACTIVATIONFAILED_EVENTLOGGED)
		SCODE_ENTRYW(CO_E_ACTIVATIONFAILED_TIMEOUT)
		SCODE_ENTRYW(CO_E_ALREADYINITIALIZED)
		SCODE_ENTRYW(CO_E_APPDIDNTREG)
		SCODE_ENTRYW(CO_E_APPNOTFOUND)
		SCODE_ENTRYW(CO_E_APPSINGLEUSE)
		SCODE_ENTRYW(CO_E_ASYNC_WORK_REJECTED)
		SCODE_ENTRYW(CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT)
		SCODE_ENTRYW(CO_E_BAD_PATH)
		SCODE_ENTRYW(CO_E_BAD_SERVER_NAME)
		SCODE_ENTRYW(CO_E_CANCEL_DISABLED)
		SCODE_ENTRYW(CO_E_CANTDETERMINECLASS)
		SCODE_ENTRYW(CO_E_CANT_REMOTE)
		SCODE_ENTRYW(CO_E_CLASSSTRING)
		SCODE_ENTRYW(CO_E_CLASS_CREATE_FAILED)
		SCODE_ENTRYW(CO_E_CLASS_DISABLED)
		SCODE_ENTRYW(CO_E_CLRNOTAVAILABLE)
		SCODE_ENTRYW(CO_E_CLSREG_INCONSISTENT)
		SCODE_ENTRYW(CO_E_CONVERSIONFAILED)
		SCODE_ENTRYW(CO_E_CREATEPROCESS_FAILURE)
		SCODE_ENTRYW(CO_E_DBERROR)
		SCODE_ENTRYW(CO_E_DECODEFAILED)
		SCODE_ENTRYW(CO_E_DLLNOTFOUND)
		SCODE_ENTRYW(CO_E_ERRORINAPP)
		SCODE_ENTRYW(CO_E_ERRORINDLL)
		SCODE_ENTRYW(CO_E_EXCEEDSYSACLLIMIT)
		SCODE_ENTRYW(CO_E_FAILEDTOCLOSEHANDLE)
		SCODE_ENTRYW(CO_E_FAILEDTOCREATEFILE)
		SCODE_ENTRYW(CO_E_FAILEDTOGENUUID)
		SCODE_ENTRYW(CO_E_FAILEDTOGETSECCTX)
		SCODE_ENTRYW(CO_E_FAILEDTOGETTOKENINFO)
		SCODE_ENTRYW(CO_E_FAILEDTOGETWINDIR)
		SCODE_ENTRYW(CO_E_FAILEDTOIMPERSONATE)
		SCODE_ENTRYW(CO_E_FAILEDTOOPENPROCESSTOKEN)
		SCODE_ENTRYW(CO_E_FAILEDTOOPENTHREADTOKEN)
		SCODE_ENTRYW(CO_E_FAILEDTOQUERYCLIENTBLANKET)
		SCODE_ENTRYW(CO_E_FAILEDTOSETDACL)
		SCODE_ENTRYW(CO_E_IIDREG_INCONSISTENT)
		SCODE_ENTRYW(CO_E_IIDSTRING)
		SCODE_ENTRYW(CO_E_INCOMPATIBLESTREAMVERSION)
		SCODE_ENTRYW(CO_E_INITIALIZATIONFAILED)
		SCODE_ENTRYW(CO_E_INIT_CLASS_CACHE)
		SCODE_ENTRYW(CO_E_INIT_MEMORY_ALLOCATOR)
		SCODE_ENTRYW(CO_E_INIT_ONLY_SINGLE_THREADED)
		SCODE_ENTRYW(CO_E_INIT_RPC_CHANNEL)
		SCODE_ENTRYW(CO_E_INIT_SCM_EXEC_FAILURE)
		SCODE_ENTRYW(CO_E_INIT_SCM_FILE_MAPPING_EXISTS)
		SCODE_ENTRYW(CO_E_INIT_SCM_MAP_VIEW_OF_FILE)
		SCODE_ENTRYW(CO_E_INIT_SCM_MUTEX_EXISTS)
		SCODE_ENTRYW(CO_E_INIT_SHARED_ALLOCATOR)
		SCODE_ENTRYW(CO_E_INIT_TLS)
		SCODE_ENTRYW(CO_E_INIT_TLS_CHANNEL_CONTROL)
		SCODE_ENTRYW(CO_E_INIT_TLS_SET_CHANNEL_CONTROL)
		SCODE_ENTRYW(CO_E_INIT_UNACCEPTED_USER_ALLOCATOR)
		SCODE_ENTRYW(CO_E_INVALIDSID)
		SCODE_ENTRYW(CO_E_ISOLEVELMISMATCH)
		SCODE_ENTRYW(CO_E_LAUNCH_PERMSSION_DENIED)
		SCODE_ENTRYW(CO_E_LOOKUPACCNAMEFAILED)
		SCODE_ENTRYW(CO_E_LOOKUPACCSIDFAILED)
		SCODE_ENTRYW(CO_E_MALFORMED_SPN)
		SCODE_ENTRYW(CO_E_MSI_ERROR)
		SCODE_ENTRYW(CO_E_NETACCESSAPIFAILED)
		SCODE_ENTRYW(CO_E_NOCOOKIES)
		SCODE_ENTRYW(CO_E_NOIISINTRINSICS)
		SCODE_ENTRYW(CO_E_NOMATCHINGNAMEFOUND)
		SCODE_ENTRYW(CO_E_NOMATCHINGSIDFOUND)
		SCODE_ENTRYW(CO_E_NOSYNCHRONIZATION)
		SCODE_ENTRYW(CO_E_NOTCONSTRUCTED)
		SCODE_ENTRYW(CO_E_NOTINITIALIZED)
		SCODE_ENTRYW(CO_E_NOTPOOLED)
		SCODE_ENTRYW(CO_E_NOT_SUPPORTED)
		SCODE_ENTRYW(CO_E_NO_SECCTX_IN_ACTIVATE)
		SCODE_ENTRYW(CO_E_OBJISREG)
		SCODE_ENTRYW(CO_E_OBJNOTCONNECTED)
		SCODE_ENTRYW(CO_E_OBJNOTREG)
		SCODE_ENTRYW(CO_E_OBJSRV_RPC_FAILURE)
		SCODE_ENTRYW(CO_E_OLE1DDE_DISABLED)
		SCODE_ENTRYW(CO_E_PATHTOOLONG)
		SCODE_ENTRYW(CO_E_RELEASED)
		SCODE_ENTRYW(CO_E_RELOAD_DLL)
		SCODE_ENTRYW(CO_E_REMOTE_COMMUNICATION_FAILURE)
		SCODE_ENTRYW(CO_E_RUNAS_CREATEPROCESS_FAILURE)
		SCODE_ENTRYW(CO_E_RUNAS_LOGON_FAILURE)
		SCODE_ENTRYW(CO_E_RUNAS_SYNTAX)
		SCODE_ENTRYW(CO_E_SCM_ERROR)
		SCODE_ENTRYW(CO_E_SCM_RPC_FAILURE)
		SCODE_ENTRYW(CO_E_SERVER_EXEC_FAILURE)
		SCODE_ENTRYW(CO_E_SERVER_INIT_TIMEOUT)
		SCODE_ENTRYW(CO_E_SERVER_NOT_PAUSED)
		SCODE_ENTRYW(CO_E_SERVER_PAUSED)
		SCODE_ENTRYW(CO_E_SERVER_START_TIMEOUT)
		SCODE_ENTRYW(CO_E_SERVER_STOPPING)
		SCODE_ENTRYW(CO_E_SETSERLHNDLFAILED)
		SCODE_ENTRYW(CO_E_START_SERVICE_FAILURE)
		SCODE_ENTRYW(CO_E_SXS_CONFIG)
		SCODE_ENTRYW(CO_E_THREADINGMODEL_CHANGED)
		SCODE_ENTRYW(CO_E_THREADPOOL_CONFIG)
		SCODE_ENTRYW(CO_E_TRACKER_CONFIG)
		SCODE_ENTRYW(CO_E_TRUSTEEDOESNTMATCHCLIENT)
		SCODE_ENTRYW(CO_E_WRONGOSFORAPP)
		SCODE_ENTRYW(CO_E_WRONGTRUSTEENAMESYNTAX)
		SCODE_ENTRYW(CO_E_WRONG_SERVER_IDENTITY)
		SCODE_ENTRYW(CO_S_MACHINENAMENOTFOUND)
		SCODE_ENTRYW(CO_S_NOTALLINTERFACES)
		SCODE_ENTRYW(CACHE_E_NOCACHE_UPDATED)
		SCODE_ENTRYW(CACHE_S_FORMATETC_NOTSUPPORTED)
		SCODE_ENTRYW(CACHE_S_SAMECACHE)
		SCODE_ENTRYW(CACHE_S_SOMECACHES_NOTUPDATED)
		SCODE_ENTRYW(CAT_E_CATIDNOEXIST)
		SCODE_ENTRYW(CAT_E_NODESCRIPTION)
		SCODE_ENTRYW(CERTSRV_E_ALIGNMENT_FAULT)
		SCODE_ENTRYW(CERTSRV_E_ARCHIVED_KEY_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_ARCHIVED_KEY_UNEXPECTED)
		SCODE_ENTRYW(CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE)
		SCODE_ENTRYW(CERTSRV_E_BAD_RENEWAL_SUBJECT)
		SCODE_ENTRYW(CERTSRV_E_BAD_REQUESTSTATUS)
		SCODE_ENTRYW(CERTSRV_E_BAD_REQUESTSUBJECT)
		SCODE_ENTRYW(CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL)
		SCODE_ENTRYW(CERTSRV_E_BAD_TEMPLATE_VERSION)
		SCODE_ENTRYW(CERTSRV_E_ENCODING_LENGTH)
		SCODE_ENTRYW(CERTSRV_E_ENROLL_DENIED)
		SCODE_ENTRYW(CERTSRV_E_INVALID_CA_CERTIFICATE)
		SCODE_ENTRYW(CERTSRV_E_ISSUANCE_POLICY_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED)
		SCODE_ENTRYW(CERTSRV_E_KEY_LENGTH)
		SCODE_ENTRYW(CERTSRV_E_NO_CAADMIN_DEFINED)
		SCODE_ENTRYW(CERTSRV_E_NO_CERT_TYPE)
		SCODE_ENTRYW(CERTSRV_E_NO_DB_SESSIONS)
		SCODE_ENTRYW(CERTSRV_E_NO_REQUEST)
		SCODE_ENTRYW(CERTSRV_E_NO_VALID_KRA)
		SCODE_ENTRYW(CERTSRV_E_PROPERTY_EMPTY)
		SCODE_ENTRYW(CERTSRV_E_RESTRICTEDOFFICER)
		SCODE_ENTRYW(CERTSRV_E_ROLECONFLICT)
		SCODE_ENTRYW(CERTSRV_E_SERVER_SUSPENDED)
		SCODE_ENTRYW(CERTSRV_E_SIGNATURE_COUNT)
		SCODE_ENTRYW(CERTSRV_E_SIGNATURE_POLICY_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_SIGNATURE_REJECTED)
		SCODE_ENTRYW(CERTSRV_E_SMIME_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_SUBJECT_DNS_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_SUBJECT_UPN_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_TEMPLATE_CONFLICT)
		SCODE_ENTRYW(CERTSRV_E_TEMPLATE_DENIED)
		SCODE_ENTRYW(CERTSRV_E_TEMPLATE_POLICY_REQUIRED)
		SCODE_ENTRYW(CERTSRV_E_UNSUPPORTED_CERT_TYPE)
		SCODE_ENTRYW(CERT_E_CHAINING)
		SCODE_ENTRYW(CERT_E_CN_NO_MATCH)
		SCODE_ENTRYW(CERT_E_CRITICAL)
		SCODE_ENTRYW(CERT_E_EXPIRED)
		SCODE_ENTRYW(CERT_E_INVALID_NAME)
		SCODE_ENTRYW(CERT_E_INVALID_POLICY)
		SCODE_ENTRYW(CERT_E_ISSUERCHAINING)
		SCODE_ENTRYW(CERT_E_MALFORMED)
		SCODE_ENTRYW(CERT_E_PATHLENCONST)
		SCODE_ENTRYW(CERT_E_PURPOSE)
		SCODE_ENTRYW(CERT_E_REVOCATION_FAILURE)
		SCODE_ENTRYW(CERT_E_REVOKED)
		SCODE_ENTRYW(CERT_E_ROLE)
		SCODE_ENTRYW(CERT_E_UNTRUSTEDCA)
		SCODE_ENTRYW(CERT_E_UNTRUSTEDROOT)
		SCODE_ENTRYW(CERT_E_UNTRUSTEDTESTROOT)
		SCODE_ENTRYW(CERT_E_VALIDITYPERIODNESTING)
		SCODE_ENTRYW(CERT_E_WRONG_USAGE)
		SCODE_ENTRYW(CLASS_E_CLASSNOTAVAILABLE)
		SCODE_ENTRYW(CLASS_E_NOAGGREGATION)
		SCODE_ENTRYW(CLASS_E_NOTLICENSED)
		SCODE_ENTRYW(CLIPBRD_E_BAD_DATA)
		SCODE_ENTRYW(CLIPBRD_E_CANT_CLOSE)
		SCODE_ENTRYW(CLIPBRD_E_CANT_EMPTY)
		SCODE_ENTRYW(CLIPBRD_E_CANT_OPEN)
		SCODE_ENTRYW(CLIPBRD_E_CANT_SET)
		SCODE_ENTRYW(COMADMIN_E_ALREADYINSTALLED)
		SCODE_ENTRYW(COMADMIN_E_AMBIGUOUS_APPLICATION_NAME)
		SCODE_ENTRYW(COMADMIN_E_AMBIGUOUS_PARTITION_NAME)
		SCODE_ENTRYW(COMADMIN_E_APPDIRNOTFOUND)
		SCODE_ENTRYW(COMADMIN_E_APPLICATIONEXISTS)
		SCODE_ENTRYW(COMADMIN_E_APPLID_MATCHES_CLSID)
		SCODE_ENTRYW(COMADMIN_E_APP_FILE_READFAIL)
		SCODE_ENTRYW(COMADMIN_E_APP_FILE_VERSION)
		SCODE_ENTRYW(COMADMIN_E_APP_FILE_WRITEFAIL)
		SCODE_ENTRYW(COMADMIN_E_APP_NOT_RUNNING)
		SCODE_ENTRYW(COMADMIN_E_AUTHENTICATIONLEVEL)
		SCODE_ENTRYW(COMADMIN_E_BADPATH)
		SCODE_ENTRYW(COMADMIN_E_BADREGISTRYLIBID)
		SCODE_ENTRYW(COMADMIN_E_BADREGISTRYPROGID)
		SCODE_ENTRYW(COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET)
		SCODE_ENTRYW(COMADMIN_E_BASE_PARTITION_ONLY)
		SCODE_ENTRYW(COMADMIN_E_CANNOT_ALIAS_EVENTCLASS)
		SCODE_ENTRYW(COMADMIN_E_CANTCOPYFILE)
		SCODE_ENTRYW(COMADMIN_E_CANTMAKEINPROCSERVICE)
		SCODE_ENTRYW(COMADMIN_E_CANTRECYCLELIBRARYAPPS)
		SCODE_ENTRYW(COMADMIN_E_CANTRECYCLESERVICEAPPS)
		SCODE_ENTRYW(COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT)
		SCODE_ENTRYW(COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY)
		SCODE_ENTRYW(COMADMIN_E_CAN_NOT_EXPORT_SYS_APP)
		SCODE_ENTRYW(COMADMIN_E_CAN_NOT_START_APP)
		SCODE_ENTRYW(COMADMIN_E_CAT_BITNESSMISMATCH)
		SCODE_ENTRYW(COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME)
		SCODE_ENTRYW(COMADMIN_E_CAT_DUPLICATE_PARTITION_SET_NAME)
		SCODE_ENTRYW(COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED)
		SCODE_ENTRYW(COMADMIN_E_CAT_INVALID_PARTITION_NAME)
		SCODE_ENTRYW(COMADMIN_E_CAT_INVALID_PARTITION_SET_NAME)
		SCODE_ENTRYW(COMADMIN_E_CAT_PARTITION_IN_USE)
		SCODE_ENTRYW(COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED)
		SCODE_ENTRYW(COMADMIN_E_CAT_SERVERFAULT)
		SCODE_ENTRYW(COMADMIN_E_CAT_UNACCEPTABLEBITNESS)
		SCODE_ENTRYW(COMADMIN_E_CAT_WRONGAPPBITNESS)
		SCODE_ENTRYW(COMADMIN_E_CLSIDORIIDMISMATCH)
		SCODE_ENTRYW(COMADMIN_E_COMPFILE_BADTLB)
		SCODE_ENTRYW(COMADMIN_E_COMPFILE_CLASSNOTAVAIL)
		SCODE_ENTRYW(COMADMIN_E_COMPFILE_DOESNOTEXIST)
		SCODE_ENTRYW(COMADMIN_E_COMPFILE_GETCLASSOBJ)
		SCODE_ENTRYW(COMADMIN_E_COMPFILE_LOADDLLFAIL)
		SCODE_ENTRYW(COMADMIN_E_COMPFILE_NOREGISTRAR)
		SCODE_ENTRYW(COMADMIN_E_COMPFILE_NOTINSTALLABLE)
		SCODE_ENTRYW(COMADMIN_E_COMPONENTEXISTS)
		SCODE_ENTRYW(COMADMIN_E_COMP_MOVE_BAD_DEST)
		SCODE_ENTRYW(COMADMIN_E_COMP_MOVE_DEST)
		SCODE_ENTRYW(COMADMIN_E_COMP_MOVE_LOCKED)
		SCODE_ENTRYW(COMADMIN_E_COMP_MOVE_PRIVATE)
		SCODE_ENTRYW(COMADMIN_E_COMP_MOVE_SOURCE)
		SCODE_ENTRYW(COMADMIN_E_COREQCOMPINSTALLED)
		SCODE_ENTRYW(COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET)
		SCODE_ENTRYW(COMADMIN_E_DLLLOADFAILED)
		SCODE_ENTRYW(COMADMIN_E_DLLREGISTERSERVER)
		SCODE_ENTRYW(COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER)
		SCODE_ENTRYW(COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES)
		SCODE_ENTRYW(COMADMIN_E_INVALIDUSERIDS)
		SCODE_ENTRYW(COMADMIN_E_INVALID_PARTITION)
		SCODE_ENTRYW(COMADMIN_E_KEYMISSING)
		SCODE_ENTRYW(COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT)
		SCODE_ENTRYW(COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS)
		SCODE_ENTRYW(COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE)
		SCODE_ENTRYW(COMADMIN_E_MIG_SCHEMANOTFOUND)
		SCODE_ENTRYW(COMADMIN_E_MIG_VERSIONNOTSUPPORTED)
		SCODE_ENTRYW(COMADMIN_E_NOREGISTRYCLSID)
		SCODE_ENTRYW(COMADMIN_E_NOSERVERSHARE)
		SCODE_ENTRYW(COMADMIN_E_NOTCHANGEABLE)
		SCODE_ENTRYW(COMADMIN_E_NOTDELETEABLE)
		SCODE_ENTRYW(COMADMIN_E_NOTINREGISTRY)
		SCODE_ENTRYW(COMADMIN_E_NOUSER)
		SCODE_ENTRYW(COMADMIN_E_OBJECTERRORS)
		SCODE_ENTRYW(COMADMIN_E_OBJECTEXISTS)
		SCODE_ENTRYW(COMADMIN_E_OBJECTINVALID)
		SCODE_ENTRYW(COMADMIN_E_OBJECTNOTPOOLABLE)
		SCODE_ENTRYW(COMADMIN_E_OBJECT_DOES_NOT_EXIST)
		SCODE_ENTRYW(COMADMIN_E_OBJECT_PARENT_MISSING)
		SCODE_ENTRYW(COMADMIN_E_PARTITION_ACCESSDENIED)
		SCODE_ENTRYW(COMADMIN_E_PARTITION_MSI_ONLY)
		SCODE_ENTRYW(COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED)
		SCODE_ENTRYW(COMADMIN_E_PRIVATE_ACCESSDENIED)
		SCODE_ENTRYW(COMADMIN_E_PROCESSALREADYRECYCLED)
		SCODE_ENTRYW(COMADMIN_E_PROGIDINUSEBYCLSID)
		SCODE_ENTRYW(COMADMIN_E_PROPERTYSAVEFAILED)
		SCODE_ENTRYW(COMADMIN_E_PROPERTY_OVERFLOW)
		SCODE_ENTRYW(COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED)
		SCODE_ENTRYW(COMADMIN_E_REGDB_ALREADYRUNNING)
		SCODE_ENTRYW(COMADMIN_E_REGDB_NOTINITIALIZED)
		SCODE_ENTRYW(COMADMIN_E_REGDB_NOTOPEN)
		SCODE_ENTRYW(COMADMIN_E_REGDB_SYSTEMERR)
		SCODE_ENTRYW(COMADMIN_E_REGFILE_CORRUPT)
		SCODE_ENTRYW(COMADMIN_E_REGISTERTLB)
		SCODE_ENTRYW(COMADMIN_E_REGISTRARFAILED)
		SCODE_ENTRYW(COMADMIN_E_REGISTRY_ACCESSDENIED)
		SCODE_ENTRYW(COMADMIN_E_REMOTEINTERFACE)
		SCODE_ENTRYW(COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM)
		SCODE_ENTRYW(COMADMIN_E_ROLEEXISTS)
		SCODE_ENTRYW(COMADMIN_E_ROLE_DOES_NOT_EXIST)
		SCODE_ENTRYW(COMADMIN_E_SAFERINVALID)
		SCODE_ENTRYW(COMADMIN_E_SERVICENOTINSTALLED)
		SCODE_ENTRYW(COMADMIN_E_SESSION)
		SCODE_ENTRYW(COMADMIN_E_START_APP_DISABLED)
		SCODE_ENTRYW(COMADMIN_E_START_APP_NEEDS_COMPONENTS)
		SCODE_ENTRYW(COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE)
		SCODE_ENTRYW(COMADMIN_E_SYSTEMAPP)
		SCODE_ENTRYW(COMADMIN_E_USERPASSWDNOTVALID)
		SCODE_ENTRYW(COMADMIN_E_USER_IN_SET)
		SCODE_ENTRYW(COMQC_E_APPLICATION_NOT_QUEUED)
		SCODE_ENTRYW(COMQC_E_BAD_MESSAGE)
		SCODE_ENTRYW(COMQC_E_NO_IPERSISTSTREAM)
		SCODE_ENTRYW(COMQC_E_NO_QUEUEABLE_INTERFACES)
		SCODE_ENTRYW(COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE)
		SCODE_ENTRYW(COMQC_E_UNAUTHENTICATED)
		SCODE_ENTRYW(COMQC_E_UNTRUSTED_ENQUEUER)
		SCODE_ENTRYW(CONTEXT_E_ABORTED)
		SCODE_ENTRYW(CONTEXT_E_ABORTING)
		SCODE_ENTRYW(CONTEXT_E_NOCONTEXT)
		SCODE_ENTRYW(CONTEXT_E_NOJIT)
		SCODE_ENTRYW(CONTEXT_E_NOTRANSACTION)
		SCODE_ENTRYW(CONTEXT_E_OLDREF)
		SCODE_ENTRYW(CONTEXT_E_ROLENOTFOUND)
		SCODE_ENTRYW(CONTEXT_E_SYNCH_TIMEOUT)
		SCODE_ENTRYW(CONTEXT_E_TMNOTAVAILABLE)
		SCODE_ENTRYW(CONVERT10_E_OLESTREAM_BITMAP_TO_DIB)
		SCODE_ENTRYW(CONVERT10_E_OLESTREAM_FMT)
		SCODE_ENTRYW(CONVERT10_E_OLESTREAM_GET)
		SCODE_ENTRYW(CONVERT10_E_OLESTREAM_PUT)
		SCODE_ENTRYW(CONVERT10_E_STG_DIB_TO_BITMAP)
		SCODE_ENTRYW(CONVERT10_E_STG_FMT)
		SCODE_ENTRYW(CONVERT10_E_STG_NO_STD_STREAM)
		SCODE_ENTRYW(CONVERT10_S_NO_PRESENTATION)
		SCODE_ENTRYW(CRYPT_E_ALREADY_DECRYPTED)
		SCODE_ENTRYW(CRYPT_E_ASN1_BADARGS)
		SCODE_ENTRYW(CRYPT_E_ASN1_BADPDU)
		SCODE_ENTRYW(CRYPT_E_ASN1_BADREAL)
		SCODE_ENTRYW(CRYPT_E_ASN1_BADTAG)
		SCODE_ENTRYW(CRYPT_E_ASN1_CHOICE)
		SCODE_ENTRYW(CRYPT_E_ASN1_CONSTRAINT)
		SCODE_ENTRYW(CRYPT_E_ASN1_CORRUPT)
		SCODE_ENTRYW(CRYPT_E_ASN1_EOD)
		SCODE_ENTRYW(CRYPT_E_ASN1_ERROR)
		SCODE_ENTRYW(CRYPT_E_ASN1_EXTENDED)
		SCODE_ENTRYW(CRYPT_E_ASN1_INTERNAL)
		SCODE_ENTRYW(CRYPT_E_ASN1_LARGE)
		SCODE_ENTRYW(CRYPT_E_ASN1_MEMORY)
		SCODE_ENTRYW(CRYPT_E_ASN1_NOEOD)
		SCODE_ENTRYW(CRYPT_E_ASN1_NYI)
		SCODE_ENTRYW(CRYPT_E_ASN1_OVERFLOW)
		SCODE_ENTRYW(CRYPT_E_ASN1_PDU_TYPE)
		SCODE_ENTRYW(CRYPT_E_ASN1_RULE)
		SCODE_ENTRYW(CRYPT_E_ASN1_UTF8)
		SCODE_ENTRYW(CRYPT_E_ATTRIBUTES_MISSING)
		SCODE_ENTRYW(CRYPT_E_AUTH_ATTR_MISSING)
		SCODE_ENTRYW(CRYPT_E_BAD_ENCODE)
		SCODE_ENTRYW(CRYPT_E_BAD_LEN)
		SCODE_ENTRYW(CRYPT_E_BAD_MSG)
		SCODE_ENTRYW(CRYPT_E_CONTROL_TYPE)
		SCODE_ENTRYW(CRYPT_E_DELETED_PREV)
		SCODE_ENTRYW(CRYPT_E_EXISTS)
		SCODE_ENTRYW(CRYPT_E_FILERESIZED)
		SCODE_ENTRYW(CRYPT_E_FILE_ERROR)
		SCODE_ENTRYW(CRYPT_E_HASH_VALUE)
		SCODE_ENTRYW(CRYPT_E_INVALID_IA5_STRING)
		SCODE_ENTRYW(CRYPT_E_INVALID_INDEX)
		SCODE_ENTRYW(CRYPT_E_INVALID_MSG_TYPE)
		SCODE_ENTRYW(CRYPT_E_INVALID_NUMERIC_STRING)
		SCODE_ENTRYW(CRYPT_E_INVALID_PRINTABLE_STRING)
		SCODE_ENTRYW(CRYPT_E_INVALID_X500_STRING)
		SCODE_ENTRYW(CRYPT_E_ISSUER_SERIALNUMBER)
		SCODE_ENTRYW(CRYPT_E_MISSING_PUBKEY_PARA)
		SCODE_ENTRYW(CRYPT_E_MSG_ERROR)
		SCODE_ENTRYW(CRYPT_E_NOT_CHAR_STRING)
		SCODE_ENTRYW(CRYPT_E_NOT_DECRYPTED)
		SCODE_ENTRYW(CRYPT_E_NOT_FOUND)
		SCODE_ENTRYW(CRYPT_E_NOT_IN_CTL)
		SCODE_ENTRYW(CRYPT_E_NOT_IN_REVOCATION_DATABASE)
		SCODE_ENTRYW(CRYPT_E_NO_DECRYPT_CERT)
		SCODE_ENTRYW(CRYPT_E_NO_KEY_PROPERTY)
		SCODE_ENTRYW(CRYPT_E_NO_MATCH)
		SCODE_ENTRYW(CRYPT_E_NO_PROVIDER)
		SCODE_ENTRYW(CRYPT_E_NO_REVOCATION_CHECK)
		SCODE_ENTRYW(CRYPT_E_NO_REVOCATION_DLL)
		SCODE_ENTRYW(CRYPT_E_NO_SIGNER)
		SCODE_ENTRYW(CRYPT_E_NO_TRUSTED_SIGNER)
		SCODE_ENTRYW(CRYPT_E_NO_VERIFY_USAGE_CHECK)
		SCODE_ENTRYW(CRYPT_E_NO_VERIFY_USAGE_DLL)
		SCODE_ENTRYW(CRYPT_E_OID_FORMAT)
		SCODE_ENTRYW(CRYPT_E_OSS_ERROR)
		SCODE_ENTRYW(CRYPT_E_PENDING_CLOSE)
		SCODE_ENTRYW(CRYPT_E_RECIPIENT_NOT_FOUND)
		SCODE_ENTRYW(CRYPT_E_REVOCATION_OFFLINE)
		SCODE_ENTRYW(CRYPT_E_REVOKED)
		SCODE_ENTRYW(CRYPT_E_SECURITY_SETTINGS)
		SCODE_ENTRYW(CRYPT_E_SELF_SIGNED)
		SCODE_ENTRYW(CRYPT_E_SIGNER_NOT_FOUND)
		SCODE_ENTRYW(CRYPT_E_STREAM_INSUFFICIENT_DATA)
		SCODE_ENTRYW(CRYPT_E_STREAM_MSG_NOT_READY)
		SCODE_ENTRYW(CRYPT_E_UNEXPECTED_ENCODING)
		SCODE_ENTRYW(CRYPT_E_UNEXPECTED_MSG_TYPE)
		SCODE_ENTRYW(CRYPT_E_UNKNOWN_ALGO)
		SCODE_ENTRYW(CRYPT_E_VERIFY_USAGE_OFFLINE)
		SCODE_ENTRYW(CRYPT_I_NEW_PROTECTION_REQUIRED)
		SCODE_ENTRYW(CS_E_ADMIN_LIMIT_EXCEEDED)
		SCODE_ENTRYW(CS_E_CLASS_NOTFOUND)
		SCODE_ENTRYW(CS_E_INTERNAL_ERROR)
		SCODE_ENTRYW(CS_E_INVALID_PATH)
		SCODE_ENTRYW(CS_E_INVALID_VERSION)
		SCODE_ENTRYW(CS_E_NETWORK_ERROR)
		SCODE_ENTRYW(CS_E_NOT_DELETABLE)
		SCODE_ENTRYW(CS_E_NO_CLASSSTORE)
		SCODE_ENTRYW(CS_E_OBJECT_ALREADY_EXISTS)
		SCODE_ENTRYW(CS_E_OBJECT_NOTFOUND)
		SCODE_ENTRYW(CS_E_PACKAGE_NOTFOUND)
		SCODE_ENTRYW(CS_E_SCHEMA_MISMATCH)
		SCODE_ENTRYW(DATA_S_SAMEFORMATETC)
		SCODE_ENTRYW(DIGSIG_E_CRYPTO)
		SCODE_ENTRYW(DIGSIG_E_DECODE)
		SCODE_ENTRYW(DIGSIG_E_ENCODE)
		SCODE_ENTRYW(DIGSIG_E_EXTENSIBILITY)
		SCODE_ENTRYW(DISP_E_ARRAYISLOCKED)
		SCODE_ENTRYW(DISP_E_BADCALLEE)
		SCODE_ENTRYW(DISP_E_BADINDEX)
		SCODE_ENTRYW(DISP_E_BADPARAMCOUNT)
		SCODE_ENTRYW(DISP_E_BADVARTYPE)
		SCODE_ENTRYW(DISP_E_BUFFERTOOSMALL)
		SCODE_ENTRYW(DISP_E_DIVBYZERO)
		SCODE_ENTRYW(DISP_E_EXCEPTION)
		SCODE_ENTRYW(DISP_E_MEMBERNOTFOUND)
		SCODE_ENTRYW(DISP_E_NONAMEDARGS)
		SCODE_ENTRYW(DISP_E_NOTACOLLECTION)
		SCODE_ENTRYW(DISP_E_OVERFLOW)
		SCODE_ENTRYW(DISP_E_PARAMNOTFOUND)
		SCODE_ENTRYW(DISP_E_PARAMNOTOPTIONAL)
		SCODE_ENTRYW(DISP_E_TYPEMISMATCH)
		SCODE_ENTRYW(DISP_E_UNKNOWNINTERFACE)
		SCODE_ENTRYW(DISP_E_UNKNOWNLCID)
		SCODE_ENTRYW(DISP_E_UNKNOWNNAME)
		SCODE_ENTRYW(DRAGDROP_E_ALREADYREGISTERED)
		SCODE_ENTRYW(DRAGDROP_E_INVALIDHWND)
		SCODE_ENTRYW(DRAGDROP_E_NOTREGISTERED)
		SCODE_ENTRYW(DRAGDROP_S_CANCEL)
		SCODE_ENTRYW(DRAGDROP_S_DROP)
		SCODE_ENTRYW(DRAGDROP_S_USEDEFAULTCURSORS)
		SCODE_ENTRYW(DV_E_CLIPFORMAT)
		SCODE_ENTRYW(DV_E_DVASPECT)
		SCODE_ENTRYW(DV_E_DVTARGETDEVICE)
		SCODE_ENTRYW(DV_E_DVTARGETDEVICE_SIZE)
		SCODE_ENTRYW(DV_E_FORMATETC)
		SCODE_ENTRYW(DV_E_LINDEX)
		SCODE_ENTRYW(DV_E_NOIVIEWOBJECT)
		SCODE_ENTRYW(DV_E_STATDATA)
		SCODE_ENTRYW(DV_E_STGMEDIUM)
		SCODE_ENTRYW(DV_E_TYMED)
		SCODE_ENTRYW(ERROR_ALL_SIDS_FILTERED)
		SCODE_ENTRYW(ERROR_AUDITING_DISABLED)
		SCODE_ENTRYW(EVENT_E_ALL_SUBSCRIBERS_FAILED)
		SCODE_ENTRYW(EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT)
		SCODE_ENTRYW(EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT)
		SCODE_ENTRYW(EVENT_E_COMPLUS_NOT_INSTALLED)
		SCODE_ENTRYW(EVENT_E_INTERNALERROR)
		SCODE_ENTRYW(EVENT_E_INTERNALEXCEPTION)
		SCODE_ENTRYW(EVENT_E_INVALID_EVENT_CLASS_PARTITION)
		SCODE_ENTRYW(EVENT_E_INVALID_PER_USER_SID)
		SCODE_ENTRYW(EVENT_E_MISSING_EVENTCLASS)
		SCODE_ENTRYW(EVENT_E_NOT_ALL_REMOVED)
		SCODE_ENTRYW(EVENT_E_PER_USER_SID_NOT_LOGGED_ON)
		SCODE_ENTRYW(EVENT_E_QUERYFIELD)
		SCODE_ENTRYW(EVENT_E_QUERYSYNTAX)
		SCODE_ENTRYW(EVENT_E_TOO_MANY_METHODS)
		SCODE_ENTRYW(EVENT_E_USER_EXCEPTION)
		SCODE_ENTRYW(EVENT_S_NOSUBSCRIBERS)
		SCODE_ENTRYW(EVENT_S_SOME_SUBSCRIBERS_FAILED)
		SCODE_ENTRYW(INPLACE_E_NOTOOLSPACE)
		SCODE_ENTRYW(INPLACE_E_NOTUNDOABLE)
		SCODE_ENTRYW(INPLACE_S_TRUNCATED)
		SCODE_ENTRYW(MEM_E_INVALID_LINK)
		SCODE_ENTRYW(MEM_E_INVALID_ROOT)
		SCODE_ENTRYW(MEM_E_INVALID_SIZE)
		SCODE_ENTRYW(MK_E_CANTOPENFILE)
		SCODE_ENTRYW(MK_E_CONNECTMANUALLY)
		SCODE_ENTRYW(MK_E_ENUMERATION_FAILED)
		SCODE_ENTRYW(MK_E_EXCEEDEDDEADLINE)
		SCODE_ENTRYW(MK_E_INTERMEDIATEINTERFACENOTSUPPORTED)
		SCODE_ENTRYW(MK_E_INVALIDEXTENSION)
		SCODE_ENTRYW(MK_E_MUSTBOTHERUSER)
		SCODE_ENTRYW(MK_E_NEEDGENERIC)
		SCODE_ENTRYW(MK_E_NOINVERSE)
		SCODE_ENTRYW(MK_E_NOOBJECT)
		SCODE_ENTRYW(MK_E_NOPREFIX)
		SCODE_ENTRYW(MK_E_NOSTORAGE)
		SCODE_ENTRYW(MK_E_NOTBINDABLE)
		SCODE_ENTRYW(MK_E_NOTBOUND)
		SCODE_ENTRYW(MK_E_NO_NORMALIZED)
		SCODE_ENTRYW(MK_E_SYNTAX)
		SCODE_ENTRYW(MK_E_UNAVAILABLE)
		SCODE_ENTRYW(MK_S_HIM)
		SCODE_ENTRYW(MK_S_ME)
		SCODE_ENTRYW(MK_S_MONIKERALREADYREGISTERED)
		SCODE_ENTRYW(MK_S_REDUCED_TO_SELF)
		SCODE_ENTRYW(MK_S_US)
		SCODE_ENTRYW(MSDTC_E_DUPLICATE_RESOURCE)
		SCODE_ENTRYW(MSSIPOTF_E_BADVERSION)
		SCODE_ENTRYW(MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT)
		SCODE_ENTRYW(MSSIPOTF_E_BAD_MAGICNUMBER)
		SCODE_ENTRYW(MSSIPOTF_E_BAD_OFFSET_TABLE)
		SCODE_ENTRYW(MSSIPOTF_E_CANTGETOBJECT)
		SCODE_ENTRYW(MSSIPOTF_E_CRYPT)
		SCODE_ENTRYW(MSSIPOTF_E_DSIG_STRUCTURE)
		SCODE_ENTRYW(MSSIPOTF_E_FAILED_HINTS_CHECK)
		SCODE_ENTRYW(MSSIPOTF_E_FAILED_POLICY)
		SCODE_ENTRYW(MSSIPOTF_E_FILE)
		SCODE_ENTRYW(MSSIPOTF_E_FILETOOSMALL)
		SCODE_ENTRYW(MSSIPOTF_E_FILE_CHECKSUM)
		SCODE_ENTRYW(MSSIPOTF_E_NOHEADTABLE)
		SCODE_ENTRYW(MSSIPOTF_E_NOT_OPENTYPE)
		SCODE_ENTRYW(MSSIPOTF_E_OUTOFMEMRANGE)
		SCODE_ENTRYW(MSSIPOTF_E_PCONST_CHECK)
		SCODE_ENTRYW(MSSIPOTF_E_STRUCTURE)
		SCODE_ENTRYW(MSSIPOTF_E_TABLES_OVERLAP)
		SCODE_ENTRYW(MSSIPOTF_E_TABLE_CHECKSUM)
		SCODE_ENTRYW(MSSIPOTF_E_TABLE_LONGWORD)
		SCODE_ENTRYW(MSSIPOTF_E_TABLE_PADBYTES)
		SCODE_ENTRYW(MSSIPOTF_E_TABLE_TAGORDER)
		SCODE_ENTRYW(NTE_BAD_ALGID)
		SCODE_ENTRYW(NTE_BAD_DATA)
		SCODE_ENTRYW(NTE_BAD_FLAGS)
		SCODE_ENTRYW(NTE_BAD_HASH)
		SCODE_ENTRYW(NTE_BAD_HASH_STATE)
		SCODE_ENTRYW(NTE_BAD_KEY)
		SCODE_ENTRYW(NTE_BAD_KEYSET)
		SCODE_ENTRYW(NTE_BAD_KEYSET_PARAM)
		SCODE_ENTRYW(NTE_BAD_KEY_STATE)
		SCODE_ENTRYW(NTE_BAD_LEN)
		SCODE_ENTRYW(NTE_BAD_PROVIDER)
		SCODE_ENTRYW(NTE_BAD_PROV_TYPE)
		SCODE_ENTRYW(NTE_BAD_PUBLIC_KEY)
		SCODE_ENTRYW(NTE_BAD_SIGNATURE)
		SCODE_ENTRYW(NTE_BAD_TYPE)
		SCODE_ENTRYW(NTE_BAD_UID)
		SCODE_ENTRYW(NTE_BAD_VER)
		SCODE_ENTRYW(NTE_DOUBLE_ENCRYPT)
		SCODE_ENTRYW(NTE_EXISTS)
		SCODE_ENTRYW(NTE_FAIL)
		SCODE_ENTRYW(NTE_FIXEDPARAMETER)
		SCODE_ENTRYW(NTE_KEYSET_ENTRY_BAD)
		SCODE_ENTRYW(NTE_KEYSET_NOT_DEF)
		SCODE_ENTRYW(NTE_NOT_FOUND)
		SCODE_ENTRYW(NTE_NO_KEY)
		SCODE_ENTRYW(NTE_NO_MEMORY)
		SCODE_ENTRYW(NTE_OP_OK) // alias of S_OK
		SCODE_ENTRYW(NTE_PERM)
		SCODE_ENTRYW(NTE_PROVIDER_DLL_FAIL)
		SCODE_ENTRYW(NTE_PROV_DLL_NOT_FOUND)
		SCODE_ENTRYW(NTE_PROV_TYPE_ENTRY_BAD)
		SCODE_ENTRYW(NTE_PROV_TYPE_NOT_DEF)
		SCODE_ENTRYW(NTE_PROV_TYPE_NO_MATCH)
		SCODE_ENTRYW(NTE_SIGNATURE_FILE_BAD)
		SCODE_ENTRYW(NTE_SILENT_CONTEXT)
		SCODE_ENTRYW(NTE_SYS_ERR)
		SCODE_ENTRYW(NTE_TEMPORARY_PROFILE)
		SCODE_ENTRYW(NTE_TOKEN_KEYSET_STORAGE_FULL)
		SCODE_ENTRYW(OLEOBJ_E_INVALIDVERB)
		SCODE_ENTRYW(OLEOBJ_E_NOVERBS)
		SCODE_ENTRYW(OLEOBJ_S_CANNOT_DOVERB_NOW)
		SCODE_ENTRYW(OLEOBJ_S_INVALIDHWND)
		SCODE_ENTRYW(OLEOBJ_S_INVALIDVERB)
		SCODE_ENTRYW(OSS_ACCESS_SERIALIZATION_ERROR)
		SCODE_ENTRYW(OSS_API_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_BAD_ARG)
		SCODE_ENTRYW(OSS_BAD_ENCRULES)
		SCODE_ENTRYW(OSS_BAD_PTR)
		SCODE_ENTRYW(OSS_BAD_TABLE)
		SCODE_ENTRYW(OSS_BAD_TIME)
		SCODE_ENTRYW(OSS_BAD_VERSION)
		SCODE_ENTRYW(OSS_BERDER_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_CANT_CLOSE_TRACE_FILE)
		SCODE_ENTRYW(OSS_CANT_OPEN_TRACE_FILE)
		SCODE_ENTRYW(OSS_CANT_OPEN_TRACE_WINDOW)
		SCODE_ENTRYW(OSS_COMPARATOR_CODE_NOT_LINKED)
		SCODE_ENTRYW(OSS_COMPARATOR_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_CONSTRAINT_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_CONSTRAINT_VIOLATED)
		SCODE_ENTRYW(OSS_COPIER_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_DATA_ERROR)
		SCODE_ENTRYW(OSS_FATAL_ERROR)
		SCODE_ENTRYW(OSS_INDEFINITE_NOT_SUPPORTED)
		SCODE_ENTRYW(OSS_LIMITED)
		SCODE_ENTRYW(OSS_MEM_ERROR)
		SCODE_ENTRYW(OSS_MEM_MGR_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_MORE_BUF)
		SCODE_ENTRYW(OSS_MORE_INPUT)
		SCODE_ENTRYW(OSS_MUTEX_NOT_CREATED)
		SCODE_ENTRYW(OSS_NEGATIVE_UINTEGER)
		SCODE_ENTRYW(OSS_NULL_FCN)
		SCODE_ENTRYW(OSS_NULL_TBL)
		SCODE_ENTRYW(OSS_OID_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_OPEN_TYPE_ERROR)
		SCODE_ENTRYW(OSS_OUT_MEMORY)
		SCODE_ENTRYW(OSS_OUT_OF_RANGE)
		SCODE_ENTRYW(OSS_PDU_MISMATCH)
		SCODE_ENTRYW(OSS_PDU_RANGE)
		SCODE_ENTRYW(OSS_PDV_CODE_NOT_LINKED)
		SCODE_ENTRYW(OSS_PDV_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_PER_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_REAL_CODE_NOT_LINKED)
		SCODE_ENTRYW(OSS_REAL_DLL_NOT_LINKED)
		SCODE_ENTRYW(OSS_TABLE_MISMATCH)
		SCODE_ENTRYW(OSS_TOO_LONG)
		SCODE_ENTRYW(OSS_TRACE_FILE_ALREADY_OPEN)
		SCODE_ENTRYW(OSS_TYPE_NOT_SUPPORTED)
		SCODE_ENTRYW(OSS_UNAVAIL_ENCRULES)
		SCODE_ENTRYW(OSS_UNIMPLEMENTED)
		SCODE_ENTRYW(PERSIST_E_NOTSELFSIZING)
		SCODE_ENTRYW(PERSIST_E_SIZEDEFINITE)
		SCODE_ENTRYW(PERSIST_E_SIZEINDEFINITE)
		SCODE_ENTRYW(REGDB_E_BADTHREADINGMODEL)
		SCODE_ENTRYW(REGDB_E_CLASSNOTREG)
		SCODE_ENTRYW(REGDB_E_IIDNOTREG)
		SCODE_ENTRYW(REGDB_E_INVALIDVALUE)
		SCODE_ENTRYW(REGDB_E_KEYMISSING)
		SCODE_ENTRYW(REGDB_E_READREGDB)
		SCODE_ENTRYW(REGDB_E_WRITEREGDB)
		SCODE_ENTRYW(RPC_E_ACCESS_DENIED)
		SCODE_ENTRYW(RPC_E_ATTEMPTED_MULTITHREAD)
		SCODE_ENTRYW(RPC_E_CALL_CANCELED)
		SCODE_ENTRYW(RPC_E_CALL_COMPLETE)
		SCODE_ENTRYW(RPC_E_CALL_REJECTED)
		SCODE_ENTRYW(RPC_E_CANTCALLOUT_AGAIN)
		SCODE_ENTRYW(RPC_E_CANTCALLOUT_INASYNCCALL)
		SCODE_ENTRYW(RPC_E_CANTCALLOUT_INEXTERNALCALL)
		SCODE_ENTRYW(RPC_E_CANTCALLOUT_ININPUTSYNCCALL)
		SCODE_ENTRYW(RPC_E_CANTPOST_INSENDCALL)
		SCODE_ENTRYW(RPC_E_CANTTRANSMIT_CALL)
		SCODE_ENTRYW(RPC_E_CHANGED_MODE)
		SCODE_ENTRYW(RPC_E_CLIENT_CANTMARSHAL_DATA)
		SCODE_ENTRYW(RPC_E_CLIENT_CANTUNMARSHAL_DATA)
		SCODE_ENTRYW(RPC_E_CLIENT_DIED)
		SCODE_ENTRYW(RPC_E_CONNECTION_TERMINATED)
		SCODE_ENTRYW(RPC_E_DISCONNECTED)
		SCODE_ENTRYW(RPC_E_FAULT)
		SCODE_ENTRYW(RPC_E_FULLSIC_REQUIRED)
		SCODE_ENTRYW(RPC_E_INVALIDMETHOD)
		SCODE_ENTRYW(RPC_E_INVALID_CALLDATA)
		SCODE_ENTRYW(RPC_E_INVALID_DATA)
		SCODE_ENTRYW(RPC_E_INVALID_DATAPACKET)
		SCODE_ENTRYW(RPC_E_INVALID_EXTENSION)
		SCODE_ENTRYW(RPC_E_INVALID_HEADER)
		SCODE_ENTRYW(RPC_E_INVALID_IPID)
		SCODE_ENTRYW(RPC_E_INVALID_OBJECT)
		SCODE_ENTRYW(RPC_E_INVALID_OBJREF)
		SCODE_ENTRYW(RPC_E_INVALID_PARAMETER)
		SCODE_ENTRYW(RPC_E_INVALID_STD_NAME)
		SCODE_ENTRYW(RPC_E_NOT_REGISTERED)
		SCODE_ENTRYW(RPC_E_NO_CONTEXT)
		SCODE_ENTRYW(RPC_E_NO_GOOD_SECURITY_PACKAGES)
		SCODE_ENTRYW(RPC_E_NO_SYNC)
		SCODE_ENTRYW(RPC_E_OUT_OF_RESOURCES)
		SCODE_ENTRYW(RPC_E_REMOTE_DISABLED)
		SCODE_ENTRYW(RPC_E_RETRY)
		SCODE_ENTRYW(RPC_E_SERVERCALL_REJECTED)
		SCODE_ENTRYW(RPC_E_SERVERCALL_RETRYLATER)
		SCODE_ENTRYW(RPC_E_SERVERFAULT)
		SCODE_ENTRYW(RPC_E_SERVER_CANTMARSHAL_DATA)
		SCODE_ENTRYW(RPC_E_SERVER_CANTUNMARSHAL_DATA)
		SCODE_ENTRYW(RPC_E_SERVER_DIED)
		SCODE_ENTRYW(RPC_E_SERVER_DIED_DNE)
		SCODE_ENTRYW(RPC_E_SYS_CALL_FAILED)
		SCODE_ENTRYW(RPC_E_THREAD_NOT_INIT)
		SCODE_ENTRYW(RPC_E_TIMEOUT)
		SCODE_ENTRYW(RPC_E_TOO_LATE)
		SCODE_ENTRYW(RPC_E_UNEXPECTED)
		SCODE_ENTRYW(RPC_E_UNSECURE_CALL)
		SCODE_ENTRYW(RPC_E_VERSION_MISMATCH)
		SCODE_ENTRYW(RPC_E_WRONG_THREAD)
		SCODE_ENTRYW(RPC_S_CALLPENDING)
		SCODE_ENTRYW(RPC_S_WAITONTIMER)
		SCODE_ENTRYW(SCARD_E_BAD_SEEK)
		SCODE_ENTRYW(SCARD_E_CANCELLED)
		SCODE_ENTRYW(SCARD_E_CANT_DISPOSE)
		SCODE_ENTRYW(SCARD_E_CARD_UNSUPPORTED)
		SCODE_ENTRYW(SCARD_E_CERTIFICATE_UNAVAILABLE)
		SCODE_ENTRYW(SCARD_E_COMM_DATA_LOST)
		SCODE_ENTRYW(SCARD_E_DIR_NOT_FOUND)
		SCODE_ENTRYW(SCARD_E_DUPLICATE_READER)
		SCODE_ENTRYW(SCARD_E_FILE_NOT_FOUND)
		SCODE_ENTRYW(SCARD_E_ICC_CREATEORDER)
		SCODE_ENTRYW(SCARD_E_ICC_INSTALLATION)
		SCODE_ENTRYW(SCARD_E_INSUFFICIENT_BUFFER)
		SCODE_ENTRYW(SCARD_E_INVALID_ATR)
		SCODE_ENTRYW(SCARD_E_INVALID_CHV)
		SCODE_ENTRYW(SCARD_E_INVALID_HANDLE)
		SCODE_ENTRYW(SCARD_E_INVALID_PARAMETER)
		SCODE_ENTRYW(SCARD_E_INVALID_TARGET)
		SCODE_ENTRYW(SCARD_E_INVALID_VALUE)
		SCODE_ENTRYW(SCARD_E_NOT_READY)
		SCODE_ENTRYW(SCARD_E_NOT_TRANSACTED)
		SCODE_ENTRYW(SCARD_E_NO_ACCESS)
		SCODE_ENTRYW(SCARD_E_NO_DIR)
		SCODE_ENTRYW(SCARD_E_NO_FILE)
		SCODE_ENTRYW(SCARD_E_NO_KEY_CONTAINER)
		SCODE_ENTRYW(SCARD_E_NO_MEMORY)
		SCODE_ENTRYW(SCARD_E_NO_READERS_AVAILABLE)
		SCODE_ENTRYW(SCARD_E_NO_SERVICE)
		SCODE_ENTRYW(SCARD_E_NO_SMARTCARD)
		SCODE_ENTRYW(SCARD_E_NO_SUCH_CERTIFICATE)
		SCODE_ENTRYW(SCARD_E_PCI_TOO_SMALL)
		SCODE_ENTRYW(SCARD_E_PROTO_MISMATCH)
		SCODE_ENTRYW(SCARD_E_READER_UNAVAILABLE)
		SCODE_ENTRYW(SCARD_E_READER_UNSUPPORTED)
		SCODE_ENTRYW(SCARD_E_SERVICE_STOPPED)
		SCODE_ENTRYW(SCARD_E_SHARING_VIOLATION)
		SCODE_ENTRYW(SCARD_E_SYSTEM_CANCELLED)
		SCODE_ENTRYW(SCARD_E_TIMEOUT)
		SCODE_ENTRYW(SCARD_E_UNEXPECTED)
		SCODE_ENTRYW(SCARD_E_UNKNOWN_CARD)
		SCODE_ENTRYW(SCARD_E_UNKNOWN_READER)
		SCODE_ENTRYW(SCARD_E_UNKNOWN_RES_MNG)
		SCODE_ENTRYW(SCARD_E_UNSUPPORTED_FEATURE)
		SCODE_ENTRYW(SCARD_E_WRITE_TOO_MANY)
		SCODE_ENTRYW(SCARD_F_COMM_ERROR)
		SCODE_ENTRYW(SCARD_F_INTERNAL_ERROR)
		SCODE_ENTRYW(SCARD_F_UNKNOWN_ERROR)
		SCODE_ENTRYW(SCARD_F_WAITED_TOO_LONG)
		SCODE_ENTRYW(SCARD_P_SHUTDOWN)
		SCODE_ENTRYW(SCARD_W_CANCELLED_BY_USER)
		SCODE_ENTRYW(SCARD_W_CARD_NOT_AUTHENTICATED)
		SCODE_ENTRYW(SCARD_W_CHV_BLOCKED)
		SCODE_ENTRYW(SCARD_W_EOF)
		SCODE_ENTRYW(SCARD_W_REMOVED_CARD)
		SCODE_ENTRYW(SCARD_W_RESET_CARD)
		SCODE_ENTRYW(SCARD_W_SECURITY_VIOLATION)
		SCODE_ENTRYW(SCARD_W_UNPOWERED_CARD)
		SCODE_ENTRYW(SCARD_W_UNRESPONSIVE_CARD)
		SCODE_ENTRYW(SCARD_W_UNSUPPORTED_CARD)
		SCODE_ENTRYW(SCARD_W_WRONG_CHV)
		SCODE_ENTRYW(SCHED_E_ACCOUNT_DBASE_CORRUPT)
		SCODE_ENTRYW(SCHED_E_ACCOUNT_INFORMATION_NOT_SET)
		SCODE_ENTRYW(SCHED_E_ACCOUNT_NAME_NOT_FOUND)
		SCODE_ENTRYW(SCHED_E_CANNOT_OPEN_TASK)
		SCODE_ENTRYW(SCHED_E_INVALID_TASK)
		SCODE_ENTRYW(SCHED_E_NO_SECURITY_SERVICES)
		SCODE_ENTRYW(SCHED_E_SERVICE_NOT_INSTALLED)
		SCODE_ENTRYW(SCHED_E_SERVICE_NOT_RUNNING)
		SCODE_ENTRYW(SCHED_E_TASK_NOT_READY)
		SCODE_ENTRYW(SCHED_E_TASK_NOT_RUNNING)
		SCODE_ENTRYW(SCHED_E_TRIGGER_NOT_FOUND)
		SCODE_ENTRYW(SCHED_E_UNKNOWN_OBJECT_VERSION)
		SCODE_ENTRYW(SCHED_E_UNSUPPORTED_ACCOUNT_OPTION)
		SCODE_ENTRYW(SCHED_S_EVENT_TRIGGER)
		SCODE_ENTRYW(SCARD_S_SUCCESS) // alias of S_OK
		SCODE_ENTRYW(SCHED_S_TASK_DISABLED)
		SCODE_ENTRYW(SCHED_S_TASK_HAS_NOT_RUN)
		SCODE_ENTRYW(SCHED_S_TASK_NOT_SCHEDULED)
		SCODE_ENTRYW(SCHED_S_TASK_NO_MORE_RUNS)
		SCODE_ENTRYW(SCHED_S_TASK_NO_VALID_TRIGGERS)
		SCODE_ENTRYW(SCHED_S_TASK_READY)
		SCODE_ENTRYW(SCHED_S_TASK_RUNNING)
		SCODE_ENTRYW(SCHED_S_TASK_TERMINATED)
		SCODE_ENTRYW(SEC_E_ALGORITHM_MISMATCH)
		SCODE_ENTRYW(SEC_E_BAD_BINDINGS)
		SCODE_ENTRYW(SEC_E_BAD_PKGID)
		SCODE_ENTRYW(SEC_E_BUFFER_TOO_SMALL)
		SCODE_ENTRYW(SEC_E_CANNOT_INSTALL)
		SCODE_ENTRYW(SEC_E_CANNOT_PACK)
		SCODE_ENTRYW(SEC_E_CERT_EXPIRED)
		SCODE_ENTRYW(SEC_E_CERT_UNKNOWN)
		SCODE_ENTRYW(SEC_E_CONTEXT_EXPIRED)
		SCODE_ENTRYW(SEC_E_CRYPTO_SYSTEM_INVALID)
		SCODE_ENTRYW(SEC_E_DECRYPT_FAILURE)
		SCODE_ENTRYW(SEC_E_DELEGATION_REQUIRED)
		SCODE_ENTRYW(SEC_E_ENCRYPT_FAILURE)
		SCODE_ENTRYW(SEC_E_ILLEGAL_MESSAGE)
		SCODE_ENTRYW(SEC_E_INCOMPLETE_CREDENTIALS)
		SCODE_ENTRYW(SEC_E_INCOMPLETE_MESSAGE)
		SCODE_ENTRYW(SEC_E_INSUFFICIENT_MEMORY)
		SCODE_ENTRYW(SEC_E_INTERNAL_ERROR)
		SCODE_ENTRYW(SEC_E_INVALID_HANDLE)
		SCODE_ENTRYW(SEC_E_INVALID_TOKEN)
		SCODE_ENTRYW(SEC_E_KDC_INVALID_REQUEST)
		SCODE_ENTRYW(SEC_E_KDC_UNABLE_TO_REFER)
		SCODE_ENTRYW(SEC_E_KDC_UNKNOWN_ETYPE)
		SCODE_ENTRYW(SEC_E_LOGON_DENIED)
		SCODE_ENTRYW(SEC_E_MAX_REFERRALS_EXCEEDED)
		SCODE_ENTRYW(SEC_E_MESSAGE_ALTERED)
		SCODE_ENTRYW(SEC_E_MULTIPLE_ACCOUNTS)
		SCODE_ENTRYW(SEC_E_MUST_BE_KDC)
		SCODE_ENTRYW(SEC_E_NOT_OWNER)
		SCODE_ENTRYW(SEC_E_NO_AUTHENTICATING_AUTHORITY)
		SCODE_ENTRYW(SEC_E_NO_CREDENTIALS)
		SCODE_ENTRYW(SEC_E_NO_IMPERSONATION)
		SCODE_ENTRYW(SEC_E_NO_IP_ADDRESSES)
		SCODE_ENTRYW(SEC_E_NO_KERB_KEY)
		SCODE_ENTRYW(SEC_E_NO_PA_DATA)
		SCODE_ENTRYW(SEC_E_NO_SPM) // alias of SEC_E_INTERNAL_ERROR
		SCODE_ENTRYW(SEC_E_NO_TGT_REPLY)
		SCODE_ENTRYW(SEC_E_NOT_SUPPORTED) // alias of SEC_E_UNSUPPORTED_FUNCTION
		SCODE_ENTRYW(SEC_E_OUT_OF_SEQUENCE)
		SCODE_ENTRYW(SEC_E_PKINIT_NAME_MISMATCH)
		SCODE_ENTRYW(SEC_E_QOP_NOT_SUPPORTED)
		SCODE_ENTRYW(SEC_E_SECPKG_NOT_FOUND)
		SCODE_ENTRYW(SEC_E_SECURITY_QOS_FAILED)
		SCODE_ENTRYW(SEC_E_SHUTDOWN_IN_PROGRESS)
		SCODE_ENTRYW(SEC_E_SMARTCARD_LOGON_REQUIRED)
		SCODE_ENTRYW(SEC_E_STRONG_CRYPTO_NOT_SUPPORTED)
		SCODE_ENTRYW(SEC_E_TARGET_UNKNOWN)
		SCODE_ENTRYW(SEC_E_TIME_SKEW)
		SCODE_ENTRYW(SEC_E_TOO_MANY_PRINCIPALS)
		SCODE_ENTRYW(SEC_E_UNFINISHED_CONTEXT_DELETED)
		SCODE_ENTRYW(SEC_E_UNKNOWN_CREDENTIALS)
		SCODE_ENTRYW(SEC_E_UNSUPPORTED_FUNCTION) // alias of SEC_E_NOT_SUPPORTED
		SCODE_ENTRYW(SEC_E_UNSUPPORTED_PREAUTH)
		SCODE_ENTRYW(SEC_E_UNTRUSTED_ROOT)
		SCODE_ENTRYW(SEC_E_WRONG_CREDENTIAL_HANDLE)
		SCODE_ENTRYW(SEC_E_WRONG_PRINCIPAL)
		SCODE_ENTRYW(SEC_I_COMPLETE_AND_CONTINUE)
		SCODE_ENTRYW(SEC_I_COMPLETE_NEEDED)
		SCODE_ENTRYW(SEC_I_CONTEXT_EXPIRED)
		SCODE_ENTRYW(SEC_I_CONTINUE_NEEDED)
		SCODE_ENTRYW(SEC_I_INCOMPLETE_CREDENTIALS)
		SCODE_ENTRYW(SEC_I_LOCAL_LOGON)
		SCODE_ENTRYW(SEC_I_NO_LSA_CONTEXT)
		SCODE_ENTRYW(SEC_I_RENEGOTIATE)
		SCODE_ENTRYW(SPAPI_E_BAD_INTERFACE_INSTALLSECT)
		SCODE_ENTRYW(SPAPI_E_BAD_SECTION_NAME_LINE)
		SCODE_ENTRYW(SPAPI_E_BAD_SERVICE_INSTALLSECT)
		SCODE_ENTRYW(SPAPI_E_CANT_LOAD_CLASS_ICON)
		SCODE_ENTRYW(SPAPI_E_CANT_REMOVE_DEVINST)
		SCODE_ENTRYW(SPAPI_E_CLASS_MISMATCH)
		SCODE_ENTRYW(SPAPI_E_DEVICE_INTERFACE_ACTIVE)
		SCODE_ENTRYW(SPAPI_E_DEVICE_INTERFACE_REMOVED)
		SCODE_ENTRYW(SPAPI_E_DEVINFO_DATA_LOCKED)
		SCODE_ENTRYW(SPAPI_E_DEVINFO_LIST_LOCKED)
		SCODE_ENTRYW(SPAPI_E_DEVINFO_NOT_REGISTERED)
		SCODE_ENTRYW(SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE)
		SCODE_ENTRYW(SPAPI_E_DEVINST_ALREADY_EXISTS)
		SCODE_ENTRYW(SPAPI_E_DI_BAD_PATH)
		SCODE_ENTRYW(SPAPI_E_DI_DONT_INSTALL)
		SCODE_ENTRYW(SPAPI_E_DI_DO_DEFAULT)
		SCODE_ENTRYW(SPAPI_E_DI_NOFILECOPY)
		SCODE_ENTRYW(SPAPI_E_DI_POSTPROCESSING_REQUIRED)
		SCODE_ENTRYW(SPAPI_E_DRIVER_NONNATIVE)
		SCODE_ENTRYW(SPAPI_E_DUPLICATE_FOUND)
		SCODE_ENTRYW(SPAPI_E_ERROR_NOT_INSTALLED)
		SCODE_ENTRYW(SPAPI_E_EXPECTED_SECTION_NAME)
		SCODE_ENTRYW(SPAPI_E_FILEQUEUE_LOCKED)
		SCODE_ENTRYW(SPAPI_E_GENERAL_SYNTAX)
		SCODE_ENTRYW(SPAPI_E_INCORRECTLY_COPIED_INF)
		SCODE_ENTRYW(SPAPI_E_INVALID_CLASS)
		SCODE_ENTRYW(SPAPI_E_INVALID_CLASS_INSTALLER)
		SCODE_ENTRYW(SPAPI_E_INVALID_COINSTALLER)
		SCODE_ENTRYW(SPAPI_E_INVALID_DEVINST_NAME)
		SCODE_ENTRYW(SPAPI_E_INVALID_FILTER_DRIVER)
		SCODE_ENTRYW(SPAPI_E_INVALID_HWPROFILE)
		SCODE_ENTRYW(SPAPI_E_INVALID_INF_LOGCONFIG)
		SCODE_ENTRYW(SPAPI_E_INVALID_MACHINENAME)
		SCODE_ENTRYW(SPAPI_E_INVALID_PROPPAGE_PROVIDER)
		SCODE_ENTRYW(SPAPI_E_INVALID_REFERENCE_STRING)
		SCODE_ENTRYW(SPAPI_E_INVALID_REG_PROPERTY)
		SCODE_ENTRYW(SPAPI_E_INVALID_TARGET)
		SCODE_ENTRYW(SPAPI_E_IN_WOW64)
		SCODE_ENTRYW(SPAPI_E_KEY_DOES_NOT_EXIST)
		SCODE_ENTRYW(SPAPI_E_LINE_NOT_FOUND)
		SCODE_ENTRYW(SPAPI_E_MACHINE_UNAVAILABLE)
		SCODE_ENTRYW(SPAPI_E_NON_WINDOWS_DRIVER)
		SCODE_ENTRYW(SPAPI_E_NON_WINDOWS_NT_DRIVER)
		SCODE_ENTRYW(SPAPI_E_NOT_DISABLEABLE)
		SCODE_ENTRYW(SPAPI_E_NO_ASSOCIATED_CLASS)
		SCODE_ENTRYW(SPAPI_E_NO_ASSOCIATED_SERVICE)
		SCODE_ENTRYW(SPAPI_E_NO_BACKUP)
		SCODE_ENTRYW(SPAPI_E_NO_CATALOG_FOR_OEM_INF)
		SCODE_ENTRYW(SPAPI_E_NO_CLASSINSTALL_PARAMS)
		SCODE_ENTRYW(SPAPI_E_NO_CLASS_DRIVER_LIST)
		SCODE_ENTRYW(SPAPI_E_NO_COMPAT_DRIVERS)
		SCODE_ENTRYW(SPAPI_E_NO_CONFIGMGR_SERVICES)
		SCODE_ENTRYW(SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE)
		SCODE_ENTRYW(SPAPI_E_NO_DEVICE_ICON)
		SCODE_ENTRYW(SPAPI_E_NO_DEVICE_SELECTED)
		SCODE_ENTRYW(SPAPI_E_NO_DRIVER_SELECTED)
		SCODE_ENTRYW(SPAPI_E_NO_INF)
		SCODE_ENTRYW(SPAPI_E_NO_SUCH_DEVICE_INTERFACE)
		SCODE_ENTRYW(SPAPI_E_NO_SUCH_DEVINST)
		SCODE_ENTRYW(SPAPI_E_NO_SUCH_INTERFACE_CLASS)
		SCODE_ENTRYW(SPAPI_E_REMOTE_COMM_FAILURE)
		SCODE_ENTRYW(SPAPI_E_SCE_DISABLED)
		SCODE_ENTRYW(SPAPI_E_SECTION_NAME_TOO_LONG)
		SCODE_ENTRYW(SPAPI_E_SECTION_NOT_FOUND)
		SCODE_ENTRYW(SPAPI_E_SET_SYSTEM_RESTORE_POINT)
		SCODE_ENTRYW(SPAPI_E_WRONG_INF_STYLE)
		SCODE_ENTRYW(STG_E_ABNORMALAPIEXIT)
		SCODE_ENTRYW(STG_E_ACCESSDENIED)
		SCODE_ENTRYW(STG_E_BADBASEADDRESS)
		SCODE_ENTRYW(STG_E_CANTSAVE)
		SCODE_ENTRYW(STG_E_CSS_AUTHENTICATION_FAILURE)
		SCODE_ENTRYW(STG_E_CSS_KEY_NOT_ESTABLISHED)
		SCODE_ENTRYW(STG_E_CSS_KEY_NOT_PRESENT)
		SCODE_ENTRYW(STG_E_CSS_REGION_MISMATCH)
		SCODE_ENTRYW(STG_E_CSS_SCRAMBLED_SECTOR)
		SCODE_ENTRYW(STG_E_DISKISWRITEPROTECTED)
		SCODE_ENTRYW(STG_E_DOCFILECORRUPT)
		SCODE_ENTRYW(STG_E_DOCFILETOOLARGE)
		SCODE_ENTRYW(STG_E_EXTANTMARSHALLINGS)
		SCODE_ENTRYW(STG_E_FILEALREADYEXISTS)
		SCODE_ENTRYW(STG_E_FILENOTFOUND)
		SCODE_ENTRYW(STG_E_INCOMPLETE)
		SCODE_ENTRYW(STG_E_INSUFFICIENTMEMORY)
		SCODE_ENTRYW(STG_E_INUSE)
		SCODE_ENTRYW(STG_E_INVALIDFLAG)
		SCODE_ENTRYW(STG_E_INVALIDFUNCTION)
		SCODE_ENTRYW(STG_E_INVALIDHANDLE)
		SCODE_ENTRYW(STG_E_INVALIDHEADER)
		SCODE_ENTRYW(STG_E_INVALIDNAME)
		SCODE_ENTRYW(STG_E_INVALIDPARAMETER)
		SCODE_ENTRYW(STG_E_INVALIDPOINTER)
		SCODE_ENTRYW(STG_E_LOCKVIOLATION)
		SCODE_ENTRYW(STG_E_MEDIUMFULL)
		SCODE_ENTRYW(STG_E_NOMOREFILES)
		SCODE_ENTRYW(STG_E_NOTCURRENT)
		SCODE_ENTRYW(STG_E_NOTFILEBASEDSTORAGE)
		SCODE_ENTRYW(STG_E_NOTSIMPLEFORMAT)
		SCODE_ENTRYW(STG_E_OLDDLL)
		SCODE_ENTRYW(STG_E_OLDFORMAT)
		SCODE_ENTRYW(STG_E_PATHNOTFOUND)
		SCODE_ENTRYW(STG_E_PROPSETMISMATCHED)
		SCODE_ENTRYW(STG_E_READFAULT)
		SCODE_ENTRYW(STG_E_RESETS_EXHAUSTED)
		SCODE_ENTRYW(STG_E_REVERTED)
		SCODE_ENTRYW(STG_E_SEEKERROR)
		SCODE_ENTRYW(STG_E_SHAREREQUIRED)
		SCODE_ENTRYW(STG_E_SHAREVIOLATION)
		SCODE_ENTRYW(STG_E_STATUS_COPY_PROTECTION_FAILURE)
		SCODE_ENTRYW(STG_E_TERMINATED)
		SCODE_ENTRYW(STG_E_TOOMANYOPENFILES)
		SCODE_ENTRYW(STG_E_UNIMPLEMENTEDFUNCTION)
		SCODE_ENTRYW(STG_E_UNKNOWN)
		SCODE_ENTRYW(STG_E_WRITEFAULT)
		SCODE_ENTRYW(STG_S_BLOCK)
		SCODE_ENTRYW(STG_S_CANNOTCONSOLIDATE)
		SCODE_ENTRYW(STG_S_CONSOLIDATIONFAILED)
		SCODE_ENTRYW(STG_S_CONVERTED)
		SCODE_ENTRYW(STG_S_MONITORING)
		SCODE_ENTRYW(STG_S_MULTIPLEOPENS)
		SCODE_ENTRYW(STG_S_RETRYNOW)
		SCODE_ENTRYW(TRUST_E_ACTION_UNKNOWN)
		SCODE_ENTRYW(TRUST_E_BAD_DIGEST)
		SCODE_ENTRYW(TRUST_E_BASIC_CONSTRAINTS)
		SCODE_ENTRYW(TRUST_E_CERT_SIGNATURE)
		SCODE_ENTRYW(TRUST_E_COUNTER_SIGNER)
		SCODE_ENTRYW(TRUST_E_EXPLICIT_DISTRUST)
		SCODE_ENTRYW(TRUST_E_FAIL)
		SCODE_ENTRYW(TRUST_E_FINANCIAL_CRITERIA)
		SCODE_ENTRYW(TRUST_E_NOSIGNATURE)
		SCODE_ENTRYW(TRUST_E_NO_SIGNER_CERT)
		SCODE_ENTRYW(TRUST_E_PROVIDER_UNKNOWN)
		SCODE_ENTRYW(TRUST_E_SUBJECT_FORM_UNKNOWN)
		SCODE_ENTRYW(TRUST_E_SUBJECT_NOT_TRUSTED)
		SCODE_ENTRYW(TRUST_E_SYSTEM_ERROR)
		SCODE_ENTRYW(TRUST_E_TIME_STAMP)
		SCODE_ENTRYW(TYPE_E_AMBIGUOUSNAME)
		SCODE_ENTRYW(TYPE_E_BADMODULEKIND)
		SCODE_ENTRYW(TYPE_E_BUFFERTOOSMALL)
		SCODE_ENTRYW(TYPE_E_CANTCREATETMPFILE)
		SCODE_ENTRYW(TYPE_E_CANTLOADLIBRARY)
		SCODE_ENTRYW(TYPE_E_CIRCULARTYPE)
		SCODE_ENTRYW(TYPE_E_DLLFUNCTIONNOTFOUND)
		SCODE_ENTRYW(TYPE_E_DUPLICATEID)
		SCODE_ENTRYW(TYPE_E_ELEMENTNOTFOUND)
		SCODE_ENTRYW(TYPE_E_FIELDNOTFOUND)
		SCODE_ENTRYW(TYPE_E_INCONSISTENTPROPFUNCS)
		SCODE_ENTRYW(TYPE_E_INVALIDID)
		SCODE_ENTRYW(TYPE_E_INVALIDSTATE)
		SCODE_ENTRYW(TYPE_E_INVDATAREAD)
		SCODE_ENTRYW(TYPE_E_IOERROR)
		SCODE_ENTRYW(TYPE_E_LIBNOTREGISTERED)
		SCODE_ENTRYW(TYPE_E_NAMECONFLICT)
		SCODE_ENTRYW(TYPE_E_OUTOFBOUNDS)
		SCODE_ENTRYW(TYPE_E_QUALIFIEDNAMEDISALLOWED)
		SCODE_ENTRYW(TYPE_E_REGISTRYACCESS)
		SCODE_ENTRYW(TYPE_E_SIZETOOBIG)
		SCODE_ENTRYW(TYPE_E_TYPEMISMATCH)
		SCODE_ENTRYW(TYPE_E_UNDEFINEDTYPE)
		SCODE_ENTRYW(TYPE_E_UNKNOWNLCID)
		SCODE_ENTRYW(TYPE_E_UNSUPFORMAT)
		SCODE_ENTRYW(TYPE_E_WRONGTYPEKIND)
		SCODE_ENTRYW(VIEW_E_DRAW)
		SCODE_ENTRYW(VIEW_S_ALREADY_FROZEN)
		SCODE_ENTRYW(XACT_E_ABORTED)
		SCODE_ENTRYW(XACT_E_ABORTING)
		SCODE_ENTRYW(XACT_E_ALREADYINPROGRESS)
		SCODE_ENTRYW(XACT_E_ALREADYOTHERSINGLEPHASE)
		SCODE_ENTRYW(XACT_E_CANTRETAIN)
		SCODE_ENTRYW(XACT_E_CLERKEXISTS)
		SCODE_ENTRYW(XACT_E_CLERKNOTFOUND)
		SCODE_ENTRYW(XACT_E_COMMITFAILED)
		SCODE_ENTRYW(XACT_E_COMMITPREVENTED)
		SCODE_ENTRYW(XACT_E_CONNECTION_DENIED)
		SCODE_ENTRYW(XACT_E_CONNECTION_DOWN)
		SCODE_ENTRYW(XACT_E_DEST_TMNOTAVAILABLE)
		SCODE_ENTRYW(XACT_E_HEURISTICABORT)
		SCODE_ENTRYW(XACT_E_HEURISTICCOMMIT)
		SCODE_ENTRYW(XACT_E_HEURISTICDAMAGE)
		SCODE_ENTRYW(XACT_E_HEURISTICDANGER)
		SCODE_ENTRYW(XACT_E_INDOUBT)
		SCODE_ENTRYW(XACT_E_INVALIDCOOKIE)
		SCODE_ENTRYW(XACT_E_INVALIDLSN)
		SCODE_ENTRYW(XACT_E_ISOLATIONLEVEL)
		SCODE_ENTRYW(XACT_E_LOGFULL)
		SCODE_ENTRYW(XACT_E_NETWORK_TX_DISABLED)
		SCODE_ENTRYW(XACT_E_NOASYNC)
		SCODE_ENTRYW(XACT_E_NOENLIST)
		SCODE_ENTRYW(XACT_E_NOIMPORTOBJECT)
		SCODE_ENTRYW(XACT_E_NOISORETAIN)
		SCODE_ENTRYW(XACT_E_NORESOURCE)
		SCODE_ENTRYW(XACT_E_NOTCURRENT)
		SCODE_ENTRYW(XACT_E_NOTIMEOUT)
		SCODE_ENTRYW(XACT_E_NOTRANSACTION)
		SCODE_ENTRYW(XACT_E_NOTSUPPORTED)
		SCODE_ENTRYW(XACT_E_PARTNER_NETWORK_TX_DISABLED)
		SCODE_ENTRYW(XACT_E_RECOVERYINPROGRESS)
		SCODE_ENTRYW(XACT_E_REENLISTTIMEOUT)
		SCODE_ENTRYW(XACT_E_REPLAYREQUEST)
		SCODE_ENTRYW(XACT_E_TIP_CONNECT_FAILED)
		SCODE_ENTRYW(XACT_E_TIP_DISABLED)
		SCODE_ENTRYW(XACT_E_TIP_PROTOCOL_ERROR)
		SCODE_ENTRYW(XACT_E_TIP_PULL_FAILED)
		SCODE_ENTRYW(XACT_E_TMNOTAVAILABLE)
		SCODE_ENTRYW(XACT_E_TRANSACTIONCLOSED)
		SCODE_ENTRYW(XACT_E_UNABLE_TO_LOAD_DTC_PROXY)
		SCODE_ENTRYW(XACT_E_UNABLE_TO_READ_DTC_CONFIG)
		SCODE_ENTRYW(XACT_E_UNKNOWNRMGRID)
		SCODE_ENTRYW(XACT_E_WRONGSTATE)
		SCODE_ENTRYW(XACT_E_WRONGUOW)
		SCODE_ENTRYW(XACT_E_XA_TX_DISABLED)
		SCODE_ENTRYW(XACT_E_XTIONEXISTS)
		SCODE_ENTRYW(XACT_S_ABORTING)
		SCODE_ENTRYW(XACT_S_ALLNORETAIN)
		SCODE_ENTRYW(XACT_S_ASYNC)
		SCODE_ENTRYW(XACT_S_DEFECT)
		SCODE_ENTRYW(XACT_S_LASTRESOURCEMANAGER)
		SCODE_ENTRYW(XACT_S_LOCALLY_OK)
		SCODE_ENTRYW(XACT_S_MADECHANGESCONTENT)
		SCODE_ENTRYW(XACT_S_MADECHANGESINFORM)
		SCODE_ENTRYW(XACT_S_OKINFORM)
		SCODE_ENTRYW(XACT_S_READONLY)
		SCODE_ENTRYW(XACT_S_SINGLEPHASE)
		SCODE_ENTRYW(XACT_S_SOMENORETAIN)
		SCODE_ENTRYW(XENROLL_E_CANNOT_ADD_ROOT_CERT)
		SCODE_ENTRYW(XENROLL_E_KEYSPEC_SMIME_MISMATCH)
		SCODE_ENTRYW(XENROLL_E_KEY_NOT_EXPORTABLE)
		SCODE_ENTRYW(XENROLL_E_RESPONSE_KA_HASH_MISMATCH)
		SCODE_ENTRYW(XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND)
		SCODE_ENTRYW(XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH)
	};
#undef SCODE_ENTRYW
	for (uint ndx = 0; ndx < qnumber(foo); ++ndx)
		if (foo[ndx].scode == scode) return foo[ndx].bstr;
	return NULL;
}

// iostreams overhead
//#ifdef BOOST_NO_INTRINSIC_WCHAR_T
//#undef BOOST_NO_INTRINSIC_WCHAR_T
//#endif // BOOST_NO_INTRINSIC_WCHAR_T
//#include <boost/lexical_cast.hpp>

std::wstring TokenizeVariant(const VARIANT &var) {
	std::wstring result;
	if (var.vt == VT_EMPTY) return result;
	CComBSTR bstr;
	switch (var.vt) {
		//case VT_INT: //return boost::lexical_cast<std::wstring>(var.intVal); // INT var.intVal
		//case VT_UINT: //return boost::lexical_cast<std::wstring>(var.uintVal); // UINT var.uintVal
		//case VT_I1: //return boost::lexical_cast<std::wstring>(var.cVal); // CHAR var.cVal
		//case VT_UI1: //return boost::lexical_cast<std::wstring>(var.bVal); // BYTE var.bVal
		//case VT_I2: //return boost::lexical_cast<std::wstring>(var.iVal); // SHORT var.iVal
		//case VT_UI2: //return boost::lexical_cast<std::wstring>(var.uiVal); // USHORT var.uiVal
		//case VT_I4: //return boost::lexical_cast<std::wstring>(var.lVal); // LONG var.lVal
		//case VT_UI4: //return boost::lexical_cast<std::wstring>(var.ulVal); // ULONG var.ulVal
		//case VT_I8: //return boost::lexical_cast<std::wstring>(var.llVal); // LONGLONG var.llVal
		//case VT_UI8: //return boost::lexical_cast<std::wstring>(var.ullVal); // ULONGLONG var.ullVal
		case VT_R4: //return boost::lexical_cast<std::wstring>(var.fltVal); // FLOAT var.fltVal
		case VT_R8: //return boost::lexical_cast<std::wstring>(var.dblVal); // DOUBLE var.dblVal
		case VT_DECIMAL: //return boost::lexical_cast<std::wstring>(decVal); // DECIMAL decVal
			VarFormatNumber((LPVARIANT)&var, -1, -2, -2, -2, 0, &bstr);
			break;
		case VT_BOOL: // VARIANT_BOOL var.boolVal
			return var.boolVal ? L"TRUE" : L"FALSE";
		case VT_BSTR: // BSTR var.bstrVal
			if (var.bstrVal == NULL) return L"NULL";
			_swprintf(result, L"L\"%s\"", var.bstrVal);
			return result;
		case VT_ERROR: { // SCODE var.scode
			const BSTR strError(TokenizeSCODE(var.scode));
			if (strError != NULL) return strError;
			goto _default;
		}
		case VT_CY: // CY var.cyVal
			VarFormatCurrency((LPVARIANT)&var, -1, -2, -2, -2, 0, &bstr);
			break;
		case VT_DATE: // DATE var.date
			VarFormatDateTime((LPVARIANT)&var, 0, 0, &bstr);
			break;
		//case VT_ARRAY: // SAFEARRAY *var.parray
		//case VT_UNKNOWN: // IUnknown *var.punkVal
		//case VT_DISPATCH: // IDispatch *var.pdispVal
		//case VT_NULL: // var.??? /* SQL-style null */
		//case VT_RECORD: // var.???
		case VT_BYREF | VT_ARRAY: // SAFEARRAY **var.pparray
			if (var.pparray == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_BOOL: // VARIANT_BOOL *var.pboolVal
			if (var.pboolVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_BSTR: // BSTR *var.pbstrVal
			if (var.pbstrVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_CY: // CY *var.pcyVal
			if (var.pcyVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_DATE: // DATE *var.pdate
			if (var.pdate == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_DECIMAL: // DECIMAL *var.pdecVal
			if (var.pdecVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_DISPATCH: // IDispatch **var.ppdispVal
			if (var.ppdispVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_ERROR: // SCODE *var.pscode
			if (var.pscode == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_I1: // CHAR *var.pcVal
			if (var.pcVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_I2: // SHORT *var.piVal
			if (var.piVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_I4: // LONG *var.plVal
			if (var.plVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_I8: // LONGLONG *var.pllVal
			if (var.pllVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_INT: // INT *var.pintVal
			if (var.pintVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_R4: // FLOAT *var.pfltVal
			if (var.pfltVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_R8: // DOUBLE *var.pdblVal
			if (var.pdblVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_RECORD: // IRecordInfo *var.pRecInfo /*PVOID var.pvRecord*/
			if (var.pRecInfo == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_UI1: // BYTE *var.pbVal
			if (var.pbVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_UI2: // USHORT *var.puiVal
			if (var.puiVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_UI4: // ULONG *var.pulVal
			if (var.pulVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_UI8: // ULONGLONG *var.pullVal
			if (var.pullVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_UINT: // UINT *var.puintVal
			if (var.puintVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_UNKNOWN: // IUnknown **var.ppunkVal
			if (var.ppunkVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF | VT_VARIANT: // VARIANT *var.pvarVal
			if (var.pvarVal == NULL) return L"NULL";
			goto _default;
		case VT_BYREF: // PVOID var.byref
			if (var.byref == NULL) return L"NULL";
			goto _default;
		default:
		_default:
			VarFormat((LPVARIANT)&var, NULL, 0, 0, 0, &bstr);
	} // switch
	if (bstr != NULL) result.assign(bstr);
	return result;
}

const char *TokenizeVarType(VARENUM vt) {
	switch (vt) {
#define TOKENIZE(x) case VT_##x: return "VT_"#x;
		TOKENIZE(EMPTY)   TOKENIZE(VOID)
		TOKENIZE(INT)     TOKENIZE(UINT)
		TOKENIZE(I1)      TOKENIZE(I2)      TOKENIZE(I4)      TOKENIZE(I8)
		TOKENIZE(UI1)     TOKENIZE(UI2)     TOKENIZE(UI4)     TOKENIZE(UI8)
		TOKENIZE(INT_PTR) TOKENIZE(UINT_PTR)
		TOKENIZE(R4)      TOKENIZE(R8)
		TOKENIZE(LPSTR)   TOKENIZE(LPWSTR)
		TOKENIZE(HRESULT) TOKENIZE(CY)      TOKENIZE(DATE)    TOKENIZE(BSTR)
		TOKENIZE(BOOL)    TOKENIZE(VARIANT) TOKENIZE(UNKNOWN) TOKENIZE(DISPATCH)
		TOKENIZE(ERROR)   TOKENIZE(DECIMAL) TOKENIZE(FILETIME)
		TOKENIZE(PTR)     TOKENIZE(CARRAY)  TOKENIZE(SAFEARRAY)
		TOKENIZE(USERDEFINED)
		TOKENIZE(NULL)    TOKENIZE(RECORD)  TOKENIZE(BLOB)    TOKENIZE(STREAM)
		TOKENIZE(STORAGE) TOKENIZE(CF)
		TOKENIZE(STREAMED_OBJECT) TOKENIZE(STORED_OBJECT) TOKENIZE(BLOB_OBJECT)
#undef TOKENIZE
	};
	_RPT2(_CRT_WARN, "%s(%i): invalid VARENUM value\n", __FUNCTION__, vt);
	return "<VT_INAVLID>";
}
