
// __________________________________________________________
//
//                         SbsFile.h
//             SBS File Management Library V1.00
//                07-20-2001 Sven B. Schreiber
//                       sbs@orgon.com
// __________________________________________________________

#ifndef _SBSFILE_H_
#define _SBSFILE_H_

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

// =================================================================
// REVISION HISTORY
// =================================================================

/*

07-20-2001 V1.00 Original version (SBS).

*/

// =================================================================
// CONSTANTS
// =================================================================

#define SBS_FILE_NEW    1
#define SBS_FILE_WRITE  2
#define SBS_FILE_READ   3

#define SBS_FILE_TILE   0x00008000

// =================================================================
// FUNCTION PROTOTYPES
// =================================================================

#ifdef  _INLINE_SBSFILE_
#define _INLINE_SBSTEXT_
#define _INLINE_SBSMEM_

#define DLL_EXPORT __declspec (dllexport)

#else   // #ifdef _INLINE_SBSFILE_

#define DLL_EXPORT

#endif  // #ifdef _INLINE_SBSFILE_

// -----------------------------------------------------------------

DLL_EXPORT VOID WINAPI _finit (VOID);

DLL_EXPORT VOID WINAPI _fexit (VOID);

// -----------------------------------------------------------------

DLL_EXPORT DWORD WINAPI _frootA (PBYTE pbPath);

DLL_EXPORT DWORD WINAPI _frootW (PWORD pwPath);

DLL_EXPORT DWORD WINAPI _fleafA (PBYTE pbPath);

DLL_EXPORT DWORD WINAPI _fleafW (PWORD pwPath);

DLL_EXPORT PBYTE WINAPI _ffileA (PBYTE pbPath);

DLL_EXPORT PWORD WINAPI _ffileW (PWORD pwPath);

DLL_EXPORT DWORD WINAPI _fpathA (HINSTANCE hInstance,
                                 PBYTE     pbItem,
                                 PBYTE     pbBuffer,
                                 DWORD     dBuffer);

DLL_EXPORT DWORD WINAPI _fpathW (HINSTANCE hInstance,
                                 PWORD     pwItem,
                                 PWORD     pwBuffer,
                                 DWORD     dBuffer);

DLL_EXPORT DWORD WINAPI _fderiveA (PBYTE pbPath,
                                   PBYTE pbItem,
                                   PBYTE pbBuffer,
                                   DWORD dBuffer);

DLL_EXPORT DWORD WINAPI _fderiveW (PWORD pwPath,
                                   PWORD pwItem,
                                   PWORD pwBuffer,
                                   DWORD dBuffer);

DLL_EXPORT DWORD WINAPI _fnormalA (PBYTE pbPath,
                                   DWORD dPath,
                                   BOOL  fFolder,
                                   BOOL  fWindows);

DLL_EXPORT DWORD WINAPI _fnormalW (PWORD pwPath,
                                   DWORD dPath,
                                   BOOL  fFolder,
                                   BOOL  fWindows);

// -----------------------------------------------------------------

DLL_EXPORT HANDLE WINAPI _fopenA (PBYTE pbPath,
                                  DWORD dMode);

DLL_EXPORT HANDLE WINAPI _fopenW (PWORD pwPath,
                                  DWORD dMode);

DLL_EXPORT HANDLE WINAPI _fclose (HANDLE hf);

DLL_EXPORT HANDLE WINAPI _fclosex (HANDLE    hf,
                                   PFILETIME pftCreate,
                                   PFILETIME pftAccess,
                                   PFILETIME pftWrite);

DLL_EXPORT BOOL WINAPI _ftestA (PBYTE pbPath);

DLL_EXPORT BOOL WINAPI _ftestW (PWORD pwPath);

DLL_EXPORT BOOL WINAPI _fsaveA (PBYTE pbPath,
                                PVOID pData,
                                DWORD dData);

DLL_EXPORT BOOL WINAPI _fsaveW (PWORD pwPath,
                                PVOID pData,
                                DWORD dData);

DLL_EXPORT BOOL WINAPI _fappendA (PBYTE pbPath,
                                  PVOID pData,
                                  DWORD dData);

DLL_EXPORT BOOL WINAPI _fappendW (PWORD pwPath,
                                  PVOID pData,
                                  DWORD dData);

DLL_EXPORT PVOID WINAPI _floadA (PBYTE  pbPath,
                                 PDWORD pdData);

DLL_EXPORT PVOID WINAPI _floadW (PWORD  pwPath,
                                 PDWORD pdData);

DLL_EXPORT PVOID WINAPI _floadxA (PBYTE     pbPath,
                                  PDWORD    pdData,
                                  PFILETIME pftCreate,
                                  PFILETIME pftAccess,
                                  PFILETIME pftWrite);

DLL_EXPORT PVOID WINAPI _floadxW (PWORD     pwPath,
                                  PDWORD    pdData,
                                  PFILETIME pftCreate,
                                  PFILETIME pftAccess,
                                  PFILETIME pftWrite);

DLL_EXPORT PBYTE WINAPI _ftextA (PBYTE  pbPath,
                                 PDWORD pdData);

DLL_EXPORT PWORD WINAPI _ftextW (PWORD  pwPath,
                                 PDWORD pdData);

DLL_EXPORT PBYTE WINAPI _ftextxA (PBYTE     pbPath,
                                  PDWORD    pdData,
                                  PFILETIME pftCreate,
                                  PFILETIME pftAccess,
                                  PFILETIME pftWrite);

DLL_EXPORT PWORD WINAPI _ftextxW (PWORD     pwPath,
                                  PDWORD    pdData,
                                  PFILETIME pftCreate,
                                  PFILETIME pftAccess,
                                  PFILETIME pftWrite);

DLL_EXPORT BOOL WINAPI _fwrite (HANDLE hf,
                                PVOID  pData,
                                DWORD  dData);

DLL_EXPORT DWORD WINAPI _fwritex (HANDLE hf,
                                  PVOID  pData,
                                  DWORD  dData);

DLL_EXPORT DWORD WINAPI _fread (HANDLE hf,
                                PVOID  pData,
                                DWORD  dData);

DLL_EXPORT PVOID WINAPI _fimage (HANDLE hf,
                                 PDWORD pdData);

DLL_EXPORT PVOID WINAPI _fimagex (HANDLE    hf,
                                  PDWORD    pdData,
                                  PFILETIME pftCreate,
                                  PFILETIME pftAccess,
                                  PFILETIME pftWrite);

DLL_EXPORT BOOL WINAPI _folder (FILETIME ft1,
                                FILETIME ft2);

DLL_EXPORT BOOL WINAPI _fnewer (FILETIME ft1,
                                FILETIME ft2);

// -----------------------------------------------------------------

#undef DLL_EXPORT

#include <SbsText.h>
#include <SbsMem.h>

// =================================================================
// CONDITIONAL ANSI/UNICODE SYMBOLS
// =================================================================

#ifdef  UNICODE

#define _froot      _frootW
#define _fleaf      _fleafW
#define _ffile      _ffileW
#define _fpath      _fpathW
#define _fderive    _fderiveW
#define _fnormal    _fnormalW

#define _fopen      _fopenW
#define _ftest      _ftestW
#define _fsave      _fsaveW
#define _fappend    _fappendW
#define _fload      _floadW
#define _floadx     _floadxW
#define _ftext      _ftextW
#define _ftextx     _ftextxW

#else   // #ifdef UNICODE

#define _froot      _frootA
#define _fleaf      _fleafA
#define _ffile      _ffileA
#define _fpath      _fpathA
#define _fderive    _fderiveA
#define _fnormal    _fnormalA

#define _fopen      _fopenA
#define _ftest      _ftestA
#define _fsave      _fsaveA
#define _fappend    _fappendA
#define _fload      _floadA
#define _floadx     _floadxA
#define _ftext      _ftextA
#define _ftextx     _ftextxA

#endif  // #ifdef UNICODE

////////////////////////////////////////////////////////////////////
#ifdef _INLINE_SBSFILE_
////////////////////////////////////////////////////////////////////

// =================================================================
// STARTUP & CLEANUP
// =================================================================

VOID WINAPI _finit (VOID)
    {
    _tinit ();
    _minit (_awAnsiUnicode, _abUnicodeAnsi);
    return;
    }

// -----------------------------------------------------------------

VOID WINAPI _fexit (VOID)
    {
    _mexit ();
    _texit ();
    return;
    }

// =================================================================
// PATH MANAGEMENT
// =================================================================

DWORD WINAPI _frootA (PBYTE pbPath)
    {
    DWORD n = 0;

    if ((pbPath != NULL) && (pbPath [0]))
        {
        if (pbPath [0] == '\\')
            {
            if (pbPath [1] == '\\')
                {
                n = 2;
                while (pbPath [n] && (pbPath [n] != '\\')) n++;
                }
            }
        else
            {
            if (pbPath [1] == ':')
                {
                n = 2;
                }
            }
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _frootW (PWORD pwPath)
    {
    DWORD n = 0;

    if ((pwPath != NULL) && (pwPath [0]))
        {
        if (pwPath [0] == '\\')
            {
            if (pwPath [1] == '\\')
                {
                n = 2;
                while (pwPath [n] && (pwPath [n] != '\\')) n++;
                }
            }
        else
            {
            if (pwPath [1] == ':')
                {
                n = 2;
                }
            }
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fleafA (PBYTE pbPath)
    {
    DWORD i;
    DWORD n = 0;

    if (pbPath != NULL)
        {
        n = i = _frootA (pbPath);

        while (pbPath [i])
            {
            if (pbPath [i++] == '\\') n = i;
            }
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fleafW (PWORD pwPath)
    {
    DWORD i;
    DWORD n = 0;

    if (pwPath != NULL)
        {
        n = i = _frootW (pwPath);

        while (pwPath [i])
            {
            if (pwPath [i++] == '\\') n = i;
            }
        }
    return n;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _ffileA (PBYTE pbPath)
    {
    return (pbPath != NULL ? pbPath + _fleafA (pbPath) : NULL);
    }

// -----------------------------------------------------------------

PWORD WINAPI _ffileW (PWORD pwPath)
    {
    return (pwPath != NULL ? pwPath + _fleafW (pwPath) : NULL);
    }

// -----------------------------------------------------------------

DWORD WINAPI _fpathA (HINSTANCE hInstance,
                      PBYTE     pbItem,
                      PBYTE     pbBuffer,
                      DWORD     dBuffer)
    {
    BYTE  abPath [MAX_PATH];
    DWORD n = 0;

    if ((pbBuffer != NULL) && dBuffer)
        {
        if (GetModuleFileNameA (hInstance, abPath, MAX_PATH))
            {
            n = _fderiveA (abPath, pbItem, pbBuffer, dBuffer);
            }
        pbBuffer [n] = 0;
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fpathW (HINSTANCE hInstance,
                      PWORD     pwItem,
                      PWORD     pwBuffer,
                      DWORD     dBuffer)
    {
    WORD  awPath [MAX_PATH];
    DWORD n = 0;

    if ((pwBuffer != NULL) && dBuffer)
        {
        if (GetModuleFileNameW (hInstance, awPath, MAX_PATH))
            {
            n = _fderiveW (awPath, pwItem, pwBuffer, dBuffer);
            }
        pwBuffer [n] = 0;
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fderiveA (PBYTE pbPath,
                        PBYTE pbItem,
                        PBYTE pbBuffer,
                        DWORD dBuffer)
    {
    DWORD i, j, k;
    DWORD n = 0;

    if ((pbBuffer != NULL) && dBuffer)
        {
        if (pbPath != NULL)
            {
            i = _fleafA (pbPath);
            j = k = i + _tsizeA (pbPath+i);
            }
        else
            {
            i = j = k = 0;
            }
        if (pbItem != NULL)
            {
            if ((pbItem [0] == '.' ) && (pbItem [1] != '.' ))
                {
                while ((j > i) && (pbPath [--j] != '.'));
                }
            else
                {
                j = i;
                }
            k = j + _tsizeA (pbItem);
            }
        if (k < dBuffer)
            {
            if ( j ) _tcopynA (pbBuffer,   pbPath, j+1);
            if (k-j) _tcopyA  (pbBuffer+j, pbItem);
            n = k;
            }
        pbBuffer [n] = 0;
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fderiveW (PWORD pwPath,
                        PWORD pwItem,
                        PWORD pwBuffer,
                        DWORD dBuffer)
    {
    DWORD i, j, k;
    DWORD n = 0;

    if ((pwBuffer != NULL) && dBuffer)
        {
        if (pwPath != NULL)
            {
            i = _fleafW (pwPath);
            j = k = i + _tsizeW (pwPath+i);
            }
        else
            {
            i = j = k = 0;
            }
        if (pwItem != NULL)
            {
            if ((pwItem [0] == '.' ) && (pwItem [1] != '.' ))
                {
                while ((j > i) && (pwPath [--j] != '.'));
                }
            else
                {
                j = i;
                }
            k = j + _tsizeW (pwItem);
            }
        if (k < dBuffer)
            {
            if ( j ) _tcopynW (pwBuffer,   pwPath, j+1);
            if (k-j) _tcopyW  (pwBuffer+j, pwItem);
            n = k;
            }
        pwBuffer [n] = 0;
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fnormalA (PBYTE pbPath,
                        DWORD dPath,
                        BOOL  fFolder,
                        BOOL  fWindows)
    {
    BYTE  abPath [MAX_PATH];
    PBYTE pbFile;
    BOOL  fFolder1;
    DWORD n = 0;

    if ((pbPath != NULL) && dPath)
        {
        fFolder1 = fFolder || !pbPath [0];

        n = (pbPath [0]
             ? GetFullPathNameA (pbPath, MAX_PATH, abPath, &pbFile)
             : GetCurrentDirectoryA (MAX_PATH, abPath));

        if (n >= MAX_PATH) n = 0;

        if (fFolder1 && n && (abPath [n-1] != '\\'))
            {
            if (n+1 < MAX_PATH)
                {
                abPath [n++] = '\\';
                }
            else
                {
                n = 0;
                }
            }
        abPath [n] = 0;

        if (fWindows && fFolder1 && n && (abPath [n-1] == '\\') &&
            (n-1 > _frootA (abPath)))
            {
            abPath [--n] = 0;
            }
        if (n >= dPath) n = 0;

        _tcopynA (pbPath, abPath, n+1);
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fnormalW (PWORD pwPath,
                        DWORD dPath,
                        BOOL  fFolder,
                        BOOL  fWindows)
    {
    WORD  awPath [MAX_PATH];
    PWORD pwFile;
    BOOL  fFolder1;
    DWORD n = 0;

    if ((pwPath != NULL) && dPath)
        {
        fFolder1 = fFolder || !pwPath [0];

        n = (pwPath [0]
             ? GetFullPathNameW (pwPath, MAX_PATH, awPath, &pwFile)
             : GetCurrentDirectoryW (MAX_PATH, awPath));

        if (n >= MAX_PATH) n = 0;

        if (fFolder1 && n && (awPath [n-1] != '\\'))
            {
            if (n+1 < MAX_PATH)
                {
                awPath [n++] = '\\';
                }
            else
                {
                n = 0;
                }
            }
        awPath [n] = 0;

        if (fWindows && fFolder1 && n && (awPath [n-1] == '\\') &&
            (n-1 > _frootW (awPath)))
            {
            awPath [--n] = 0;
            }
        if (n >= dPath) n = 0;

        _tcopynW (pwPath, awPath, n+1);
        }
    return n;
    }

// =================================================================
// FILE MANAGEMENT
// =================================================================

HANDLE WINAPI _fopenA (PBYTE pbPath,
                       DWORD dMode)
    {
    DWORD  dAccess, dAction, dFlags;
    HANDLE hf = INVALID_HANDLE_VALUE;

    if ((pbPath != NULL) && pbPath [0])
        {
        dAccess = 0;

        switch (dMode)
            {
            case SBS_FILE_NEW:
                {
                dAccess = GENERIC_READ | GENERIC_WRITE;
                dAction = CREATE_ALWAYS;
                dFlags  = FILE_FLAG_SEQUENTIAL_SCAN |
                          FILE_ATTRIBUTE_NORMAL;
                break;
                }
            case SBS_FILE_WRITE:
                {
                dAccess = GENERIC_READ | GENERIC_WRITE;
                dAction = OPEN_ALWAYS;
                dFlags  = FILE_FLAG_SEQUENTIAL_SCAN |
                          FILE_ATTRIBUTE_NORMAL;
                break;
                }
            case SBS_FILE_READ:
                {
                dAccess = GENERIC_READ;
                dAction = OPEN_EXISTING;
                dFlags  = FILE_FLAG_SEQUENTIAL_SCAN;

                break;
                }
            }
        if (dAccess)
            {
            hf = CreateFileA (pbPath, dAccess, FILE_SHARE_READ,
                              NULL, dAction, dFlags, NULL);
            }
        }
    return hf;
    }

// -----------------------------------------------------------------

HANDLE WINAPI _fopenW (PWORD pwPath,
                       DWORD dMode)
    {
    DWORD  dAccess, dAction, dFlags;
    HANDLE hf = INVALID_HANDLE_VALUE;

    if ((pwPath != NULL) && pwPath [0])
        {
        dAccess = 0;

        switch (dMode)
            {
            case SBS_FILE_NEW:
                {
                dAccess = GENERIC_READ | GENERIC_WRITE;
                dAction = CREATE_ALWAYS;
                dFlags  = FILE_FLAG_SEQUENTIAL_SCAN |
                          FILE_ATTRIBUTE_NORMAL;
                break;
                }
            case SBS_FILE_WRITE:
                {
                dAccess = GENERIC_READ | GENERIC_WRITE;
                dAction = OPEN_ALWAYS;
                dFlags  = FILE_FLAG_SEQUENTIAL_SCAN |
                          FILE_ATTRIBUTE_NORMAL;
                break;
                }
            case SBS_FILE_READ:
                {
                dAccess = GENERIC_READ;
                dAction = OPEN_EXISTING;
                dFlags  = FILE_FLAG_SEQUENTIAL_SCAN;

                break;
                }
            }
        if (dAccess)
            {
            hf = CreateFileW (pwPath, dAccess, FILE_SHARE_READ,
                              NULL, dAction, dFlags, NULL);
            }
        }
    return hf;
    }

// -----------------------------------------------------------------

HANDLE WINAPI _fclose (HANDLE hf)
    {
    return _fclosex (hf, NULL, NULL, NULL);
    }

// -----------------------------------------------------------------

HANDLE WINAPI _fclosex (HANDLE    hf,
                        PFILETIME pftCreate,
                        PFILETIME pftAccess,
                        PFILETIME pftWrite)
    {
    if (hf != INVALID_HANDLE_VALUE)
        {
        if ((pftCreate != NULL) ||
            (pftAccess != NULL) ||
            (pftWrite  != NULL))
            {
            SetFileTime (hf, pftCreate, pftAccess, pftWrite);
            }
        CloseHandle (hf);
        }
    return INVALID_HANDLE_VALUE;
    }

// -----------------------------------------------------------------

BOOL WINAPI _ftestA (PBYTE pbPath)
    {
    HANDLE           hff;
    WIN32_FIND_DATAA wfd;
    BOOL             fOk = FALSE;

    if ((pbPath != NULL) && pbPath [0]
        &&
        ((hff = FindFirstFileA (pbPath, &wfd))
         != INVALID_HANDLE_VALUE))
        {
        fOk = (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY));
        FindClose (hff);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL WINAPI _ftestW (PWORD pwPath)
    {
    HANDLE           hff;
    WIN32_FIND_DATAW wfd;
    BOOL             fOk = FALSE;

    if ((pwPath != NULL) && pwPath [0]
        &&
        ((hff = FindFirstFileW (pwPath, &wfd))
         != INVALID_HANDLE_VALUE))
        {
        fOk = (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY));
        FindClose (hff);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL WINAPI _fsaveA (PBYTE pbPath,
                     PVOID pData,
                     DWORD dData)
    {
    HANDLE hf;
    DWORD  dData1;
    BOOL   fOk = FALSE;

    if ((hf = _fopenA (pbPath, SBS_FILE_NEW))
        != INVALID_HANDLE_VALUE)
        {
        dData1 = (dData != -1 ? dData : _tsizeA (pData));
        fOk    = _fwrite (hf, pData, dData1) && SetEndOfFile (hf);

        _fclose (hf);

        if (!fOk) DeleteFileA (pbPath);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL WINAPI _fsaveW (PWORD pwPath,
                     PVOID pData,
                     DWORD dData)
    {
    HANDLE hf;
    DWORD  dData1;
    BOOL   fOk = FALSE;

    if ((hf = _fopenW (pwPath, SBS_FILE_NEW))
        != INVALID_HANDLE_VALUE)
        {
        dData1 = (dData != -1 ? dData : _tsizeA (pData));
        fOk    = _fwrite (hf, pData, dData1) && SetEndOfFile (hf);

        _fclose (hf);

        if (!fOk) DeleteFileW (pwPath);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL WINAPI _fappendA (PBYTE pbPath,
                       PVOID pData,
                       DWORD dData)
    {
    HANDLE hf;
    DWORD  dData1;
    BOOL   fOk = FALSE;

    if ((hf = _fopenA (pbPath, SBS_FILE_WRITE))
        != INVALID_HANDLE_VALUE)
        {
        if (SetFilePointer (hf, 0, NULL, FILE_END)
            != INVALID_SET_FILE_POINTER)
            {
            dData1 = (dData != -1 ? dData : _tsizeA (pData));
            fOk    = _fwrite  (hf, pData, dData1);
            }
        _fclose (hf);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL WINAPI _fappendW (PWORD pwPath,
                       PVOID pData,
                       DWORD dData)
    {
    HANDLE hf;
    DWORD  dData1;
    BOOL   fOk = FALSE;

    if ((hf = _fopenW (pwPath, SBS_FILE_WRITE))
        != INVALID_HANDLE_VALUE)
        {
        if (SetFilePointer (hf, 0, NULL, FILE_END)
            != INVALID_SET_FILE_POINTER)
            {
            dData1 = (dData != -1 ? dData : _tsizeA (pData));
            fOk    = _fwrite  (hf, pData, dData1);
            }
        _fclose (hf);
        }
    return fOk;
    }

// -----------------------------------------------------------------

PVOID WINAPI _floadA (PBYTE  pbPath,
                      PDWORD pdData)
    {
    return _floadxA (pbPath, pdData, NULL, NULL, NULL);
    }

// -----------------------------------------------------------------

PVOID WINAPI _floadW (PWORD  pwPath,
                      PDWORD pdData)
    {
    return _floadxW (pwPath, pdData, NULL, NULL, NULL);
    }

// -----------------------------------------------------------------

PVOID WINAPI _floadxA (PBYTE     pbPath,
                       PDWORD    pdData,
                       PFILETIME pftCreate,
                       PFILETIME pftAccess,
                       PFILETIME pftWrite)
    {
    HANDLE   hf;
    DWORD    dData    = 0;
    FILETIME ftCreate = {0, 0};
    FILETIME ftAccess = {0, 0};
    FILETIME ftWrite  = {0, 0};
    PVOID    pData    = NULL;

    if ((hf = _fopenA (pbPath, SBS_FILE_READ))
        != INVALID_HANDLE_VALUE)
        {
        pData = _fimagex (hf, &dData,
                          &ftCreate, &ftAccess, &ftWrite);
        _fclose (hf);
        }
    if (pdData    != NULL) *pdData    = dData;
    if (pftCreate != NULL) *pftCreate = ftCreate;
    if (pftAccess != NULL) *pftAccess = ftAccess;
    if (pftWrite  != NULL) *pftWrite  = ftWrite;
    return pData;
    }

// -----------------------------------------------------------------

PVOID WINAPI _floadxW (PWORD     pwPath,
                       PDWORD    pdData,
                       PFILETIME pftCreate,
                       PFILETIME pftAccess,
                       PFILETIME pftWrite)
    {
    HANDLE   hf;
    DWORD    dData    = 0;
    FILETIME ftCreate = {0, 0};
    FILETIME ftAccess = {0, 0};
    FILETIME ftWrite  = {0, 0};
    PVOID    pData    = NULL;

    if ((hf = _fopenW (pwPath, SBS_FILE_READ))
        != INVALID_HANDLE_VALUE)
        {
        pData = _fimagex (hf, &dData,
                          &ftCreate, &ftAccess, &ftWrite);
        _fclose (hf);
        }
    if (pdData    != NULL) *pdData    = dData;
    if (pftCreate != NULL) *pftCreate = ftCreate;
    if (pftAccess != NULL) *pftAccess = ftAccess;
    if (pftWrite  != NULL) *pftWrite  = ftWrite;
    return pData;
    }

// -----------------------------------------------------------------

PBYTE WINAPI _ftextA (PBYTE  pbPath,
                      PDWORD pdData)
    {
    return _ftextxA (pbPath, pdData, NULL, NULL, NULL);
    }

// -----------------------------------------------------------------

PWORD WINAPI _ftextW (PWORD  pwPath,
                      PDWORD pdData)
    {
    return _ftextxW (pwPath, pdData, NULL, NULL, NULL);
    }

// -----------------------------------------------------------------

PBYTE WINAPI _ftextxA (PBYTE     pbPath,
                       PDWORD    pdData,
                       PFILETIME pftCreate,
                       PFILETIME pftAccess,
                       PFILETIME pftWrite)
    {
    return _floadxA (pbPath, pdData,
                     pftCreate, pftAccess, pftWrite);
    }

// -----------------------------------------------------------------

PWORD WINAPI _ftextxW (PWORD     pwPath,
                       PDWORD    pdData,
                       PFILETIME pftCreate,
                       PFILETIME pftAccess,
                       PFILETIME pftWrite)
    {
    DWORD    dData1, i;
    FILETIME ftCreate1, ftAccess1, ftWrite1;
    PBYTE    pbData;

    DWORD    dData    = 0;
    FILETIME ftCreate = {0, 0};
    FILETIME ftAccess = {0, 0};
    FILETIME ftWrite  = {0, 0};
    PWORD    pwData   = NULL;

    if ((pbData = _floadxW (pwPath, &dData1,
                            &ftCreate1, &ftAccess1, &ftWrite1))
        != NULL)
        {
        if ((dData1 <= (MAXDWORD / sizeof (WORD)) - 2) &&
            ((pwData = _tnewW (dData1+2)) != NULL))
            {
            for (i = 0; i < dData1; i++)
                {
                pwData [i] = pbData [i];
                }
            pwData [i  ] = 0;
            pwData [i+1] = 0;

            dData    = dData1;
            ftCreate = ftCreate1;
            ftAccess = ftAccess1;
            ftWrite  = ftWrite1;
            }
        _mfree (pbData);
        }
    if (pdData    != NULL) *pdData    = dData;
    if (pftCreate != NULL) *pftCreate = ftCreate;
    if (pftAccess != NULL) *pftAccess = ftAccess;
    if (pftWrite  != NULL) *pftWrite  = ftWrite;
    return pwData;
    }

// -----------------------------------------------------------------

BOOL WINAPI _fwrite (HANDLE hf,
                     PVOID  pData,
                     DWORD  dData)
    {
    return (hf != INVALID_HANDLE_VALUE) &&
           (_fwritex (hf, pData, dData) == dData);
    }

// -----------------------------------------------------------------

DWORD WINAPI _fwritex (HANDLE hf,
                       PVOID  pData,
                       DWORD  dData)
    {
    PBYTE pbData;
    DWORD n1, n2;
    DWORD n = 0;

    if ((hf != INVALID_HANDLE_VALUE) && (pData != NULL))
        {
        for (n = 0; n < dData; n += n2)
            {
            pbData = (PBYTE) pData + n;
            n1     = min (dData - n, SBS_FILE_TILE);
            n2     = 0;

            if ((!WriteFile (hf, pbData, n1, &n2, NULL)) ||
                (!n2)) break;
            }
        }
    return n;
    }

// -----------------------------------------------------------------

DWORD WINAPI _fread (HANDLE hf,
                     PVOID  pData,
                     DWORD  dData)
    {
    DWORD n = 0;

    if (hf != INVALID_HANDLE_VALUE)
        {
        if ((pData != NULL) && dData)
            {
            if (!ReadFile (hf, pData, dData, &n, NULL)) n = 0;
            }
        }
    return n;
    }

// -----------------------------------------------------------------

PVOID WINAPI _fimage (HANDLE hf,
                      PDWORD pdData)
    {
    return _fimagex (hf, pdData, NULL, NULL, NULL);
    }

// -----------------------------------------------------------------

PVOID WINAPI _fimagex (HANDLE    hf,
                       PDWORD    pdData,
                       PFILETIME pftCreate,
                       PFILETIME pftAccess,
                       PFILETIME pftWrite)
    {
    DWORD    dData1;
    FILETIME ftCreate1, ftAccess1, ftWrite1;

    DWORD    dData    = 0;
    FILETIME ftCreate = {0, 0};
    FILETIME ftAccess = {0, 0};
    FILETIME ftWrite  = {0, 0};
    PVOID    pData    = NULL;

    if ((hf != INVALID_HANDLE_VALUE)                             &&
        GetFileTime (hf, &ftCreate1, &ftAccess1, &ftWrite1)      &&
        ((dData1 = GetFileSize (hf, NULL)) != INVALID_FILE_SIZE) &&
        (dData1 <= MAXDWORD-2)                                   &&
        ((pData  = _mnew (dData1+2)) != NULL))
        {
        if (_fread (hf, pData, dData1) == dData1)
            {
            ((PBYTE) pData) [dData1  ] = 0;
            ((PBYTE) pData) [dData1+1] = 0;

            dData    = dData1;
            ftCreate = ftCreate1;
            ftAccess = ftAccess1;
            ftWrite  = ftWrite1;
            }
        else
            {
            pData = _mfree (pData);
            }
        }
    if (pdData    != NULL) *pdData    = dData;
    if (pftCreate != NULL) *pftCreate = ftCreate;
    if (pftAccess != NULL) *pftAccess = ftAccess;
    if (pftWrite  != NULL) *pftWrite  = ftWrite;
    return pData;
    }

// -----------------------------------------------------------------

BOOL WINAPI _folder (FILETIME ft1,
                     FILETIME ft2)
    {
    return (ft1.dwHighDateTime < ft2.dwHighDateTime)
           ||
           ((ft1.dwHighDateTime == ft2.dwHighDateTime) &&
            (ft1.dwLowDateTime  <  ft2.dwLowDateTime ));
    }

// -----------------------------------------------------------------

BOOL WINAPI _fnewer (FILETIME ft1,
                     FILETIME ft2)
    {
    return (ft1.dwHighDateTime > ft2.dwHighDateTime)
           ||
           ((ft1.dwHighDateTime == ft2.dwHighDateTime) &&
            (ft1.dwLowDateTime  >  ft2.dwLowDateTime ));
    }

////////////////////////////////////////////////////////////////////
#endif // #ifdef _INLINE_SBSFILE_
////////////////////////////////////////////////////////////////////

#endif // #ifndef _SBSFILE_H_

// =================================================================
// END OF FILE
// =================================================================
