
// __________________________________________________________
//
//                          SbsNum.h
//           SBS Optimized Numeric Functions V1.00
//                02-10-2003 Sven B. Schreiber
//                       sbs@orgon.com
// __________________________________________________________

#ifndef _SBSNUM_H_
#define _SBSNUM_H_

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

// =================================================================
// REVISION HISTORY
// =================================================================

/*

02-10-2003 V1.00 Original version (SBS).

*/

// =================================================================
// FUNCTION PROTOTYPES
// =================================================================

#ifdef  _INLINE_SBSNUM_

#define DLL_EXPORT __declspec (dllexport)

#else   // #ifdef _INLINE_SBSNUM_

#define DLL_EXPORT

#endif  // #ifdef _INLINE_SBSNUM_

// -----------------------------------------------------------------

DLL_EXPORT DWORD __fastcall _crc32_start (PDWORD pdCrc32);

DLL_EXPORT BOOL __fastcall _crc32_stop (PDWORD pdCrc32);

DLL_EXPORT DWORD __fastcall _crc32_08 (PDWORD pdCrc32,
                                       BYTE   bData);

DLL_EXPORT DWORD __fastcall _crc32_16 (PDWORD pdCrc32,
                                       WORD   wData);

DLL_EXPORT DWORD __fastcall _crc32_32 (PDWORD pdCrc32,
                                       DWORD  dData);

DLL_EXPORT DWORD __fastcall _crc32 (PDWORD pdCrc32,
                                    PVOID  pData,
                                    DWORD  dData);

// -----------------------------------------------------------------

DLL_EXPORT DWORD __fastcall _random_reset (PDWORD pdData,
                                           PDWORD pdAddr);

DLL_EXPORT DWORD __fastcall _random_seed (PDWORD pdData,
                                          PDWORD pdAddr,
                                          DWORD  dSeed);

DLL_EXPORT DWORD __fastcall _random_bit (PDWORD pdData,
                                         PDWORD pdAddr);

DLL_EXPORT BYTE __fastcall _random_08 (PDWORD pdData,
                                       PDWORD pdAddr);

DLL_EXPORT WORD __fastcall _random_16 (PDWORD pdData,
                                       PDWORD pdAddr);

DLL_EXPORT DWORD __fastcall _random_32 (PDWORD pdData,
                                        PDWORD pdAddr);

DLL_EXPORT BOOL WINAPI _random_list (PDWORD pdData,
                                     PDWORD pdAddr,
                                     PPVOID ppData,
                                     DWORD  dCount);

// -----------------------------------------------------------------

#undef DLL_EXPORT

////////////////////////////////////////////////////////////////////
#ifdef _INLINE_SBSNUM_
////////////////////////////////////////////////////////////////////

// =================================================================
// VARIABLES
// =================================================================

DWORD _dRandomData = 0;
DWORD _dRandomAddr = 0;

// =================================================================
// CRC32 LOOKUP TABLE
// =================================================================

DWORD _adCrc32 [256] =
    {
    0x00000000, 0x77073096, 0xEE0E612C, 0x990951BA,   //0x00..0x03
    0x076DC419, 0x706AF48F, 0xE963A535, 0x9E6495A3,   //0x04..0x07
    0x0EDB8832, 0x79DCB8A4, 0xE0D5E91E, 0x97D2D988,   //0x08..0x0B
    0x09B64C2B, 0x7EB17CBD, 0xE7B82D07, 0x90BF1D91,   //0x0C..0x0F
    0x1DB71064, 0x6AB020F2, 0xF3B97148, 0x84BE41DE,   //0x10..0x13
    0x1ADAD47D, 0x6DDDE4EB, 0xF4D4B551, 0x83D385C7,   //0x14..0x17
    0x136C9856, 0x646BA8C0, 0xFD62F97A, 0x8A65C9EC,   //0x18..0x1B
    0x14015C4F, 0x63066CD9, 0xFA0F3D63, 0x8D080DF5,   //0x1C..0x1F
    0x3B6E20C8, 0x4C69105E, 0xD56041E4, 0xA2677172,   //0x20..0x23
    0x3C03E4D1, 0x4B04D447, 0xD20D85FD, 0xA50AB56B,   //0x24..0x27
    0x35B5A8FA, 0x42B2986C, 0xDBBBC9D6, 0xACBCF940,   //0x28..0x2B
    0x32D86CE3, 0x45DF5C75, 0xDCD60DCF, 0xABD13D59,   //0x2C..0x2F
    0x26D930AC, 0x51DE003A, 0xC8D75180, 0xBFD06116,   //0x30..0x33
    0x21B4F4B5, 0x56B3C423, 0xCFBA9599, 0xB8BDA50F,   //0x34..0x37
    0x2802B89E, 0x5F058808, 0xC60CD9B2, 0xB10BE924,   //0x38..0x3B
    0x2F6F7C87, 0x58684C11, 0xC1611DAB, 0xB6662D3D,   //0x3C..0x3F
    0x76DC4190, 0x01DB7106, 0x98D220BC, 0xEFD5102A,   //0x40..0x43
    0x71B18589, 0x06B6B51F, 0x9FBFE4A5, 0xE8B8D433,   //0x44..0x47
    0x7807C9A2, 0x0F00F934, 0x9609A88E, 0xE10E9818,   //0x48..0x4B
    0x7F6A0DBB, 0x086D3D2D, 0x91646C97, 0xE6635C01,   //0x4C..0x4F
    0x6B6B51F4, 0x1C6C6162, 0x856530D8, 0xF262004E,   //0x50..0x53
    0x6C0695ED, 0x1B01A57B, 0x8208F4C1, 0xF50FC457,   //0x54..0x57
    0x65B0D9C6, 0x12B7E950, 0x8BBEB8EA, 0xFCB9887C,   //0x58..0x5B
    0x62DD1DDF, 0x15DA2D49, 0x8CD37CF3, 0xFBD44C65,   //0x5C..0x5F
    0x4DB26158, 0x3AB551CE, 0xA3BC0074, 0xD4BB30E2,   //0x60..0x63
    0x4ADFA541, 0x3DD895D7, 0xA4D1C46D, 0xD3D6F4FB,   //0x64..0x67
    0x4369E96A, 0x346ED9FC, 0xAD678846, 0xDA60B8D0,   //0x68..0x6B
    0x44042D73, 0x33031DE5, 0xAA0A4C5F, 0xDD0D7CC9,   //0x6C..0x6F
    0x5005713C, 0x270241AA, 0xBE0B1010, 0xC90C2086,   //0x70..0x73
    0x5768B525, 0x206F85B3, 0xB966D409, 0xCE61E49F,   //0x74..0x77
    0x5EDEF90E, 0x29D9C998, 0xB0D09822, 0xC7D7A8B4,   //0x78..0x7B
    0x59B33D17, 0x2EB40D81, 0xB7BD5C3B, 0xC0BA6CAD,   //0x7C..0x7F
    0xEDB88320, 0x9ABFB3B6, 0x03B6E20C, 0x74B1D29A,   //0x80..0x83
    0xEAD54739, 0x9DD277AF, 0x04DB2615, 0x73DC1683,   //0x84..0x87
    0xE3630B12, 0x94643B84, 0x0D6D6A3E, 0x7A6A5AA8,   //0x88..0x8B
    0xE40ECF0B, 0x9309FF9D, 0x0A00AE27, 0x7D079EB1,   //0x8C..0x8F
    0xF00F9344, 0x8708A3D2, 0x1E01F268, 0x6906C2FE,   //0x90..0x93
    0xF762575D, 0x806567CB, 0x196C3671, 0x6E6B06E7,   //0x94..0x97
    0xFED41B76, 0x89D32BE0, 0x10DA7A5A, 0x67DD4ACC,   //0x98..0x9B
    0xF9B9DF6F, 0x8EBEEFF9, 0x17B7BE43, 0x60B08ED5,   //0x9C..0x9F
    0xD6D6A3E8, 0xA1D1937E, 0x38D8C2C4, 0x4FDFF252,   //0xA0..0xA3
    0xD1BB67F1, 0xA6BC5767, 0x3FB506DD, 0x48B2364B,   //0xA4..0xA7
    0xD80D2BDA, 0xAF0A1B4C, 0x36034AF6, 0x41047A60,   //0xA8..0xAB
    0xDF60EFC3, 0xA867DF55, 0x316E8EEF, 0x4669BE79,   //0xAC..0xAF
    0xCB61B38C, 0xBC66831A, 0x256FD2A0, 0x5268E236,   //0xB0..0xB3
    0xCC0C7795, 0xBB0B4703, 0x220216B9, 0x5505262F,   //0xB4..0xB7
    0xC5BA3BBE, 0xB2BD0B28, 0x2BB45A92, 0x5CB36A04,   //0xB8..0xBB
    0xC2D7FFA7, 0xB5D0CF31, 0x2CD99E8B, 0x5BDEAE1D,   //0xBC..0xBF
    0x9B64C2B0, 0xEC63F226, 0x756AA39C, 0x026D930A,   //0xC0..0xC3
    0x9C0906A9, 0xEB0E363F, 0x72076785, 0x05005713,   //0xC4..0xC7
    0x95BF4A82, 0xE2B87A14, 0x7BB12BAE, 0x0CB61B38,   //0xC8..0xCB
    0x92D28E9B, 0xE5D5BE0D, 0x7CDCEFB7, 0x0BDBDF21,   //0xCC..0xCF
    0x86D3D2D4, 0xF1D4E242, 0x68DDB3F8, 0x1FDA836E,   //0xD0..0xD3
    0x81BE16CD, 0xF6B9265B, 0x6FB077E1, 0x18B74777,   //0xD4..0xD7
    0x88085AE6, 0xFF0F6A70, 0x66063BCA, 0x11010B5C,   //0xD8..0xDB
    0x8F659EFF, 0xF862AE69, 0x616BFFD3, 0x166CCF45,   //0xDC..0xDF
    0xA00AE278, 0xD70DD2EE, 0x4E048354, 0x3903B3C2,   //0xE0..0xE3
    0xA7672661, 0xD06016F7, 0x4969474D, 0x3E6E77DB,   //0xE4..0xE7
    0xAED16A4A, 0xD9D65ADC, 0x40DF0B66, 0x37D83BF0,   //0xE8..0xEB
    0xA9BCAE53, 0xDEBB9EC5, 0x47B2CF7F, 0x30B5FFE9,   //0xEC..0xEF
    0xBDBDF21C, 0xCABAC28A, 0x53B39330, 0x24B4A3A6,   //0xF0..0xF3
    0xBAD03605, 0xCDD70693, 0x54DE5729, 0x23D967BF,   //0xF4..0xF7
    0xB3667A2E, 0xC4614AB8, 0x5D681B02, 0x2A6F2B94,   //0xF8..0xFB
    0xB40BBE37, 0xC30C8EA1, 0x5A05DF1B, 0x2D02EF8D    //0xFC..0xFF
    };

// =================================================================
// CRC32 COMPUTATION
// =================================================================

#define SBS_CRC32_BYTE      \
    __asm   mov     bl,  dl \
    __asm   shr     edx, 8  \
    __asm   xor     bl,  al \
    __asm   shr     eax, 8  \
    __asm   xor     eax, [_adCrc32+ebx*4]

// -----------------------------------------------------------------

DWORD __fastcall _crc32_start (PDWORD pdCrc32)
    {
    __asm   mov     dword ptr [ecx], 0FFFFFFFFh

    return *pdCrc32;
    }

// -----------------------------------------------------------------

BOOL __fastcall _crc32_stop (PDWORD pdCrc32)
    {
    __asm   not     dword ptr [ecx]

    return (*pdCrc32 == 0xDEBB20E3);
    }

// -----------------------------------------------------------------

DWORD __fastcall _crc32_08 (PDWORD pdCrc32,
                            BYTE   bData)
    {
    __asm   xor     ebx, ebx
    __asm   mov     eax, [ecx]

    SBS_CRC32_BYTE ; 1

    __asm   mov     [ecx], eax

    return *pdCrc32;
    }

// -----------------------------------------------------------------

DWORD __fastcall _crc32_16 (PDWORD pdCrc32,
                            WORD   wData)
    {
    __asm   xor     ebx, ebx
    __asm   mov     eax, [ecx]

    SBS_CRC32_BYTE ; 1
    SBS_CRC32_BYTE ; 2

    __asm   mov     [ecx], eax

    return *pdCrc32;
    }

// -----------------------------------------------------------------

DWORD __fastcall _crc32_32 (PDWORD pdCrc32,
                            DWORD  dData)
    {
    __asm   xor     ebx, ebx
    __asm   mov     eax, [ecx]

    SBS_CRC32_BYTE ; 1
    SBS_CRC32_BYTE ; 2
    SBS_CRC32_BYTE ; 3
    SBS_CRC32_BYTE ; 4

    __asm   mov     [ecx], eax

    return *pdCrc32;
    }

// -----------------------------------------------------------------

DWORD __fastcall _crc32 (PDWORD pdCrc32,
                         PVOID  pData,
                         DWORD  dData)
    {
    DWORD dCrc32;

    __asm
        {
                    test    ecx, ecx
                    mov     eax, 0FFFFFFFFh
                    jz      _label01
                    mov     eax, [ecx]

        _label01:   xor     ebx, ebx
                    mov     esi, dData

                    test    edx, edx
                    jz      _label03
                    test    esi, esi
                    jz      _label03

        _label02:   mov     bl,  [edx]
                    inc     edx
                    xor     bl,  al
                    shr     eax, 8
                    xor     eax, [_adCrc32+ebx*4]
                    dec     esi
                    jnz     _label02

        _label03:   test    ecx, ecx
                    jz      _label04
                    mov     [ecx], eax
                    jmp     _label05

        _label04:   not     eax
        _label05:   mov     dCrc32, eax
        }
    return dCrc32;
    }

// ============================================================================
// PSEUDO-RANDOM NUMBER GENERATOR
// ============================================================================

#define SBS_RANDOM_BIT          \
    __asm   mov     ecx, esi    \
    __asm   mov     edx, edi    \
    __asm   call    _random_bit \
    __asm   shr     ebx, 1      \
    __asm   ror     eax, 1      \
    __asm   or      ebx, eax

// -----------------------------------------------------------------

DWORD __fastcall _random_reset (PDWORD pdData,
                                PDWORD pdAddr)
    {
    return _random_seed (pdData, pdAddr, 0);
    }

// -----------------------------------------------------------------

DWORD __fastcall _random_seed (PDWORD pdData,
                               PDWORD pdAddr,
                               DWORD  dSeed)
    {
    DWORD dValue;

    __asm
        {
                    mov     eax, dSeed
                    test    eax, eax
                    jnz     _label01

                    push    ecx
                    push    edx
                    call    dword ptr GetTickCount
                    pop     edx
                    pop     ecx

        _label01:   test    ecx, ecx
                    jnz     _label02
                    mov     ecx, offset _dRandomData

        _label02:   test    edx, edx
                    jnz     _label03
                    mov     edx, offset _dRandomAddr

        _label03:   test    eax, eax
                    mov     dword ptr [ecx], eax
                    jnz     _label04
                    mov     dword ptr [ecx], 1

        _label04:   and     eax, 7FFFFFFFh
                    mov     dword ptr [edx], eax
                    jnz     _label05
                    mov     dword ptr [edx], 1

        _label05:   push    ecx
                    call    _random_32
                    pop     ecx

                    mov     eax, [ecx]
                    mov     dValue, eax
        }
    return dValue;
    }

// ----------------------------------------------------------------------------

DWORD __fastcall _random_bit (PDWORD pdData,
                              PDWORD pdAddr)
    {
    DWORD dValue = 1;

    __asm
        {
                    mov     edi, ecx
                    mov     esi, edx

                    test    edi, edi
                    jnz     _label01
                    mov     edi, offset _dRandomData

        _label01:   test    esi, esi
                    jnz     _label02
                    mov     esi, offset _dRandomAddr

        _label02:   mov     eax, [edi]
                    mov     ecx, [esi]

                    rol     eax, 1
                    shl     ecx, 1
                    sets    dl
                    or      cl, dl

                    test    al, 10101110b
                    setnp   dl

                    test    cl, 00001000b
                    setnp   bl

                    xor     al, dl
                    xor     cl, bl

                    mov     [edi], eax
                    mov     [esi], ecx

                    shr     ecx, 21
                    shr     eax, cl

                    and     dValue, eax
        }
    return dValue;
    }

// ----------------------------------------------------------------------------

BYTE __fastcall _random_08 (PDWORD pdData,
                            PDWORD pdAddr)
    {
    BYTE bValue;

    __asm   mov     esi, ecx
    __asm   mov     edi, edx
    __asm   xor     ebx, ebx

    SBS_RANDOM_BIT ;  1
    SBS_RANDOM_BIT ;  2
    SBS_RANDOM_BIT ;  3
    SBS_RANDOM_BIT ;  4
    SBS_RANDOM_BIT ;  5
    SBS_RANDOM_BIT ;  6
    SBS_RANDOM_BIT ;  7
    SBS_RANDOM_BIT ;  8

    __asm   shr     ebx, 24
    __asm   mov     bValue, bl

    return bValue;
    }

// ----------------------------------------------------------------------------

WORD __fastcall _random_16 (PDWORD pdData,
                            PDWORD pdAddr)
    {
    WORD wValue;

    __asm   mov     esi, ecx
    __asm   mov     edi, edx
    __asm   xor     ebx, ebx

    SBS_RANDOM_BIT ;  1
    SBS_RANDOM_BIT ;  2
    SBS_RANDOM_BIT ;  3
    SBS_RANDOM_BIT ;  4
    SBS_RANDOM_BIT ;  5
    SBS_RANDOM_BIT ;  6
    SBS_RANDOM_BIT ;  7
    SBS_RANDOM_BIT ;  8
    SBS_RANDOM_BIT ;  9
    SBS_RANDOM_BIT ; 10
    SBS_RANDOM_BIT ; 11
    SBS_RANDOM_BIT ; 12
    SBS_RANDOM_BIT ; 13
    SBS_RANDOM_BIT ; 14
    SBS_RANDOM_BIT ; 15
    SBS_RANDOM_BIT ; 16

    __asm   shr     ebx, 16
    __asm   mov     wValue, bx

    return wValue;
    }

// ----------------------------------------------------------------------------

DWORD __fastcall _random_32 (PDWORD pdData,
                             PDWORD pdAddr)
    {
    DWORD dValue;

    __asm   mov     esi, ecx
    __asm   mov     edi, edx
    __asm   xor     ebx, ebx

    SBS_RANDOM_BIT ;  1
    SBS_RANDOM_BIT ;  2
    SBS_RANDOM_BIT ;  3
    SBS_RANDOM_BIT ;  4
    SBS_RANDOM_BIT ;  5
    SBS_RANDOM_BIT ;  6
    SBS_RANDOM_BIT ;  7
    SBS_RANDOM_BIT ;  8
    SBS_RANDOM_BIT ;  9
    SBS_RANDOM_BIT ; 10
    SBS_RANDOM_BIT ; 11
    SBS_RANDOM_BIT ; 12
    SBS_RANDOM_BIT ; 13
    SBS_RANDOM_BIT ; 14
    SBS_RANDOM_BIT ; 15
    SBS_RANDOM_BIT ; 16
    SBS_RANDOM_BIT ; 17
    SBS_RANDOM_BIT ; 18
    SBS_RANDOM_BIT ; 19
    SBS_RANDOM_BIT ; 20
    SBS_RANDOM_BIT ; 21
    SBS_RANDOM_BIT ; 22
    SBS_RANDOM_BIT ; 23
    SBS_RANDOM_BIT ; 24
    SBS_RANDOM_BIT ; 25
    SBS_RANDOM_BIT ; 26
    SBS_RANDOM_BIT ; 27
    SBS_RANDOM_BIT ; 28
    SBS_RANDOM_BIT ; 29
    SBS_RANDOM_BIT ; 30
    SBS_RANDOM_BIT ; 31
    SBS_RANDOM_BIT ; 32

    __asm   mov     dValue, ebx

    return dValue;
    }

// -----------------------------------------------------------------

BOOL WINAPI _random_list (PDWORD pdData,
                          PDWORD pdAddr,
                          PPVOID ppData,
                          DWORD  dCount)
    {
    PVOID pData;
    DWORD i, j;
    BOOL  fOk = FALSE;

    if (ppData != NULL)
        {
        if (dCount >= 2)
            {
            for (i = 0; i < dCount; i++)
                {
                j = _random_32 (pdData, pdAddr) % dCount;

                pData      = ppData [i];
                ppData [i] = ppData [j];
                ppData [j] = pData;
                }
            }
        fOk = TRUE;
        }
    return fOk;
    }

////////////////////////////////////////////////////////////////////
#endif // #ifdef _INLINE_SBSNUM_
////////////////////////////////////////////////////////////////////

#endif // #ifndef _SBSNUM_H_

// =================================================================
// END OF FILE
// =================================================================
